/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.ui;

import com.intellij.ide.NativeIconProvider;
import com.jetbrains.cidr.ui.BaseItemPrinter;
import com.jetbrains.cidr.ui.ComponentRenderer;
import com.jetbrains.cidr.ui.ItemPrinterKt;
import com.jetbrains.cidr.ui.ItemState;
import com.jetbrains.cidr.ui.PrintersKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/ui/FileItemPrinter;", "Lcom/jetbrains/cidr/ui/BaseItemPrinter;", "Ljava/io/File;", "printFullPath", "", "showIcon", "checkExists", "<init>", "(ZZZ)V", "getPrintFullPath", "()Z", "renderValue", "", "Lcom/jetbrains/cidr/ui/ComponentRenderer;", "value", "state", "Lcom/jetbrains/cidr/ui/ItemState;", "intellij.cidr.util.ui"})
@SourceDebugExtension(value={"SMAP\nprinters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 printers.kt\ncom/jetbrains/cidr/ui/FileItemPrinter\n+ 2 itemPrinter.kt\ncom/jetbrains/cidr/ui/ItemPrinterKt\n*L\n1#1,42:1\n64#2:43\n*S KotlinDebug\n*F\n+ 1 printers.kt\ncom/jetbrains/cidr/ui/FileItemPrinter\n*L\n10#1:43\n*E\n"})
public final class FileItemPrinter
extends BaseItemPrinter<File> {
    private final boolean printFullPath;
    private final boolean showIcon;
    private final boolean checkExists;

    @JvmOverloads
    public FileItemPrinter(boolean printFullPath, boolean showIcon, boolean checkExists) {
        boolean $i$f$filterByClass = false;
        super(ItemPrinterKt.filterByClass(File.class));
        this.printFullPath = printFullPath;
        this.showIcon = showIcon;
        this.checkExists = checkExists;
    }

    public /* synthetic */ FileItemPrinter(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        this(bl, bl2, bl3);
    }

    public final boolean getPrintFullPath() {
        return this.printFullPath;
    }

    @Override
    public void renderValue(@NotNull ComponentRenderer $this$renderValue, @NotNull File value, @NotNull ItemState state) {
        Intrinsics.checkNotNullParameter((Object)$this$renderValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.checkExists && !value.exists()) {
            $this$renderValue.appendError(value.getName(), state);
        } else {
            String string = value.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            $this$renderValue.append(string);
        }
        if (this.printFullPath && !Intrinsics.areEqual((Object)value.getName(), (Object)value.getPath())) {
            $this$renderValue.appendGrayed(" (" + PrintersKt.getPresentablePath(value) + ")", state);
        }
        if (this.showIcon) {
            $this$renderValue.setIcon(NativeIconProvider.getNativeIcon((Path)value.toPath()));
        }
    }

    @JvmOverloads
    public FileItemPrinter(boolean printFullPath, boolean showIcon) {
        this(printFullPath, showIcon, false, 4, null);
    }

    @JvmOverloads
    public FileItemPrinter(boolean printFullPath) {
        this(printFullPath, false, false, 6, null);
    }

    @JvmOverloads
    public FileItemPrinter() {
        this(false, false, false, 7, null);
    }
}

