/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.ide.actions.runAnything.items.RunAnythingHelpItem;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskRunAction;
import com.intellij.lang.javascript.buildTools.npm.NpmRunAnythingProvider;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.runAnything.JsbtRunAnythingProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class NpmScriptRunAnythingProvider
extends JsbtRunAnythingProvider {
    @Nls
    private final String myPackageManagerName;
    @NotNull
    private final Icon myIcon;

    NpmScriptRunAnythingProvider(@NotNull @Nls String packageManagerName, @NotNull Icon icon) {
        if (packageManagerName == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(0);
        }
        if (icon == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(1);
        }
        this.myPackageManagerName = packageManagerName;
        this.myIcon = icon;
    }

    @Override
    @NotNull
    public String getCommand(@NotNull JsbtTaskRunAction value) {
        if (value == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(2);
        }
        String string = NpmManager.getNpmCommandPresentableText(NodePackageRef.create(this.myPackageManagerName), NpmCommand.RUN_SCRIPT) + " " + StringUtil.join(value.getTaskSet().getTaskNames(), (String)" ") + (String)(!value.getTaskSet().getArguments().isEmpty() ? " " + value.getTaskSet().getArguments() : "");
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected JsbtApplicationService getService() {
        NpmScriptsService.NpmScriptsApplicationService npmScriptsApplicationService = NpmScriptsService.NpmScriptsApplicationService.getInstance();
        if (npmScriptsApplicationService == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(4);
        }
        return npmScriptsApplicationService;
    }

    @NotNull
    public Icon getIcon(@NotNull JsbtTaskRunAction value) {
        if (value == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(5);
        }
        Icon icon = this.myIcon;
        if (icon == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(6);
        }
        return icon;
    }

    @Override
    @NotNull
    public @Unmodifiable Collection<JsbtTaskRunAction> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        boolean matchNpmScriptName;
        if (dataContext == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(7);
        }
        if (pattern == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(8);
        }
        boolean matchCommandPrefix = this.hasCommandPrefix(pattern);
        boolean bl = matchNpmScriptName = !StringUtil.isEmptyOrSpaces((String)pattern) && this.isProjectPackageManager(dataContext);
        if (!matchCommandPrefix && !matchNpmScriptName) {
            List<JsbtTaskRunAction> list = Collections.emptyList();
            if (list == null) {
                NpmScriptRunAnythingProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<JsbtTaskRunAction> allValues = this.getAllValues(dataContext);
        List list = ContainerUtil.filter(allValues, action -> {
            String command = this.getCommand((JsbtTaskRunAction)((Object)action));
            if (matchCommandPrefix && command.startsWith(pattern)) {
                return true;
            }
            if (pattern.startsWith(command + " ")) {
                String args = pattern.substring(command.length() + 1);
                action.getTaskSet().setArguments(args);
                return true;
            }
            String task = (String)ContainerUtil.getFirstItem(action.getTaskSet().getTaskNames());
            return matchNpmScriptName && task != null && task.startsWith(pattern);
        });
        if (list == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    private boolean isProjectPackageManager(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(11);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return false;
        }
        NodePackageRef pkgManagerRef = NpmManager.getInstance(project).getPackageRef();
        return NpmUtil.isYarnAlikePackageRef(pkgManagerRef) == this.isYarn();
    }

    @Override
    @NotNull
    protected List<JsbtFileStructure> getFileStructures(@NotNull Project project, @NotNull DataContext dataContext) {
        VirtualFile packageJson;
        if (project == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(12);
        }
        if (dataContext == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(13);
        }
        if ((packageJson = NpmRunAnythingProvider.getPackageJson(project, dataContext)) == null) {
            List<JsbtFileStructure> list = Collections.emptyList();
            if (list == null) {
                NpmScriptRunAnythingProvider.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)this.getBuildfileStructure(project, packageJson));
        if (list == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Override
    @Nullable
    protected JsbtFileStructure getBuildfileStructure(@NotNull Project project, @NotNull VirtualFile buildfile) {
        if (project == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(16);
        }
        if (buildfile == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(17);
        }
        try {
            return NpmScriptsService.getInstance(project).fetchBuildfileStructure(buildfile);
        }
        catch (JsbtTaskFetchException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getCompletionGroupTitle() {
        String string = this.myPackageManagerName;
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public RunAnythingHelpItem getHelpItem(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(19);
        }
        boolean yarn = this.isYarn();
        return new RunAnythingHelpItem(NpmScriptRunAnythingProvider.getHelpCommandPlaceholder(yarn), NpmScriptRunAnythingProvider.getCommandPrefix(yarn), this.getHelpDescription(), this.myIcon);
    }

    @Override
    @NotNull
    public Icon getHelpIcon() {
        Icon icon = this.myIcon;
        if (icon == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(20);
        }
        return icon;
    }

    @Override
    public boolean hasCommandPrefix(@NotNull String pattern) {
        if (pattern == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(21);
        }
        return NpmRunAnythingProvider.hasPackageNamePrefix(pattern, this.myPackageManagerName);
    }

    @Override
    @NotNull
    protected String getCommandPrefix() {
        return NpmScriptRunAnythingProvider.getCommandPrefix(this.isYarn());
    }

    @NotNull
    private static String getCommandPrefix(boolean yarn) {
        String string = NpmManager.getNpmPackagePresentableName(yarn);
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public String getHelpCommandPlaceholder() {
        return NpmScriptRunAnythingProvider.getHelpCommandPlaceholder(false);
    }

    @NotNull
    private static String getHelpCommandPlaceholder(boolean yarn) {
        String string = NpmScriptRunAnythingProvider.getCommandPrefix(yarn) + " run <script name>";
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHelpCommand() {
        String string = this.myPackageManagerName;
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Override
    @NotNull
    public String getHelpGroupTitle() {
        String string = this.myPackageManagerName;
        if (string == null) {
            NpmScriptRunAnythingProvider.$$$reportNull$$$0(25);
        }
        return string;
    }

    private boolean isYarn() {
        return NpmRunAnythingProvider.isYarn(this.myPackageManagerName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 9, 10, 14, 15, 18, 20, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptRunAnythingProvider";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptRunAnythingProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStructures";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionGroupTitle";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpIcon";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandPrefix";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommandPlaceholder";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpCommand";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpGroupTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isProjectPackageManager";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileStructures";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBuildfileStructure";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getHelpItem";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasCommandPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 9, 10, 14, 15, 18, 20, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }
}

