/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterfaceClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassBase;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitMemberForComputedPropertyImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNotARecordType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JsonElementType;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSCustomElementType;
import com.intellij.lang.javascript.psi.types.evaluable.JSObjectLiteralExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeOfPsiElementBase;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerObjectType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.CssClass;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class TypeScriptQualifiedItemProcessor<T extends ResultSink>
extends QualifiedItemProcessor<T> {
    protected final boolean myTypeScript;

    public TypeScriptQualifiedItemProcessor(T sink, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(0);
        }
        super(sink, containingFile);
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)ObjectUtils.coalesce((Object)this.place, (Object)containingFile));
        this.myTypeScript = holder != null && holder.isTypeScript;
    }

    public static boolean processNamespaceChildren(@NotNull ResolveProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @Nullable PsiElement place, @NotNull PsiElement element2) {
        if (processor == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(1);
        }
        if (state == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(3);
        }
        boolean statics = processor.getAccessibilityProcessingHandler().isProcessStatics();
        if (element2 instanceof JSVariable) {
            return !statics || JSResolveUtil.processDeclarationsInScope((JSVariable)element2, processor, state, lastParent, place);
        }
        if (element2 instanceof JSFile && processor instanceof JSModuleElementsProcessor) {
            if (statics) {
                return ES6PsiUtil.processExportDeclarationInScope(element2, (JSModuleElementsProcessor)((Object)processor));
            }
            return true;
        }
        if (element2 instanceof ES6ImportExportSpecifier) {
            return true;
        }
        return place == null || element2.processDeclarations((PsiScopeProcessor)processor, state, lastParent, place);
    }

    @Override
    protected void handleActionScriptFunctionExpressionEvents(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(4);
        }
    }

    public void processImpl(@NotNull JSType _type, @NotNull JSEvaluateContext evaluateContext) {
        if (_type == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(5);
        }
        if (evaluateContext == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(6);
        }
        JSType type2 = JSTypeUtils.unwrapDecorations(_type);
        String name = JSTypeUtils.getQualifiedNameMatchingType(type2, false);
        PsiElement sourceElement = type2.getSourceElement();
        if (name == null && type2.isSourceStrict() && this.myTypeScript && this.isUnnamedTypeWithoutProperties(type2)) {
            this.forceResolvedState(type2);
            return;
        }
        if (name == null || sourceElement == null) {
            this.doProcessImpl(_type, evaluateContext);
            return;
        }
        Collection<JSElement> elements = this.getElements(type2, name, sourceElement);
        if (elements.isEmpty()) {
            this.doProcessImpl(_type, evaluateContext);
            return;
        }
        this.processElementsForType(evaluateContext, type2, elements);
        if (type2.isSourceStrict() && this.myTypeScript) {
            this.forceResolvedState(type2);
        }
    }

    private void forceResolvedState(@NotNull JSType type2) {
        if (type2 == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(7);
        }
        if (!(type2 instanceof TypeScriptJSFunctionTypeImpl) || !TypeScriptQualifiedItemProcessor.isApplicableFuncSource(type2.getSourceElement())) {
            this.resolved = QualifiedItemProcessor.TypeResolveState.Resolved;
        }
    }

    private static boolean isApplicableFuncSource(@Nullable PsiElement element2) {
        if (!(element2 instanceof JSFunction)) {
            return false;
        }
        if (!(element2 instanceof JSExpression)) {
            return true;
        }
        PsiElement parent = element2.getParent();
        if (!(parent instanceof JSVariable) || ((JSVariable)parent).getInitializerOrStub() != element2) {
            return false;
        }
        return ((JSVariable)parent).isConst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processElementsForType(@NotNull JSEvaluateContext evaluateContext, @NotNull JSType type2, @NotNull Collection<? extends PsiElement> elements) {
        JSTypeSubstitutor substitutor;
        if (evaluateContext == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(8);
        }
        if (type2 == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(9);
        }
        if (elements == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(10);
        }
        ResolveState state = (substitutor = TypeScriptQualifiedItemProcessor.getTypeSubstitutor(type2, elements)) == null ? ResolveState.initial() : ResolveState.initial().put(JSResolveResult.GENERICS, (Object)substitutor);
        Set<TypeScriptInterfaceClass> classes = elements.stream().filter(el -> el instanceof TypeScriptInterfaceClass).map(el -> (TypeScriptInterfaceClass)el).collect(Collectors.toSet());
        boolean savedProcessStatics = this.getAccessibilityProcessingHandler().isProcessStatics();
        if (type2 instanceof JSNamespace) {
            JSNamespace jsNamespace = (JSNamespace)type2;
            this.getAccessibilityProcessingHandler().setProcessStatics(jsNamespace.getJSContext() == JSContext.STATIC);
        }
        try {
            this.processClasses(classes, state);
            HashSet<TypeScriptEnum> processedEnums = new HashSet<TypeScriptEnum>();
            for (PsiElement psiElement : elements) {
                TypeScriptEnum owner;
                if (classes.contains(psiElement)) continue;
                if (psiElement instanceof TypeScriptTypeAlias) {
                    JSType declaration = ((TypeScriptTypeAlias)psiElement).getParsedTypeDeclaration();
                    if (declaration == null) continue;
                    JSEvaluationRecursionGuard.processWithEvaluationGuard(psiElement, evaluateContext, () -> {
                        this.process(JSTypeUtils.applyGenericArguments(declaration, substitutor), evaluateContext);
                        return null;
                    });
                    continue;
                }
                if (this.isToProcessHierarchy() && psiElement instanceof TypeScriptEnumField && (owner = ((TypeScriptEnumField)psiElement).getOwner()) != null && processedEnums.add(owner)) {
                    this.processClasses(JBIterable.of((Object[])owner.getSuperClasses()).filter(TypeScriptInterfaceClass.class).toSet(), state);
                }
                this.processWithLocalResolveForModules(psiElement, state);
            }
        }
        finally {
            this.getAccessibilityProcessingHandler().setProcessStatics(savedProcessStatics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWithLocalResolveForModules(@NotNull PsiElement element2, @NotNull ResolveState state) {
        if (element2 == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(11);
        }
        if (state == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(12);
        }
        boolean savedLocalResolve = this.isLocalResolve();
        try {
            if (element2 instanceof TypeScriptModule) {
                this.setLocalResolve(true);
            }
            TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, state, element2, this.place, element2);
        }
        finally {
            this.setLocalResolve(savedLocalResolve);
        }
    }

    private void processClasses(@NotNull Set<TypeScriptInterfaceClass> classes, @NotNull ResolveState state) {
        if (classes == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(13);
        }
        if (state == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(14);
        }
        boolean savedValue = this.isToProcessHierarchy();
        this.setToProcessHierarchy(false);
        boolean toProcessSupers = true;
        for (TypeScriptInterfaceClass tsClass : classes) {
            toProcessSupers &= TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, state, tsClass, this.place, tsClass);
        }
        this.setToProcessHierarchy(savedValue);
        if (!savedValue || !toProcessSupers) {
            return;
        }
        for (TypeScriptInterfaceClass tsClass : classes) {
            TypeScriptClassBase.processSupers(tsClass, this, state, tsClass, this.place);
        }
    }

    @Contract(value="null -> false")
    private boolean isUnnamedTypeWithoutProperties(@Nullable JSType type2) {
        return type2 instanceof TypeScriptNeverType || type2 instanceof JSVoidType || (type2 instanceof JSNullType || type2 instanceof JSUndefinedType) && TypeScriptConfigUtil.strictNullChecks(this.place);
    }

    @NotNull
    private Collection<? extends JSElement> getElements(@NotNull JSType type2, @NotNull String name, @NotNull PsiElement sourceElement) {
        if (type2 == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(15);
        }
        if (name == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(16);
        }
        if (sourceElement == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(17);
        }
        PsiElement sourceToResolve = sourceElement;
        PsiFile file = sourceElement.getContainingFile();
        if (file != null && TypeScriptLibraryProvider.checkLibraryFile(sourceElement.getProject(), file.getVirtualFile()) && this.place != null) {
            sourceToResolve = this.place;
        }
        Collection<PsiElement> resolveResultElements = this.resolveElementsByTypeWithContext(type2, name, sourceToResolve);
        SmartList elements = new SmartList();
        for (PsiElement element2 : resolveResultElements) {
            if (!(element2 instanceof JSElement)) continue;
            elements.add((JSElement)element2);
        }
        SmartList smartList = elements;
        if (smartList == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    protected @Unmodifiable @NotNull Collection<? extends PsiElement> resolveElementsByTypeWithContext(@NotNull JSType type2, @NotNull String qName, @NotNull PsiElement sourceToResolve) {
        if (type2 == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(19);
        }
        if (qName == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(20);
        }
        if (sourceToResolve == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(21);
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type2, sourceToResolve);
        if (collection == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(22);
        }
        return collection;
    }

    @Nullable
    public static JSTypeSubstitutor getTypeSubstitutor(@Nullable JSType type2, @NotNull Collection<? extends PsiElement> elements) {
        List<JSType> arguments;
        if (elements == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(23);
        }
        if ((arguments = JSTypeUtils.getGenericTypeArguments(type2)) == null) {
            return null;
        }
        JSClass candidateClass = null;
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSClass)) continue;
            candidateClass = (JSClass)psiElement;
            break;
        }
        if (candidateClass instanceof TypeScriptTypeParameterListOwner) {
            return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)((Object)candidateClass), arguments);
        }
        return null;
    }

    private static boolean isFromDeclareClassOrInterface(@NotNull TypeScriptFunction function) {
        JSClass parent;
        if (function == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(24);
        }
        if ((parent = JSUtils.getMemberContainingClass(function)) instanceof TypeScriptInterface) {
            return true;
        }
        if (parent instanceof TypeScriptClass && TypeScriptPsiUtil.isAbstractElement(function)) {
            return true;
        }
        return TypeScriptPsiUtil.isAmbientDeclaration(function);
    }

    @Override
    protected boolean executeAcceptedElement(@NotNull PsiElement element2, @NotNull ResolveState state) {
        JSType parameterType;
        if (element2 == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(25);
        }
        if (state == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(26);
        }
        if (element2 instanceof TypeScriptFunction && ((TypeScriptFunction)element2).hasOverloadDeclarations()) {
            boolean isDeclareOrInterface = TypeScriptQualifiedItemProcessor.isFromDeclareClassOrInterface((TypeScriptFunction)element2);
            boolean isImplementation = ((TypeScriptFunction)element2).isOverloadImplementation();
            if (isImplementation || isDeclareOrInterface && !((TypeScriptFunction)element2).isOverloadDeclaration()) {
                boolean result2 = true;
                for (TypeScriptFunction function : ((TypeScriptFunction)element2).getOverloadDeclarations()) {
                    result2 &= super.executeAcceptedElement(function, state);
                }
                if (!isImplementation) {
                    result2 &= super.executeAcceptedElement(element2, state);
                }
                return result2;
            }
        }
        if (element2 instanceof TypeScriptIndexSignature && this.myName != null && ((parameterType = ((TypeScriptIndexSignature)element2).getMemberParameterType()) instanceof JSStringType && !(parameterType instanceof JSLiteralType) || JSRecordTypeImpl.isPropNameApplicableToIndexType(this.myName, parameterType, element2))) {
            return ((ResultSink)this.getResultSink()).addResult(element2, state, this.getPlaceTopParent());
        }
        return super.executeAcceptedElement(element2, state);
    }

    @Override
    public final void process(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
        if (type2 == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(27);
        }
        if (evaluateContext == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(28);
        }
        if (type2 instanceof JSModuleTypeImpl) {
            PsiElement module = ((JSModuleTypeImpl)type2).getModule();
            ES6PsiUtil.processExportDeclarationInScope(module, this, evaluateContext, ((JSModuleTypeImpl)type2).isFromRequire(), null);
            boolean hasIncompleteMatch = false;
            if (module instanceof JSFile) {
                JSModuleStatusOwner.ModuleStatus status = ((JSFile)module).getModuleStatus();
                boolean bl = hasIncompleteMatch = status == JSModuleStatusOwner.ModuleStatus.COMMONJS || status == JSModuleStatusOwner.ModuleStatus.MAYBE_COMMONJS;
            }
            if (!hasIncompleteMatch) {
                this.forceResolvedState();
            }
            return;
        }
        if (type2 instanceof JSObjectLiteralExpressionType) {
            JSObjectLiteralExpression element2 = ((JSObjectLiteralExpressionType)type2).findAssociatedExpression();
            if (element2 != null) {
                element2.processDeclarations(this, ResolveState.initial(), (PsiElement)element2, this.place);
            }
            return;
        }
        if (type2 instanceof TypeScriptCompilerObjectType) {
            TypeScriptCompilerObjectType objectType2 = (TypeScriptCompilerObjectType)type2;
            Collection declarations = objectType2.getDeclarations();
            if (ContainerUtil.exists((Iterable)declarations, TypeScriptInterfaceClass.class::isInstance)) {
                JSType substituted = type2.substitute().substitute();
                this.processElementsForType(evaluateContext, substituted, declarations);
            } else {
                JSRecordType recordType = objectType2.asRecordType();
                this.processRecordTypeImpl(recordType, true);
            }
            this.forceResolvedState();
            return;
        }
        JSType substituted = type2.substitute((PsiElement)evaluateContext.targetFile);
        this.processImpl(substituted, evaluateContext);
        if (this.resolved == QualifiedItemProcessor.TypeResolveState.Unknown) {
            for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
                if (!handler.useOnlyCompleteMatch(type2, evaluateContext)) continue;
                this.forceResolvedState();
                break;
            }
        }
    }

    protected void doProcessImpl(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
        Object element2;
        JSGenericParameterImpl genericParameter;
        JSType constraintType2;
        if (type2 == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(29);
        }
        if (evaluateContext == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(30);
        }
        if (type2 instanceof JSGenericParameterImpl && (constraintType2 = (genericParameter = (JSGenericParameterImpl)type2).getConstraintType()) != null) {
            type2 = constraintType2;
        }
        if (type2 instanceof JSRecordType) {
            JSRecordType recordType = (JSRecordType)type2;
            this.processRecordTypeImpl(recordType, false);
            return;
        }
        if (type2 instanceof JSClassExpressionType) {
            JSClassExpressionType classExpressionType = (JSClassExpressionType)type2;
            boolean isStatic = classExpressionType.getJSContext() == JSContext.STATIC;
            JSClassExpression element3 = classExpressionType.findAssociatedExpression();
            if (element3 != null) {
                AccessibilityProcessingHandler.processWithStatic(this, isStatic, () -> element3.processDeclarations(this, ResolveState.initial(), element3, this.place));
                if (this.myTypeScript && type2.isSourceStrict() && !this.isTypeContext() && this.resolved != QualifiedItemProcessor.TypeResolveState.PrefixUnknown) {
                    this.forceResolvedState();
                }
            }
            return;
        }
        if ((type2 instanceof JsonElementType || type2 instanceof JSCustomElementType) && !TypeScriptQualifiedItemProcessor.processResolvedElement(element2 = ((JSTypeOfPsiElementBase)type2).getElement(), this)) {
            this.forceResolvedState();
        }
        JSType finalType = type2;
        JSEvaluationRecursionGuard.evaluateWithGuard(type2, evaluateContext, () -> JSTypeUtils.processExpandedType(this, finalType, evaluateContext));
    }

    private void processRecordTypeImpl(@NotNull JSRecordType type2, boolean isFromTypeScriptCompilerType) {
        JSRecordType.IndexSignature indexer;
        List<PsiElement> results;
        String name;
        if (type2 == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(31);
        }
        if (this.myTypeScript && type2.isSourceStrict() && this.resolved != QualifiedItemProcessor.TypeResolveState.PrefixUnknown) {
            this.forceResolvedState();
        }
        if (type2 instanceof JSNotARecordType) {
            return;
        }
        PsiElement sourceElement = type2.getSourceElement();
        if (sourceElement == null && ApplicationManager.getApplication().isUnitTestMode() && this.place != null && !((TypeScriptCompilerEvaluationFacade)this.place.getProject().getService(TypeScriptCompilerEvaluationFacade.class)).isAnyEnabled()) {
            Logger.getInstance(this.getClass()).error((Throwable)((Object)new AssertionError((Object)"Record type source must be not empty")));
        }
        boolean isSimpleRecordWithDefinedSource = type2 instanceof JSSimpleRecordTypeImpl && sourceElement != null && sourceElement.isValid();
        boolean isTypeScriptObjectType = sourceElement instanceof TypeScriptObjectType;
        if (isSimpleRecordWithDefinedSource && (sourceElement instanceof JSClassExpression || isTypeScriptObjectType)) {
            Stream<JSType> constructors = JSTypeUtils.getFunctionType(type2, true, this.place);
            this.getAccessibilityProcessingHandler().setProcessStatics(constructors.findAny().isPresent());
            boolean found = !sourceElement.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), sourceElement, this.place);
            boolean processBaseDeclarations = !found || isTypeScriptObjectType && TypeScriptQualifiedItemProcessor.hasOnlyIndexers(this.getResults());
            boolean processObjectClassMembers = this.getResultSink() instanceof ResolveResultSink;
            if (processBaseDeclarations && isTypeScriptObjectType && processObjectClassMembers) {
                boolean hasCallSignature = false;
                boolean hasConstructSignature = false;
                for (TypeScriptTypeMember typeMember : ((TypeScriptObjectType)sourceElement).getTypeMembers()) {
                    hasCallSignature |= typeMember instanceof JSRecordType.CallSignature && !((JSRecordType.CallSignature)((Object)typeMember)).hasNew();
                    hasConstructSignature |= typeMember instanceof JSRecordType.CallSignature && ((JSRecordType.CallSignature)((Object)typeMember)).hasNew();
                }
                this.processSuperClassMembers(sourceElement, hasCallSignature, hasConstructSignature);
            }
            return;
        }
        if (isSimpleRecordWithDefinedSource && sourceElement instanceof JSObjectLiteralExpression) {
            JSObjectLiteralExpression objectLiteralExpression = (JSObjectLiteralExpression)sourceElement;
            for (JSProperty property : objectLiteralExpression.getProperties()) {
                if (this.execute((PsiElement)property, ResolveState.initial())) continue;
                return;
            }
        }
        boolean isCompleteResolve = isSimpleRecordWithDefinedSource || !(this.getResultSink() instanceof ResolveResultSink) || sourceElement != null && (DialectDetector.isTypeScript(sourceElement) || type2.isSourceStrict());
        for (JSRecordType.TypeMember typeMember : type2.getProperties()) {
            String name2 = this.getName();
            if (name2 != null && !name2.equals(typeMember.getMemberName())) continue;
            if (!type2.isSourceStrict()) {
                typeMember = typeMember.copyTypeHierarchy(t -> t.copyWithStrict(false));
            }
            if (this.processRecordTypeMember(sourceElement, !isSimpleRecordWithDefinedSource, isCompleteResolve, typeMember, isFromTypeScriptCompilerType)) continue;
            return;
        }
        PsiElement location = JSTypeEvaluationLocationProvider.getTypeEvaluationLocation();
        if (sourceElement != null && sourceElement.isValid() && DialectDetector.isTypeScript(sourceElement) && !ES6PsiUtil.isExternalModule(sourceElement) || location != null && isFromTypeScriptCompilerType) {
            boolean hasCallSignature = false;
            boolean hasConstructSignature = false;
            List<JSRecordType.CallSignature> signatures2 = type2.getCallSignatures();
            for (JSRecordType.CallSignature signature : signatures2) {
                hasCallSignature |= !signature.hasNew();
                hasConstructSignature |= signature.hasNew();
            }
            this.processSuperClassMembers(location != null ? location : sourceElement, hasCallSignature, hasConstructSignature);
        }
        if ((name = this.getName()) != null && type2.hasIndexers() && ((results = this.getResults()) == null || results.isEmpty()) && (indexer = type2.findIndexer(JSRecordType.IndexSignatureKind.STRING)) != null && !indexer.isForComputedProperty()) {
            PsiElement element2 = (PsiElement)ObjectUtils.coalesce((Object)indexer.getMemberSource().getSingleElement(), (Object)sourceElement);
            if (element2 == null) {
                return;
            }
            this.execute((PsiElement)new TypeScriptImplicitMemberForComputedPropertyImpl(name, indexer.getMemberType(), element2, false), ResolveState.initial());
        }
    }

    private static boolean processResolvedElement(@NotNull PsiElement element2, @NotNull JSResolveProcessor processor) {
        if (element2 == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(32);
        }
        if (processor == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(33);
        }
        if (element2 instanceof JsonElement) {
            JsonValue value = null;
            if (element2 instanceof JsonFile) {
                JsonFile file = (JsonFile)element2;
                value = (JsonValue)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file, () -> file.getTopLevelValue());
            } else if (element2 instanceof JsonProperty) {
                value = ((JsonProperty)element2).getValue();
            } else if (element2 instanceof JsonValue) {
                value = (JsonValue)element2;
            }
            if (value instanceof JsonObject) {
                String name = processor.getName();
                if (name != null) {
                    JsonProperty property = ((JsonObject)value).findProperty(name);
                    if (property != null) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                        return false;
                    }
                } else {
                    List list = ((JsonObject)value).getPropertyList();
                    for (JsonProperty property : list) {
                        processor.execute((PsiElement)property, ResolveState.initial());
                    }
                }
            }
        } else if (element2 instanceof StylesheetFile) {
            CssStylesheet stylesheet = ((StylesheetFile)element2).getStylesheet();
            if (stylesheet != null) {
                TypeScriptQualifiedItemProcessor.processCssClasses(stylesheet, processor);
            }
            return false;
        }
        return true;
    }

    private static void processCssClasses(@NotNull CssStylesheet stylesheet, @NotNull JSResolveProcessor processor) {
        if (stylesheet == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(34);
        }
        if (processor == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(35);
        }
        MultiMap stylesheetClasses = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)stylesheet, () -> {
            MultiMap classes = new MultiMap();
            for (CssRuleset cssRuleset : stylesheet.getRulesets()) {
                TypeScriptQualifiedItemProcessor.collectCssClasses(cssRuleset, (MultiMap<String, CssClass>)classes);
            }
            return CachedValueProvider.Result.create((Object)classes, (Object[])new Object[]{stylesheet.getContainingFile()});
        });
        Collection classes = processor.getName() != null ? stylesheetClasses.get((Object)processor.getName()) : stylesheetClasses.values();
        for (CssClass cssClass : classes) {
            ProgressManager.checkCanceled();
            processor.execute((PsiElement)cssClass, ResolveState.initial());
        }
    }

    private static void collectCssClasses(@NotNull CssRuleset cssRuleset, @NotNull MultiMap<String, CssClass> classes) {
        if (cssRuleset == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(36);
        }
        if (classes == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(37);
        }
        for (CssSelector cssSelector : cssRuleset.getSelectors()) {
            if (cssSelector.isAmpersandSelector()) {
                cssSelector.processAmpersandEvaluatedSelectors(effectiveSelector -> {
                    TypeScriptQualifiedItemProcessor.collectCssClasses(effectiveSelector, classes);
                    return true;
                });
                continue;
            }
            TypeScriptQualifiedItemProcessor.collectCssClasses(cssSelector, classes);
        }
        for (CssSelector cssSelector : cssRuleset.getNestedRulesets()) {
            TypeScriptQualifiedItemProcessor.collectCssClasses((CssRuleset)cssSelector, classes);
        }
    }

    private static void collectCssClasses(@NotNull CssSelector selector, @NotNull MultiMap<String, CssClass> classes) {
        if (selector == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(38);
        }
        if (classes == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(39);
        }
        ProgressManager.checkCanceled();
        for (CssSimpleSelector simpleSelector : selector.getSimpleSelectors()) {
            for (CssSelectorSuffix selectorSuffix : simpleSelector.getSelectorSuffixes()) {
                String name;
                if (!(selectorSuffix instanceof CssClass) || (name = TypeScriptQualifiedItemProcessor.getName((PsiElement)selectorSuffix)) == null) continue;
                classes.putValue((Object)name, (Object)((CssClass)selectorSuffix));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasOnlyIndexers(List<PsiElement> results) {
        if (results == null) return false;
        if (!ContainerUtil.and(results, TypeScriptIndexSignature.class::isInstance)) return false;
        return true;
    }

    private boolean processRecordTypeMember(@Nullable PsiElement sourceElement, boolean createImplicitElements, boolean isCompleteResolve, @NotNull JSRecordType.TypeMember typeMember, boolean isFromTypeScriptCompilerType) {
        Collection<PsiElement> elements;
        if (typeMember == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(40);
        }
        Collection<PsiElement> collection = elements = isFromTypeScriptCompilerType ? typeMember.getMemberSource().getAllSourceElements() : TypeScriptQualifiedItemProcessor.getElementsForTypeMember(typeMember, sourceElement, createImplicitElements);
        if (elements.isEmpty() && isFromTypeScriptCompilerType) {
            elements = TypeScriptQualifiedItemProcessor.getElementsForTypeMember(typeMember, sourceElement, true);
        }
        boolean added = false;
        for (PsiElement element2 : elements) {
            if (element2 == null) continue;
            if (!isCompleteResolve) {
                this.addPossibleCandidateResult(element2, null);
                continue;
            }
            if (element2 instanceof JSImplicitElement && !(element2 instanceof TypeScriptProxyImplicitElement)) {
                this.addResult(element2);
                continue;
            }
            if (this.execute(element2, ResolveState.initial())) continue;
            added = true;
        }
        return !added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSuperClassMembers(@NotNull PsiElement sourceElement, boolean hasCallSignature, boolean hasConstructSignature) {
        if (sourceElement == null) {
            TypeScriptQualifiedItemProcessor.$$$reportNull$$$0(41);
        }
        int level = ((ResultSink)this.getResultSink()).getNestingLevel();
        boolean processStatics = this.getAccessibilityProcessingHandler().isProcessStatics();
        ((ResultSink)this.getResultSink()).setNestingLevel(10);
        this.getAccessibilityProcessingHandler().setProcessStatics(false);
        try {
            String classParentName = hasCallSignature || hasConstructSignature ? JSTypeUtils.getFunctionTypeName(sourceElement.getContainingFile(), hasConstructSignature) : "Object";
            for (JSQualifiedNamedElement object : TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(classParentName, sourceElement)) {
                TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, ResolveState.initial(), sourceElement, this.place, (PsiElement)object);
            }
        }
        finally {
            ((ResultSink)this.getResultSink()).setNestingLevel(level);
            this.getAccessibilityProcessingHandler().setProcessStatics(processStatics);
        }
    }

    @Override
    public void prefixResolved() {
        if (this.myTypeScript) {
            this.forceResolvedState();
        }
    }

    @Override
    protected void elementIsNotAccessible(PsiElement element2) {
        super.elementIsNotAccessible(element2);
        if (this.myTypeScript) {
            this.forceResolvedState();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 1: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: 
            case 11: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 6: 
            case 8: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 7: 
            case 9: 
            case 15: 
            case 19: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 13: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceToResolve";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stylesheet";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssRuleset";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsByTypeWithContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processNamespaceChildren";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleActionScriptFunctionExpressionEvents";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forceResolvedState";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processElementsForType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processWithLocalResolveForModules";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processClasses";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 18: 
            case 22: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsByTypeWithContext";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isFromDeclareClassOrInterface";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "executeAcceptedElement";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doProcessImpl";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeImpl";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processResolvedElement";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processCssClasses";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "collectCssClasses";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processRecordTypeMember";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processSuperClassMembers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 22 -> new IllegalStateException(string);
        };
    }
}

