/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.lang.javascript.findUsages.JSFindUsagesOptions;
import com.intellij.lang.javascript.findUsages.JavaScriptFindUsagesConfiguration;
import com.intellij.lang.javascript.frameworks.jsx.JSXTagNameReference;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.polySymbols.search.PsiSourcedPolySymbolReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewElementsListener;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUsageViewElementsListener
implements UsageViewElementsListener {
    private static final Map<UsageViewImpl, Set<Usage>> HAS_DYNAMIC_USAGE_EXCLUDE_LISTENER = CollectionFactory.createConcurrentSoftMap();

    public boolean skipUsage(@NotNull UsageView view, @NotNull Usage usage) {
        if (view == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(0);
        }
        if (usage == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(1);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return false;
        }
        Class referenceClass = ((UsageInfo2UsageAdapter)usage).getReferenceClass();
        if (referenceClass == null || !JSXTagNameReference.class.isAssignableFrom(referenceClass)) {
            return false;
        }
        UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
        PsiElement element2 = usageInfo.getElement();
        ProperTextRange rangeInElement = usageInfo.getRangeInElement();
        if (element2 == null || rangeInElement == null) {
            return false;
        }
        PsiReference reference = element2.findReferenceAt(rangeInElement.getStartOffset());
        return reference instanceof JSXTagNameReference && !((JSXTagNameReference)reference).isStartTagFlag();
    }

    public void beforeUsageAdded(@NotNull UsageView view, @NotNull Usage usage) {
        UsageTarget[] targets;
        if (view == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(2);
        }
        if (usage == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(3);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return;
        }
        UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
        UsageTarget[] usageTargetArray = targets = view instanceof UsageViewImpl ? ((UsageViewImpl)view).getTargets() : UsageTarget.EMPTY_ARRAY;
        if (JSUsageViewElementsListener.checkIfJavaScriptDynamicUsage(usageInfo, targets)) {
            usageInfo.setDynamicUsage(true);
        }
    }

    public boolean isExcludedByDefault(@NotNull UsageView view, @NotNull Usage usage) {
        if (view == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(4);
        }
        if (usage == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(5);
        }
        if (!RefactoringBundle.message((String)"usageView.tabText").equals(view.getPresentation().getTabText())) {
            return false;
        }
        UsageTarget[] usageTargets = view instanceof UsageViewImpl ? ((UsageViewImpl)view).getTargets() : UsageTarget.EMPTY_ARRAY;
        boolean isDynamicUsage = JSUsageViewElementsListener.isJavaScriptDynamicUsage(usage, usageTargets);
        if (isDynamicUsage && view instanceof UsageViewImpl) {
            JSUsageViewElementsListener.registerExcludeListenerAndJSDynamicUsage((UsageViewImpl)view, usage);
            if (!JavaScriptFindUsagesConfiguration.getFindUsagesOptions((Project)((UsageViewImpl)view).getProject(), null).isExcludeDynamicUsages) {
                return false;
            }
        }
        return isDynamicUsage;
    }

    private static void registerExcludeListenerAndJSDynamicUsage(final @NotNull UsageViewImpl view, @NotNull Usage usage) {
        Set newSet;
        Set<Usage> prevSet;
        if (view == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(6);
        }
        if (usage == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(7);
        }
        if ((prevSet = HAS_DYNAMIC_USAGE_EXCLUDE_LISTENER.putIfAbsent(view, newSet = ConcurrentCollectionFactory.createConcurrentSet())) != null) {
            prevSet.add(usage);
        } else {
            newSet.add(usage);
            Disposer.register((Disposable)view, (Disposable)new Disposable(){

                public void dispose() {
                    HAS_DYNAMIC_USAGE_EXCLUDE_LISTENER.remove(view);
                }
            });
            view.addExcludeListener((Disposable)view, (usages, excluded) -> {
                JSFindUsagesOptions options = JavaScriptFindUsagesConfiguration.getFindUsagesOptions(view.getProject(), null);
                Set<Usage> dynamicUsages = HAS_DYNAMIC_USAGE_EXCLUDE_LISTENER.get(view);
                if (ContainerUtil.isEmpty(dynamicUsages) || excluded == options.isExcludeDynamicUsages) {
                    return;
                }
                if (excluded) {
                    if (ContainerUtil.intersects(dynamicUsages, (Collection)usages)) {
                        options.isExcludeDynamicUsages = true;
                    }
                } else {
                    dynamicUsages.removeAll(usages);
                    if (dynamicUsages.isEmpty()) {
                        options.isExcludeDynamicUsages = false;
                    }
                }
            });
        }
    }

    public static boolean isJavaScriptDynamicUsage(@NotNull Usage usage, UsageTarget @NotNull [] usageTargets) {
        if (usage == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(8);
        }
        if (usageTargets == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(9);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return false;
        }
        UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
        return usageInfo.isDynamicUsage() && JSUsageViewElementsListener.checkIfJavaScriptDynamicUsage(usageInfo, usageTargets) || usageInfo.getReference() != null && !JSDefaultRenameProcessor.isStrictEnoughReference(usageInfo.getReference());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static boolean checkIfJavaScriptDynamicUsage(@NotNull UsageInfo usageInfo, UsageTarget @NotNull [] usageTargets) {
        if (usageInfo == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(10);
        }
        if (usageTargets == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(11);
        }
        @NotNull List targets = ContainerUtil.mapNotNull((Object[])usageTargets, usageTarget -> usageTarget instanceof PsiElementUsageTarget ? ((PsiElementUsageTarget)usageTarget).getElement() : null);
        return JSUsageViewElementsListener.checkIfJavaScriptDynamicUsage(usageInfo, targets);
    }

    public static boolean checkIfJavaScriptDynamicUsage(@NotNull UsageInfo usageInfo, @NotNull Collection<PsiElement> targets) {
        PsiReference reference;
        if (usageInfo == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(12);
        }
        if (targets == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(13);
        }
        return (reference = JSUsageViewElementsListener.extractReference(usageInfo)) != null && JSResolveUtil.isResolveDynamic(reference, targets);
    }

    @Nullable
    private static PsiReference extractReference(@NotNull UsageInfo usageInfo) {
        PsiElement element2;
        if (usageInfo == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(14);
        }
        if (!((element2 = usageInfo.getElement()) instanceof JSElement)) {
            return null;
        }
        if (usageInfo.getReference() instanceof PsiSourcedPolySymbolReference) {
            return usageInfo.getReference();
        }
        ProperTextRange rangeInElement = usageInfo.getRangeInElement();
        if (rangeInElement == null) {
            return null;
        }
        PsiReference candidate = null;
        for (PsiReference reference : element2.getReferences()) {
            if (!rangeInElement.equals((Object)reference.getRangeInElement())) continue;
            if (candidate != null) {
                return null;
            }
            candidate = reference;
        }
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageTargets";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/findUsages/JSUsageViewElementsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "skipUsage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeUsageAdded";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isExcludedByDefault";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "registerExcludeListenerAndJSDynamicUsage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaScriptDynamicUsage";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfJavaScriptDynamicUsage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "extractReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

