/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescription;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescriptionProcessor;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagDefinition;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDocTagImpl
extends JSElementImpl
implements JSDocTag,
PsiExternalReferenceHost {
    public JSDocTagImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    @NotNull
    public JSDocTagDefinition getTagDefinition() {
        JSDocTagDefinition definition = JSDocBlockTags.definitionFor(this.getName());
        if (definition == JSDocBlockTags.CONFIG) {
            JSDocBlockTags jSDocBlockTags = JSDocumentationUtils.getPreviousParamTagForConfigTag(this) == null ? JSDocBlockTags.PROPERTY : JSDocBlockTags.PARAM;
            if (jSDocBlockTags == null) {
                JSDocTagImpl.$$$reportNull$$$0(0);
            }
            return jSDocBlockTags;
        }
        JSDocTagDefinition jSDocTagDefinition = definition;
        if (jSDocTagDefinition == null) {
            JSDocTagImpl.$$$reportNull$$$0(1);
        }
        return jSDocTagDefinition;
    }

    @Override
    public boolean isForced() {
        return this.findChildByType(JSDocTokenTypes.DOC_TAG_FORCED) != null;
    }

    @Override
    @NotNull
    public String getName() {
        ASTNode element2 = this.findChildByType(JSDocTokenTypes.DOC_TAG_NAME);
        return element2 != null ? element2.getText().substring(1) : "<null>";
    }

    @Override
    public boolean is(@NotNull String name) {
        if (name == null) {
            JSDocTagImpl.$$$reportNull$$$0(2);
        }
        return this.getTagDefinition().equals(JSDocBlockTags.definitionFor(name));
    }

    @Override
    public boolean is(@NotNull JSDocTagDefinition tag) {
        if (tag == null) {
            JSDocTagImpl.$$$reportNull$$$0(3);
        }
        return this.getTagDefinition().equals(tag);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDocTagImpl.$$$reportNull$$$0(4);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocTag(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @Nullable
    public JSDocDescription getDescription() {
        return (JSDocDescription)PsiTreeUtil.getChildOfType((PsiElement)this, JSDocDescription.class);
    }

    @Override
    @Nullable
    public String getTypeText() {
        return (String)ObjectUtils.doIfNotNull((Object)this.getType(), JSDocTagType::getTypeText);
    }

    @Override
    @Nullable
    public String getNamepathText() {
        return (String)ObjectUtils.doIfNotNull((Object)this.getNamepath(), JSDocTagNamepath::getNamepathText);
    }

    @Override
    @Nullable
    public String getDescriptionText(@NotNull JSDocDescriptionProcessor processor) {
        JSDocDescription description;
        if (processor == null) {
            JSDocTagImpl.$$$reportNull$$$0(5);
        }
        return (description = this.getDescription()) != null ? description.getDescriptionText(processor) : null;
    }

    @Override
    @Nullable
    public String getDescriptionText() {
        return this.getDescriptionText(JSDocumentationUtils.DEFAULT_DESCRIPTION_PROCESSOR);
    }

    @Override
    public JSDocTagValue getValue() {
        return (JSDocTagValue)PsiTreeUtil.getChildOfType((PsiElement)this, JSDocTagValue.class);
    }

    @Override
    @Nullable
    public JSDocTagType getType() {
        return (JSDocTagType)PsiTreeUtil.getChildOfType((PsiElement)this, JSDocTagType.class);
    }

    @Override
    @Nullable
    public JSDocTagNamepath getNamepath() {
        return (JSDocTagNamepath)PsiTreeUtil.getChildOfType((PsiElement)this, JSDocTagNamepath.class);
    }

    public void delete() throws IncorrectOperationException {
        ASTNode treePrev;
        ASTNode node = this.getNode();
        ASTNode parentNode = node.getTreeParent();
        for (treePrev = node.getTreePrev(); treePrev != null && (treePrev.getElementType() == TokenType.WHITE_SPACE || treePrev.getElementType() == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK); treePrev = treePrev.getTreePrev()) {
            node = treePrev;
            parentNode.removeChild(node);
        }
        if (treePrev != null && treePrev.getElementType() == JSDocTokenTypes.DOC_COMMENT_START) {
            ASTNode treeNext;
            for (treeNext = this.getNode().getTreeNext(); treeNext != null && (treeNext.getElementType() == TokenType.WHITE_SPACE || treeNext.getElementType() == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK); treeNext = treeNext.getTreeNext()) {
            }
            if (treeNext != null && treeNext.getElementType() == JSDocTokenTypes.DOC_COMMENT_END) {
                parentNode.getTreeParent().removeChild(parentNode);
                return;
            }
        }
        super.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagDefinition";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

