/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfoImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyTypeofType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumNumberLiteralType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.text.CharacterIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeImpl
extends JSNamedType
implements JSResolvableType {
    private static final Key<JSType> ourTypedefsExpandedKey = Key.create((String)"typedefs.expanded");
    @NotNull
    private final String myType;
    private final boolean myIsLocal;
    @NotNull
    private final NullableLazyValue<PsiElement> myLocalScope;
    @NotNull
    private final NotNullLazyValue<CachedValue<JSResolvedTypeInfo>> myCachedValue;

    JSTypeImpl(@NotNull String type2, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance, boolean isLocal) {
        if (type2 == null) {
            JSTypeImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(1);
        }
        if (staticOrInstance == null) {
            JSTypeImpl.$$$reportNull$$$0(2);
        }
        this(type2, source, staticOrInstance, isLocal, (JSResolvedTypeInfo)null);
    }

    JSTypeImpl(final @NotNull JSTypeSource source, @NotNull CharacterIterator serialized) {
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(3);
        }
        if (serialized == null) {
            JSTypeImpl.$$$reportNull$$$0(4);
        }
        super(source, serialized);
        this.myLocalScope = new NullableLazyValue<PsiElement>(){

            @Nullable
            protected PsiElement compute() {
                return JSTypeUtils.getLocalScopeFromSource(JSTypeImpl.this);
            }
        };
        this.myType = JSTypeSerializer.readString(serialized);
        this.myIsLocal = JSTypeSerializer.readBoolean(serialized);
        this.myCachedValue = NotNullLazyValue.lazy((Supplier)new Supplier<CachedValue<JSResolvedTypeInfo>>(){

            @Override
            public CachedValue<JSResolvedTypeInfo> get() {
                return JSTypeImpl.createResolvedTypeInfoCachedValue(source.getSourceElement(), JSTypeImpl.this, null);
            }
        });
    }

    private JSTypeImpl(@NotNull String type2, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance, boolean isLocal, final @Nullable JSResolvedTypeInfo prevInfo) {
        if (type2 == null) {
            JSTypeImpl.$$$reportNull$$$0(5);
        }
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(6);
        }
        if (staticOrInstance == null) {
            JSTypeImpl.$$$reportNull$$$0(7);
        }
        super(source, staticOrInstance);
        this.myLocalScope = new /* invalid duplicate definition of identical inner class */;
        this.myType = type2;
        this.myIsLocal = isLocal;
        final PsiElement element2 = source.getSourceElement();
        this.myCachedValue = NotNullLazyValue.lazy((Supplier)new Supplier<CachedValue<JSResolvedTypeInfo>>(){

            @Override
            public CachedValue<JSResolvedTypeInfo> get() {
                return JSTypeImpl.createResolvedTypeInfoCachedValue(element2, JSTypeImpl.this, prevInfo);
            }
        });
    }

    private JSTypeImpl(@NotNull String type2, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance, boolean isLocal, @NotNull NotNullLazyValue<CachedValue<JSResolvedTypeInfo>> resolvedTypeInfo) {
        if (type2 == null) {
            JSTypeImpl.$$$reportNull$$$0(8);
        }
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(9);
        }
        if (staticOrInstance == null) {
            JSTypeImpl.$$$reportNull$$$0(10);
        }
        if (resolvedTypeInfo == null) {
            JSTypeImpl.$$$reportNull$$$0(11);
        }
        super(source, staticOrInstance);
        this.myLocalScope = new /* invalid duplicate definition of identical inner class */;
        this.myType = type2;
        this.myIsLocal = isLocal;
        this.myCachedValue = resolvedTypeInfo;
        assert (!type2.startsWith("import("));
    }

    @NotNull
    public static JSTypeImpl fromDeclarations(@NotNull String type2, @NotNull Set<PsiElement> declarations) {
        if (type2 == null) {
            JSTypeImpl.$$$reportNull$$$0(12);
        }
        if (declarations == null) {
            JSTypeImpl.$$$reportNull$$$0(13);
        }
        NotNullLazyValue lazyValue = NotNullLazyValue.createConstantValue((Object)new CachedValueImpl(() -> new CachedValueProvider.Result((Object)new JSResolvedTypeInfoImpl(type2, declarations), new Object[]{ModificationTracker.NEVER_CHANGED})));
        JSTypeSource typeSource = !declarations.isEmpty() ? JSTypeSourceFactory.createTypeSource((PsiElement)ContainerUtil.getFirstItem(declarations)) : JSTypeSource.EMPTY_TS_EXPLICITLY_DECLARED;
        return new JSTypeImpl(type2, typeSource, JSTypeContext.INSTANCE, false, (NotNullLazyValue<CachedValue<JSResolvedTypeInfo>>)lazyValue);
    }

    @Override
    public void serialize(@NotNull StringBuilder builder2) {
        if (builder2 == null) {
            JSTypeImpl.$$$reportNull$$$0(14);
        }
        super.serialize(builder2);
        JSTypeSerializer.writeString(this.myType, builder2);
        JSTypeSerializer.writeBoolean(this.myIsLocal, builder2);
    }

    private static long calcModification(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSTypeImpl.$$$reportNull$$$0(15);
        }
        return PsiModificationTracker.getInstance((Project)element2.getProject()).getModificationCount();
    }

    @NotNull
    private static CachedValue<JSResolvedTypeInfo> createResolvedTypeInfoCachedValue(@Nullable PsiElement element2, @NotNull JSTypeImpl type2, @Nullable JSResolvedTypeInfo prevValue) {
        if (type2 == null) {
            JSTypeImpl.$$$reportNull$$$0(16);
        }
        if (JSTypeImpl.isSourceElementNotValid(element2)) {
            return new CachedValueImpl(() -> CachedValueProvider.Result.create((Object)type2.resolveTypeImpl(), (Object[])new Object[]{ModificationTracker.NEVER_CHANGED}));
        }
        if (prevValue == null) {
            CachedValue cachedValue = CachedValuesManager.getManager((Project)element2.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)type2.resolveTypeImpl(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
            if (cachedValue == null) {
                JSTypeImpl.$$$reportNull$$$0(17);
            }
            return cachedValue;
        }
        long startModification = JSTypeImpl.calcModification(element2);
        CachedValue cachedValue = CachedValuesManager.getManager((Project)element2.getProject()).createCachedValue(() -> {
            if (JSTypeImpl.calcModification(element2) == startModification) {
                return CachedValueProvider.Result.create((Object)prevValue, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
            return CachedValueProvider.Result.create((Object)type2.resolveTypeImpl(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }, false);
        if (cachedValue == null) {
            JSTypeImpl.$$$reportNull$$$0(18);
        }
        return cachedValue;
    }

    @Override
    @NotNull
    public JSResolvedTypeInfo resolveType() {
        JSResolvedTypeInfo jSResolvedTypeInfo = (JSResolvedTypeInfo)((CachedValue)this.myCachedValue.get()).getValue();
        if (jSResolvedTypeInfo == null) {
            JSTypeImpl.$$$reportNull$$$0(19);
        }
        return jSResolvedTypeInfo;
    }

    @NotNull
    private JSResolvedTypeInfo resolveTypeImpl() {
        JSTypeResolveResult result2;
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (JSTypeImpl.isSourceElementNotValid(sourceElement)) {
            return new JSResolvedTypeInfoImpl(this.myType, ContainerUtil.emptyList());
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler();
        if (this.myIsLocal) {
            result2 = importHandler.resolveName(this.myType, sourceElement, this.getLocalScope());
        } else {
            JSContext context2 = this.getTypeContext().toJSContext();
            result2 = importHandler.resolveMainElementName(this.myType, sourceElement, context2);
        }
        return new JSResolvedTypeInfoImpl(result2.getQualifiedName(), result2.getElements());
    }

    @Override
    @Deprecated
    @Nullable
    public JSClass resolveClass() {
        PsiElement clazz;
        if (!this.isEcma()) {
            return null;
        }
        ProgressManager.checkCanceled();
        String qualifiedType = this.myType;
        JSTypeSource source = this.getSource();
        PsiElement element2 = source.getSourceElement();
        PsiElement resolvedElement = null;
        if (element2 != null) {
            JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)this.getScope()).getImportHandler();
            JSTypeResolveResult result2 = importHandler.resolveTypeName(this.myType, element2);
            qualifiedType = result2.getQualifiedName();
            Iterator<? extends PsiElement> iterator = result2.getElements().iterator();
            if (iterator.hasNext()) {
                resolvedElement = iterator.next();
            }
        }
        PsiElement psiElement = clazz = resolvedElement != null ? resolvedElement : JSResolveUtil.findType(qualifiedType, (PsiElement)this.getScope(), true);
        if (clazz instanceof JSClass) {
            return (JSClass)clazz;
        }
        return null;
    }

    public static boolean isSourceElementNotValid(PsiElement sourceElement) {
        return sourceElement == null || !sourceElement.isValid();
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSTypeImpl.$$$reportNull$$$0(20);
        }
        if (builder2 == null) {
            JSTypeImpl.$$$reportNull$$$0(21);
        }
        if (format == JSType.TypeTextFormat.RESOLVED || format == JSType.TypeTextFormat.CODE) {
            String qualifiedName = this.getSimpleResolvedTypeText();
            if (format == JSType.TypeTextFormat.CODE && TypeScriptUtil.hasAmbientExternalModuleInQName(qualifiedName)) {
                builder2.append(this.myType);
                return;
            }
            builder2.append(qualifiedName);
            return;
        }
        builder2.append(this.myType);
    }

    @NotNull
    private String getSimpleResolvedTypeText() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (JSTypeImpl.isSourceElementNotValid(sourceElement)) {
            String string = this.myType;
            if (string == null) {
                JSTypeImpl.$$$reportNull$$$0(22);
            }
            return string;
        }
        JSResolvedTypeInfo resolvedType = this.resolveType();
        String string = resolvedType.getResolvedTypeText();
        if (string == null) {
            JSTypeImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType typedefValue;
        if (elementType == null) {
            JSTypeImpl.$$$reportNull$$$0(24);
        }
        if (processingContext == null) {
            JSTypeImpl.$$$reportNull$$$0(25);
        }
        if (this.isSourceStrict() && !this.isEcma() && (typedefValue = this.getJSTypedef()) != null) {
            return typedefValue.isDirectlyAssignableType(elementType, processingContext);
        }
        Boolean isEnumAssignable = JSTypeImpl.isDirectlyAssignableEnum(this, elementType, processingContext);
        if (isEnumAssignable != null) {
            return isEnumAssignable;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Nullable
    public static Boolean isDirectlyAssignableEnum(@NotNull JSResolvableType thisType, @NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        String qualifiedName;
        TypeScriptEnum parentEnumElement;
        TypeScriptEnumField field;
        if (thisType == null) {
            JSTypeImpl.$$$reportNull$$$0(26);
        }
        if (elementType == null) {
            JSTypeImpl.$$$reportNull$$$0(27);
        }
        if (processingContext == null) {
            JSTypeImpl.$$$reportNull$$$0(28);
        }
        JSResolvedTypeInfo resolvedType = thisType.resolveType();
        if (elementType instanceof JSNumberType && !(elementType instanceof TypeScriptEnumNumberLiteralType) && resolvedType.isEnum()) {
            return true;
        }
        boolean isEnumLiteral = resolvedType.isEnumLiteral();
        boolean otherIsEnumLiteral = false;
        boolean otherIsEnum = false;
        JSResolvedTypeInfo resolvedOtherType = null;
        if (elementType instanceof JSResolvableType) {
            resolvedOtherType = ((JSResolvableType)elementType).resolveType();
            otherIsEnumLiteral = resolvedOtherType.isEnumLiteral();
            otherIsEnum = resolvedOtherType.isEnum();
        }
        if (isEnumLiteral && otherIsEnumLiteral) {
            TypeScriptEnum otherEnum;
            if (!JSTypeImpl.enumValuesIdentical(resolvedType.getEnumConstValue(), resolvedOtherType.getEnumConstValue())) {
                return false;
            }
            TypeScriptEnumField ownField = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
            TypeScriptEnumField otherField = resolvedOtherType.getDeclarationOfType(TypeScriptEnumField.class);
            if (ownField == null || otherField == null) {
                return false;
            }
            TypeScriptEnum ownEnum = ownField.getOwner();
            if (!Objects.equals(ownEnum, otherEnum = otherField.getOwner())) {
                return false;
            }
            return true;
        }
        if (otherIsEnumLiteral && resolvedType.isEnum() && (field = resolvedOtherType.getDeclarationOfType(TypeScriptEnumField.class)) != null && (parentEnumElement = (TypeScriptEnum)PsiTreeUtil.getContextOfType((PsiElement)field, (Class[])new Class[]{TypeScriptEnum.class})) != null && (qualifiedName = parentEnumElement.getQualifiedName()) != null) {
            JSType otherEnum = JSNamedTypeFactory.createExplicitlyDeclaredType(qualifiedName, parentEnumElement);
            return thisType.isDirectlyAssignableType(otherEnum, processingContext);
        }
        if (isEnumLiteral && otherIsEnum) {
            return false;
        }
        if (elementType instanceof JSNumberType && isEnumLiteral) {
            field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
            if (field == null) {
                return false;
            }
            Double value = field.getConstantValue().getNumericValue();
            return value != null;
        }
        if (elementType instanceof JSStringLiteralTypeImpl && isEnumLiteral) {
            return false;
        }
        if (!otherIsEnum && isEnumLiteral && !JSTypeUtils.hasForeignGenericParameter(elementType)) {
            return false;
        }
        return null;
    }

    private static boolean enumValuesIdentical(EnumConstantValue ownConstantValue, EnumConstantValue otherConstantValue) {
        Double ownDouble = ownConstantValue.getNumericValue();
        Double otherDouble = otherConstantValue.getNumericValue();
        if (ownDouble != null && otherDouble != null && Objects.equals(ownDouble, otherDouble)) {
            return true;
        }
        String ownString = ownConstantValue.getStringValue();
        String otherString = otherConstantValue.getStringValue();
        if (ownString != null && otherString != null && Objects.equals(ownString, otherString)) {
            return true;
        }
        BigInteger ownBigInt = ownConstantValue.getBigIntValue();
        BigInteger otherBigInt = otherConstantValue.getBigIntValue();
        return ownBigInt != null && otherBigInt != null && Objects.equals(ownBigInt, otherBigInt);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSTypeImpl.$$$reportNull$$$0(29);
        }
        if (processingContext == null) {
            JSTypeImpl.$$$reportNull$$$0(30);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSTypeImpl.$$$reportNull$$$0(31);
            }
            return assignableResult;
        }
        if (elementType instanceof JSTypeImpl) {
            JSTypeImpl elementTypeImpl = (JSTypeImpl)elementType;
            JSTypeContext elementTypeContext = elementTypeImpl.getTypeContext();
            if (this.getTypeContext() == JSTypeContext.STATIC && elementTypeContext == JSTypeContext.STATIC) {
                JSResolvedTypeInfo resolvedType1 = this.resolveType();
                JSResolvedTypeInfo resolvedType2 = ((JSTypeImpl)elementType).resolveType();
                if (!resolvedType1.isAbstract() && resolvedType2.isAbstract()) {
                    JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
                    if (assignableResult == null) {
                        JSTypeImpl.$$$reportNull$$$0(32);
                    }
                    return assignableResult;
                }
            }
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.getTypeHelper().isAssignableToNamedType(this, elementType, processingContext));
        if (assignableResult == null) {
            JSTypeImpl.$$$reportNull$$$0(33);
        }
        return assignableResult;
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type2 == null) {
            JSTypeImpl.$$$reportNull$$$0(34);
        }
        if (!super.isEquivalentToWithSameClass(type2, processingContext, allowResolve)) {
            return false;
        }
        if (this.getSource().getLanguage() != type2.getSource().getLanguage()) {
            return false;
        }
        JSTypeImpl jsType = (JSTypeImpl)type2;
        if (this.getJSContext() != jsType.getJSContext()) {
            return false;
        }
        if (this.isLocal() != jsType.isLocal()) {
            return false;
        }
        if (!Objects.equals(this.getLocalScope(), jsType.getLocalScope())) {
            return false;
        }
        if (!(this.isEcma() && allowResolve || this.myType.equals(((JSTypeImpl)type2).myType))) {
            return false;
        }
        JSQualifiedNameImpl lName = JSQualifiedNameImpl.fromQualifiedName(this.getTypeText());
        JSQualifiedNameImpl rName = JSQualifiedNameImpl.fromQualifiedName(jsType.getTypeText());
        if (!Objects.equals(lName.getName(), rName.getName())) {
            return false;
        }
        if (!allowResolve || JSTypeImpl.areEqualByScope(this, jsType)) {
            return true;
        }
        if (this.isEcma()) {
            return this.getSimpleResolvedTypeText().equals(((JSTypeImpl)type2).getSimpleResolvedTypeText());
        }
        return Objects.equals(this.resolveType(), jsType.resolveType());
    }

    private static boolean areEqualByScope(@NotNull JSTypeImpl left, @NotNull JSTypeImpl right) {
        JSElement rightScope;
        if (left == null) {
            JSTypeImpl.$$$reportNull$$$0(35);
        }
        if (right == null) {
            JSTypeImpl.$$$reportNull$$$0(36);
        }
        if (left.isEcma()) {
            return false;
        }
        JSTypeSource lSource = left.getSource();
        JSTypeSource rSource = right.getSource();
        if (lSource.getSourceElement() == rSource.getSourceElement()) {
            return true;
        }
        JSElement leftScope = ES6PsiUtil.getNonStrictExportScope(lSource.getSourceElement());
        if (leftScope != (rightScope = ES6PsiUtil.getNonStrictExportScope(rSource.getSourceElement()))) {
            return false;
        }
        return !TypeScriptUtil.isLocalClassPossible((PsiElement)leftScope);
    }

    @Nullable
    public JSType getJSTypedef() {
        if (this.isTypeScript()) {
            return null;
        }
        JSResolvedTypeInfo resolvedType = this.resolveType();
        if (resolvedType.getAliasedType() != null) {
            return null;
        }
        String text = resolvedType.getResolvedTypeText();
        JSTypeBaseImpl.JSResolvedTypeIdImpl id = this.getResolvedTypeId();
        return id.getLocalCachedValue(ourTypedefsExpandedKey, () -> {
            JSType type2 = JSTypeEvaluateManager.getTypedefValue((PsiElement)this.getScope(), text);
            if (type2 != null && this.getJSContext() == JSContext.STATIC) {
                type2 = new JSApplyTypeofType(type2, this.getSource());
            }
            return type2;
        });
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeImpl.$$$reportNull$$$0(37);
        }
        JSTypeSource currentSource = this.getSource();
        boolean sameContext = source.getSourceElement() == currentSource.getSourceElement();
        return new JSTypeImpl(this.getTypeText(), source, this.getTypeContext(), this.myIsLocal, sameContext ? this.getCachedResolvedTypeInfo() : null);
    }

    @Nullable
    private JSResolvedTypeInfo getCachedResolvedTypeInfo() {
        return ((CachedValue)this.myCachedValue.get()).hasUpToDateValue() ? this.resolveType() : null;
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        JSType expanded;
        if (context2 == null) {
            JSTypeImpl.$$$reportNull$$$0(38);
        }
        JSResolvedTypeInfo info = this.resolveType();
        Collection<? extends PsiElement> declarations = info.getDeclarations();
        List<JSType> genericArguments = context2.getGenerics();
        TypeScriptTypeAlias alias = (TypeScriptTypeAlias)ContainerUtil.findInstance(declarations, TypeScriptTypeAlias.class);
        if (alias == null) {
            JSType typedefValue;
            JSTypeSource source = this.getSource();
            if (source.isStrict() && source.getLanguage() == JSTypeSource.SourceLanguage.JS && (typedefValue = this.getJSTypedef()) != null) {
                if (!genericArguments.isEmpty()) {
                    typedefValue = JSTypeImpl.applyGenericsToTypedef(typedefValue, genericArguments);
                }
                return typedefValue.substitute(context2);
            }
            return JSTypeImpl.expandDefaultGenericsForSingleType(this, genericArguments, declarations);
        }
        if (!JSTypeImpl.validateAliases(info, alias)) {
            return this;
        }
        JSType declaration = info.getAliasedType();
        if (declaration == null) {
            return this;
        }
        if (genericArguments.isEmpty() && (expanded = JSTypeImpl.expandDefaultGenericsForSingleType(this, genericArguments, declarations)) instanceof JSGenericTypeImpl) {
            genericArguments = ((JSGenericTypeImpl)expanded).getArguments();
        }
        if (!genericArguments.isEmpty()) {
            JSTypeSubstitutor generics = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)alias, genericArguments);
            declaration = JSTypeUtils.applyGenericArguments(declaration, generics, false, null);
        }
        JSType afterProcessing = declaration.substitute(context2.withGenerics(ContainerUtil.emptyList()));
        return JSTypeImpl.wrapWithAliasIfNeeded(this, afterProcessing, genericArguments);
    }

    @NotNull
    private static JSType applyGenericsToTypedef(@NotNull JSType typedefValue, @NotNull List<JSType> genericArguments) {
        List<Pair<String, String>> parameters2;
        PsiElement sourceElement;
        if (typedefValue == null) {
            JSTypeImpl.$$$reportNull$$$0(39);
        }
        if (genericArguments == null) {
            JSTypeImpl.$$$reportNull$$$0(40);
        }
        if ((sourceElement = typedefValue.getSourceElement()) instanceof JSImplicitElement) {
            sourceElement = sourceElement.getParent();
        }
        if (sourceElement instanceof JSDocComment && !(parameters2 = ((JSDocComment)sourceElement).getGenericParameters()).isEmpty()) {
            JSTypeSubstitutorImpl substitutor = new JSTypeSubstitutorImpl();
            List genericParameters = ContainerUtil.map(parameters2, it -> (String)it.getFirst());
            JSGenericTypesEvaluatorBase.addArgumentsToSubstitutor(genericParameters, genericArguments, substitutor);
            JSType jSType = JSTypeUtils.applyGenericArguments(typedefValue, substitutor, false, null);
            if (jSType == null) {
                JSTypeImpl.$$$reportNull$$$0(41);
            }
            return jSType;
        }
        JSType jSType = typedefValue;
        if (jSType == null) {
            JSTypeImpl.$$$reportNull$$$0(42);
        }
        return jSType;
    }

    @Nullable
    private static JSType wrapWithAliasIfNeeded(@NotNull JSType type2, @Nullable JSType afterProcessing, @NotNull List<JSType> genericArguments) {
        if (type2 == null) {
            JSTypeImpl.$$$reportNull$$$0(43);
        }
        if (genericArguments == null) {
            JSTypeImpl.$$$reportNull$$$0(44);
        }
        if (JSAliasTypeImpl.shouldPreserveAlias(type2, afterProcessing)) {
            JSType aliasType = type2;
            if (!genericArguments.isEmpty()) {
                aliasType = new JSGenericTypeImpl(type2.getSource(), aliasType, genericArguments);
            }
            if (afterProcessing instanceof JSAliasTypeImpl) {
                afterProcessing = ((JSAliasTypeImpl)afterProcessing).getOriginalType();
            }
            return new JSAliasTypeImpl(aliasType, afterProcessing, afterProcessing.getSource());
        }
        return afterProcessing;
    }

    @NotNull
    public static JSType expandDefaultGenericsForSingleType(@NotNull JSType selfType, @NotNull List<JSType> genericArguments, @NotNull Collection<? extends PsiElement> declarations) {
        if (selfType == null) {
            JSTypeImpl.$$$reportNull$$$0(45);
        }
        if (genericArguments == null) {
            JSTypeImpl.$$$reportNull$$$0(46);
        }
        if (declarations == null) {
            JSTypeImpl.$$$reportNull$$$0(47);
        }
        if (!genericArguments.isEmpty() || declarations.isEmpty() || !TypeScriptGenericTypesEvaluator.isInstanceJSTypeImpl(selfType) || !selfType.isTypeScript()) {
            JSType jSType = selfType;
            if (jSType == null) {
                JSTypeImpl.$$$reportNull$$$0(48);
            }
            return jSType;
        }
        for (PsiElement psiElement : declarations) {
            List<JSType> types;
            TypeScriptTypeParameter[] parameters2 = TypeScriptPsiUtil.getTypeParametersForOwner(psiElement);
            if (parameters2.length == 0 || (types = TypeScriptGenericTypesEvaluator.getArgumentsListForTypeWithOwner(selfType, psiElement)).isEmpty()) continue;
            return new JSGenericTypeImpl(selfType.getSource(), selfType, types);
        }
        JSType jSType = selfType;
        if (jSType == null) {
            JSTypeImpl.$$$reportNull$$$0(49);
        }
        return jSType;
    }

    @Override
    @NotNull
    public String getTypeText(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSTypeImpl.$$$reportNull$$$0(50);
        }
        if (format == JSType.TypeTextFormat.SIMPLE) {
            String string = this.myType;
            if (string == null) {
                JSTypeImpl.$$$reportNull$$$0(51);
            }
            return string;
        }
        String string = super.getTypeText(format);
        if (string == null) {
            JSTypeImpl.$$$reportNull$$$0(52);
        }
        return string;
    }

    private static boolean validateAliases(@NotNull JSResolvedTypeInfo info, @NotNull TypeScriptTypeAlias alias) {
        if (info == null) {
            JSTypeImpl.$$$reportNull$$$0(53);
        }
        if (alias == null) {
            JSTypeImpl.$$$reportNull$$$0(54);
        }
        Collection<? extends PsiElement> declarations = info.getDeclarations();
        String name = alias.getName();
        if (name == null) {
            return false;
        }
        boolean hasAliases = false;
        for (PsiElement psiElement : declarations) {
            if (!(psiElement instanceof PsiNamedElement) || !name.equals(((PsiNamedElement)psiElement).getName())) {
                return false;
            }
            if (psiElement instanceof TypeScriptTypeAlias) {
                hasAliases = true;
                continue;
            }
            if (!JSTypeImpl.isInvalidForAlias(psiElement)) continue;
            return false;
        }
        return hasAliases;
    }

    private static boolean isInvalidForAlias(@NotNull PsiElement e) {
        if (e == null) {
            JSTypeImpl.$$$reportNull$$$0(55);
        }
        if (e instanceof TypeScriptTypeAlias) {
            return false;
        }
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)e);
        return virtualFile != null && !JSLibraryUtil.hasDirectoryInPath(virtualFile, JSLibraryUtil.LIBRARY_DIR_NAMES, null);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.isTypeScript(), super.hashCodeImpl(), this.getLocalScope());
    }

    @Override
    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSTypeImpl.$$$reportNull$$$0(56);
        }
        Stream<JSType> stream = JSTypeImpl.getFunctionTypesForNamedType(this, processingContext, newCallSignatures);
        if (stream == null) {
            JSTypeImpl.$$$reportNull$$$0(57);
        }
        return stream;
    }

    public static Stream<JSType> getFunctionTypesForNamedType(@NotNull JSNamespace type2, @NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        Stream<JSType> types;
        List<JSType> collect;
        boolean isStaticContext;
        if (type2 == null) {
            JSTypeImpl.$$$reportNull$$$0(58);
        }
        if (processingContext == null) {
            JSTypeImpl.$$$reportNull$$$0(59);
        }
        boolean bl = isStaticContext = type2.getTypeContext() == JSTypeContext.STATIC;
        if (JSTypeImpl.isFromJavaScriptFunction(type2)) {
            return Stream.of(type2);
        }
        JSRecordType substitute = type2.asRecordType();
        if (substitute != type2 && !(collect = (types = substitute.getFunctionTypes(processingContext, newCallSignatures)).toList()).isEmpty()) {
            return collect.stream();
        }
        if (newCallSignatures && isStaticContext) {
            JSNamespace instanceType = type2.copyWithTypeContext(JSTypeContext.INSTANCE);
            return Stream.of(new JSFunctionTypeImpl(type2.getSource(), ContainerUtil.emptyList(), instanceType));
        }
        return Stream.empty();
    }

    public static boolean isFromJavaScriptFunction(@NotNull JSNamespace type2) {
        JSTypeSource source;
        if (type2 == null) {
            JSTypeImpl.$$$reportNull$$$0(60);
        }
        return (source = type2.getSource()).isJavaScript() && type2.getTypeContext() == JSTypeContext.STATIC && source.getSourceElement() instanceof JSFunctionItem;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarations() {
        JSType typedef = this.getJSTypedef();
        if (typedef != null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JSTypeImpl.$$$reportNull$$$0(61);
            }
            return list;
        }
        Collection<PsiElement> collection = JSResolvableType.super.getDeclarations();
        if (collection == null) {
            JSTypeImpl.$$$reportNull$$$0(62);
        }
        return collection;
    }

    @Override
    public boolean isLocal() {
        return this.myIsLocal;
    }

    @Override
    @Nullable
    public PsiElement getLocalScope() {
        return this.myIsLocal ? (PsiElement)this.myLocalScope.getValue() : null;
    }

    @Override
    public String toString() {
        Object typeText = super.toString();
        if (this.isLocal() || this.getTypeContext() != JSTypeContext.INSTANCE) {
            if (this.isLocal()) {
                typeText = (String)typeText + ", local";
            }
            if (this.getTypeContext() != JSTypeContext.INSTANCE) {
                typeText = (String)typeText + ", " + String.valueOf((Object)this.getTypeContext());
            }
            typeText = "[" + (String)typeText + "]";
        }
        return typeText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 19, 22, 23, 31, 32, 33, 41, 42, 48, 49, 51, 52, 57, 61, 62 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedTypeInfo";
                break;
            }
            case 13: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 57: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeImpl";
                break;
            }
            case 20: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 25: 
            case 28: 
            case 30: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedefValue";
                break;
            }
            case 40: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfType";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeImpl";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolvedTypeInfoCachedValue";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleResolvedTypeText";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "applyGenericsToTypedef";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "expandDefaultGenericsForSingleType";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fromDeclarations";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "calcModification";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createResolvedTypeInfoCachedValue";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 57: 
            case 61: 
            case 62: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableEnum";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "areEqualByScope";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "applyGenericsToTypedef";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithAliasIfNeeded";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "expandDefaultGenericsForSingleType";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "validateAliases";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidForAlias";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesForNamedType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isFromJavaScriptFunction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 19, 22, 23, 31, 32, 33, 41, 42, 48, 49, 51, 52, 57, 61, 62 -> new IllegalStateException(string);
        };
    }
}

