/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ApplicationKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0007J&\u0010\u000b\u001a\u00020\f2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/javascript/psi/util/JSPluginPathManager;", "", "<init>", "()V", "getPluginResource", "Ljava/nio/file/Path;", "pluginClass", "Ljava/lang/Class;", "resourceName", "", "relativePathFromPluginsDirectoryToResourceRoot", "getPluginResourceOrSource", "Ljava/io/File;", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nJSPluginPathManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSPluginPathManager.kt\ncom/intellij/lang/javascript/psi/util/JSPluginPathManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n24#2:48\n*S KotlinDebug\n*F\n+ 1 JSPluginPathManager.kt\ncom/intellij/lang/javascript/psi/util/JSPluginPathManager\n*L\n33#1:48\n*E\n"})
public final class JSPluginPathManager {
    @NotNull
    public static final JSPluginPathManager INSTANCE = new JSPluginPathManager();

    private JSPluginPathManager() {
    }

    @JvmStatic
    @NotNull
    public static final Path getPluginResource(@NotNull Class<?> pluginClass, @NotNull String resourceName, @Nullable String relativePathFromPluginsDirectoryToResourceRoot) throws IOException {
        Comparable<File> comparable;
        Intrinsics.checkNotNullParameter(pluginClass, (String)"pluginClass");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        if (relativePathFromPluginsDirectoryToResourceRoot != null && (ApplicationKt.getApplication().isUnitTestMode() || PluginManagerCore.isRunningFromSources() || AppMode.isDevServer())) {
            Path sourceFile = PluginPathManager.getPluginHome((String)(relativePathFromPluginsDirectoryToResourceRoot + "/" + resourceName)).toPath();
            if (Files.exists(sourceFile, new LinkOption[0])) {
                Intrinsics.checkNotNull((Object)sourceFile);
                return sourceFile;
            }
            JSPluginPathManager $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JSPluginPathManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot find " + sourceFile);
        }
        if ((comparable = PluginPathManager.getPluginResource(pluginClass, (String)resourceName)) == null || (comparable = comparable.toPath()) == null) {
            throw new IOException("Cannot find " + resourceName);
        }
        return comparable;
    }

    @JvmStatic
    @Deprecated(message="Use getPluginResource instead", replaceWith=@ReplaceWith(expression="JSPluginPathManager.getPluginResource(pluginClass, resourceName, relativePathFromPluginsDirectoryToResourceRoot)", imports={}))
    @NotNull
    public static final File getPluginResourceOrSource(@NotNull Class<?> pluginClass, @NotNull String resourceName, @Nullable String relativePathFromPluginsDirectoryToResourceRoot) throws IOException {
        Intrinsics.checkNotNullParameter(pluginClass, (String)"pluginClass");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        File file = JSPluginPathManager.getPluginResource(pluginClass, resourceName, relativePathFromPluginsDirectoryToResourceRoot).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }
}

