/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.ide;

import com.intellij.lang.javascript.service.ide.JSLanguageServiceEditorListenerBase;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

final class JSLanguageServiceFileEditorListener
extends JSLanguageServiceEditorListenerBase
implements FileEditorManagerListener {
    private final Set<VirtualFile> myOpenedFiles;

    JSLanguageServiceFileEditorListener(@NotNull Project project, @NotNull CoroutineScope cs) {
        if (project == null) {
            JSLanguageServiceFileEditorListener.$$$reportNull$$$0(0);
        }
        if (cs == null) {
            JSLanguageServiceFileEditorListener.$$$reportNull$$$0(1);
        }
        super(project, cs);
        this.myOpenedFiles = Collections.synchronizedSet(new HashSet());
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            JSLanguageServiceFileEditorListener.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSLanguageServiceFileEditorListener.$$$reportNull$$$0(3);
        }
        if ((JSLanguageServiceFileEditorListener.isFileVisible(source, file) || JSLanguageServiceFileEditorListener.isMultipleWindowsOpen(source)) && this.myOpenedFiles.add(file)) {
            this.fileOpenedImpl(file);
        }
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        VirtualFile newFile;
        if (event == null) {
            JSLanguageServiceFileEditorListener.$$$reportNull$$$0(4);
        }
        if ((newFile = event.getNewFile()) != null && JSLanguageServiceFileEditorListener.isFileVisible(event.getManager(), newFile) && this.myOpenedFiles.add(newFile)) {
            this.fileOpenedImpl(newFile);
        }
    }

    private static boolean isFileVisible(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            JSLanguageServiceFileEditorListener.$$$reportNull$$$0(5);
        }
        if (file == null) {
            JSLanguageServiceFileEditorListener.$$$reportNull$$$0(6);
        }
        return ArrayUtil.contains((Object)file, (Object[])source.getSelectedFiles());
    }

    private static boolean isMultipleWindowsOpen(@NotNull FileEditorManager source) {
        FileEditorManagerEx managerEx;
        if (source == null) {
            JSLanguageServiceFileEditorListener.$$$reportNull$$$0(7);
        }
        return source instanceof FileEditorManagerEx && (managerEx = (FileEditorManagerEx)source).getWindows().length > 1;
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            JSLanguageServiceFileEditorListener.$$$reportNull$$$0(8);
        }
        if (file == null) {
            JSLanguageServiceFileEditorListener.$$$reportNull$$$0(9);
        }
        if (source.getAllEditorList(file).isEmpty() && this.myOpenedFiles.remove(file)) {
            this.fileClosedImpl(file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/service/ide/JSLanguageServiceFileEditorListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileVisible";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isMultipleWindowsOpen";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fileClosed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

