/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.lsp.BaseLspTypeScriptServiceCompletionSupport;
import com.intellij.lang.typescript.lsp.JSFrameworkLsp4jServer;
import com.intellij.lang.typescript.lsp.TypeScriptGoLspServiceKt;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfo;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfoKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.platform.lsp.api.customization.LspCompletionSupport;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsSupport;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R \u0010\u0006\u001a\u000e\u0012\n\b\u0001\u0012\u00060\bj\u0002`\t0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/intellij/lang/typescript/lsp/TypeScriptGoLspServerDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lsp4jServerClass", "Ljava/lang/Class;", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "getLsp4jServerClass", "()Ljava/lang/Class;", "lspDiagnosticsSupport", "Lcom/intellij/platform/lsp/api/customization/LspDiagnosticsSupport;", "getLspDiagnosticsSupport", "()Lcom/intellij/platform/lsp/api/customization/LspDiagnosticsSupport;", "lspCompletionSupport", "Lcom/intellij/platform/lsp/api/customization/LspCompletionSupport;", "getLspCompletionSupport", "()Lcom/intellij/platform/lsp/api/customization/LspCompletionSupport;", "isSupportedFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.javascript.impl"})
public final class TypeScriptGoLspServerDescriptor
extends ProjectWideLspServerDescriptor {
    @NotNull
    private final Class<? extends LanguageServer> lsp4jServerClass;
    @NotNull
    private final LspDiagnosticsSupport lspDiagnosticsSupport;
    @NotNull
    private final LspCompletionSupport lspCompletionSupport;

    public TypeScriptGoLspServerDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = JavaScriptBundle.message("typescript.go.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(project, string);
        this.lsp4jServerClass = JSFrameworkLsp4jServer.class;
        this.lspDiagnosticsSupport = new LspDiagnosticsSupport(){

            public void createAnnotation(AnnotationHolder holder, Diagnostic diagnostic, TextRange textRange, List<? extends IntentionAction> quickFixes) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
                Intrinsics.checkNotNullParameter(quickFixes, (String)"quickFixes");
            }
        };
        this.lspCompletionSupport = new BaseLspTypeScriptServiceCompletionSupport();
    }

    @NotNull
    public Class<? extends LanguageServer> getLsp4jServerClass() {
        return this.lsp4jServerClass;
    }

    @NotNull
    public LspDiagnosticsSupport getLspDiagnosticsSupport() {
        return this.lspDiagnosticsSupport;
    }

    @NotNull
    public LspCompletionSupport getLspCompletionSupport() {
        return this.lspCompletionSupport;
    }

    public boolean isSupportedFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TypeScriptGoLspServiceKt.access$getService(this.getProject()).isAcceptable(file);
    }

    @NotNull
    public GeneralCommandLine createCommandLine() {
        String serviceDirectory = (String)ReadAction.nonBlocking(() -> TypeScriptGoLspServerDescriptor.createCommandLine$lambda$0(this)).executeSynchronously();
        Intrinsics.checkNotNull((Object)serviceDirectory);
        TypeScriptGoPackageInfo typeScriptGoPackageInfo = TypeScriptGoPackageInfoKt.getTypeScriptGoPackageInfo(serviceDirectory);
        if (typeScriptGoPackageInfo == null) {
            Object[] objectArray = new Object[]{serviceDirectory};
            throw new ExecutionException(JavaScriptBundle.message("typescript.go.bad.package", objectArray));
        }
        TypeScriptGoPackageInfo tsGoInfo = typeScriptGoPackageInfo;
        if (Registry.Companion.get("typescript.service.lsp.go.debug.enable").asBoolean()) {
            String[] stringArray = new String[]{"dlv", "--listen=:" + Registry.Companion.get("typescript.service.lsp.go.debug.port").asInteger(), "--headless=true", "--api-version=2", "--accept-multiclient", "exec", tsGoInfo.getBinaryExecutable().getPath(), "--", "--lsp", "--stdio"};
            return new GeneralCommandLine(stringArray);
        }
        String[] stringArray = new String[]{tsGoInfo.getBinaryExecutable().getPath(), "--lsp", "--stdio"};
        return new GeneralCommandLine(stringArray);
    }

    private static final String createCommandLine$lambda$0(TypeScriptGoLspServerDescriptor this$0) {
        return TypeScriptServiceDirectoryWatcher.getService(this$0.getProject()).calcServiceDirectoryAndRefresh();
    }
}

