/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.resharper.assist;

import com.intellij.psi.tree.IElementType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0001\u001bB!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0005J\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u0015J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\"\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/resharper/assist/BracketMatcher;", "", "myBrackets", "", "Lkotlin/Pair;", "Lcom/intellij/psi/tree/IElementType;", "<init>", "([Lkotlin/Pair;)V", "[Lkotlin/Pair;", "myDirection", "", "", "myStack", "Ljava/util/Stack;", "getDirection", "type", "findMatchingBracket", "iterator", "Lcom/intellij/resharper/assist/BracketMatcher$TokenIterator;", "(Lcom/intellij/resharper/assist/BracketMatcher$TokenIterator;)Ljava/lang/Integer;", "isStackEmpty", "", "proceedStack", "tokenType", "failIfRightOnEmpty", "tryCollapse", "peekedTokenType", "TokenIterator", "intellij.resharper.assist"})
public abstract class BracketMatcher {
    @NotNull
    private final Pair<IElementType, IElementType>[] myBrackets;
    @NotNull
    private final Map<IElementType, Integer> myDirection;
    @NotNull
    private final Stack<IElementType> myStack;

    public BracketMatcher(@NotNull Pair<IElementType, IElementType>[] myBrackets) {
        Intrinsics.checkNotNullParameter(myBrackets, (String)"myBrackets");
        this.myBrackets = myBrackets;
        this.myDirection = new LinkedHashMap();
        this.myStack = new Stack();
        for (Pair<IElementType, IElementType> pair2 : this.myBrackets) {
            IElementType first = (IElementType)pair2.component1();
            IElementType second = (IElementType)pair2.component2();
            this.myDirection.put(first, 1);
            this.myDirection.put(second, -1);
        }
    }

    public final int getDirection(@NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Integer n = this.myDirection.get(type);
        return n != null ? n : 0;
    }

    @Nullable
    public final Integer findMatchingBracket(@NotNull TokenIterator iterator) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        this.myStack.clear();
        IElementType iElementType = iterator.getTokenType();
        if (iElementType == null) {
            return null;
        }
        IElementType tokenType = iElementType;
        int delta = this.getDirection(tokenType);
        if (delta == 0) {
            return null;
        }
        while (BracketMatcher.proceedStack$default(this, tokenType, false, 2, null)) {
            if (this.isStackEmpty()) {
                return iterator.getTokenStart();
            }
            if (delta < 0) {
                iterator.retreat();
            } else {
                iterator.advance();
            }
            if (iterator.getTokenType() != null) continue;
            return null;
        }
        return null;
    }

    public final boolean isStackEmpty() {
        return this.myStack.isEmpty();
    }

    public final boolean proceedStack(@NotNull IElementType tokenType, boolean failIfRightOnEmpty) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        int direction = this.getDirection(tokenType);
        if (direction == 0) {
            return true;
        }
        if (this.isStackEmpty()) {
            this.myStack.push(tokenType);
            return !failIfRightOnEmpty || direction != -1;
        }
        IElementType prevToken = this.myStack.peek();
        Intrinsics.checkNotNull((Object)prevToken);
        if (this.getDirection(prevToken) == direction) {
            this.myStack.push(tokenType);
            return true;
        }
        for (Pair<IElementType, IElementType> pair2 : this.myBrackets) {
            IElementType first = (IElementType)pair2.component1();
            IElementType second = (IElementType)pair2.component2();
            if (Intrinsics.areEqual((Object)tokenType, (Object)first)) {
                return this.tryCollapse(second, prevToken);
            }
            if (!Intrinsics.areEqual((Object)tokenType, (Object)second)) continue;
            return this.tryCollapse(first, prevToken);
        }
        throw new IllegalStateException("Should never get here!".toString());
    }

    public static /* synthetic */ boolean proceedStack$default(BracketMatcher bracketMatcher, IElementType iElementType, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: proceedStack");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return bracketMatcher.proceedStack(iElementType, bl);
    }

    private final boolean tryCollapse(IElementType tokenType, IElementType peekedTokenType) {
        boolean bl;
        if (Intrinsics.areEqual((Object)tokenType, (Object)peekedTokenType)) {
            this.myStack.pop();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/resharper/assist/BracketMatcher$TokenIterator;", "", "advance", "", "retreat", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "getTokenType", "()Lcom/intellij/psi/tree/IElementType;", "tokenStart", "", "getTokenStart", "()I", "intellij.resharper.assist"})
    public static interface TokenIterator {
        public void advance();

        public void retreat();

        @Nullable
        public IElementType getTokenType();

        public int getTokenStart();
    }
}

