/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.resharper.cpp.assist.utils;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.resharper.cpp.assist.utils.DocCoordinates;
import com.intellij.resharper.cpp.assist.utils.DocOffsetAndVirtual;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0003\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"moveTo", "", "Lcom/intellij/openapi/editor/CaretModel;", "offset", "Lcom/intellij/resharper/cpp/assist/utils/DocOffsetAndVirtual;", "offsetToDocCoordinates", "Lcom/intellij/resharper/cpp/assist/utils/DocCoordinates;", "Lcom/intellij/openapi/editor/Document;", "", "intellij.resharper.cpp.assist"})
public final class DocOffsetAndVirtualKt {
    public static final void moveTo(@NotNull CaretModel $this$moveTo, @NotNull DocOffsetAndVirtual offset) {
        Intrinsics.checkNotNullParameter((Object)$this$moveTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Editor editor = $this$moveTo.getCurrentCaret().getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        DocCoordinates coords = DocOffsetAndVirtualKt.offsetToDocCoordinates(document2, offset.getOffset());
        if (!editor2.getSettings().isVirtualSpace() && offset.getVirtualDelta() > 0) {
            document2.insertString(offset.getOffset(), (CharSequence)StringsKt.repeat((CharSequence)" ", (int)offset.getVirtualDelta()));
        }
        $this$moveTo.moveToLogicalPosition(new LogicalPosition(coords.getLine(), coords.getColumn() + offset.getVirtualDelta()));
    }

    private static final DocCoordinates offsetToDocCoordinates(Document $this$offsetToDocCoordinates, int offset) {
        if (!(0 <= offset ? offset <= $this$offsetToDocCoordinates.getTextLength() : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int line = $this$offsetToDocCoordinates.getLineNumber(offset);
        int lineStartOffset = $this$offsetToDocCoordinates.getLineStartOffset(line);
        int column = offset - lineStartOffset;
        return new DocCoordinates(line, column);
    }
}

