/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.resharper.cpp.lexer;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/resharper/cpp/lexer/CppTokenNodeTypeTraits;", "", "<init>", "()V", "CHARACTER_LITERAL_UDL", "Lkotlin/text/Regex;", "STRING_LITERAL_UDL", "getSuffixPositionIfUserDefinedCharacterLiteral", "", "r", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getSuffixPositionIfUserDefinedStringLiteral", "intellij.resharper.cpp.lexer"})
public final class CppTokenNodeTypeTraits {
    @NotNull
    public static final CppTokenNodeTypeTraits INSTANCE = new CppTokenNodeTypeTraits();
    @NotNull
    private static final Regex CHARACTER_LITERAL_UDL = new Regex("(([LUu]|u8)?'.*')([_a-zA-Z][_a-zA-Z0-9]*)");
    @NotNull
    private static final Regex STRING_LITERAL_UDL = new Regex("(([LUu]|u8)?R?\".*\")([_a-zA-Z][_a-zA-Z0-9]*)");

    private CppTokenNodeTypeTraits() {
    }

    @Nullable
    public final Integer getSuffixPositionIfUserDefinedCharacterLiteral(@NotNull String r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        MatchResult m = CHARACTER_LITERAL_UDL.matchEntire((CharSequence)r);
        if (m == null || m.getValue().length() != r.length()) {
            return null;
        }
        Object object = m.getGroups().get(1);
        return object != null && (object = object.getValue()) != null ? Integer.valueOf(((String)object).length()) : null;
    }

    @Nullable
    public final Integer getSuffixPositionIfUserDefinedStringLiteral(@NotNull String r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        MatchResult m = STRING_LITERAL_UDL.matchEntire((CharSequence)r);
        if (m == null || m.getValue().length() != r.length()) {
            return null;
        }
        Object object = m.getGroups().get(1);
        return object != null && (object = object.getValue()) != null ? Integer.valueOf(((String)object).length()) : null;
    }
}

