/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.inspections.dfabyir;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.AnalysisPass;
import com.intellij.rml.dfa.DfaAnalysisIrResult;
import com.intellij.rml.dfa.DfaAnalysisRmlResult;
import com.intellij.rml.dfa.DfaRegistry;
import com.intellij.rml.dfa.DfaSessionProvider;
import com.intellij.rml.dfa.DfaSummarySession;
import com.intellij.rml.dfa.InterproceduralAnalysisDescription;
import com.intellij.rml.dfa.RMLAnalysisDescription;
import com.intellij.rml.dfa.ir.IrProject;
import com.intellij.rml.dfa.rml.dsl.DfaAnalysisSpecification;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import com.intellij.rml.dfa.utils.RMLOptions;
import com.jetbrains.cidr.radler.inspections.dfabyir.analyzes.CppDereferenceAnalysis;
import com.jetbrains.cidr.radler.inspections.dfabyir.analyzes.CppDereferenceAnalysisKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/radler/inspections/dfabyir/DfaByIrInspectionRunner;", "", "<init>", "()V", "Companion", "intellij.rider.plugins.clion.radler.dfa"})
public final class DfaByIrInspectionRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<RmlRelation> EXTRA_RELATIONS;
    @NotNull
    private static final Map<AnalysisPass, List<DfaAnalysisSpecification>> EXTRA_ANALYSES;

    static {
        Logger logger = Logger.getInstance(DfaByIrInspectionRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        EXTRA_RELATIONS = CollectionsKt.listOf(CppDereferenceAnalysisKt.getCppNullDereferenceLocal());
        EXTRA_ANALYSES = MapsKt.mapOf((Pair)TuplesKt.to((Object)AnalysisPass.Pass1, (Object)CollectionsKt.listOf((Object)((Object)new CppDereferenceAnalysis()))));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/radler/inspections/dfabyir/DfaByIrInspectionRunner$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "EXTRA_RELATIONS", "", "Lcom/intellij/rml/dfa/rml/dsl/lang/RmlRelation;", "EXTRA_ANALYSES", "", "Lcom/intellij/rml/dfa/AnalysisPass;", "Lcom/intellij/rml/dfa/rml/dsl/DfaAnalysisSpecification;", "computeDFA", "Lcom/intellij/rml/dfa/DfaAnalysisRmlResult;", "dfaInput", "Lcom/intellij/rml/dfa/ir/IrProject;", "project", "Lcom/intellij/openapi/project/Project;", "timeLimit", "", "perFunctionTimeLimit", "maxTasksPerTime", "", "options", "Lcom/intellij/rml/dfa/utils/RMLOptions;", "intellij.rider.plugins.clion.radler.dfa"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DfaAnalysisRmlResult computeDFA(@NotNull IrProject dfaInput, @NotNull Project project, long timeLimit, long perFunctionTimeLimit, int maxTasksPerTime, @NotNull RMLOptions options) {
            Intrinsics.checkNotNullParameter((Object)dfaInput, (String)"dfaInput");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            long start2 = System.currentTimeMillis();
            int actualMaxTasks = maxTasksPerTime;
            options.set(AnalysisOptions.INSTANCE.getAnalysisTimeLimitMs(), (Object)timeLimit);
            options.set(AnalysisOptions.INSTANCE.getFunctionEvaluationTimeLimitMs(), (Object)perFunctionTimeLimit);
            if (maxTasksPerTime == -1) {
                actualMaxTasks = ((Number)AnalysisOptions.INSTANCE.getMaxTasksPerTime().getDefaultValue()).intValue();
            }
            options.set(AnalysisOptions.INSTANCE.getMaxTasksPerTime(), (Object)actualMaxTasks);
            options.set(AnalysisOptions.INSTANCE.getEnableLogging(), (Object)DfaRegistry.isLogEnabled());
            options.set(AnalysisOptions.INSTANCE.getCheckEnvironment(), (Object)new AnalysisOptions.ConsistencyCheck(AnalysisOptions.CheckMode.Skip, null, 2, null));
            options.set(AnalysisOptions.INSTANCE.getCheckNotInitializedVars(), (Object)new AnalysisOptions.ConsistencyCheck(AnalysisOptions.CheckMode.Skip, null, 2, null));
            options.set(AnalysisOptions.INSTANCE.getCheckNotInitializedFields(), (Object)new AnalysisOptions.ConsistencyCheck(AnalysisOptions.CheckMode.Skip, null, 2, null));
            options.set(AnalysisOptions.INSTANCE.getCheckDeadConditions(), (Object)new AnalysisOptions.ConsistencyCheck(AnalysisOptions.CheckMode.Skip, null, 2, null));
            InterproceduralAnalysisDescription analysisDescription = new InterproceduralAnalysisDescription(null, null, null, null, EXTRA_RELATIONS, null, EXTRA_ANALYSES, null, 175, null);
            DfaSummarySession session2 = DfaSessionProvider.Companion.getInstance().createSummarySession((RMLAnalysisDescription)analysisDescription, project, options);
            DfaAnalysisIrResult results = session2.runDfaForProject(dfaInput);
            if (DfaRegistry.isLogEnabled()) {
                LOG.warn("DFA Prime finished in " + FormatHelperKt.formatDuration$default((long)(System.currentTimeMillis() - start2), (int)0, (int)2, null) + "; ");
            }
            return (DfaAnalysisRmlResult)results;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

