/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.intentions.altEnter.RiderShowIntentionActionsHandler;
import com.jetbrains.rider.model.RadTooltipHighlightInfo;
import com.jetbrains.rider.model.RadTooltipModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.awt.event.InputEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0003H\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/radler/intentions/RadTooltipAction;", "Lcom/intellij/openapi/editor/ex/TooltipAction;", "text", "", "highlightInfo", "Lcom/jetbrains/rider/model/RadTooltipHighlightInfo;", "psiFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rider/model/RadTooltipHighlightInfo;Lcom/intellij/psi/PsiFile;)V", "getText", "execute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "event", "Ljava/awt/event/InputEvent;", "showAllActions", "moveCaretToStartOffset", "intellij.rider.plugins.clion.radler"})
public final class RadTooltipAction
implements TooltipAction {
    @NotNull
    private final String text;
    @NotNull
    private final RadTooltipHighlightInfo highlightInfo;
    @NotNull
    private final PsiFile psiFile;

    public RadTooltipAction(@NlsSafe @NotNull String text, @NotNull RadTooltipHighlightInfo highlightInfo, @NotNull PsiFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)highlightInfo, (String)"highlightInfo");
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        this.text = text;
        this.highlightInfo = highlightInfo;
        this.psiFile = psiFile2;
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public void execute(@NotNull Editor editor, @Nullable InputEvent event) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.moveCaretToStartOffset(editor);
        Project project = this.psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RadTooltipModel_PregeneratedKt.getRadTooltipModel(SolutionHostExtensionsKt.getSolution(project)).getExecuteTooltipQuickFix().start(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.psiFile.getProject())), (Object)this.highlightInfo);
    }

    public void showAllActions(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.moveCaretToStartOffset(editor);
        RiderShowIntentionActionsHandler riderShowIntentionActionsHandler = new RiderShowIntentionActionsHandler();
        Project project = this.psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        riderShowIntentionActionsHandler.invoke(project, editor, this.psiFile);
    }

    private final void moveCaretToStartOffset(Editor editor) {
        editor.getSelectionModel().removeSelection();
        editor.getCaretModel().moveToOffset(this.highlightInfo.getStartOffset());
    }
}

