/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.projectmodel;

import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.radler.projectmodel.RadProjectModelHost;
import com.jetbrains.cidr.radler.projectmodel.RadProjectSnapshot;
import com.jetbrains.cidr.radler.projectmodel.RadProjectSnapshotBuilder;
import com.jetbrains.cidr.radler.util.RdCollectionUtilKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendEditorFoldingModelAdapter;
import com.jetbrains.rider.model.RadProjectModel;
import com.jetbrains.rider.model.RadProjectModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0007\u0018\u0000 02\u00020\u0001:\u0002/0B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u0006\u0010\u0014\u001a\u00020\u0013J\u000f\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0002\u0010\u0016J<\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\u001c\u0010\u001b\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001fJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J3\u0010)\u001a\u00020!2\u0006\u0010%\u001a\u00020&2\u001c\u0010*\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001cH\u0002\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020!H\u0002J\u0016\u0010-\u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010#J\b\u0010.\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "radProjectModel", "Lcom/jetbrains/rider/model/RadProjectModel;", "projectSyncFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "initialLoadScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "frontendVersion", "Ljava/util/concurrent/atomic/AtomicLong;", "backendVersion", "snapshotBuilder", "Lcom/jetbrains/cidr/radler/projectmodel/RadProjectSnapshotBuilder;", "isProjectSynced", "", "isProjectSyncedAtLeastOnce", "getSyncedVersion", "()Ljava/lang/Long;", "withSyncedProject", "T", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "action", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/intellij/openapi/diagnostic/Logger;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onBackendReload", "", "version", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "markProjectAsDirty", "reason", "", "scheduleInitialProjectSync", "scheduleSecondaryProjectSync", "scheduleSecondaryProjectSyncIf", "condition", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "scheduleProjectSync", "syncProjectWithBackend", "reloadFoldingState", "Listener", "Companion", "intellij.rider.plugins.clion.radler"})
@SourceDebugExtension(value={"SMAP\nRadProjectModelHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,334:1\n68#2,4:335\n68#2,4:345\n68#2,4:349\n14#2:353\n95#3:339\n135#3,3:340\n13472#4,2:343\n*S KotlinDebug\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost\n*L\n150#1:335,4\n125#1:345,4\n129#1:349,4\n305#1:353\n269#1:339\n269#1:340,3\n294#1:343,2\n*E\n"})
public final class RadProjectModelHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RadProjectModel radProjectModel;
    @NotNull
    private final MutableSharedFlow<Long> projectSyncFlow;
    @NotNull
    private final AtomicBoolean initialLoadScheduled;
    @NotNull
    private final AtomicLong frontendVersion;
    @NotNull
    private final AtomicLong backendVersion;
    @NotNull
    private final RadProjectSnapshotBuilder snapshotBuilder;
    @NotNull
    private static final Logger logger;
    private static final long INITIAL_FRONTEND_VERSION = 0L;
    private static final long INITIAL_BACKEND_VERSION = -1L;

    public RadProjectModelHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.radProjectModel = RadProjectModel_PregeneratedKt.getRadProjectModel(SolutionHostExtensionsKt.getSolution(this.project));
        this.projectSyncFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.initialLoadScheduled = new AtomicBoolean(false);
        this.frontendVersion = new AtomicLong(0L);
        this.backendVersion = new AtomicLong(-1L);
        this.snapshotBuilder = new RadProjectSnapshotBuilder();
        LifetimeCoroutineUtilKt.launch$default((Lifetime)this.getServiceLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RadProjectModelHost this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.projectSyncFlow), (long)DurationKt.toDuration((int)500, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<Long, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ long J$0;
                            final /* synthetic */ RadProjectModelHost this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                long l = this.J$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.J$0 = it;
                                        this.label = 1;
                                        Object object2 = this.this$0.syncProjectWithBackend((long)it, (Continuation<? super Unit>)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.J$0 = ((Number)value).longValue();
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(long p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @RequiresReadLock
    public final boolean isProjectSynced() {
        return this.getSyncedVersion() != null;
    }

    public final boolean isProjectSyncedAtLeastOnce() {
        return this.backendVersion.get() != -1L;
    }

    @RequiresReadLock
    @Nullable
    public final Long getSyncedVersion() {
        ThreadingAssertions.assertReadAccess();
        long backendVersion = this.backendVersion.get();
        long frontendVersion = this.frontendVersion.get();
        return backendVersion == frontendVersion ? Long.valueOf(backendVersion) : null;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final <T> Object withSyncedProject(@NotNull Logger logger, @NotNull Function1<? super Continuation<? super T>, ? extends Object> action, @NotNull Continuation<? super T> $completion) {
        if (!($completion instanceof withSyncedProject.1)) ** GOTO lbl-1000
        var16_4 = $completion;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ RadProjectModelHost this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.withSyncedProject(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                attempts = new Ref.IntRef();
                maxAttempts = 50;
lbl15:
                // 4 sources

                while (true) {
                    $continuation.L$0 = logger;
                    $continuation.L$1 = action;
                    $continuation.L$2 = attempts;
                    $continuation.L$3 = null;
                    $continuation.I$0 = maxAttempts;
                    $continuation.label = 1;
                    v0 = RadProjectModelHost.withSyncedProject$getVersionOrWait(logger, this, $continuation);
                    if (v0 == var17_6) {
                        return var17_6;
                    }
                    ** GOTO lbl33
                    break;
                }
            }
            case 1: {
                maxAttempts = $continuation.I$0;
                attempts = (Ref.IntRef)$continuation.L$2;
                action = (Function1)$continuation.L$1;
                logger = (Logger)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                v1 = (Long)v0;
                if (v1 != null) ** GOTO lbl36
                ** GOTO lbl15
lbl36:
                // 1 sources

                versionBefore = v1;
                $continuation.L$0 = logger;
                $continuation.L$1 = action;
                $continuation.L$2 = attempts;
                $continuation.I$0 = maxAttempts;
                $continuation.J$0 = versionBefore;
                $continuation.label = 2;
                v2 = action.invoke($continuation);
                if (v2 == var17_6) {
                    return var17_6;
                }
                ** GOTO lbl55
            }
            case 2: {
                versionBefore = $continuation.J$0;
                maxAttempts = $continuation.I$0;
                attempts = (Ref.IntRef)$continuation.L$2;
                action = (Function1)$continuation.L$1;
                logger = (Logger)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl55:
                // 2 sources

                result = v2;
                var9_11 = attempts.element;
                attempts.element = var9_11 + 1;
                if (!(attempts.element <= maxAttempts)) {
                    $i$a$-require-RadProjectModelHost$withSyncedProject$2 = false;
                    var10_14 = "Possible infinite loop detected, project model was updated " + maxAttempts + " times while we were trying to execute the action. Check that your action doesn't trigger project model update in any way";
                    throw new IllegalArgumentException(var10_14.toString());
                }
                $continuation.L$0 = logger;
                $continuation.L$1 = action;
                $continuation.L$2 = attempts;
                $continuation.L$3 = result;
                $continuation.I$0 = maxAttempts;
                $continuation.J$0 = versionBefore;
                $continuation.label = 3;
                v3 = RadProjectModelHost.withSyncedProject$getVersionOrWait(logger, this, $continuation);
                if (v3 == var17_6) {
                    return var17_6;
                }
                ** GOTO lbl83
            }
            case 3: {
                versionBefore = $continuation.J$0;
                maxAttempts = $continuation.I$0;
                result = $continuation.L$3;
                attempts = (Ref.IntRef)$continuation.L$2;
                action = (Function1)$continuation.L$1;
                logger = (Logger)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl83:
                // 2 sources

                v4 = (Long)v3;
                if (v4 != null) ** GOTO lbl86
                ** GOTO lbl15
lbl86:
                // 1 sources

                versionAfter = v4;
                if (versionBefore == versionAfter) ** break;
                ** continue;
                $this$trace$iv = logger;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var14_17 = $this$trace$iv;
                    $i$a$-trace-RadProjectModelHost$withSyncedProject$3 = false;
                    var14_17.trace("Action executed in " + attempts.element + " attempt(s) (of " + maxAttempts + " possible) with version " + versionAfter);
                }
                return result;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object withSyncedProject$default(RadProjectModelHost radProjectModelHost, Logger logger, Function1 function1, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            logger = RadProjectModelHost.logger;
        }
        return radProjectModelHost.withSyncedProject(logger, function1, continuation);
    }

    @Nullable
    public final Object onBackendReload(long version, @NotNull Continuation<? super Unit> $completion) {
        Object object = com.intellij.openapi.application.CoroutinesKt.edtWriteAction((Function0)((Function0)new Function0<Unit>(this, version){
            final /* synthetic */ RadProjectModelHost this$0;
            final /* synthetic */ long $version;
            {
                this.this$0 = $receiver;
                this.$version = $version;
                super(0);
            }

            public final void invoke() {
                RadProjectModelHost.access$getBackendVersion$p(this.this$0).set(this.$version);
                RadProjectModelHost.access$getLogger$cp().info("Backend project reloaded (version: " + this.$version + ")");
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void markProjectAsDirty(String reason) {
        long version = this.frontendVersion.incrementAndGet();
        logger.info(reason + " (version: " + version + ", has WA: " + ApplicationKt.getApplication().isWriteAccessAllowed() + ")");
    }

    private final void scheduleInitialProjectSync(String reason) {
        this.markProjectAsDirty(reason);
        this.initialLoadScheduled.set(true);
        this.scheduleProjectSync();
    }

    private final void scheduleSecondaryProjectSync(String reason) {
        this.markProjectAsDirty(reason);
        if (this.initialLoadScheduled.get()) {
            this.scheduleProjectSync();
        }
    }

    private final void scheduleSecondaryProjectSyncIf(String reason, Function1<? super Continuation<? super Boolean>, ? extends Object> condition) {
        LifetimeCoroutineUtilKt.launch$default((Lifetime)this.getServiceLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(condition, this, reason, null){
            int label;
            final /* synthetic */ Function1<Continuation<? super Boolean>, Object> $condition;
            final /* synthetic */ RadProjectModelHost this$0;
            final /* synthetic */ String $reason;
            {
                this.$condition = $condition;
                this.this$0 = $receiver;
                this.$reason = $reason;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$condition.invoke((Object)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (((Boolean)v0).booleanValue()) {
                            RadProjectModelHost.access$scheduleSecondaryProjectSync(this.this$0, this.$reason);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void scheduleProjectSync() {
        long version = this.frontendVersion.get();
        logger.info("Scheduling C++ project model sync (with version = " + version + ")");
        this.projectSyncFlow.tryEmit((Object)version);
    }

    /*
     * Unable to fully structure code
     */
    private final Object syncProjectWithBackend(long version, Continuation<? super Unit> $completion) {
        if (!($completion instanceof syncProjectWithBackend.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                long J$0;
                long J$1;
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RadProjectModelHost this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RadProjectModelHost.access$syncProjectWithBackend(this.this$0, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                RadProjectModelHost.logger.info("Trying to build snapshot with version = " + version);
                $i$f$measureTimedValue = false;
                $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
                $i$f$measureTimedValue = false;
                mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
                $i$a$-measureTimedValue-RadProjectModelHost$syncProjectWithBackend$2 = false;
                result$iv$iv = this.snapshotBuilder.getProjectSnapshot(this.project, version);
                var4_16 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
                snapshot = (RadProjectSnapshot)var4_16.component1();
                snapshotTime = var4_16.component2-UwyO8pc();
                RadProjectModelHost.logger.info("C++ project model snapshot calculated in " + Duration.getInWholeMilliseconds-impl((long)snapshotTime) + "ms");
                $continuation.L$0 = snapshot;
                $continuation.J$0 = version;
                $continuation.J$1 = snapshotTime;
                $continuation.label = 1;
                v0 = CoroutinesKt.checkCanceled((Continuation)$continuation);
                if (v0 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl38
            }
            case 1: {
                snapshotTime = $continuation.J$1;
                version = $continuation.J$0;
                snapshot = (RadProjectSnapshot)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                this.reloadFoldingState();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)snapshot);
                $continuation.J$0 = version;
                $continuation.J$1 = snapshotTime;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Duration>, Object>(this, snapshot, null){
                    int label;
                    final /* synthetic */ RadProjectModelHost this$0;
                    final /* synthetic */ RadProjectSnapshot $snapshot;
                    {
                        this.this$0 = $receiver;
                        this.$snapshot = $snapshot;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                RadProjectModelHost radProjectModelHost = this.this$0;
                                RadProjectSnapshot radProjectSnapshot = this.$snapshot;
                                boolean $i$f$measureTime = false;
                                TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
                                boolean $i$f$measureTime2 = false;
                                long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
                                boolean bl = false;
                                com.jetbrains.cidr.radler.projectmodel.RadProjectModelHost$Companion.access$updateProtocolProjectModel(RadProjectModelHost.Companion, RadProjectModelHost.access$getRadProjectModel$p(radProjectModelHost), radProjectSnapshot);
                                return Duration.box-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Duration> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl53
            }
            case 2: {
                snapshotTime = $continuation.J$1;
                version = $continuation.J$0;
                snapshot = (RadProjectSnapshot)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl53:
                // 2 sources

                updateTime = ((Duration)v1).unbox-impl();
                RadProjectModelHost.logger.info("C++ project model updated in " + Duration.getInWholeMilliseconds-impl((long)updateTime) + "ms");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void reloadFoldingState() {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        FileEditor[] fileEditorArray = fileEditorManager.getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        Object[] $this$forEach$iv = fileEditorArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Editor editor;
            FileEditor it = (FileEditor)element$iv;
            boolean bl = false;
            if (!(it instanceof TextEditor)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((TextEditor)it).getEditor(), (String)"getEditor(...)");
            if (!CodeFoldingManagerImpl.isAsyncFoldingUpdater((Editor)editor)) continue;
            FrontendEditorFoldingModelAdapter.Companion.setReloadingState(editor);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final Object withSyncedProject$getVersionOrWait(Logger $logger, RadProjectModelHost this$0, Continuation<? super Long> $completion) {
        if (!($completion instanceof withSyncedProject.getVersionOrWait.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                long J$0;
                long J$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RadProjectModelHost.access$withSyncedProject$getVersionOrWait(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $logger;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)this$0);
                $continuation.label = 1;
                v0 = com.intellij.openapi.application.CoroutinesKt.readAction((Function0)((Function0)new Function0<Pair<? extends Long, ? extends Long>>(this$0){
                    final /* synthetic */ RadProjectModelHost this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final Pair<Long, Long> invoke() {
                        return TuplesKt.to((Object)RadProjectModelHost.access$getBackendVersion$p(this.this$0).get(), (Object)RadProjectModelHost.access$getFrontendVersion$p(this.this$0).get());
                    }
                }), (Continuation)$continuation);
                if (v0 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                this$0 = (RadProjectModelHost)$continuation.L$1;
                $logger = (Logger)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((backendVersion = ((Number)(var3_6 = (Pair)v0).component1()).longValue()) == (frontendVersion = ((Number)var3_6.component2()).longValue())) {
                    $this$trace$iv = $logger;
                    $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        var11_15 = $this$trace$iv;
                        $i$a$-trace-RadProjectModelHost$withSyncedProject$getVersionOrWait$3 = false;
                        var11_15.trace("Project versions are in sync: " + backendVersion);
                    }
                    return Boxing.boxLong((long)backendVersion);
                }
                $this$trace$iv = $logger;
                $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    var11_16 = $this$trace$iv;
                    $i$a$-trace-RadProjectModelHost$withSyncedProject$getVersionOrWait$4 = false;
                    var11_16.trace("Project versions are not in sync: backend (" + backendVersion + ") != frontend (" + frontendVersion + ")");
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$logger);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)this$0);
                $continuation.J$0 = backendVersion;
                $continuation.J$1 = frontendVersion;
                $continuation.label = 2;
                v1 = DelayKt.delay((long)10L, (Continuation)$continuation);
                if (v1 == var14_5) {
                    return var14_5;
                }
                ** GOTO lbl56
            }
            case 2: {
                frontendVersion = $continuation.J$1;
                backendVersion = $continuation.J$0;
                this$0 = (RadProjectModelHost)$continuation.L$1;
                $logger = (Logger)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl56:
                // 2 sources

                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ AtomicLong access$getBackendVersion$p(RadProjectModelHost $this) {
        return $this.backendVersion;
    }

    public static final /* synthetic */ RadProjectModel access$getRadProjectModel$p(RadProjectModelHost $this) {
        return $this.radProjectModel;
    }

    public static final /* synthetic */ Object access$withSyncedProject$getVersionOrWait(Logger $logger, RadProjectModelHost this$0, Continuation $completion) {
        return RadProjectModelHost.withSyncedProject$getVersionOrWait($logger, this$0, (Continuation<? super Long>)$completion);
    }

    public static final /* synthetic */ AtomicLong access$getFrontendVersion$p(RadProjectModelHost $this) {
        return $this.frontendVersion;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RadProjectModelHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RadProjectModelHost.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost;", "project", "Lcom/intellij/openapi/project/Project;", "INITIAL_FRONTEND_VERSION", "", "INITIAL_BACKEND_VERSION", "updateProtocolProjectModel", "", "model", "Lcom/jetbrains/rider/model/RadProjectModel;", "snapshot", "Lcom/jetbrains/cidr/radler/projectmodel/RadProjectSnapshot;", "intellij.rider.plugins.clion.radler"})
    @SourceDebugExtension(value={"SMAP\nRadProjectModelHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,334:1\n30#2,2:335\n*S KotlinDebug\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Companion\n*L\n306#1:335,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RadProjectModelHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RadProjectModelHost> serviceClass$iv = RadProjectModelHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RadProjectModelHost)((Object)object);
        }

        private final void updateProtocolProjectModel(RadProjectModel model2, RadProjectSnapshot snapshot) {
            logger.info("Sending updates, project model has " + snapshot.getSources().size() + " sources and " + snapshot.getWeakSources().size() + " weak sources (version: " + snapshot.getVersion() + ")");
            RdCollectionUtilKt.replaceAll(model2.getSourceFiles(), SequencesKt.map((Sequence)MapsKt.asSequence((Map)snapshot.getSources()), (Function1)updateProtocolProjectModel.1.INSTANCE));
            RdCollectionUtilKt.replaceAll(model2.getWeakSourceFiles(), SequencesKt.map((Sequence)MapsKt.asSequence((Map)snapshot.getWeakSources()), (Function1)updateProtocolProjectModel.2.INSTANCE));
            if (!Intrinsics.areEqual((Object)snapshot.getFallback(), (Object)model2.getFallback().getValue())) {
                model2.getFallback().set((Object)snapshot.getFallback());
            }
            RdCollectionUtilKt.replaceAll(model2.getSourceRoots(), (Iterable)snapshot.getSourceRoots());
            model2.getVersion().set((Object)snapshot.getVersion());
            model2.getName().set((Object)snapshot.getProjectName());
            model2.getBasePath().set((Object)snapshot.getBasePath());
            if (logger.isTraceEnabled()) {
                logger.trace("Sending " + IPrintableKt.printToString((Object)((Object)model2)));
            }
            InterfacesKt.fire((ISignal)((ISignal)model2.getMustReload()));
        }

        public static final /* synthetic */ void access$updateProtocolProjectModel(Companion $this, RadProjectModel model2, RadProjectSnapshot snapshot) {
            $this.updateProtocolProjectModel(model2, snapshot);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014H\u0003J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0015H\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Listener;", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "selectedResolveConfigurationChanged", "", "workspaceChanged", "event", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspaceListener$OCWorkspaceEvent;", "workspaceInitializationFinished", "success", "", "after", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "rootsChanged", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "hasInterestingEvents", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "isInterestingEvent", "intellij.rider.plugins.clion.radler"})
    @SourceDebugExtension(value={"SMAP\nRadProjectModelHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Listener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,334:1\n1761#2,3:335\n61#3,5:338\n*S KotlinDebug\n*F\n+ 1 RadProjectModelHost.kt\ncom/jetbrains/cidr/radler/projectmodel/RadProjectModelHost$Listener\n*L\n194#1:335,3\n207#1:338,5\n*E\n"})
    public static final class Listener
    implements OCWorkspaceListener,
    BulkFileListener,
    ModuleRootListener {
        @NotNull
        private final Project project;

        public Listener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public void selectedResolveConfigurationChanged() {
            Companion.getInstance(this.project).scheduleInitialProjectSync("Processing changed resolve configuration");
        }

        public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Companion.getInstance(this.project).scheduleSecondaryProjectSync("Processing changed workspace");
        }

        public void workspaceInitializationFinished(boolean success2) {
            Companion.getInstance(this.project).scheduleInitialProjectSync("Processing initialized workspace");
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Companion.getInstance(this.project).scheduleSecondaryProjectSyncIf("Processing VFS change", (Function1<? super Continuation<? super Boolean>, ? extends Object>)((Function1)new Function1<Continuation<? super Boolean>, Object>(this, events, null){
                int label;
                final /* synthetic */ Listener this$0;
                final /* synthetic */ List<? extends VFileEvent> $events;
                {
                    this.this$0 = $receiver;
                    this.$events = $events;
                    super(1, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this.this$0, this.$events, null){
                                Object L$0;
                                int label;
                                final /* synthetic */ Listener this$0;
                                final /* synthetic */ List<? extends VFileEvent> $events;
                                {
                                    this.this$0 = $receiver;
                                    this.$events = $events;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.this$0.getProject());
                                            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
                                            ProjectFileIndex fileIndex = projectFileIndex;
                                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)fileIndex);
                                            this.label = 1;
                                            Object object2 = com.intellij.openapi.application.CoroutinesKt.readAction((Function0)((Function0)new Function0<Boolean>(this.this$0, fileIndex, this.$events){
                                                final /* synthetic */ Listener this$0;
                                                final /* synthetic */ ProjectFileIndex $fileIndex;
                                                final /* synthetic */ List<? extends VFileEvent> $events;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$fileIndex = $fileIndex;
                                                    this.$events = $events;
                                                    super(0);
                                                }

                                                public final Boolean invoke() {
                                                    return Listener.access$hasInterestingEvents(this.this$0, this.$fileIndex, this.$events);
                                                }
                                            }), (Continuation)((Continuation)this));
                                            if (object2 != object) return object2;
                                            return object;
                                        }
                                        case 1: {
                                            ProjectFileIndex fileIndex = (ProjectFileIndex)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return object2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super Boolean> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Companion.getInstance(this.project).scheduleSecondaryProjectSync("Processing project root change event");
        }

        @RequiresReadLock
        @RequiresBackgroundThread
        private final boolean hasInterestingEvents(ProjectFileIndex fileIndex, List<? extends VFileEvent> events) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = events;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VFileEvent it = (VFileEvent)element$iv;
                        boolean bl2 = false;
                        if (!this.isInterestingEvent(fileIndex, it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @RequiresReadLock
        @RequiresBackgroundThread
        private final boolean isInterestingEvent(ProjectFileIndex fileIndex, VFileEvent event) {
            boolean bl;
            if (event instanceof VFileContentChangeEvent) {
                return false;
            }
            VirtualFile virtualFile = event.getFile();
            if (virtualFile == null) {
                return true;
            }
            VirtualFile file = virtualFile;
            boolean isInContent = fileIndex.isInContent(file);
            if (!isInContent) {
                Logger $this$debug_u24default$iv = logger;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("Received VFS event for file not in current project's content", e$iv);
                }
                return false;
            }
            VFileEvent vFileEvent = event;
            if (vFileEvent instanceof VFileCopyEvent || vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileMoveEvent || vFileEvent instanceof VFileDeleteEvent) {
                bl = file.isDirectory() || LanguageUtils.Companion.getInstance().isSupportedFile(file);
            } else if (vFileEvent instanceof VFilePropertyChangeEvent) {
                bl = file.isDirectory() && Intrinsics.areEqual((Object)((VFilePropertyChangeEvent)event).getPropertyName(), (Object)"name");
            } else {
                logger.warn("Unhandled file change event " + event);
                bl = false;
            }
            return bl;
        }

        public static final /* synthetic */ boolean access$hasInterestingEvents(Listener $this, ProjectFileIndex fileIndex, List events) {
            return $this.hasInterestingEvents(fileIndex, events);
        }
    }
}

