/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.settings;

import com.intellij.application.options.colors.InspectionColorSettingsPage;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.settings.CidrCodeStylePreview;
import com.jetbrains.cidr.radler.fileType.RadFileHighlighter;
import com.jetbrains.cidr.radler.settings.RadColorSettingsPageKt;
import com.jetbrains.rider.cpp.fileType.CppLanguage;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/radler/settings/RadColorSettingsPage;", "Lcom/intellij/openapi/options/colors/RainbowColorSettingsPage;", "Lcom/intellij/application/options/colors/InspectionColorSettingsPage;", "Lcom/intellij/psi/codeStyle/DisplayPrioritySortable;", "<init>", "()V", "getDisplayName", "", "getIcon", "Ljavax/swing/Icon;", "getPriority", "Lcom/intellij/psi/codeStyle/DisplayPriority;", "getAttributeDescriptors", "", "Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "()[Lcom/intellij/openapi/options/colors/AttributesDescriptor;", "getColorDescriptors", "Lcom/intellij/openapi/options/colors/ColorDescriptor;", "()[Lcom/intellij/openapi/options/colors/ColorDescriptor;", "getHighlighter", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "getDemoText", "getAdditionalHighlightingTagToDescriptorMap", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "isRainbowType", "", "type", "getLanguage", "Lcom/intellij/lang/Language;", "intellij.rider.plugins.clion.radler"})
public final class RadColorSettingsPage
implements RainbowColorSettingsPage,
InspectionColorSettingsPage,
DisplayPrioritySortable {
    @NotNull
    public String getDisplayName() {
        return CppLanguage.INSTANCE.getDisplayName();
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public DisplayPriority getPriority() {
        return DisplayPriority.KEY_LANGUAGE_SETTINGS;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        return RadColorSettingsPageKt.access$getCOLOR_ATTRS$p();
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        Intrinsics.checkNotNullExpressionValue((Object)ColorDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return (SyntaxHighlighter)new RadFileHighlighter((OCLanguageKind)CLanguageKind.Companion.maxLanguage(), OCLanguageStandard.Companion.latestCpp());
    }

    @NotNull
    public String getDemoText() {
        String string = CidrCodeStylePreview.getCodeSample((String)"Colors", (String)"cpp");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCodeSample(...)");
        String string2 = RainbowHighlighter.generatePaletteExample((String)"\n     * ");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generatePaletteExample(...)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"{$SEMANTIC_DEMO}", (String)string2, (boolean)false, (int)4, null), (String)"<cd_comment_tag_val>A</cd_comment_tag_val>", (String)"<cd_comment_tag_val><macro_par><cd_comment_tag_val>A</cd_comment_tag_val></macro_par></cd_comment_tag_val>", (boolean)false, (int)4, null), (String)"using namespace", (String)"#define <macro>STRINGIFY</macro>(<macro_par>x</macro_par>) #<macro_par>x</macro_par>\n\nusing namespace", (boolean)false, (int)4, null);
    }

    @NotNull
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        Map map = RainbowHighlighter.createRainbowHLM();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createRainbowHLM(...)");
        Map answer = map;
        answer.put("kw", OCHighlightingKeys.SELFSUPERTHIS);
        answer.put("evar", OCHighlightingKeys.EXTERN_VARIABLE);
        answer.put("gvar", OCHighlightingKeys.GLOBAL_VARIABLE);
        answer.put("lvar", OCHighlightingKeys.LOCAL_VARIABLE);
        answer.put("par", OCHighlightingKeys.PARAMETER);
        answer.put("fun_call", OCHighlightingKeys.FUNCTION_CALL);
        answer.put("fun_decl", OCHighlightingKeys.FUNCTION_DECLARATION);
        answer.put("op", OCHighlightingKeys.OVERLOADED_OPERATOR);
        answer.put("prop", OCHighlightingKeys.PROPERTY);
        answer.put("prop_attr", OCHighlightingKeys.PROPERTY_ATTRIBUTE);
        answer.put("sfield", OCHighlightingKeys.STRUCT_FIELD);
        answer.put("sel_call", OCHighlightingKeys.METHOD_CALL);
        answer.put("sel_decl", OCHighlightingKeys.METHOD_DECLARATION);
        answer.put("ifdef", OCHighlightingKeys.CONDITIONALLY_NOT_COMPILED);
        answer.put("macro", OCHighlightingKeys.MACRONAME);
        answer.put("macro_par", OCHighlightingKeys.MACRO_PARAMETER);
        answer.put("ivar", OCHighlightingKeys.INSTANCE_VARIABLE);
        answer.put("struct", OCHighlightingKeys.STRUCT_LIKE);
        answer.put("cls", OCHighlightingKeys.CLASS_REFERENCE);
        answer.put("prt", OCHighlightingKeys.PROTOCOL_REFERENCE);
        answer.put("enum", OCHighlightingKeys.ENUM_CONST);
        answer.put("label", OCHighlightingKeys.LABEL);
        answer.put("def", OCHighlightingKeys.TYPEDEF);
        answer.put("fmt", OCHighlightingKeys.OC_FORMAT_STRING_TOKEN);
        answer.put("templt", OCHighlightingKeys.TEMPLATE_TYPE);
        answer.put("templv", OCHighlightingKeys.TEMPLATE_VALUE);
        answer.put("ns", OCHighlightingKeys.NAMESPACE_LIKE);
        answer.put("generic", OCHighlightingKeys.GENERIC_PARAMETER);
        answer.put("concept", OCHighlightingKeys.CONCEPT);
        answer.put("deduction_guide", OCHighlightingKeys.DEDUCTION_GUIDE);
        answer.put("cd_comment", OCHighlightingKeys.OC_DOC_COMMENT);
        answer.put("cd_comment_tag", OCHighlightingKeys.OC_DOC_COMMENT_TAG);
        answer.put("cd_comment_tag_val", OCHighlightingKeys.OC_DOC_COMMENT_TAG_VALUE);
        answer.put("std_init_list_braces", OCHighlightingKeys.STD_INIT_LIST_BRACES);
        answer.put("dep_code", OCHighlightingKeys.DEPENDENT_CODE);
        answer.put("constant", OCHighlightingKeys.CONSTANT);
        return answer;
    }

    public boolean isRainbowType(@Nullable TextAttributesKey type) {
        return Intrinsics.areEqual((Object)OCHighlightingKeys.LOCAL_VARIABLE, (Object)type) || Intrinsics.areEqual((Object)OCHighlightingKeys.PARAMETER, (Object)type);
    }

    @NotNull
    public Language getLanguage() {
        return CppLanguage.INSTANCE;
    }
}

