/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.settings.migration;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.util.ApplicationKt;
import com.jetbrains.cidr.CidrProjectApplicationVersion;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.CidrCodeStyleSettings;
import com.jetbrains.cidr.radler.clangFormat.RadClangFormatHelper;
import com.jetbrains.cidr.radler.settings.migration.RadMigrationCollector;
import com.jetbrains.rd.ide.model.KeyPathComponents;
import com.jetbrains.rd.ide.model.PredefinedValue;
import com.jetbrains.rider.settings.RiderCustomCodeStyleSettings;
import com.jetbrains.rider.settings.SettingsSynchronizerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/radler/settings/migration/RadMigrateCodeStyleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "intellij.rider.plugins.clion.radler"})
public final class RadMigrateCodeStyleAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CPP_OPTION_PREFIX = "CodeStyle/CodeFormatting/CppFormatting";
    @NotNull
    private static final String ID_MIGRATION_ACTION = "RadMigrateCodeStyle";

    public RadMigrateCodeStyleAction() {
        RadMigrateCodeStyleAction.Companion.log("Action instantiated");
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = AnAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Companion.resetCodeStyle(project2);
        RadMigrateCodeStyleAction.Companion.performMigration(project2, true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001c\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0012\u0010\u0012\u001a\u00020\r2\b\b\u0001\u0010\u0011\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0013H\u0002J&\u0010\u0016\u001a\u00020\r2\b\b\u0001\u0010\u0011\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\n2\b\b\u0002\u0010\u0018\u001a\u00020\nH\u0002J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\rH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/radler/settings/migration/RadMigrateCodeStyleAction$Companion;", "", "<init>", "()V", "resetCodeStyle", "", "project", "Lcom/intellij/openapi/project/Project;", "performMigration", "migrateForNovaProjects", "", "fireCodeStyleSettingChanged", "CPP_OPTION_PREFIX", "", "cppEntry", "optionName", "getTernaryOperatorAlignStyle", "option", "getSimpleEmbeddedStatementStyle", "", "getConvertedWrapStyle", "getConvertedWrapToSimpleEmbeddedStatementStyle", "getBraceFormatStyleStyle", "withSpace", "withCompactOption", "ID_MIGRATION_ACTION", "migrateCodeStyleFromCidrToRad", "log", "message", "intellij.rider.plugins.clion.radler"})
    @SourceDebugExtension(value={"SMAP\nRadMigrateCodeStyleAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadMigrateCodeStyleAction.kt\ncom/jetbrains/cidr/radler/settings/migration/RadMigrateCodeStyleAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 SettingsSynchronizer.kt\ncom/jetbrains/rider/settings/SettingsSynchronizerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,403:1\n1869#2,2:404\n1869#2,2:504\n30#3,2:406\n310#4:408\n310#4:409\n310#4:410\n310#4:411\n310#4:412\n310#4:413\n310#4:414\n310#4:415\n310#4:416\n310#4:417\n310#4:418\n310#4:419\n310#4:420\n310#4:421\n310#4:422\n310#4:423\n310#4:424\n310#4:425\n310#4:426\n310#4:427\n310#4:428\n310#4:429\n310#4:430\n310#4:431\n310#4:432\n310#4:433\n310#4:434\n310#4:435\n310#4:436\n310#4:437\n310#4:438\n310#4:439\n310#4:440\n310#4:441\n310#4:442\n310#4:443\n310#4:444\n310#4:445\n310#4:446\n310#4:447\n310#4:448\n310#4:449\n310#4:450\n310#4:451\n310#4:452\n310#4:453\n310#4:454\n310#4:455\n310#4:456\n310#4:457\n310#4:458\n310#4:459\n310#4:460\n310#4:461\n310#4:462\n310#4:463\n310#4:464\n310#4:465\n310#4:466\n310#4:467\n310#4:468\n310#4:469\n310#4:470\n310#4:471\n310#4:472\n310#4:473\n310#4:474\n310#4:475\n310#4:476\n310#4:477\n310#4:478\n310#4:479\n310#4:480\n310#4:481\n310#4:482\n310#4:483\n310#4:484\n310#4:485\n310#4:486\n310#4:487\n310#4:488\n310#4:489\n310#4:490\n310#4:491\n310#4:492\n310#4:493\n310#4:494\n310#4:495\n310#4:496\n310#4:497\n310#4:498\n310#4:499\n310#4:500\n310#4:501\n310#4:502\n310#4:503\n14#5:506\n*S KotlinDebug\n*F\n+ 1 RadMigrateCodeStyleAction.kt\ncom/jetbrains/cidr/radler/settings/migration/RadMigrateCodeStyleAction$Companion\n*L\n72#1:404,2\n294#1:504,2\n81#1:406,2\n88#1:408\n89#1:409\n95#1:410\n96#1:411\n98#1:412\n99#1:413\n100#1:414\n101#1:415\n103#1:416\n106#1:417\n108#1:418\n109#1:419\n111#1:420\n112#1:421\n113#1:422\n115#1:423\n129#1:424\n130#1:425\n133#1:426\n134#1:427\n136#1:428\n139#1:429\n140#1:430\n142#1:431\n143#1:432\n145#1:433\n147#1:434\n148#1:435\n150#1:436\n154#1:437\n156#1:438\n157#1:439\n158#1:440\n160#1:441\n161#1:442\n163#1:443\n164#1:444\n165#1:445\n172#1:446\n186#1:447\n188#1:448\n189#1:449\n190#1:450\n191#1:451\n193#1:452\n197#1:453\n198#1:454\n199#1:455\n202#1:456\n205#1:457\n207#1:458\n208#1:459\n210#1:460\n211#1:461\n213#1:462\n214#1:463\n216#1:464\n217#1:465\n218#1:466\n219#1:467\n221#1:468\n222#1:469\n223#1:470\n225#1:471\n226#1:472\n227#1:473\n228#1:474\n230#1:475\n231#1:476\n232#1:477\n233#1:478\n235#1:479\n236#1:480\n237#1:481\n238#1:482\n239#1:483\n240#1:484\n242#1:485\n243#1:486\n245#1:487\n246#1:488\n247#1:489\n249#1:490\n250#1:491\n251#1:492\n253#1:493\n254#1:494\n256#1:495\n258#1:496\n263#1:497\n264#1:498\n265#1:499\n276#1:500\n282#1:501\n283#1:502\n289#1:503\n399#1:506\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void resetCodeStyle(@Nullable Project project) {
            CodeStyleSettings codeStyleSettings = CodeStyle.getProjectOrDefaultSettings((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getProjectOrDefaultSettings(...)");
            CodeStyleSettings settings = codeStyleSettings;
            CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(RiderCustomCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            RiderCustomCodeStyleSettings riderCustomSettings = (RiderCustomCodeStyleSettings)customCodeStyleSettings;
            riderCustomSettings.getData().clear();
            this.fireCodeStyleSettingChanged(project);
        }

        private final void performMigration(Project project, boolean migrateForNovaProjects) {
            CommonCodeStyleSettings.IndentOptions indentOptions;
            CidrCodeStyleSettings cidrCustomSettings;
            KeyPathComponents it;
            if (project != null && CidrProjectApplicationVersion.Companion.getInstance(project).isRadlerProject() && !migrateForNovaProjects) {
                this.log("Skip migration for Nova Projects");
                return;
            }
            CodeStyleSettings codeStyleSettings = CodeStyle.getProjectOrDefaultSettings((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getProjectOrDefaultSettings(...)");
            CodeStyleSettings settings = codeStyleSettings;
            CustomCodeStyleSettings customCodeStyleSettings = settings.getCustomSettings(RiderCustomCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            RiderCustomCodeStyleSettings riderCustomSettings = (RiderCustomCodeStyleSettings)customCodeStyleSettings;
            Iterable $this$forEach$iv = riderCustomSettings.getData().keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KeyPathComponents)element$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it.getRawKey(), (CharSequence)RadMigrateCodeStyleAction.CPP_OPTION_PREFIX, (boolean)false, (int)2, null)) continue;
                Companion.log("Skip migration for Projects with Radler Code Style customization");
                return;
            }
            List options = new ArrayList();
            Object $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
            boolean $i$f$service22 = false;
            Class<RadClangFormatHelper> serviceClass$iv = RadClangFormatHelper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            boolean cfIsEnabled = ((RadClangFormatHelper)object).isClangFormatEnabled(project);
            RadMigrationCollector.INSTANCE.getCLION_NOVA_CODE_STYLE_MIGRATION_EVENT().log((Object)(project != null && CodeStyle.usesOwnSettings((Project)project) ? 1 : 0), (Object)cfIsEnabled);
            $this$service$iv = options;
            Object[] $i$f$service22 = new Pair[2];
            String reSharperKey$iv = "CodeStyle/CodeFormatting/CppClangFormat/EnableClangFormatSupport";
            boolean $i$f$entry = false;
            $i$f$service22[0] = TuplesKt.to((Object)SettingsSynchronizerKt.key(reSharperKey$iv), (Object)new Function0<PredefinedValue>(cfIsEnabled){
                final /* synthetic */ boolean $cfIsEnabled$inlined;
                {
                    this.$cfIsEnabled$inlined = bl;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$cfIsEnabled$inlined);
                }
            });
            reSharperKey$iv = "CodeStyle/EditorConfig/EnableClangFormatSupport";
            $i$f$entry = false;
            $i$f$service22[1] = TuplesKt.to((Object)SettingsSynchronizerKt.key(reSharperKey$iv), (Object)new Function0<PredefinedValue>(){

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(false);
                }
            });
            CollectionsKt.addAll((Collection)$this$service$iv, (Iterable)CollectionsKt.listOf((Object[])$i$f$service22));
            CommonCodeStyleSettings commonCodeStyleSettings = settings.getCommonSettings((Language)OCLanguage.getInstance());
            Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getCommonSettings(...)");
            CommonCodeStyleSettings commonSettings = commonCodeStyleSettings;
            it = commonSettings;
            boolean bl = false;
            Collection collection = options;
            Object object2 = new Pair[36];
            Object reSharperKey$iv2 = Companion.cppEntry("ALIGN_MULTILINE_BINARY_EXPRESSIONS_CHAIN");
            boolean $i$f$entry2 = false;
            object2[0] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.ALIGN_MULTILINE_BINARY_OPERATION);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("ALIGN_MULTILINE_CALLS_CHAIN");
            $i$f$entry2 = false;
            object2[1] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.ALIGN_MULTILINE_CHAINED_METHODS);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("ALIGN_MULTILINE_EXPRESSION");
            $i$f$entry2 = false;
            object2[2] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("ALIGN_MULTILINE_FOR_STMT");
            $i$f$entry2 = false;
            object2[3] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.ALIGN_MULTILINE_FOR);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("ALIGN_MULTIPLE_DECLARATION");
            $i$f$entry2 = false;
            object2[4] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.ALIGN_GROUP_FIELD_DECLARATIONS);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("ALIGN_TERNARY");
            $i$f$entry2 = false;
            object2[5] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.access$getTernaryOperatorAlignStyle(RadMigrateCodeStyleAction.Companion, this.$it$inlined.ALIGN_MULTILINE_TERNARY_OPERATION));
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("BLANK_LINES_AROUND_CLASS_DEFINITION");
            $i$f$entry2 = false;
            object2[6] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.BLANK_LINES_AROUND_CLASS);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("KEEP_BLANK_LINES_IN_DECLARATIONS");
            $i$f$entry2 = false;
            object2[7] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.KEEP_BLANK_LINES_IN_DECLARATIONS);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("KEEP_BLANK_LINES_IN_CODE");
            $i$f$entry2 = false;
            object2[8] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.KEEP_BLANK_LINES_IN_CODE);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("KEEP_USER_LINEBREAKS");
            $i$f$entry2 = false;
            object2[9] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.KEEP_LINE_BREAKS);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("INDENT_CASE_FROM_SWITCH");
            $i$f$entry2 = false;
            object2[10] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.INDENT_CASE_FROM_SWITCH);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("INDENT_COMMENT");
            $i$f$entry2 = false;
            object2[11] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.KEEP_FIRST_COLUMN_COMMENT);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("INT_ALIGN_EQ");
            $i$f$entry2 = false;
            object2[12] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.ALIGN_GROUP_FIELD_DECLARATIONS);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SIMPLE_BLOCK_STYLE");
            $i$f$entry2 = false;
            object2[13] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    String string;
                    boolean bl = false;
                    boolean bl2 = this.$it$inlined.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
                    if (!bl2) {
                        string = "LINE_BREAK";
                    } else if (bl2) {
                        string = "DO_NOT_CHANGE";
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    return SettingsSynchronizerKt.asPredefinedType(string);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPACE_AFTER_COMMA_IN_TEMPLATE_ARGS");
            $i$f$entry2 = false;
            object2[14] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPACE_AFTER_COMMA_IN_TEMPLATE_PARAMS");
            $i$f$entry2 = false;
            object2[15] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_COMMA_IN_TYPE_ARGUMENTS);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPACE_AFTER_FOR_SEMICOLON");
            $i$f$entry2 = false;
            object2[16] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_SEMICOLON);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPACE_BEFORE_FOR_SEMICOLON");
            $i$f$entry2 = false;
            object2[17] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_SEMICOLON);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPACE_AFTER_UNARY_OPERATOR");
            $i$f$entry2 = false;
            object2[18] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AROUND_UNARY_OPERATOR);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPACE_WITHIN_ARRAY_ACCESS_BRACKETS");
            $i$f$entry2 = false;
            object2[19] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_WITHIN_BRACKETS);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPACE_WITHIN_CAST_EXPRESSION_PARENTHESES");
            $i$f$entry2 = false;
            object2[20] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_WITHIN_CAST_PARENTHESES);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPACE_WITHIN_EMPTY_INITIALIZER_BRACES");
            $i$f$entry2 = false;
            object2[21] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_WITHIN_EMPTY_ARRAY_INITIALIZER_BRACES);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPACE_WITHIN_EMPTY_METHOD_PARENTHESES");
            $i$f$entry2 = false;
            object2[22] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_WITHIN_EMPTY_METHOD_PARENTHESES);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPACE_WITHIN_INITIALIZER_BRACES");
            $i$f$entry2 = false;
            object2[23] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPECIAL_ELSE_IF_TREATMENT");
            $i$f$entry2 = false;
            object2[24] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPECIAL_ELSE_IF_TREATMENT);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("SPACE_AFTER_CAST_EXPRESSION_PARENTHESES");
            $i$f$entry2 = false;
            object2[25] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_TYPE_CAST);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("WRAP_AFTER_BINARY_OPSIGN");
            $i$f$entry2 = false;
            object2[26] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.BINARY_OPERATION_WRAP != 0);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("WRAP_BEFORE_TERNARY_OPSIGNS");
            $i$f$entry2 = false;
            object2[27] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.TERNARY_OPERATION_WRAP != 0);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("TYPE_DECLARATION_BRACES");
            $i$f$entry2 = false;
            object2[28] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$it$inlined.CLASS_BRACE_STYLE, this.$it$inlined.SPACE_BEFORE_CLASS_LBRACE, false, 4, null));
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("OTHER_BRACES");
            $i$f$entry2 = false;
            object2[29] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.access$getBraceFormatStyleStyle(RadMigrateCodeStyleAction.Companion, this.$it$inlined.BRACE_STYLE, true, true));
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("CASE_BLOCK_BRACES");
            $i$f$entry2 = false;
            object2[30] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$it$inlined.BRACE_STYLE, this.$it$inlined.SPACE_BEFORE_SWITCH_LBRACE, false, 4, null));
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("BLANK_LINES_AROUND_FUNCTION_DECLARATION");
            $i$f$entry2 = false;
            object2[31] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.BLANK_LINES_AROUND_METHOD_IN_INTERFACE);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("BLANK_LINES_AROUND_FUNCTION_DEFINITION");
            $i$f$entry2 = false;
            object2[32] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.BLANK_LINES_AROUND_METHOD);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("PLACE_WHILE_ON_NEW_LINE");
            $i$f$entry2 = false;
            object2[33] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.WHILE_ON_NEW_LINE);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("PLACE_ELSE_ON_NEW_LINE");
            $i$f$entry2 = false;
            object2[34] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.ELSE_ON_NEW_LINE);
                }
            });
            reSharperKey$iv2 = Companion.cppEntry("PLACE_CATCH_ON_NEW_LINE");
            $i$f$entry2 = false;
            object2[35] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv2), (Object)new Function0<PredefinedValue>((CommonCodeStyleSettings)it){
                final /* synthetic */ CommonCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.CATCH_ON_NEW_LINE);
                }
            });
            CollectionsKt.addAll((Collection)collection, (Iterable)CollectionsKt.listOf((Object[])object2));
            CustomCodeStyleSettings customCodeStyleSettings2 = settings.getCustomSettings(CidrCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings2, (String)"getCustomSettings(...)");
            CidrCodeStyleSettings it2 = cidrCustomSettings = (CidrCodeStyleSettings)customCodeStyleSettings2;
            boolean bl2 = false;
            object2 = options;
            reSharperKey$iv2 = new Pair[54];
            Object[] reSharperKey$iv3 = Companion.cppEntry("NAMESPACE_INDENTATION");
            boolean $i$f$entry3 = false;
            reSharperKey$iv2[0] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.INDENT_NAMESPACE_MEMBERS > 0 ? (this.$it$inlined.KEEP_NESTED_NAMESPACES_IN_ONE_LINE ? "Inner" : "All") : "None");
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("ALIGN_MULTILINE_ARGUMENT");
            $i$f$entry3 = false;
            reSharperKey$iv2[1] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("ALIGN_MULTILINE_EXTENDS_LIST");
            $i$f$entry3 = false;
            reSharperKey$iv2[2] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.CLASS_CONSTRUCTOR_INIT_LIST_ALIGN_MULTILINE);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("ALIGN_MULTILINE_PARAMETER");
            $i$f$entry3 = false;
            reSharperKey$iv2[3] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.FUNCTION_PARAMETERS_ALIGN_MULTILINE);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("ALIGN_MULTILINE_TYPE_ARGUMENT");
            $i$f$entry3 = false;
            reSharperKey$iv2[4] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.TEMPLATE_CALL_ARGUMENTS_ALIGN_MULTILINE);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("ALIGN_MULTILINE_TYPE_PARAMETER");
            $i$f$entry3 = false;
            reSharperKey$iv2[5] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.TEMPLATE_PARAMETERS_ALIGN_MULTILINE);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("BLANK_LINES_AROUND_DECLARATIONS");
            $i$f$entry3 = false;
            reSharperKey$iv2[6] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.BLANK_LINES_AROUND_PROPERTIES_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("INDENT_ACCESS_SPECIFIERS_FROM_CLASS");
            $i$f$entry3 = false;
            reSharperKey$iv2[7] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.INDENT_VISIBILITY_KEYWORDS > 0);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("INDENT_CLASS_MEMBERS_FROM_ACCESS_SPECIFIERS");
            $i$f$entry3 = false;
            reSharperKey$iv2[8] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.INDENT_VISIBILITY_KEYWORDS < this.$it$inlined.INDENT_CLASS_MEMBERS);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("LINE_BREAK_AFTER_COLON_IN_MEMBER_INITIALIZER_LISTS");
            $i$f$entry3 = false;
            reSharperKey$iv2[9] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.access$getSimpleEmbeddedStatementStyle(RadMigrateCodeStyleAction.Companion, this.$it$inlined.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON));
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("MEMBER_INITIALIZER_LIST_STYLE");
            $i$f$entry3 = false;
            reSharperKey$iv2[10] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.access$getSimpleEmbeddedStatementStyle(RadMigrateCodeStyleAction.Companion, this.$it$inlined.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_BEFORE_COLON));
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("PLACE_NAMESPACE_DEFINITIONS_ON_SAME_LINE");
            $i$f$entry3 = false;
            reSharperKey$iv2[11] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.KEEP_NESTED_NAMESPACES_IN_ONE_LINE);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_AFTER_COLON_IN_BITFIELD_DECLARATOR");
            $i$f$entry3 = false;
            reSharperKey$iv2[12] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_DICTIONARY_LITERAL_COLON);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_COLON_IN_BITFIELD_DECLARATOR");
            $i$f$entry3 = false;
            reSharperKey$iv2[13] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_DICTIONARY_LITERAL_COLON);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_AFTER_EXTENDS_COLON");
            $i$f$entry3 = false;
            reSharperKey$iv2[14] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_SUPERCLASS_COLON);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_EXTENDS_COLON");
            $i$f$entry3 = false;
            reSharperKey$iv2[15] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_SUPERCLASS_COLON);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_AFTER_FOR_COLON");
            $i$f$entry3 = false;
            reSharperKey$iv2[16] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_COLON_IN_FOREACH);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_FOR_COLON");
            $i$f$entry3 = false;
            reSharperKey$iv2[17] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_COLON_IN_FOREACH);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_AFTER_PTR_IN_DATA_MEMBER");
            $i$f$entry3 = false;
            reSharperKey$iv2[18] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_POINTER_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_AFTER_PTR_IN_DATA_MEMBERS");
            $i$f$entry3 = false;
            reSharperKey$iv2[19] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_POINTER_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_AFTER_PTR_IN_METHOD");
            $i$f$entry3 = false;
            reSharperKey$iv2[20] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_POINTER_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_AFTER_PTR_IN_NESTED_DECLARATOR");
            $i$f$entry3 = false;
            reSharperKey$iv2[21] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_POINTER_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_AFTER_REF_IN_DATA_MEMBER");
            $i$f$entry3 = false;
            reSharperKey$iv2[22] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_REFERENCE_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_AFTER_REF_IN_DATA_MEMBERS");
            $i$f$entry3 = false;
            reSharperKey$iv2[23] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_REFERENCE_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_AFTER_REF_IN_METHOD");
            $i$f$entry3 = false;
            reSharperKey$iv2[24] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_AFTER_REFERENCE_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_PTR_IN_ABSTRACT_DECL");
            $i$f$entry3 = false;
            reSharperKey$iv2[25] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_POINTER_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_PTR_IN_DATA_MEMBER");
            $i$f$entry3 = false;
            reSharperKey$iv2[26] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_POINTER_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_PTR_IN_DATA_MEMBERS");
            $i$f$entry3 = false;
            reSharperKey$iv2[27] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_POINTER_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_PTR_IN_METHOD");
            $i$f$entry3 = false;
            reSharperKey$iv2[28] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_POINTER_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_REF_IN_ABSTRACT_DECL");
            $i$f$entry3 = false;
            reSharperKey$iv2[29] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_REFERENCE_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_REF_IN_DATA_MEMBER");
            $i$f$entry3 = false;
            reSharperKey$iv2[30] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_REFERENCE_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_REF_IN_DATA_MEMBERS");
            $i$f$entry3 = false;
            reSharperKey$iv2[31] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_REFERENCE_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_REF_IN_METHOD");
            $i$f$entry3 = false;
            reSharperKey$iv2[32] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_REFERENCE_IN_DECLARATION);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_TEMPLATE_ARGS");
            $i$f$entry3 = false;
            reSharperKey$iv2[33] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_TEMPLATE_DECLARATION_LT);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BEFORE_TEMPLATE_PARAMS");
            $i$f$entry3 = false;
            reSharperKey$iv2[34] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_BEFORE_TEMPLATE_CALL_LT);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_BETWEEN_CLOSING_ANGLE_BRACKETS_IN_TEMPLATE_ARGS");
            $i$f$entry3 = false;
            reSharperKey$iv2[35] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_WITHIN_TEMPLATE_DOUBLE_GT);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_WITHIN_EMPTY_TEMPLATE_PARAMS");
            $i$f$entry3 = false;
            reSharperKey$iv2[36] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_WITHIN_EMPTY_TEMPLATE_DECLARATION_LTGT);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_WITHIN_TEMPLATE_ARGS");
            $i$f$entry3 = false;
            reSharperKey$iv2[37] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_WITHIN_TEMPLATE_CALL_LTGT);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_WITHIN_TEMPLATE_PARAMS");
            $i$f$entry3 = false;
            reSharperKey$iv2[38] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_WITHIN_TEMPLATE_DECLARATION_LTGT);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_WITHIN_DECLARATION_PARENTHESES");
            $i$f$entry3 = false;
            reSharperKey$iv2[39] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_WITHIN_FUNCTION_DECLARATION_PARENTHESES);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("SPACE_WITHIN_EMPTY_BLOCKS");
            $i$f$entry3 = false;
            reSharperKey$iv2[40] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.SPACE_WITHIN_EMPTY_BRACES);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("WRAP_BEFORE_INVOCATION_LPAR");
            $i$f$entry3 = false;
            reSharperKey$iv2[41] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(){

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(false);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("WRAP_AFTER_INVOCATION_LPAR");
            $i$f$entry3 = false;
            reSharperKey$iv2[42] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.FUNCTION_CALL_ARGUMENTS_NEW_LINE_AFTER_LPAR);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("WRAP_BEFORE_INVOCATION_RPAR");
            $i$f$entry3 = false;
            reSharperKey$iv2[43] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.FUNCTION_CALL_ARGUMENTS_NEW_LINE_BEFORE_RPAR);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("WRAP_BEFORE_DECLARATION_LPAR");
            $i$f$entry3 = false;
            reSharperKey$iv2[44] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(){

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(false);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("WRAP_AFTER_DECLARATION_LPAR");
            $i$f$entry3 = false;
            reSharperKey$iv2[45] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.FUNCTION_PARAMETERS_NEW_LINE_AFTER_LPAR);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("WRAP_BEFORE_DECLARATION_RPAR");
            $i$f$entry3 = false;
            reSharperKey$iv2[46] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.FUNCTION_PARAMETERS_NEW_LINE_BEFORE_RPAR);
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("WRAP_ARGUMENTS_STYLE");
            $i$f$entry3 = false;
            reSharperKey$iv2[47] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.access$getConvertedWrapStyle(RadMigrateCodeStyleAction.Companion, this.$it$inlined.FUNCTION_CALL_ARGUMENTS_WRAP));
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("WRAP_PARAMETERS_STYLE");
            $i$f$entry3 = false;
            reSharperKey$iv2[48] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.access$getConvertedWrapStyle(RadMigrateCodeStyleAction.Companion, this.$it$inlined.FUNCTION_PARAMETERS_WRAP));
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("BREAK_TEMPLATE_DECLARATION");
            $i$f$entry3 = false;
            reSharperKey$iv2[49] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.access$getConvertedWrapToSimpleEmbeddedStatementStyle(RadMigrateCodeStyleAction.Companion, this.$it$inlined.TEMPLATE_DECLARATION_FUNCTION_WRAP));
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("NAMESPACE_DECLARATION_BRACES");
            $i$f$entry3 = false;
            reSharperKey$iv2[50] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$it$inlined.NAMESPACE_BRACE_PLACEMENT, this.$it$inlined.SPACE_BEFORE_NAMESPACE_LBRACE, false, 4, null));
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("INVOCABLE_DECLARATION_BRACES");
            $i$f$entry3 = false;
            reSharperKey$iv2[51] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2, commonSettings){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$it$inlined.FUNCTION_BRACE_PLACEMENT, this.$commonSettings$inlined.SPACE_BEFORE_METHOD_LBRACE, false, 4, null));
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("ANONYMOUS_METHOD_DECLARATION_BRACES");
            $i$f$entry3 = false;
            reSharperKey$iv2[52] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2, commonSettings){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                final /* synthetic */ CommonCodeStyleSettings $commonSettings$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                    this.$commonSettings$inlined = commonCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$it$inlined.BLOCK_BRACE_PLACEMENT, this.$commonSettings$inlined.SPACE_BEFORE_METHOD_LBRACE, false, 4, null));
                }
            });
            reSharperKey$iv3 = Companion.cppEntry("INITIALIZER_BRACES");
            $i$f$entry3 = false;
            reSharperKey$iv2[53] = TuplesKt.to((Object)SettingsSynchronizerKt.key((String)reSharperKey$iv3), (Object)new Function0<PredefinedValue>(it2){
                final /* synthetic */ CidrCodeStyleSettings $it$inlined;
                {
                    this.$it$inlined = cidrCodeStyleSettings;
                }

                public final PredefinedValue invoke() {
                    boolean bl = false;
                    return SettingsSynchronizerKt.asPredefinedType(com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.getBraceFormatStyleStyle$default(RadMigrateCodeStyleAction.Companion, this.$it$inlined.BLOCK_BRACE_PLACEMENT, this.$it$inlined.SPACE_BEFORE_INIT_LIST, false, 4, null));
                }
            });
            CollectionsKt.addAll((Collection)object2, (Iterable)CollectionsKt.listOf((Object[])reSharperKey$iv2));
            CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions = commonSettings.getIndentOptions();
            if (indentOptions2 != null) {
                CommonCodeStyleSettings.IndentOptions it3 = indentOptions2;
                boolean bl3 = false;
                reSharperKey$iv2 = options;
                reSharperKey$iv3 = new Pair[4];
                String reSharperKey$iv4 = Companion.cppEntry("INDENT_STYLE");
                boolean $i$f$entry4 = false;
                reSharperKey$iv3[0] = TuplesKt.to((Object)SettingsSynchronizerKt.key(reSharperKey$iv4), (Object)new Function0<PredefinedValue>(it3){
                    final /* synthetic */ CommonCodeStyleSettings.IndentOptions $it$inlined;
                    {
                        this.$it$inlined = indentOptions;
                    }

                    public final PredefinedValue invoke() {
                        boolean bl = false;
                        return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.USE_TAB_CHARACTER ? "Tab" : "Space");
                    }
                });
                reSharperKey$iv4 = Companion.cppEntry("INDENT_SIZE");
                $i$f$entry4 = false;
                reSharperKey$iv3[1] = TuplesKt.to((Object)SettingsSynchronizerKt.key(reSharperKey$iv4), (Object)new Function0<PredefinedValue>(it3){
                    final /* synthetic */ CommonCodeStyleSettings.IndentOptions $it$inlined;
                    {
                        this.$it$inlined = indentOptions;
                    }

                    public final PredefinedValue invoke() {
                        boolean bl = false;
                        return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.INDENT_SIZE);
                    }
                });
                reSharperKey$iv4 = Companion.cppEntry("CONTINUOUS_LINE_INDENT");
                $i$f$entry4 = false;
                reSharperKey$iv3[2] = TuplesKt.to((Object)SettingsSynchronizerKt.key(reSharperKey$iv4), (Object)new Function0<PredefinedValue>(it3){
                    final /* synthetic */ CommonCodeStyleSettings.IndentOptions $it$inlined;
                    {
                        this.$it$inlined = indentOptions;
                    }

                    public final PredefinedValue invoke() {
                        boolean bl = false;
                        return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.CONTINUATION_INDENT_SIZE == 0 ? "None" : (this.$it$inlined.CONTINUATION_INDENT_SIZE <= this.$it$inlined.INDENT_SIZE ? "Single" : "Double"));
                    }
                });
                reSharperKey$iv4 = Companion.cppEntry("TAB_WIDTH");
                $i$f$entry4 = false;
                reSharperKey$iv3[3] = TuplesKt.to((Object)SettingsSynchronizerKt.key(reSharperKey$iv4), (Object)new Function0<PredefinedValue>(it3){
                    final /* synthetic */ CommonCodeStyleSettings.IndentOptions $it$inlined;
                    {
                        this.$it$inlined = indentOptions;
                    }

                    public final PredefinedValue invoke() {
                        boolean bl = false;
                        return SettingsSynchronizerKt.asPredefinedType(this.$it$inlined.TAB_SIZE);
                    }
                });
                CollectionsKt.addAll((Collection)reSharperKey$iv2, (Iterable)CollectionsKt.listOf((Object[])reSharperKey$iv3));
                v6 = Unit.INSTANCE;
            } else {
                v6 = null;
            }
            this.log("{migration");
            Iterable $this$forEach$iv2 = options;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Pair it4 = (Pair)element$iv;
                boolean bl4 = false;
                PredefinedValue value = (PredefinedValue)((Function0)it4.getSecond()).invoke();
                riderCustomSettings.getData().put((KeyPathComponents)it4.getFirst(), value);
                Companion.log("  " + it4.getFirst() + " -> " + value);
            }
            this.log("}migration");
            this.fireCodeStyleSettingChanged(project);
        }

        static /* synthetic */ void performMigration$default(Companion companion, Project project, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.performMigration(project, bl);
        }

        private final void fireCodeStyleSettingChanged(Project project) {
            if (project != null) {
                ApplicationManager.getApplication().invokeLater(() -> Companion.fireCodeStyleSettingChanged$lambda$101(project), project.getDisposed());
            } else {
                ApplicationManager.getApplication().invokeLater(Companion::fireCodeStyleSettingChanged$lambda$102);
            }
        }

        private final String cppEntry(@NonNls String optionName) {
            return "CodeStyle/CodeFormatting/CppFormatting/" + optionName;
        }

        private final String getTernaryOperatorAlignStyle(boolean option) {
            String string;
            boolean bl = option;
            if (bl) {
                string = "ALIGN_ALL";
            } else if (!bl) {
                string = "NONE";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private final String getSimpleEmbeddedStatementStyle(@CidrCodeStyleSettings.NewLineConstant int option) {
            return switch (option) {
                case 0 -> "ON_SINGLE_LINE";
                case 1 -> "LINE_BREAK";
                default -> "DO_NOT_CHANGE";
            };
        }

        private final String getConvertedWrapStyle(int option) {
            return switch (option) {
                case 1 -> "WRAP_IF_LONG";
                case 2 -> "CHOP_ALWAYS";
                case 5 -> "CHOP_IF_LONG";
                default -> "";
            };
        }

        private final String getConvertedWrapToSimpleEmbeddedStatementStyle(int option) {
            return switch (option) {
                case 1 -> "ON_SINGLE_LINE";
                case 2 -> "LINE_BREAK";
                case 5 -> "DO_NOT_CHANGE";
                default -> "";
            };
        }

        private final String getBraceFormatStyleStyle(@CommonCodeStyleSettings.BraceStyleConstant int option, boolean withSpace, boolean withCompactOption) {
            return switch (option) {
                case 1 -> {
                    if (withSpace) {
                        yield "END_OF_LINE";
                    }
                    yield "END_OF_LINE_NO_SPACE";
                }
                case 2 -> "NEXT_LINE";
                case 3 -> "NEXT_LINE_SHIFTED";
                case 4 -> "NEXT_LINE_SHIFTED_2";
                case 5 -> {
                    if (withCompactOption) {
                        yield "PICO";
                    }
                    yield "";
                }
                default -> "";
            };
        }

        static /* synthetic */ String getBraceFormatStyleStyle$default(Companion companion, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl = true;
            }
            if ((n2 & 4) != 0) {
                bl2 = false;
            }
            return companion.getBraceFormatStyleStyle(n, bl, bl2);
        }

        public final void migrateCodeStyleFromCidrToRad(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.log("Check migration Classic->Nova");
                boolean perProjectSettings = CodeStyle.usesOwnSettings((Project)project);
                RunOnceUtil.runOnceForApp((String)RadMigrateCodeStyleAction.ID_MIGRATION_ACTION, () -> Companion.migrateCodeStyleFromCidrToRad$lambda$103(perProjectSettings, project));
                RunOnceUtil.runOnceForProject((Project)project, (String)RadMigrateCodeStyleAction.ID_MIGRATION_ACTION, () -> Companion.migrateCodeStyleFromCidrToRad$lambda$104(perProjectSettings, project));
            }
        }

        private final void log(String message) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(RadMigrateCodeStyleAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info(message);
        }

        private static final void fireCodeStyleSettingChanged$lambda$101(Project $project) {
            CodeStyleSettingsManager.getInstance((Project)$project).fireCodeStyleSettingsChanged();
        }

        private static final void fireCodeStyleSettingChanged$lambda$102() {
            CodeStyleSettingsManager.getInstance().fireCodeStyleSettingsChanged();
        }

        private static final void migrateCodeStyleFromCidrToRad$lambda$103(boolean $perProjectSettings, Project $project) {
            Companion.log("{Migration procedure Classic->Nova for Default CS");
            com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.performMigration$default(Companion, null, false, 2, null);
            if (!$perProjectSettings) {
                Companion.log("  Notify project backend that project-from-default CS were changed");
                Companion.fireCodeStyleSettingChanged($project);
            }
            Companion.log("}Migration procedure Classic->Nova for Default CS");
        }

        private static final void migrateCodeStyleFromCidrToRad$lambda$104(boolean $perProjectSettings, Project $project) {
            Companion.log("{Migration procedure Classic->Nova for project CS");
            if ($perProjectSettings) {
                com.jetbrains.cidr.radler.settings.migration.RadMigrateCodeStyleAction$Companion.performMigration$default(Companion, $project, false, 2, null);
            } else {
                Companion.log("  Skip project-from-default CS migration, they need to be actual at this point");
            }
            Companion.log("}Migration procedure Classic->Nova for project CS");
        }

        public static final /* synthetic */ String access$getTernaryOperatorAlignStyle(Companion $this, boolean option) {
            return $this.getTernaryOperatorAlignStyle(option);
        }

        public static final /* synthetic */ String access$getBraceFormatStyleStyle(Companion $this, int option, boolean withSpace, boolean withCompactOption) {
            return $this.getBraceFormatStyleStyle(option, withSpace, withCompactOption);
        }

        public static final /* synthetic */ String access$getSimpleEmbeddedStatementStyle(Companion $this, int option) {
            return $this.getSimpleEmbeddedStatementStyle(option);
        }

        public static final /* synthetic */ String access$getConvertedWrapStyle(Companion $this, int option) {
            return $this.getConvertedWrapStyle(option);
        }

        public static final /* synthetic */ String access$getConvertedWrapToSimpleEmbeddedStatementStyle(Companion $this, int option) {
            return $this.getConvertedWrapToSimpleEmbeddedStatementStyle(option);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

