/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rd.platform.diagnostics.ThreadDumpResult;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.AssemblyExecutionContext;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.CrossgenRunUtil;
import com.jetbrains.rider.NetCoreUtil;
import com.jetbrains.rider.ProtectedRiderBackendExecutable;
import com.jetbrains.rider.RiderCustomBackendLogXmlPathProvider;
import com.jetbrains.rider.clrmd.ClrProcessThreadDumpUtilKt;
import com.jetbrains.rider.clrmd.CollectThreadDumpRequest;
import com.jetbrains.rider.protocol.EarlyBackendStarter;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\r\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\u000eJ\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000eJ\u0018\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\fH\u0002J\"\u0010(\u001a\u0004\u0018\u00010&2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\fH\u0002J(\u0010+\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\f2\u000e\b\u0002\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010-J*\u0010.\u001a\u0004\u0018\u00010&2\u0006\u0010*\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\f2\u000e\b\u0002\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010-J\u0006\u0010/\u001a\u00020&J\u0016\u00100\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005J2\u00102\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00052\b\b\u0002\u0010'\u001a\u00020\f2\u000e\b\u0002\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010-2\b\b\u0002\u00103\u001a\u00020\fJ\u0006\u00104\u001a\u000205J'\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00052\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050:\"\u00020\u0005\u00a2\u0006\u0002\u0010;J'\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050:\"\u00020\u0005\u00a2\u0006\u0002\u0010@J/\u0010A\u001a\u00020=2\u0006\u0010B\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0012\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050:\"\u00020\u0005\u00a2\u0006\u0002\u0010CJ\u000e\u0010^\u001a\u0002052\u0006\u0010_\u001a\u00020`J\u000e\u0010a\u001a\u0002052\u0006\u0010_\u001a\u00020`J\u0016\u0010b\u001a\u0002052\u0006\u0010c\u001a\u00020\n2\u0006\u0010d\u001a\u00020eJ\u000e\u0010f\u001a\u00020\f2\u0006\u0010c\u001a\u00020\nJ\u000e\u0010g\u001a\u00020\f2\u0006\u0010c\u001a\u00020\nJ\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\n0\u000eJ(\u0010i\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010k0j2\u0006\u0010l\u001a\u00020m2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010&J0\u0010o\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010k0j2\u0006\u0010l\u001a\u00020m2\n\b\u0002\u0010n\u001a\u0004\u0018\u00010&H\u0086@\u00a2\u0006\u0002\u0010pJ\f\u0010q\u001a\b\u0012\u0004\u0012\u00020\n0\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u000f\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0016\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0016\"\u0004\b\"\u0010#R\u001b\u0010D\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010\u0018\u001a\u0004\bE\u0010FR\u001b\u0010H\u001a\u00020&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u0010\u0018\u001a\u0004\bI\u0010FR\u001b\u0010K\u001a\u00020&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bM\u0010\u0018\u001a\u0004\bL\u0010FR\u001b\u0010N\u001a\u00020&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bP\u0010\u0018\u001a\u0004\bO\u0010FR\u0011\u0010Q\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\bR\u0010FR\u0011\u0010S\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010FR\u0011\u0010U\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010FR\u001b\u0010W\u001a\u00020X8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b[\u0010\u0018\u001a\u0004\bY\u0010ZR\u0011\u0010\\\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b]\u0010\u0016\u00a8\u0006r"}, d2={"Lcom/jetbrains/rider/RiderEnvironment;", "", "<init>", "()V", "traceEnvVar", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "riderProcesses", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "", "kotlin.jvm.PlatformType", "", "getProcesses", "", "backendHostProcesses", "riderBackendName", "clrHostExecutableName", "clrLauncherExecutableName", "clrLauncherNiExecutableName", "riderBackendExecutableName", "getRiderBackendExecutableName", "()Ljava/lang/String;", "riderBackendExecutableName$delegate", "Lkotlin/Lazy;", "hostBinEnvironmentVariable", "isUnderTeamCity", "()Z", "isNotUnderTeamCity", "isRiderForDebug", "customizedLoggers", "applyEnvTraceCategories", "customHostBinDirectory", "getCustomHostBinDirectory", "setCustomHostBinDirectory", "(Ljava/lang/String;)V", "fileExists", "file", "Ljava/io/File;", "allowDir", "tryFallbackIfLauncherNotFound", "folder", "fileName", "getBundledFileSafe", "pluginClass", "Ljava/lang/Class;", "getBundledFileOrNull", "getBundledBinDir", "getBundledPluginFile", "pluginId", "getBundledFile", "forceProcessExitOnFailure", "throwRiderBackendNotCompiled", "", "createProcessBuilderForAssembly", "Ljava/lang/ProcessBuilder;", "assemblyFullPath", "params", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/ProcessBuilder;", "createRunCmdForLauncherInfo", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "launcherInfo", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "(Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "fillRunCmdWithLauncherInfo", "emptyCmd", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;[Ljava/lang/String;)Lcom/intellij/execution/configurations/GeneralCommandLine;", "originalRiderBackendNetFrameworkExecutable", "getOriginalRiderBackendNetFrameworkExecutable", "()Ljava/io/File;", "originalRiderBackendNetFrameworkExecutable$delegate", "riderBackendExecutable", "getRiderBackendExecutable", "riderBackendExecutable$delegate", "riderBackendDirectory", "getRiderBackendDirectory", "riderBackendDirectory$delegate", "originalRiderBackendBinDir", "getOriginalRiderBackendBinDir", "originalRiderBackendBinDir$delegate", "logDirectory", "getLogDirectory", "backendThreadDumpDir", "getBackendThreadDumpDir", "debuggerWorkerThreadDumpDirFallback", "getDebuggerWorkerThreadDumpDirFallback", "backendLogXmlPath", "Ljava/nio/file/Path;", "getBackendLogXmlPath", "()Ljava/nio/file/Path;", "backendLogXmlPath$delegate", "logBackendConf", "getLogBackendConf", "addRiderBackendProcess", "processHandler", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "addRiderAuxiliaryProcess", "addRiderProcess", "pid", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "isRiderProcess", "isRiderBackendProcess", "getBackendProcessIdList", "requestThreadDumpForRunningRiderBackendsBlocking", "", "Lcom/jetbrains/rd/platform/diagnostics/ThreadDumpResult;", "request", "Lcom/jetbrains/rider/clrmd/CollectThreadDumpRequest;", "dumpDir", "requestThreadDumpForRunningRiderBackends", "(Lcom/jetbrains/rider/clrmd/CollectThreadDumpRequest;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllHostPids", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderEnvironment.kt\ncom/jetbrains/rider/RiderEnvironment\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,896:1\n1563#2:897\n1634#2,3:898\n13#3:901\n14#4:902\n*S KotlinDebug\n*F\n+ 1 RiderEnvironment.kt\ncom/jetbrains/rider/RiderEnvironment\n*L\n94#1:897\n94#1:898,3\n54#1:901\n54#1:902\n*E\n"})
public final class RiderEnvironment {
    @NotNull
    public static final RiderEnvironment INSTANCE = new RiderEnvironment();
    @NotNull
    private static final String traceEnvVar = "RESHARPER_TRACE";
    @NotNull
    private static final Logger logger;
    private static final ConcurrentHashMap.KeySetView<Long, Boolean> riderProcesses;
    private static final ConcurrentHashMap.KeySetView<Long, Boolean> backendHostProcesses;
    @NlsSafe
    @NotNull
    public static final String riderBackendName = "Rider.Backend";
    @NotNull
    private static final String clrHostExecutableName = "Rider.Backend.exe";
    @NotNull
    private static final String clrLauncherExecutableName;
    @NotNull
    private static final String clrLauncherNiExecutableName;
    @NotNull
    private static final Lazy riderBackendExecutableName$delegate;
    @NotNull
    public static final String hostBinEnvironmentVariable = "RESHARPER_HOST_BIN";
    private static final boolean isUnderTeamCity;
    private static final boolean isNotUnderTeamCity;
    private static final boolean isRiderForDebug;
    @Nullable
    private static final List<Logger> customizedLoggers;
    @Nullable
    private static String customHostBinDirectory;
    @NotNull
    private static final Lazy originalRiderBackendNetFrameworkExecutable$delegate;
    @NotNull
    private static final Lazy riderBackendExecutable$delegate;
    @NotNull
    private static final Lazy riderBackendDirectory$delegate;
    @NotNull
    private static final Lazy originalRiderBackendBinDir$delegate;
    @NotNull
    private static final File logDirectory;
    @NotNull
    private static final File backendThreadDumpDir;
    @NotNull
    private static final File debuggerWorkerThreadDumpDirFallback;
    @NotNull
    private static final Lazy backendLogXmlPath$delegate;

    private RiderEnvironment() {
    }

    @NotNull
    public final List<Long> getProcesses() {
        ConcurrentHashMap.KeySetView<Long, Boolean> keySetView = riderProcesses;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"riderProcesses");
        return CollectionsKt.toList((Iterable)keySetView);
    }

    @NotNull
    public final String getRiderBackendExecutableName() {
        Lazy lazy = riderBackendExecutableName$delegate;
        return (String)lazy.getValue();
    }

    public final boolean isUnderTeamCity() {
        return isUnderTeamCity;
    }

    public final boolean isNotUnderTeamCity() {
        return isNotUnderTeamCity;
    }

    public final boolean isRiderForDebug() {
        return isRiderForDebug;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<Logger> applyEnvTraceCategories() {
        List list;
        char[] cArray;
        Object object = System.getenv(traceEnvVar);
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{',', ' ', ':', ';'}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$mapTo$iv$iv;
            Object it = object;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)it;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void category;
                Logger logger;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Logger $this$applyEnvTraceCategories_u24lambda_u243_u24lambda_u242_u24lambda_u241 = logger = Logger.getInstance((String)category);
                boolean bl3 = false;
                $this$applyEnvTraceCategories_u24lambda_u243_u24lambda_u242_u24lambda_u241.setLevel(LogLevel.TRACE);
                Logger logger2 = logger;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"apply(...)");
                collection.add(logger2);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final String getCustomHostBinDirectory() {
        return customHostBinDirectory;
    }

    public final void setCustomHostBinDirectory(@Nullable String string) {
        customHostBinDirectory = string;
    }

    private final boolean fileExists(File file, boolean allowDir) {
        if (allowDir) {
            return file.exists();
        }
        return file.isFile();
    }

    private final File tryFallbackIfLauncherNotFound(String folder, String fileName, boolean allowDir) {
        if (SystemInfo.isWindows && ApplicationInfoImpl.getShadowInstance().getBuild().isSnapshot()) {
            CharSequence charSequence = fileName;
            Regex regex = new Regex("64.exe$");
            String string = ".exe";
            regex = new Regex("32.exe$");
            String platformIndependentFileName = regex.replace(charSequence = (CharSequence)regex.replace(charSequence, string), string = ".exe");
            File platformIndependentExe = new File(folder, platformIndependentFileName);
            if (this.fileExists(platformIndependentExe, allowDir)) {
                logger.info("fallback file " + platformIndependentFileName + " found at " + folder);
                return platformIndependentExe;
            }
        }
        return null;
    }

    @NotNull
    public final File getBundledFileSafe(@NotNull String fileName, boolean allowDir, @Nullable Class<?> pluginClass) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file = this.getBundledFileOrNull(fileName, allowDir, pluginClass);
        if (file == null) {
            file = new File("");
        }
        return file;
    }

    public static /* synthetic */ File getBundledFileSafe$default(RiderEnvironment riderEnvironment, String string, boolean bl, Class clazz, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            clazz = null;
        }
        return riderEnvironment.getBundledFileSafe(string, bl, clazz);
    }

    @Nullable
    public final File getBundledFileOrNull(@NotNull String fileName, boolean allowDir, @Nullable Class<?> pluginClass) {
        File file;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            file = this.getBundledFile(fileName, allowDir, pluginClass, false);
        }
        catch (FileNotFoundException e) {
            file = null;
        }
        return file;
    }

    public static /* synthetic */ File getBundledFileOrNull$default(RiderEnvironment riderEnvironment, String string, boolean bl, Class clazz, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            clazz = null;
        }
        return riderEnvironment.getBundledFileOrNull(string, bl, clazz);
    }

    @NotNull
    public final File getBundledBinDir() {
        if (customHostBinDirectory != null) {
            return new File(customHostBinDirectory);
        }
        String bin = System.getenv(hostBinEnvironmentVariable);
        if (bin != null) {
            return new File(bin);
        }
        return new File(PathManager.getLibPath(), "ReSharperHost");
    }

    @NotNull
    public final File getBundledPluginFile(@NotNull String fileName, @NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.Companion.getId(pluginId));
        if (ideaPluginDescriptor == null) {
            throw new IllegalStateException("Unknown plugin");
        }
        IdeaPluginDescriptor pluginDescriptor = ideaPluginDescriptor;
        File file = pluginDescriptor.getPluginPath().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        File file2 = FilesKt.resolve((File)file, (String)fileName);
        if (!file2.exists()) {
            throw new IllegalStateException("Unknown plugin file " + file2);
        }
        return file2;
    }

    @NotNull
    public final File getBundledFile(@NotNull String fileName, boolean allowDir, @Nullable Class<?> pluginClass, boolean forceProcessExitOnFailure) {
        String customDir;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (pluginClass != null) {
            File file;
            File file2;
            Path path;
            File fileInPlugin;
            String string = pluginClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginManagerCore.getPluginByClassName((String)string));
            File file3 = fileInPlugin = pluginDescriptor != null && (path = pluginDescriptor.getPluginPath()) != null && (file2 = path.toFile()) != null && (file = FilesKt.resolve((File)file2, (String)"DotFiles")) != null ? FilesKt.resolve((File)file, (String)fileName) : null;
            boolean bl = file3 != null ? file3.exists() : false;
            if (bl && fileInPlugin.isFile()) {
                return fileInPlugin;
            }
        }
        if ((customDir = customHostBinDirectory) != null) {
            File exe = new File(customDir, fileName);
            if (!this.fileExists(exe, allowDir)) {
                logger.info(fileName + " found at " + customDir + " by custom bin directory");
                File file = this.tryFallbackIfLauncherNotFound(customDir, fileName, allowDir);
                if (file == null) {
                    throw new FileNotFoundException(fileName + " is not found at " + customHostBinDirectory + " (explicitly specified host directory via customHostBinDirectory)");
                }
                return file;
            }
            return exe;
        }
        String bin = System.getenv(hostBinEnvironmentVariable);
        if (bin != null) {
            logger.info("%RESHARPER_HOST_BIN% = " + bin);
            File envExe = new File(bin, fileName);
            if (this.fileExists(envExe, allowDir)) {
                logger.info(fileName + " found at " + bin + " (from %RESHARPER_HOST_BIN%)");
                return envExe;
            }
            File file = this.tryFallbackIfLauncherNotFound(bin, fileName, allowDir);
            if (file == null) {
                RiderEnvironment $this$getBundledFile_u24lambda_u244 = this;
                boolean bl = false;
                if (forceProcessExitOnFailure && (PluginManagerCore.isRunningFromSources() || AppMode.isDevServer())) {
                    $this$getBundledFile_u24lambda_u244.throwRiderBackendNotCompiled();
                }
                throw new FileNotFoundException(fileName + " is not found at " + bin + " (explicitly specified host directory via RESHARPER_HOST_BIN environment variable)");
            }
            return file;
        }
        logger.info("%RESHARPER_HOST_BIN% is not set");
        File distDir = new File(PathManager.getLibPath(), "ReSharperHost");
        File distExe = new File(distDir, fileName);
        if (this.fileExists(distExe, allowDir)) {
            logger.info(fileName + " found at " + distExe + " (bundled to IDEA)");
            return distExe;
        }
        throw new FileNotFoundException("No '" + fileName + "' found in locations: '%RESHARPER_HOST_BIN%'(" + bin + "), '" + distDir + "'");
    }

    public static /* synthetic */ File getBundledFile$default(RiderEnvironment riderEnvironment, String string, boolean bl, Class clazz, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            clazz = null;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return riderEnvironment.getBundledFile(string, bl, clazz, bl2);
    }

    public final void throwRiderBackendNotCompiled() {
        System.err.println();
        System.err.println("*********************************************************************");
        System.err.println("*****   Start 'Compile Rider Backend' run configuration first   *****");
        System.err.println("*********************************************************************");
        Runtime.getRuntime().halt(1);
    }

    @NotNull
    public final ProcessBuilder createProcessBuilderForAssembly(@NotNull String assemblyFullPath, String ... params) {
        Intrinsics.checkNotNullParameter((Object)assemblyFullPath, (String)"assemblyFullPath");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        File assemblyFile = new File(assemblyFullPath);
        return AssemblyExecutionContext.Companion.create(assemblyFile, Arrays.copyOf(params, params.length)).toProcessBuilder();
    }

    @NotNull
    public final GeneralCommandLine createRunCmdForLauncherInfo(@NotNull BundledAssemblyLauncherInfo launcherInfo, String ... params) {
        Intrinsics.checkNotNullParameter((Object)launcherInfo, (String)"launcherInfo");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.fillRunCmdWithLauncherInfo(new GeneralCommandLine(), launcherInfo, Arrays.copyOf(params, params.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final GeneralCommandLine fillRunCmdWithLauncherInfo(@NotNull GeneralCommandLine emptyCmd, @NotNull BundledAssemblyLauncherInfo launcherInfo, String ... params) {
        Intrinsics.checkNotNullParameter((Object)emptyCmd, (String)"emptyCmd");
        Intrinsics.checkNotNullParameter((Object)launcherInfo, (String)"launcherInfo");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String previousBinDirValue = customHostBinDirectory;
        customHostBinDirectory = null;
        try {
            GeneralCommandLine generalCommandLine = AssemblyExecutionContext.Companion.create(launcherInfo, Arrays.copyOf(params, params.length)).fillCommandLine(emptyCmd);
            return generalCommandLine;
        }
        finally {
            customHostBinDirectory = previousBinDirValue;
        }
    }

    private final File getOriginalRiderBackendNetFrameworkExecutable() {
        Lazy lazy = originalRiderBackendNetFrameworkExecutable$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getRiderBackendExecutable() {
        Lazy lazy = riderBackendExecutable$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getRiderBackendDirectory() {
        Lazy lazy = riderBackendDirectory$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (File)object;
    }

    @NotNull
    public final File getOriginalRiderBackendBinDir() {
        Lazy lazy = originalRiderBackendBinDir$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (File)object;
    }

    @NotNull
    public final File getLogDirectory() {
        return logDirectory;
    }

    @NotNull
    public final File getBackendThreadDumpDir() {
        return backendThreadDumpDir;
    }

    @NotNull
    public final File getDebuggerWorkerThreadDumpDirFallback() {
        return debuggerWorkerThreadDumpDirFallback;
    }

    @NotNull
    public final Path getBackendLogXmlPath() {
        Lazy lazy = backendLogXmlPath$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    public final String getLogBackendConf() {
        return ((Object)this.getBackendLogXmlPath().toAbsolutePath()).toString();
    }

    public final void addRiderBackendProcess(@NotNull BaseOSProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        long pid = processHandler.getProcess().pid();
        backendHostProcesses.add(pid);
        this.addRiderAuxiliaryProcess(processHandler);
    }

    public final void addRiderAuxiliaryProcess(@NotNull BaseOSProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        long pid = processHandler.getProcess().pid();
        riderProcesses.add(pid);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(pid){
            final /* synthetic */ long $pid;
            {
                this.$pid = $pid;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                RiderEnvironment.access$getRiderProcesses$p().remove(this.$pid);
                if (RiderEnvironment.access$getBackendHostProcesses$p().contains(this.$pid)) {
                    RiderEnvironment.access$getBackendHostProcesses$p().remove(this.$pid);
                }
            }
        });
    }

    public final void addRiderProcess(long pid, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        lifetime.bracketOrThrow(() -> RiderEnvironment.addRiderProcess$lambda$10(pid), () -> RiderEnvironment.addRiderProcess$lambda$11(pid));
    }

    public final boolean isRiderProcess(long pid) {
        return riderProcesses.contains(pid);
    }

    public final boolean isRiderBackendProcess(long pid) {
        return backendHostProcesses.contains(pid);
    }

    @NotNull
    public final List<Long> getBackendProcessIdList() {
        ConcurrentHashMap.KeySetView<Long, Boolean> keySetView = backendHostProcesses;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"backendHostProcesses");
        return CollectionsKt.toList((Iterable)keySetView);
    }

    @NotNull
    public final Map<Long, ThreadDumpResult> requestThreadDumpForRunningRiderBackendsBlocking(@NotNull CollectThreadDumpRequest request, @Nullable File dumpDir) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ConcurrentHashMap.KeySetView<Long, Boolean> keySetView = backendHostProcesses;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"backendHostProcesses");
        long[] lArray = CollectionsKt.toLongArray((Collection)keySetView);
        return ClrProcessThreadDumpUtilKt.requestThreadDumpForClrProcessesBlocking(request, Arrays.copyOf(lArray, lArray.length), dumpDir);
    }

    public static /* synthetic */ Map requestThreadDumpForRunningRiderBackendsBlocking$default(RiderEnvironment riderEnvironment, CollectThreadDumpRequest collectThreadDumpRequest, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        return riderEnvironment.requestThreadDumpForRunningRiderBackendsBlocking(collectThreadDumpRequest, file);
    }

    @Nullable
    public final Object requestThreadDumpForRunningRiderBackends(@NotNull CollectThreadDumpRequest request, @Nullable File dumpDir, @NotNull Continuation<? super Map<Long, ThreadDumpResult>> $completion) {
        ConcurrentHashMap.KeySetView<Long, Boolean> keySetView = backendHostProcesses;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"backendHostProcesses");
        long[] lArray = CollectionsKt.toLongArray((Collection)keySetView);
        return ClrProcessThreadDumpUtilKt.requestThreadDumpForClrProcesses(request, Arrays.copyOf(lArray, lArray.length), dumpDir, $completion);
    }

    public static /* synthetic */ Object requestThreadDumpForRunningRiderBackends$default(RiderEnvironment riderEnvironment, CollectThreadDumpRequest collectThreadDumpRequest, File file, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        return riderEnvironment.requestThreadDumpForRunningRiderBackends(collectThreadDumpRequest, file, (Continuation<? super Map<Long, ThreadDumpResult>>)continuation);
    }

    @NotNull
    public final List<Long> getAllHostPids() {
        ConcurrentHashMap.KeySetView<Long, Boolean> keySetView = backendHostProcesses;
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"backendHostProcesses");
        return CollectionsKt.toList((Iterable)keySetView);
    }

    private static final String riderBackendExecutableName_delegate$lambda$0() {
        return NetCoreUtil.INSTANCE.runOnNetCore() ? (NetCoreUtil.INSTANCE.useNativeLauncher() ? clrLauncherExecutableName : clrHostExecutableName) : "Rider.Backend64.exe";
    }

    private static final File originalRiderBackendNetFrameworkExecutable_delegate$lambda$5() {
        return RiderEnvironment.getBundledFile$default(INSTANCE, INSTANCE.getRiderBackendExecutableName(), false, null, false, 14, null);
    }

    private static final File riderBackendExecutable_delegate$lambda$6() {
        ProtectedRiderBackendExecutable protectedExecutable;
        if (NetCoreUtil.INSTANCE.runOnNetCore() && !NetCoreUtil.INSTANCE.getUseCompositeCrossgen() && (protectedExecutable = CrossgenRunUtil.INSTANCE.tryGetProtectedRiderBackendExecutable()) != null) {
            if (NetCoreUtil.INSTANCE.useNativeLauncher()) {
                String name = protectedExecutable.getCrossgen() ? clrLauncherNiExecutableName : clrLauncherExecutableName;
                File file = protectedExecutable.getFile().getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
                return FilesKt.resolve((File)FilesKt.resolve((File)file, (String)NetCoreUtil.INSTANCE.getPlatformId()), (String)name);
            }
            return protectedExecutable.getFile();
        }
        if (NetCoreUtil.INSTANCE.runOnNetCore() && NetCoreUtil.INSTANCE.useNativeLauncher()) {
            return RiderEnvironment.getBundledFile$default(INSTANCE, NetCoreUtil.INSTANCE.getPlatformId() + File.separatorChar + INSTANCE.getRiderBackendExecutableName(), false, null, false, 14, null);
        }
        return INSTANCE.getOriginalRiderBackendNetFrameworkExecutable();
    }

    private static final File riderBackendDirectory_delegate$lambda$7() {
        return NetCoreUtil.INSTANCE.runOnNetCore() && NetCoreUtil.INSTANCE.useNativeLauncher() ? INSTANCE.getRiderBackendExecutable().getParentFile().getParentFile() : INSTANCE.getRiderBackendExecutable().getParentFile();
    }

    private static final File originalRiderBackendBinDir_delegate$lambda$8() {
        File executable = INSTANCE.getOriginalRiderBackendNetFrameworkExecutable();
        return executable.getParentFile();
    }

    private static final Path backendLogXmlPath_delegate$lambda$9() {
        Path path;
        if (PluginManagerCore.isRunningFromSources()) {
            path = Paths.get(PathManager.getHomePath(), new String[0]).resolve("rider").resolve("build").resolve("backend-log.xml");
        } else if (AppMode.isDevServer()) {
            path = Paths.get(PathManager.getHomePath(), new String[0]).getParent().getParent().getParent().resolve("rider").resolve("build").resolve("backend-log.xml");
        } else {
            Path customPath;
            if (!EarlyBackendStarter.Companion.isEnabled() && (customPath = RiderCustomBackendLogXmlPathProvider.Companion.getBackendLogXmlPath()) != null) {
                return customPath;
            }
            path = Paths.get(PathManager.getBinPath(), new String[0]).resolve("backend-log.xml");
        }
        Path path2 = path;
        Intrinsics.checkNotNull((Object)path2);
        return path2;
    }

    private static final boolean addRiderProcess$lambda$10(long $pid) {
        return riderProcesses.add($pid);
    }

    private static final Unit addRiderProcess$lambda$11(long $pid) {
        riderProcesses.remove($pid);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ConcurrentHashMap.KeySetView access$getRiderProcesses$p() {
        return riderProcesses;
    }

    public static final /* synthetic */ ConcurrentHashMap.KeySetView access$getBackendHostProcesses$p() {
        return backendHostProcesses;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderEnvironment.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderEnvironment.logger = logger;
        riderProcesses = ConcurrentHashMap.newKeySet();
        backendHostProcesses = ConcurrentHashMap.newKeySet();
        clrLauncherExecutableName = riderBackendName + (SystemInfo.isWindows ? ".exe" : "");
        clrLauncherNiExecutableName = "Rider.Backend.ni" + (SystemInfo.isWindows ? ".exe" : "");
        riderBackendExecutableName$delegate = LazyKt.lazy(RiderEnvironment::riderBackendExecutableName_delegate$lambda$0);
        isUnderTeamCity = System.getenv("TEAMCITY_VERSION") != null;
        isNotUnderTeamCity = !isUnderTeamCity;
        CharSequence charSequence = System.getenv(hostBinEnvironmentVariable);
        isRiderForDebug = !(charSequence == null || charSequence.length() == 0);
        customizedLoggers = INSTANCE.applyEnvTraceCategories();
        originalRiderBackendNetFrameworkExecutable$delegate = LazyKt.lazy(RiderEnvironment::originalRiderBackendNetFrameworkExecutable_delegate$lambda$5);
        riderBackendExecutable$delegate = LazyKt.lazy(RiderEnvironment::riderBackendExecutable_delegate$lambda$6);
        riderBackendDirectory$delegate = LazyKt.lazy(RiderEnvironment::riderBackendDirectory_delegate$lambda$7);
        originalRiderBackendBinDir$delegate = LazyKt.lazy(RiderEnvironment::originalRiderBackendBinDir_delegate$lambda$8);
        logDirectory = new File(PathManager.getLogPath());
        backendThreadDumpDir = FilesKt.resolve((File)logDirectory, (String)"BackendThreadDump");
        debuggerWorkerThreadDumpDirFallback = FilesKt.resolve((File)logDirectory, (String)"DebuggerWorkerThreadDump");
        backendLogXmlPath$delegate = LazyKt.lazy(RiderEnvironment::backendLogXmlPath_delegate$lambda$9);
    }
}

