/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.actions.ui;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.ide.model.uiautomation.ComponentId;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.ToolWindowComponentId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.ui.ComponentIdOwner;
import com.jetbrains.rd.ui.ComponentIdProvider;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/actions/ui/ToolWindowComponentIdProvider;", "Lcom/jetbrains/rd/ui/ComponentIdProvider;", "Lcom/jetbrains/rd/ide/model/ToolWindowComponentId;", "Lcom/jetbrains/rd/ui/ComponentIdOwner;", "<init>", "()V", "createComponentId", "Lcom/jetbrains/ide/model/uiautomation/ComponentId;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "tryGetComponent", "Ljava/awt/Component;", "componentId", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "parentComponent", "intellij.rider.rdclient.dotnet"})
public final class ToolWindowComponentIdProvider
implements ComponentIdProvider<ToolWindowComponentId>,
ComponentIdOwner {
    @Nullable
    public ComponentId createComponentId(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        ToolWindow toolWindow = (ToolWindow)PlatformDataKeys.TOOL_WINDOW.getData(dataContext);
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        Project project = toolWindow2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RdProjectId rdProjectId = ProjectUtilKt.getRdProjectId((Project)project);
        String string = toolWindow2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return (ComponentId)new ToolWindowComponentId(rdProjectId, string);
    }

    @Nullable
    public Component tryGetComponent(@NotNull ComponentId componentId, @NotNull ClientAppSession session2, @Nullable Component parentComponent) {
        Component component2;
        Intrinsics.checkNotNullParameter((Object)componentId, (String)"componentId");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!(componentId instanceof ToolWindowComponentId)) {
            return null;
        }
        ClientProjectSession clientProjectSession = SessionUtilKt.getProjectSession((ClientAppSession)session2, (RdProjectId)((ToolWindowComponentId)componentId).getProjectId());
        if (clientProjectSession == null || (clientProjectSession = clientProjectSession.getProject()) == null) {
            return null;
        }
        ClientProjectSession project = clientProjectSession;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance((Project)project).getToolWindow(((ToolWindowComponentId)componentId).getId());
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        Object object = toolWindow2.getContentManager().getSelectedContent();
        if (object != null && (object = object.getComponent()) != null) {
            component2 = (Component)object;
        } else {
            JComponent jComponent = toolWindow2.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            component2 = jComponent;
        }
        return component2;
    }
}

