/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.breadcrumbs;

import com.intellij.codeInsight.breadcrumbs.FileBreadcrumbsCollector;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.util.ApplicationKt;
import com.intellij.util.TimeoutUtil;
import com.intellij.xml.breadcrumbs.BreadcrumbsUtilEx;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.CrumbAction;
import com.jetbrains.rd.ide.model.CrumbModel;
import com.jetbrains.rd.ide.model.CrumbSession;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ide.model.RiderProjectDocumentOperationModel_PregeneratedKt;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.threading.SpinWait;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.breadcrumbs.BreadCrumbAction;
import com.jetbrains.rider.breadcrumbs.CustomFileBreadcrumbExtensions;
import com.jetbrains.rider.breadcrumbs.RiderBreadcrumbsSupport;
import com.jetbrains.rider.projectView.SolutionLifecycleHost;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Action;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J5\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\rH\u0002J.\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector;", "Lcom/intellij/codeInsight/breadcrumbs/FileBreadcrumbsCollector;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "timestamp", "Ljava/util/concurrent/atomic/AtomicInteger;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "watchForChanges", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "disposable", "Lcom/intellij/openapi/Disposable;", "changesHandler", "Ljava/lang/Runnable;", "handlesFile", "", "virtualFile", "computeCrumbs", "", "Lcom/intellij/ui/components/breadcrumbs/Crumb;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "forcedShown", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/editor/Document;ILjava/lang/Boolean;)Ljava/lang/Iterable;", "checkCancelled", "getCrumbsSynchronously", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "currentSessionTimestamp", "RdCrumb", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderFileBreadcrumbsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFileBreadcrumbsCollector.kt\ncom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 SpinWait.kt\ncom/jetbrains/rd/util/threading/SpinWait$Companion\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n13#2:222\n14#3:223\n61#3,5:231\n23#4,7:224\n30#4,9:236\n1563#5:245\n1634#5,3:246\n1563#5:249\n1634#5,3:250\n*S KotlinDebug\n*F\n+ 1 RiderFileBreadcrumbsCollector.kt\ncom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector\n*L\n60#1:222\n60#1:223\n124#1:231,5\n114#1:224,7\n114#1:236,9\n137#1:245\n137#1:246,3\n171#1:249\n171#1:250,3\n*E\n"})
public final class RiderFileBreadcrumbsCollector
extends FileBreadcrumbsCollector {
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicInteger timestamp;
    @NotNull
    private final Logger logger;

    public RiderFileBreadcrumbsCollector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.timestamp = new AtomicInteger(0);
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderFileBreadcrumbsCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void watchForChanges(@NotNull VirtualFile file, @NotNull Editor editor, @NotNull Disposable disposable, @NotNull Runnable changesHandler) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)changesHandler, (String)"changesHandler");
        if (editor.getProject() == null) {
            return;
        }
        Lifetime listenerLifetime = LifetimeDisposableExKt.createLifetime((Disposable)disposable);
        ApplicationKt.getApplication().invokeLater(() -> RiderFileBreadcrumbsCollector.watchForChanges$lambda$2(editor, listenerLifetime, changesHandler));
    }

    public boolean handlesFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!EditorSettingsExternalizable.getInstance().isBreadcrumbsShown()) {
            return false;
        }
        Language language = LanguageUtil.getFileLanguage((VirtualFile)virtualFile);
        if (language == null) {
            return false;
        }
        boolean handlesFile = BreadcrumbsUtilEx.isBreadcrumbsShownFor((Language)language) && RiderBreadcrumbsSupport.INSTANCE.isAvailable(language);
        this.logger.debug("backend breadcrumbs support handles file = " + handlesFile);
        return handlesFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<Crumb> computeCrumbs(@NotNull VirtualFile virtualFile, @NotNull Document document, int offset, @Nullable Boolean forcedShown) {
        void $this$mapTo$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.logger.debug("start computing crumbs for the file " + virtualFile + " and offset " + offset + " (thread: " + Thread.currentThread().getId() + ":" + Thread.currentThread().getName() + ")");
        if (!((Boolean)SolutionLifecycleHost.Companion.getInstance(this.project).isBackendLoaded().getValue()).booleanValue()) {
            return CollectionsKt.emptyList();
        }
        int currentSessionTimestamp = this.timestamp.incrementAndGet();
        DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer((Document)document, (Project)this.project);
        if (documentSynchronizer == null || (documentSynchronizer = documentSynchronizer.getModelDocument()) == null) {
            return CollectionsKt.emptyList();
        }
        DocumentSynchronizer rdDocument = documentSynchronizer;
        if (ApplicationKt.getApplication().isDispatchThread()) {
            long startNanoTime = System.nanoTime();
            Iterable<Crumb> crumbs = this.getCrumbsSynchronously(this.project, (RdDocumentModel)rdDocument, currentSessionTimestamp, offset);
            long durationMs = TimeoutUtil.getDurationMillis((long)startNanoTime);
            this.logger.debug("getCrumbsSynchronously took " + durationMs + "ms");
            return crumbs;
        }
        List backendResult = new ArrayList();
        ApplicationManager.getApplication().invokeLater(() -> RiderFileBreadcrumbsCollector.computeCrumbs$lambda$3(this, (RdDocumentModel)rdDocument, offset, currentSessionTimestamp));
        long fullTimeout = 5000L;
        long startNanoTime = System.nanoTime();
        SpinWait.Companion companion = SpinWait.Companion;
        Lifetime lifetime = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project));
        long timeoutMs$iv = fullTimeout;
        int $i$f$spinUntil = 0;
        void var17_19 = this_$iv;
        Duration duration = Duration.ofMillis(timeoutMs$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(timeoutMs)");
        Duration duration$iv$iv = duration;
        boolean $i$f$spinUntil2 = false;
        long start$iv$iv = System.nanoTime();
        long spins$iv$iv22 = 0L;
        while (true) {
            void lifetime$iv;
            CrumbSession session2;
            boolean bl;
            boolean bl2 = false;
            if (this.timestamp.get() > currentSessionTimestamp) {
                throw new ProcessCanceledException();
            }
            this.checkCancelled();
            if ((CrumbSession)com.jetbrains.rd.ide.document.DocumentExKt.getCrumbsSession((RdDocumentModel)rdDocument).getValue() == null) {
                bl = false;
            } else if (InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)session2.getCrumbs())) && session2.getTimestamp() == currentSessionTimestamp) {
                backendResult.addAll((Collection)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)session2.getCrumbs())));
                Logger $this$debug_u24default$iv = this.logger;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl3 = false;
                    logger.debug("Have gotten crumbs from the backend: " + backendResult, e$iv);
                }
                bl = true;
            } else {
                bl = false;
            }
            if (bl || !RLifetimeKt.isAlive((Lifetime)lifetime$iv) || System.nanoTime() - start$iv$iv > duration$iv$iv.toNanos()) break;
            long l = spins$iv$iv22;
            spins$iv$iv22 = l + 1L;
            if (l < 100L) {
                Thread.yield();
                continue;
            }
            Thread.sleep(spins$iv$iv22 / (long)100);
        }
        long durationMs = TimeoutUtil.getDurationMillis((long)startNanoTime);
        this.logger.debug("SpinWait.spinUntil took " + durationMs + "ms");
        List result2 = new ArrayList();
        for (CustomFileBreadcrumbExtensions ext : (CustomFileBreadcrumbExtensions[])CustomFileBreadcrumbExtensions.Companion.getEP_NAME().getExtensions()) {
            result2.addAll((Collection)ext.createCustomCrumbs(this.project, document));
        }
        Iterable iterable = backendResult;
        List list = result2;
        boolean $i$f$map = false;
        Iterable this_$iv$iv = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CrumbModel spins$iv$iv22 = (CrumbModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IconModel iconModel = it.getIcon();
            collection.add(new RdCrumb((CrumbModel)it, iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null, this.project));
        }
        list.addAll((List)destination$iv$iv);
        return result2;
    }

    private final void checkCancelled() {
        ProgressManager.checkCanceled();
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<Crumb> getCrumbsSynchronously(Project project, RdDocumentModel documentModel, int currentSessionTimestamp, int offset) {
        void $this$mapTo$iv$iv;
        com.jetbrains.rd.ide.document.DocumentExKt.getCrumbsSession((RdDocumentModel)documentModel).set((Object)new CrumbSession(offset, currentSessionTimestamp));
        IRdDispatcher dispatcher = IRdDispatcherKt.getAsRdDispatcher((IScheduler)ApplicationProtocolKt.getProtocol(project).getScheduler());
        Ref.ObjectRef backendResult = new Ref.ObjectRef();
        backendResult.element = CollectionsKt.emptyList();
        long timeout = 3000L;
        try {
            IRdDispatcherKt.pumpProtocolQueue((IRdDispatcher)dispatcher, (long)timeout, () -> RiderFileBreadcrumbsCollector.getCrumbsSynchronously$lambda$7(documentModel, currentSessionTimestamp, backendResult));
        }
        catch (TimeoutException timeoutException) {
            this.logger.error("Failed to get crumbs synchronously for " + timeout + " ms");
        }
        Iterable $this$map$iv = (Iterable)backendResult.element;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CrumbModel crumbModel = (CrumbModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IconModel iconModel = it.getIcon();
            collection.add(new RdCrumb((CrumbModel)it, iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null, project));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit watchForChanges$lambda$2$lambda$0(Runnable $changesHandler, boolean it) {
        $changesHandler.run();
        return Unit.INSTANCE;
    }

    private static final Unit watchForChanges$lambda$2$lambda$1(Runnable $changesHandler, String it) {
        $changesHandler.run();
        return Unit.INSTANCE;
    }

    private static final void watchForChanges$lambda$2(Editor $editor, Lifetime $listenerLifetime, Runnable $changesHandler) {
        Project project = $editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        SolutionLifecycleHost.Companion.getInstance(project2).isBackendLoaded().getChange().advise($listenerLifetime, arg_0 -> RiderFileBreadcrumbsCollector.watchForChanges$lambda$2$lambda$0($changesHandler, arg_0));
        IProperty<String> transaction = RiderProjectDocumentOperationModel_PregeneratedKt.getRiderProjectDocumentOperationModel(FrontendSessionsUtilKt.getProtocolModel((ClientProjectSession)FrontendSessionsUtilKt.getFrontendProjectSession((Project)project2))).getCommittingTransaction();
        transaction.getChange().advise($listenerLifetime, arg_0 -> RiderFileBreadcrumbsCollector.watchForChanges$lambda$2$lambda$1($changesHandler, arg_0));
    }

    private static final void computeCrumbs$lambda$3(RiderFileBreadcrumbsCollector this$0, RdDocumentModel $rdDocument, int $offset, int $currentSessionTimestamp) {
        if (this$0.project.isDisposed() || !$rdDocument.isBound()) {
            return;
        }
        com.jetbrains.rd.ide.document.DocumentExKt.getCrumbsSession((RdDocumentModel)$rdDocument).set((Object)new CrumbSession($offset, $currentSessionTimestamp));
    }

    private static final boolean getCrumbsSynchronously$lambda$7(RdDocumentModel $documentModel, int $currentSessionTimestamp, Ref.ObjectRef $backendResult) {
        CrumbSession crumbSession = (CrumbSession)com.jetbrains.rd.ide.document.DocumentExKt.getCrumbsSession((RdDocumentModel)$documentModel).getValue();
        if (crumbSession == null) {
            return true;
        }
        CrumbSession session2 = crumbSession;
        if (InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)session2.getCrumbs())) && session2.getTimestamp() == $currentSessionTimestamp) {
            $backendResult.element = InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)session2.getCrumbs()));
            return false;
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector$RdCrumb;", "Lcom/intellij/xml/breadcrumbs/NavigatableCrumb;", "crumbModel", "Lcom/jetbrains/rd/ide/model/CrumbModel;", "icon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/rd/ide/model/CrumbModel;Ljavax/swing/Icon;Lcom/intellij/openapi/project/Project;)V", "navigate", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "withSelection", "", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "getText", "", "getTooltip", "getIcon", "getContextActions", "", "Ljavax/swing/Action;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderFileBreadcrumbsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFileBreadcrumbsCollector.kt\ncom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector$RdCrumb\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n1#2:222\n1563#3:223\n1634#3,3:224\n*S KotlinDebug\n*F\n+ 1 RiderFileBreadcrumbsCollector.kt\ncom/jetbrains/rider/breadcrumbs/RiderFileBreadcrumbsCollector$RdCrumb\n*L\n188#1:223\n188#1:224,3\n*E\n"})
    public static final class RdCrumb
    implements NavigatableCrumb {
        @NotNull
        private final CrumbModel crumbModel;
        @Nullable
        private final Icon icon;
        @NotNull
        private final Project project;

        public RdCrumb(@NotNull CrumbModel crumbModel, @Nullable Icon icon, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)crumbModel, (String)"crumbModel");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.crumbModel = crumbModel;
            this.icon = icon;
            this.project = project;
        }

        public void navigate(@NotNull Editor editor, boolean withSelection) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.crumbModel.getNavigate().start(ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), (Object)withSelection);
        }

        @Nullable
        public TextRange getHighlightRange() {
            TextRange textRange;
            RdTextRange rdTextRange = this.crumbModel.getTextRange();
            if (rdTextRange != null) {
                RdTextRange $this$getHighlightRange_u24lambda_u240 = rdTextRange;
                boolean bl = false;
                textRange = new TextRange($this$getHighlightRange_u24lambda_u240.getStartOffset(), $this$getHighlightRange_u24lambda_u240.getEndOffset());
            } else {
                textRange = null;
            }
            return textRange;
        }

        @NotNull
        public String getText() {
            return this.crumbModel.getText();
        }

        @Nullable
        public String getTooltip() {
            return this.crumbModel.getTooltip();
        }

        @Nullable
        public Icon getIcon() {
            return this.icon;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<? extends Action> getContextActions() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.crumbModel.getActions();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void action2;
                CrumbAction crumbAction = (CrumbAction)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new BreadCrumbAction((CrumbAction)action2, this.project));
            }
            return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
    }
}

