/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.FocusBehaviour;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rdclient.completion.ProtocolLookupItemBase;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rider.completion.CompletionStateData;
import com.jetbrains.rider.completion.FrontendAutoPopupHost;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.FrontendCompletionHostKt;
import com.jetbrains.rider.completion.FrontendLookupListener;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.completion.QuickDocLookupListener;
import com.jetbrains.rider.completion.RiderLookupAsyncPresenter;
import com.jetbrains.rider.completion.RiderLookupListener;
import com.jetbrains.rider.completion.UtilsKt;
import com.jetbrains.rider.completion.summaryInfo.SummaryInfoTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/completion/RiderLookupListener;", "Lcom/jetbrains/rider/completion/FrontendLookupListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "handleBackendLookupShown", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "Companion", "intellij.rider.rdclient.dotnet"})
public final class RiderLookupListener
extends FrontendLookupListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<Boolean> forceSoftSelectionKey;

    public RiderLookupListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    protected void handleBackendLookupShown(@NotNull LookupImpl lookup, @NotNull IdeBackend backend) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        if (!UtilsKt.isTypingSessionCompletionEnabled()) {
            return;
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (settings.AUTO_POPUP_JAVADOC_INFO) {
            SummaryInfoTracker.Companion.addSummaryInfoTracker((LookupEx)lookup);
        }
        super.handleBackendLookupShown(lookup, backend);
        RiderLookupAsyncPresenter updater = RiderLookupAsyncPresenter.Companion.getInstance(this.getProject());
        Editor editor = lookup.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        FrontendAutoPopupHost.AutoPopupState autoPopupState = FrontendAutoPopupHost.Companion.getAutoPopupState(editor);
        boolean bl = autoPopupState != null ? autoPopupState.isNextLookupSoft() : false;
        if (bl) {
            lookup.putUserData(forceSoftSelectionKey, (Object)true);
        }
        FrontendCompletionHost completionHost = FrontendCompletionHost.Companion.getInstance(this.getProject());
        lookup.addLookupListener(new LookupListener(lookup, completionHost, updater){
            final /* synthetic */ LookupImpl $lookup;
            final /* synthetic */ FrontendCompletionHost $completionHost;
            final /* synthetic */ RiderLookupAsyncPresenter $updater;
            {
                this.$lookup = $lookup;
                this.$completionHost = $completionHost;
                this.$updater = $updater;
            }

            public boolean beforeItemSelected(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return com.jetbrains.rdclient.completion.UtilsKt.tryGetProtocolItem((LookupElement)event.getItem()) == null;
            }

            /*
             * WARNING - void declaration
             */
            public void uiRefreshed() {
                RiderLookupListener.Companion.getLogger().trace("refreshUI " + this.hashCode());
                Editor editor = this.$lookup.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
                boolean hasSession = completionStateData.getHasSession();
                if (hasSession) {
                    Editor editor2 = this.$lookup.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                    if (this.$completionHost.getBackendFocusBehaviour(editor2) == FocusBehaviour.SoftWhenEmpty) {
                        String string = this.$lookup.getAdditionalPrefix();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAdditionalPrefix(...)");
                        if (((CharSequence)string).length() > 0) {
                            boolean bl;
                            block10: {
                                String string2 = this.$lookup.getAdditionalPrefix();
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAdditionalPrefix(...)");
                                CharSequence $this$any$iv = string2;
                                boolean $i$f$any = false;
                                for (int i = 0; i < $this$any$iv.length(); ++i) {
                                    char element$iv;
                                    char it = element$iv = $this$any$iv.charAt(i);
                                    boolean bl2 = false;
                                    if (!(!Character.isDigit(it))) continue;
                                    bl = true;
                                    break block10;
                                }
                                bl = false;
                            }
                            if (bl && CodeInsightSettings.getInstance().isSelectAutopopupSuggestionsByChars()) {
                                this.$lookup.setLookupFocusDegree(LookupFocusDegree.FOCUSED);
                            }
                        }
                    }
                }
                if (hasSession && !ApplicationKt.getApplication().isUnitTestMode()) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Object element$iv$iv$iv2;
                    void $this$mapNotNullTo$iv$iv2;
                    List list = this.$lookup.getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
                    Iterable $this$mapNotNull$iv = list;
                    boolean $i$f$mapNotNull = false;
                    Iterable element$iv = $this$mapNotNull$iv;
                    Iterable<Pair> destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
                        Pair it$iv$iv;
                        T element$iv$iv = element$iv$iv$iv2;
                        boolean bl = false;
                        LookupElement it = (LookupElement)element$iv$iv;
                        boolean bl3 = false;
                        if (TuplesKt.to((Object)it, (Object)com.jetbrains.rdclient.completion.UtilsKt.tryGetProtocolItem((LookupElement)it)) == null) continue;
                        boolean bl4 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List lookupToResharperItems = (List)destination$iv$iv;
                    Iterable $this$mapNotNull$iv2 = lookupToResharperItems;
                    boolean $i$f$mapNotNull2 = false;
                    destination$iv$iv = $this$mapNotNull$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo2 = false;
                    void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach2 = false;
                    element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
                    while (element$iv$iv$iv2.hasNext()) {
                        ProtocolLookupItemBase it$iv$iv;
                        E element$iv$iv$iv3;
                        E element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
                        boolean bl = false;
                        Pair it = (Pair)element$iv$iv;
                        boolean bl5 = false;
                        if ((ProtocolLookupItemBase)it.getSecond() == null) continue;
                        boolean bl6 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv2 = (List)destination$iv$iv2;
                    boolean $i$f$filter = false;
                    $this$mapNotNullTo$iv$iv = $this$filter$iv;
                    destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        ProtocolLookupItemBase it = (ProtocolLookupItemBase)element$iv$iv;
                        boolean bl = false;
                        if (!it.shouldRequestUpdate()) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List toUpdate = (List)destination$iv$iv2;
                    if (!((Collection)toUpdate).isEmpty()) {
                        this.$updater.updatePresentation(toUpdate, this.$lookup, (Function0<Unit>)((Function0)() -> handleBackendLookupShown.1.uiRefreshed$lambda$5(this.$lookup, lookupToResharperItems)));
                    }
                }
            }

            private static final Unit uiRefreshed$lambda$5(LookupImpl $lookup, List $lookupToResharperItems) {
                List currentItems = $lookup.getItems();
                Iterable $this$forEach$iv = $lookupToResharperItems;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ProtocolLookupItemBase protocolLookupItemBase;
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    if (currentItems.contains(it.getFirst())) {
                        $lookup.scheduleItemUpdate((LookupElement)it.getFirst());
                        continue;
                    }
                    RiderLookupListener.Companion.getLogger().trace("Skip updating item " + ((protocolLookupItemBase = (ProtocolLookupItemBase)it.getSecond()) != null && (protocolLookupItemBase = protocolLookupItemBase.getCompletionItem()) != null ? protocolLookupItemBase.getShortText() : null) + " because it doesn't shown in lookup anymore");
                }
                return Unit.INSTANCE;
            }
        });
        lookup.addLookupListener(new LookupListener(lookup, this){
            final /* synthetic */ LookupImpl $lookup;
            final /* synthetic */ RiderLookupListener this$0;
            {
                this.$lookup = $lookup;
                this.this$0 = $receiver;
            }

            public void lookupCanceled(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.isCanceledExplicitly()) {
                    Editor editor = this.$lookup.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
                    if (FrontendCompletionHostKt.getCompletionStateData(editor).getHasSession()) {
                        PreemptiveCompletionHost preemptiveCompletionHost = PreemptiveCompletionHost.Companion.getInstance(this.this$0.getProject());
                        Editor editor2 = this.$lookup.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                        preemptiveCompletionHost.tryScheduleCompletion(editor2, "Lookup was cancelled");
                    }
                }
            }
        });
        lookup.addLookupListener((LookupListener)new QuickDocLookupListener(ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)lookup)), lookup));
    }

    static {
        Logger logger = Logger.getInstance(RiderLookupListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderLookupListener.logger = logger;
        forceSoftSelectionKey = new Key("ForceSoft");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/completion/RiderLookupListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "forceSoftSelectionKey", "Lcom/intellij/openapi/util/Key;", "", "getForceSoftSelectionKey", "()Lcom/intellij/openapi/util/Key;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Key<Boolean> getForceSoftSelectionKey() {
            return forceSoftSelectionKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

