/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagnostics;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.NetCoreUtil;
import com.jetbrains.rider.model.RdShellModel;
import com.jetbrains.rider.model.RdShellModel_PregeneratedKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/diagnostics/RiderDescriptionProvider;", "", "<init>", "()V", "getDescription", "", "backendRuntimeInfo", "frontendClrInfo", "intellij.rider.rdclient.dotnet"})
public final class RiderDescriptionProvider {
    @NotNull
    public static final RiderDescriptionProvider INSTANCE = new RiderDescriptionProvider();
    @NotNull
    private static final String frontendClrInfo = NetCoreUtil.INSTANCE.runOnNetCore() ? ".NET" : (SystemInfo.isWindows ? ".NET Framework" : "Mono");

    private RiderDescriptionProvider() {
    }

    @NotNull
    public final String getDescription() {
        Object object = this.backendRuntimeInfo();
        if (object == null) {
            object = frontendClrInfo + " (backend unavailable)";
        }
        return object;
    }

    private final String backendRuntimeInfo() {
        IProtocolHostWithBackend iProtocolHostWithBackend;
        try {
            IOptProperty<String> iOptProperty;
            RdShellModel rdShellModel;
            IProtocol iProtocol;
            iProtocolHostWithBackend = (IProtocolHostWithBackend)CollectionsKt.firstOrNull((Iterable)ApplicationProtocolKt.getProtocolManager(ApplicationKt.getApplication()).getProtocolHostsFlow());
            iProtocolHostWithBackend = iProtocolHostWithBackend != null && (iProtocol = iProtocolHostWithBackend.getProtocol()) != null && (rdShellModel = RdShellModel_PregeneratedKt.getRdShellModel(iProtocol)) != null && (iOptProperty = rdShellModel.getBackendRuntime()) != null ? (String)iOptProperty.getValueOrNull() : null;
        }
        catch (Throwable e) {
            Logger.getInstance(INSTANCE.getClass()).error(e);
            iProtocolHostWithBackend = null;
        }
        return iProtocolHostWithBackend;
    }
}

