/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdTextBufferDocumentModel;
import com.jetbrains.rd.ide.model.RiderTextBufferDocumentModel;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rider.document.DocumentChangeModelConversion;
import com.jetbrains.rider.document.FrontendDocumentSuppressor;
import com.jetbrains.rider.document.TextBufferDocumentSynchronizer;
import com.jetbrains.rider.editors.RiderBackendInteractionHelper;
import com.jetbrains.rider.model.DiagnosticsModel;
import com.jetbrains.rider.model.DiagnosticsModel_PregeneratedKt;
import com.jetbrains.rider.protocol.ProtocolManagerKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u001c\u001a\u00020\u001d2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001fH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010 \u001a\u00020!8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/document/RiderDocumentSynchronizer;", "Lcom/jetbrains/rider/document/TextBufferDocumentSynchronizer;", "documentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "modelDocument", "Lcom/jetbrains/rd/ide/model/RiderTextBufferDocumentModel;", "modelDocumentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "suppressor", "Lcom/jetbrains/rider/document/FrontendDocumentSuppressor;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/rd/ide/model/RiderTextBufferDocumentModel;Lcom/jetbrains/rd/ide/model/RdDocumentId;Lcom/jetbrains/rider/document/FrontendDocumentSuppressor;)V", "getDocumentLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getModelDocument", "()Lcom/jetbrains/rd/ide/model/RiderTextBufferDocumentModel;", "gateway", "Lcom/jetbrains/rider/editors/RiderBackendInteractionHelper;", "getGateway", "()Lcom/jetbrains/rider/editors/RiderBackendInteractionHelper;", "gateway$delegate", "Lkotlin/Lazy;", "verifyMayUpdateDocument", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentConsistencyAssertionsEnabled", "", "getDocumentConsistencyAssertionsEnabled", "()Z", "createModelChange", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "change", "intellij.rider.rdclient.dotnet"})
public final class RiderDocumentSynchronizer
extends TextBufferDocumentSynchronizer {
    @NotNull
    private final Lifetime documentLifetime;
    @NotNull
    private final RiderTextBufferDocumentModel modelDocument;
    @NotNull
    private final Lazy gateway$delegate;

    public RiderDocumentSynchronizer(@NotNull Lifetime documentLifetime, @NotNull ClientAppSession session2, @NotNull Document document, @Nullable VirtualFile file, @NotNull RiderTextBufferDocumentModel modelDocument, @NotNull RdDocumentId modelDocumentId, @NotNull FrontendDocumentSuppressor suppressor) {
        Intrinsics.checkNotNullParameter((Object)documentLifetime, (String)"documentLifetime");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)modelDocument, (String)"modelDocument");
        Intrinsics.checkNotNullParameter((Object)modelDocumentId, (String)"modelDocumentId");
        Intrinsics.checkNotNullParameter((Object)suppressor, (String)"suppressor");
        super(session2, document, file, (RdTextBufferDocumentModel)modelDocument, modelDocumentId, suppressor);
        this.documentLifetime = documentLifetime;
        this.modelDocument = modelDocument;
        this.gateway$delegate = LazyKt.lazy(() -> RiderDocumentSynchronizer.gateway_delegate$lambda$0(session2));
    }

    @NotNull
    public Lifetime getDocumentLifetime() {
        return this.documentLifetime;
    }

    @NotNull
    public RiderTextBufferDocumentModel getModelDocument() {
        return this.modelDocument;
    }

    private final RiderBackendInteractionHelper getGateway() {
        Lazy lazy = this.gateway$delegate;
        return (RiderBackendInteractionHelper)((Object)lazy.getValue());
    }

    @Override
    protected void verifyMayUpdateDocument(@Nullable VirtualFile file, @NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.verifyMayUpdateDocument(file, event);
        boolean frontendChangeUnderSyncFromBackend = this.getGateway().isSyncFromBackendInProgress(file) && !this.getBackendUpdateInProgressMarker();
        if (!(!frontendChangeUnderSyncFromBackend)) {
            boolean bl = false;
            String string = "Someone is intentionally modifying the document while syncing from backend. Change: '" + event.getOldFragment() + "' -> '" + event.getNewFragment() + "' in " + event.getOffset();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    protected boolean getDocumentConsistencyAssertionsEnabled() {
        Object object = ProtocolManagerKt.getProjectSessionOrNull(this.getSession());
        return object != null && (object = FrontendSessionsUtilKt.getProtocolModel((ClientProjectSession)object)) != null && (object = DiagnosticsModel_PregeneratedKt.getDiagnosticsModel((Solution)object)) != null && (object = ((DiagnosticsModel)((Object)object)).getBackendDocumentAssertEnabled()) != null ? (Boolean)object.getValue() : false;
    }

    @Override
    @NotNull
    protected RdTextChange createModelChange(@NotNull DocumentEvent change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        return DocumentChangeModelConversion.INSTANCE.createModelChange(change);
    }

    private static final RiderBackendInteractionHelper gateway_delegate$lambda$0(ClientAppSession $session) {
        return RiderBackendInteractionHelper.Companion.getInstance($session);
    }
}

