/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.ImmutableCharSequence;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKind;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.util.StringUtilKt;
import com.jetbrains.rider.editorActions.RangePair;
import com.jetbrains.rider.editorActions.TextModificationSide;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@RiderOnly
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\"\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"delta", "", "Lcom/jetbrains/rider/editorActions/RangePair;", "getDelta", "(Lcom/jetbrains/rider/editorActions/RangePair;)I", "shiftNewRange", "toTextChange", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "optimize", "initialDocumentText", "", "applyChange", "", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.rider.rdclient.dotnet"})
public final class RangePairKt {
    public static final int getDelta(@NotNull RangePair $this$delta) {
        Intrinsics.checkNotNullParameter((Object)$this$delta, (String)"<this>");
        boolean $i$f$getDelta = false;
        return $this$delta.getNewRange().getLength() - $this$delta.getOldRange().getLength();
    }

    @NotNull
    public static final RangePair shiftNewRange(@NotNull RangePair $this$shiftNewRange, int delta) {
        Intrinsics.checkNotNullParameter((Object)$this$shiftNewRange, (String)"<this>");
        TextRange textRange = $this$shiftNewRange.getOldRange();
        TextRange textRange2 = $this$shiftNewRange.getNewRange().shiftRight(delta);
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftRight(...)");
        return new RangePair(textRange, textRange2, $this$shiftNewRange.getNewText(), $this$shiftNewRange.getModificationSide());
    }

    @NotNull
    public static final RangePair toTextChange(@NotNull RdTextChange $this$toTextChange) {
        Intrinsics.checkNotNullParameter((Object)$this$toTextChange, (String)"<this>");
        TextRange textRange = TextRange.from((int)$this$toTextChange.getStartOffset(), (int)$this$toTextChange.getOld().length());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
        TextRange oldRange = textRange;
        TextRange textRange2 = TextRange.from((int)$this$toTextChange.getStartOffset(), (int)$this$toTextChange.getNew().length());
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"from(...)");
        TextRange newRange = textRange2;
        TextModificationSide modificationSide = switch (WhenMappings.$EnumSwitchMapping$0[$this$toTextChange.getKind().ordinal()]) {
            case 1 -> TextModificationSide.LeftSide;
            case 2 -> TextModificationSide.RightSide;
            case 3 -> throw new IllegalArgumentException("Unexpected kind");
            case 4 -> throw new IllegalArgumentException("Unexpected kind");
            default -> TextModificationSide.NotSpecified;
        };
        return new RangePair(oldRange, newRange, $this$toTextChange.getNew(), modificationSide);
    }

    @NotNull
    public static final RangePair optimize(@NotNull RangePair $this$optimize, @NotNull CharSequence initialDocumentText) {
        Intrinsics.checkNotNullParameter((Object)$this$optimize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)initialDocumentText, (String)"initialDocumentText");
        if ($this$optimize.isEmpty()) {
            return $this$optimize;
        }
        TextRange oldRange = $this$optimize.getOldRange();
        TextRange newRange = $this$optimize.getNewRange();
        CharSequence oldText = initialDocumentText.subSequence(oldRange.getStartOffset(), oldRange.getEndOffset());
        ImmutableCharSequence newText = $this$optimize.getNewText();
        int prefixLength = StringUtilKt.getCommonPrefixLength((CharSequence)oldText, (CharSequence)((CharSequence)newText));
        int suffixLength = StringUtilKt.getCommonSuffixLength((CharSequence)oldText, (CharSequence)((CharSequence)newText), (int)prefixLength);
        if (prefixLength == 0 && suffixLength == 0) {
            return $this$optimize;
        }
        TextRange oldRange1 = new TextRange(oldRange.getStartOffset() + prefixLength, oldRange.getEndOffset() - suffixLength);
        TextRange newRange1 = new TextRange(newRange.getStartOffset() + prefixLength, newRange.getEndOffset() - suffixLength);
        ImmutableCharSequence immutableCharSequence = newText.subtext(prefixLength, newText.length() - suffixLength);
        Intrinsics.checkNotNullExpressionValue((Object)immutableCharSequence, (String)"subtext(...)");
        ImmutableCharSequence newText1 = immutableCharSequence;
        return new RangePair(oldRange1, newRange1, newText1, TextModificationSide.NotSpecified);
    }

    public static final void applyChange(@NotNull RangePair $this$applyChange, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$applyChange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        TextRange oldRange = $this$applyChange.getOldRange();
        TextRange newRange = $this$applyChange.getNewRange();
        switch (WhenMappings.$EnumSwitchMapping$1[$this$applyChange.getModificationSide().ordinal()]) {
            case 1: {
                if (!oldRange.isEmpty() && !newRange.isEmpty()) {
                    document.replaceString(oldRange.getStartOffset(), oldRange.getEndOffset(), (CharSequence)$this$applyChange.getNewText());
                    break;
                }
                if (!oldRange.isEmpty() && newRange.isEmpty()) {
                    document.deleteString(oldRange.getStartOffset(), oldRange.getEndOffset());
                    break;
                }
                if (!oldRange.isEmpty() || newRange.isEmpty()) break;
                document.insertString(oldRange.getStartOffset(), (CharSequence)$this$applyChange.getNewText());
                break;
            }
            case 2: {
                int initialEnd = Math.min(document.getTextLength(), oldRange.getEndOffset() + 1);
                String initialNewText = $this$applyChange.getNewText() + document.getText(new TextRange(oldRange.getEndOffset(), initialEnd));
                document.replaceString(oldRange.getStartOffset(), initialEnd, (CharSequence)initialNewText);
                break;
            }
            case 3: {
                int initialStart = Math.max(0, oldRange.getStartOffset() - 1);
                String initialNewText = document.getText(new TextRange(initialStart, oldRange.getStartOffset())) + $this$applyChange.getNewText();
                document.replaceString(initialStart, oldRange.getStartOffset(), (CharSequence)initialNewText);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RdTextChangeKind.values().length];
            try {
                nArray[RdTextChangeKind.InsertLeftSide.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.InsertRightSide.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.PromoteVersion.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdTextChangeKind.Reset.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TextModificationSide.values().length];
            try {
                nArray[TextModificationSide.NotSpecified.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextModificationSide.LeftSide.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextModificationSide.RightSide.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

