/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.rider.editorActions.FrontendTypedHandler;
import com.jetbrains.rider.platform.LanguageExtensionExtensions;
import com.jetbrains.rider.platform.ProtocolLanguageFeatureProvider;
import com.jetbrains.rider.platform.SinglePerLanguageExtension;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/editorActions/RiderTypedHandlersSupport;", "Lcom/jetbrains/rider/platform/ProtocolLanguageFeatureProvider;", "<init>", "()V", "EP_NAME", "", "extensions", "Lcom/jetbrains/rider/platform/SinglePerLanguageExtension;", "Lcom/jetbrains/rider/editorActions/FrontendTypedHandler;", "forLanguage", "language", "Lcom/intellij/lang/Language;", "getTypeHandler", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "intellij.rider.rdclient.dotnet"})
public final class RiderTypedHandlersSupport
implements ProtocolLanguageFeatureProvider {
    @NotNull
    public static final RiderTypedHandlersSupport INSTANCE = new RiderTypedHandlersSupport();
    @NotNull
    public static final String EP_NAME = "com.intellij.backend.typedHandler";
    @NotNull
    private static final SinglePerLanguageExtension<FrontendTypedHandler> extensions = new SinglePerLanguageExtension("com.intellij.backend.typedHandler");

    private RiderTypedHandlersSupport() {
    }

    @JvmStatic
    @Nullable
    public static final FrontendTypedHandler forLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return LanguageExtensionExtensions.INSTANCE.findFirstForHierarchy(extensions, language);
    }

    @JvmStatic
    @Nullable
    public static final FrontendTypedHandler getTypeHandler(@NotNull Editor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        Language language = PsiUtilBase.getLanguageAtOffset((PsiFile)psiFile3, (int)offset);
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguageAtOffset(...)");
        Language language2 = language;
        FrontendTypedHandler frontendTypedHandler = RiderTypedHandlersSupport.forLanguage(language2);
        if (frontendTypedHandler == null) {
            return null;
        }
        FrontendTypedHandler typedHandler = frontendTypedHandler;
        if (typedHandler.isAvailable(psiFile3, offset)) {
            return typedHandler;
        }
        return null;
    }

    public static /* synthetic */ FrontendTypedHandler getTypeHandler$default(Editor editor, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = editor.getCaretModel().getOffset();
        }
        return RiderTypedHandlersSupport.getTypeHandler(editor, n);
    }

    @Override
    public boolean isAvailable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Language language = file.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        FrontendTypedHandler frontendTypedHandler = RiderTypedHandlersSupport.forLanguage(language);
        return frontendTypedHandler != null ? frontendTypedHandler.isAvailable(file) : false;
    }
}

