/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.icons.converters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.IconLoader;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.ImageSourceIconModel;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconModelRegistry;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rider.icons.RiderIconCache;
import com.jetbrains.rider.icons.RiderIconUtilsKt;
import icons.ReSharperIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/icons/converters/ImageSourceIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Ljavax/swing/Icon;", "Lcom/jetbrains/rd/ide/model/IconModel;", "<init>", "()V", "getIdeaIconId", "", "iconPack", "iconName", "createIcon", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "icon", "Lcom/jetbrains/rd/ui/icons/ProtocolIconModelRegistry;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nImageSourceIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageSourceIconConverter.kt\ncom/jetbrains/rider/icons/converters/ImageSourceIconConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n83#2,3:62\n14#2:65\n*S KotlinDebug\n*F\n+ 1 ImageSourceIconConverter.kt\ncom/jetbrains/rider/icons/converters/ImageSourceIconConverter\n*L\n49#1:62,3\n18#1:65\n*E\n"})
public final class ImageSourceIconConverter
implements ProtocolIconConverter<Icon, IconModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Nullable
    public final String getIdeaIconId(@NotNull String iconPack, @NotNull String iconName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)iconPack, (String)"iconPack");
        Intrinsics.checkNotNullParameter((Object)iconName, (String)"iconName");
        String[] stringArray = new String[]{"."};
        List packSplit = StringsKt.split$default((CharSequence)iconPack, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (packSplit.size() == 1) {
            string = (String)CollectionsKt.single((List)packSplit);
        } else if (packSplit.size() >= 3) {
            Object e = packSplit.get(packSplit.size() - 3);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            string = (String)e;
        } else {
            return null;
        }
        String category = string;
        return "resharper/" + category + "/" + iconName + ".svg";
    }

    @Nullable
    public Icon createIcon(@NotNull IconModel model2, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        if (!(model2 instanceof ImageSourceIconModel)) {
            return null;
        }
        String iconPack = ((ImageSourceIconModel)model2).getIconPackStringId();
        String iconName = ((ImageSourceIconModel)model2).getIconNameStringId();
        return RiderIconCache.Companion.getInstance().getOrPut(iconPack, iconName, (Function0<? extends Icon>)((Function0)() -> ImageSourceIconConverter.createIcon$lambda$2(this, iconPack, iconName)));
    }

    @Nullable
    public IconModel createModel(@NotNull Icon icon, @NotNull ProtocolIconModelRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        return null;
    }

    private static final Icon createIcon$lambda$2(ImageSourceIconConverter this$0, String $iconPack, String $iconName) {
        Icon icon;
        Object $this$runAndLogException_u24lambda_u240$iv;
        String ideaIconId = this$0.getIdeaIconId($iconPack, $iconName);
        if (ideaIconId == null) {
            logger.error("Invalid R# coordinates for pack: pack:" + $iconPack + " name:" + $iconName + " (expected 1 or >= 3 dot-separated words)");
            Icon icon2 = ReSharperIcons.Special.InvalidIcon;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"InvalidIcon");
            return icon2;
        }
        ClassLoader classLoader = RiderIconUtilsKt.tryFindIconClassLoader(ideaIconId);
        if (classLoader == null) {
            logger.error("Unable to find icon " + ideaIconId + ", R# coordinates: pack:" + $iconPack + " name:" + $iconName);
            Icon icon3 = ReSharperIcons.Special.InvalidIcon;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"InvalidIcon");
            return icon3;
        }
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)IconLoader.findIcon((String)ideaIconId, (ClassLoader)classLoader));
        }
        catch (Throwable throwable) {
            $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if ((icon = (Icon)LoggerKt.getOrLogException((Object)$this$runAndLogException_u24lambda_u240$iv, (Logger)$this$runAndLogException$iv)) == null) {
            ImageSourceIconConverter $this$createIcon_u24lambda_u242_u24lambda_u241 = this$0;
            boolean bl = false;
            ImageSourceIconConverter.logger.error("Unable to load icon " + ideaIconId + ", R# coordinates: pack:" + $iconPack + " name:" + $iconName);
            Icon icon4 = ReSharperIcons.Special.InvalidIcon;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"run(...)");
        }
        return icon;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ImageSourceIconConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ImageSourceIconConverter.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/icons/converters/ImageSourceIconConverter$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

