/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.inTests;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.inTests.BulbItemsTestInfo;
import com.jetbrains.rider.inTests.PerformancePlaybackTestsKt;
import com.jetbrains.rider.model.BulbTestState;
import com.jetbrains.rider.model.CleanupData;
import com.jetbrains.rider.model.NotReadyTestState;
import com.jetbrains.rider.model.RdTestSettingsEntry;
import com.jetbrains.rider.model.ReadyTestState;
import com.jetbrains.rider.model.RiderTestModel;
import com.jetbrains.rider.model.RiderTestModel_PregeneratedKt;
import com.jetbrains.rider.model.SymLinkArg;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.ProtocolManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00182\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0018J\u0006\u0010\"\u001a\u00020\u0016J\u0006\u0010#\u001a\u00020\u0016J\u000e\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0018J\u0016\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/inTests/TestHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "frameworkLogger", "Lorg/apache/commons/logging/Log;", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "getProtocol", "()Lcom/jetbrains/rd/framework/IProtocol;", "model", "Lcom/jetbrains/rider/model/RiderTestModel;", "getModel", "()Lcom/jetbrains/rider/model/RiderTestModel;", "isReady", "", "()Z", "setEnvVar", "", "key", "", "value", "getBulbItemsDiagnosticInformation", "Lcom/jetbrains/rider/inTests/BulbItemsTestInfo;", "cleanupBetweenTests", "reason", "filesToInvalidateCaches", "", "Ljava/io/File;", "backendWaitForCaches", "waitForExternalChangeProcessor", "waitForWebFormsAvailabilityCache", "commitPsiFile", "editor", "Lcom/jetbrains/rd/ide/model/TextControlId;", "flushQueueFromTests", "createSymLinkDir", "source", "link", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTestHostFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestHostFactory.kt\ncom/jetbrains/rider/inTests/TestHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1563#2:123\n1634#2,3:124\n*S KotlinDebug\n*F\n+ 1 TestHostFactory.kt\ncom/jetbrains/rider/inTests/TestHost\n*L\n69#1:123\n69#1:124,3\n*E\n"})
public final class TestHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final Log frameworkLogger;

    public TestHost(@NotNull ClientAppSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        Log log = LogFactory.getLog((String)"com.jetbrains.rider.test.framework");
        Intrinsics.checkNotNull((Object)log);
        this.frameworkLogger = log;
        boolean bl2 = bl = ApplicationKt.getApplication().isUnitTestMode() || PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "This component must be instantiated only in some test mode";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    private final IProtocol getProtocol() {
        return FrontendSessionsUtilKt.getProtocol((ClientAppSession)this.session);
    }

    @NotNull
    public final RiderTestModel getModel() {
        return RiderTestModel_PregeneratedKt.getRiderTestModel(this.getProtocol());
    }

    public final boolean isReady() {
        return BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.getModel().getReady()));
    }

    public final void setEnvVar(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        ExtensionsKt.callSynchronously$default((IRdCall)((IRdCall)this.getModel().getSetEnvVariable()), (Object)new RdTestSettingsEntry(key, value), (IProtocol)this.getProtocol(), (Lifetime)this.getServiceLifetime(), null, null, (int)24, null);
        this.frameworkLogger.info((Object)("Setup env var " + key + " = '" + value + "'"));
    }

    @NotNull
    public final BulbItemsTestInfo getBulbItemsDiagnosticInformation() {
        BulbTestState value = (BulbTestState)this.getModel().getBulbTestStateInfo().getValueOrNull();
        BulbTestState bulbTestState = value;
        if (bulbTestState instanceof ReadyTestState) {
            if (((ReadyTestState)value).getCreatedWithHighlighterUnderCaret()) {
                return new BulbItemsTestInfo(false, "BulbItems was created by Highlighter Under caret.");
            }
            if (((ReadyTestState)value).getUponInvalidatedDaemon()) {
                return new BulbItemsTestInfo(false, "The Daemon was invalidated (QF's isn't collected).");
            }
            return new BulbItemsTestInfo(true, "");
        }
        if (bulbTestState instanceof NotReadyTestState) {
            return new BulbItemsTestInfo(false, "BulbItems isn't in ready state.");
        }
        Object object = value;
        if (object == null || (object = object.getClass()) == null || (object = ((Class)object).getSimpleName()) == null) {
            object = "NULL";
        }
        throw new IllegalArgumentException("Unexpected type: " + (String)object);
    }

    /*
     * WARNING - void declaration
     */
    public final void cleanupBetweenTests(@NotNull String reason, @NotNull List<? extends File> filesToInvalidateCaches) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Intrinsics.checkNotNullParameter(filesToInvalidateCaches, (String)"filesToInvalidateCaches");
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        Iterable iterable = filesToInvalidateCaches;
        String string = reason;
        IRdCall iRdCall = (IRdCall)this.getModel().getCleanupDocuments();
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCanonicalPath());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        String string2 = string;
        ExtensionsKt.callSynchronously$default((IRdCall)iRdCall, (Object)new CleanupData(string2, list), (IProtocol)this.getProtocol(), (Lifetime)this.getServiceLifetime(), null, null, (int)24, null);
        this.frameworkLogger.info((Object)"Cleaned up documents between tests.");
    }

    public static /* synthetic */ void cleanupBetweenTests$default(TestHost testHost, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        testHost.cleanupBetweenTests(string, list);
    }

    public final void backendWaitForCaches(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        Integer result2 = (Integer)ExtensionsKt.callSynchronously$default((IRdCall)((IRdCall)this.getModel().getWaitForCaches()), (Object)reason, (IProtocol)this.getProtocol(), (Lifetime)this.getServiceLifetime(), null, null, (int)24, null);
        this.frameworkLogger.info((Object)("Complete waiting for backend document caches. waitForIdle state performed for " + result2 + " milliseconds"));
    }

    public final void waitForExternalChangeProcessor() {
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        this.frameworkLogger.info((Object)"Start syncExternalChangeProcessor()");
        ExtensionsKt.callSynchronously$default((IRdCall)((IRdCall)this.getModel().getSyncExternalChangeProcessor()), (Object)Unit.INSTANCE, (IProtocol)this.getProtocol(), (Lifetime)this.getServiceLifetime(), null, null, (int)24, null);
        this.frameworkLogger.info((Object)"Finished syncExternalChangeProcessor()");
    }

    public final void waitForWebFormsAvailabilityCache() {
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        this.frameworkLogger.info((Object)"Start waitForWebFormsAvailabilityCache()");
        ExtensionsKt.callSynchronously$default((IRdCall)((IRdCall)this.getModel().getWaitForWebFormsAvailabilityCache()), (Object)Unit.INSTANCE, (IProtocol)this.getProtocol(), (Lifetime)this.getServiceLifetime(), null, null, (int)24, null);
        this.frameworkLogger.info((Object)"Finished waitForWebFormsAvailabilityCache()");
    }

    public final void commitPsiFile(@NotNull TextControlId editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        Integer result2 = (Integer)ExtensionsKt.callSynchronously$default((IRdCall)((IRdCall)this.getModel().getCommitPsiFile()), (Object)editor, (IProtocol)this.getProtocol(), (Lifetime)this.getServiceLifetime(), null, null, (int)24, null);
        this.frameworkLogger.info((Object)("Complete waiting for backend commit psi file. Commit performed for " + result2 + " milliseconds"));
    }

    public final void flushQueueFromTests(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.frameworkLogger.info((Object)"flushing the backend queue from tests....");
        if (ProtocolManager.Companion.isResharperBackendDisabled()) {
            return;
        }
        ExtensionsKt.callSynchronously$default((IRdCall)((IRdCall)this.getModel().getFlushQueueFromTests()), (Object)reason, (IProtocol)this.getProtocol(), (Lifetime)this.getServiceLifetime(), null, null, (int)24, null);
        this.frameworkLogger.info((Object)"Processed frontend queues on the backend");
    }

    @NotNull
    public final File createSymLinkDir(@NotNull File source, @NotNull File link) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        this.frameworkLogger.info((Object)"Call createSymLink");
        IRdCall iRdCall = (IRdCall)this.getModel().getCreateSymLink();
        String string = source.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String string2 = link.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        ExtensionsKt.callSynchronously$default((IRdCall)iRdCall, (Object)new SymLinkArg(string, string2), (IProtocol)this.getProtocol(), (Lifetime)this.getServiceLifetime(), null, null, (int)24, null);
        return link;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/inTests/TestHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/inTests/TestHost;", "protocolHost", "Lcom/jetbrains/rider/protocol/IProtocolHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nTestHostFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestHostFactory.kt\ncom/jetbrains/rider/inTests/TestHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,122:1\n23#2:123\n*S KotlinDebug\n*F\n+ 1 TestHostFactory.kt\ncom/jetbrains/rider/inTests/TestHost$Companion\n*L\n24#1:123\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use an overload with app session")
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final TestHost getInstance(@NotNull IProtocolHost protocolHost) {
            Intrinsics.checkNotNullParameter((Object)protocolHost, (String)"protocolHost");
            return this.getInstance(protocolHost.getSession());
        }

        @NotNull
        public final TestHost getInstance(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(TestHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (TestHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

