/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.inspections.callHierarchy;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiElementBase;
import com.jetbrains.rd.ide.model.RichAttributedTextModel;
import com.jetbrains.rd.ui.util.RichAttributedModelExKt;
import com.jetbrains.rider.model.RdCallHierarchyElement;
import com.jetbrains.rider.model.RdCallHierarchySession;
import com.jetbrains.rider.model.RdCallHierarchySessionNavigateArgs;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0015\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0018H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010!\u001a\u00020\u001eH\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016J\b\u0010#\u001a\u00020$H\u0016J\r\u0010%\u001a\u00070$\u00a2\u0006\u0002\b&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020\u0003H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010.\u001a\u00020\u001eH\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020-H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00062"}, d2={"Lcom/jetbrains/rider/inspections/callHierarchy/RiderCallHierarchyElement;", "Lcom/intellij/psi/impl/PsiElementBase;", "myProject", "Lcom/intellij/openapi/project/Project;", "sessionModel", "Lcom/jetbrains/rider/model/RdCallHierarchySession;", "elementModel", "Lcom/jetbrains/rider/model/RdCallHierarchyElement;", "icon", "Ljavax/swing/Icon;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/model/RdCallHierarchySession;Lcom/jetbrains/rider/model/RdCallHierarchyElement;Ljavax/swing/Icon;)V", "getSessionModel", "()Lcom/jetbrains/rider/model/RdCallHierarchySession;", "getElementModel", "()Lcom/jetbrains/rider/model/RdCallHierarchyElement;", "getIcon", "()Ljavax/swing/Icon;", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "getLanguage", "Lcom/intellij/lang/Language;", "getChildren", "", "Lcom/intellij/psi/PsiElement;", "()[Lcom/intellij/psi/PsiElement;", "getParent", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "getStartOffsetInParent", "", "getTextLength", "findElementAt", "offset", "getTextOffset", "getName", "", "getText", "Lcom/intellij/openapi/util/NlsSafe;", "textToCharArray", "", "getNode", "Lcom/intellij/lang/ASTNode;", "getProject", "isPhysical", "", "flags", "navigate", "", "requestFocus", "intellij.rider.rdclient.dotnet"})
public final class RiderCallHierarchyElement
extends PsiElementBase {
    @NotNull
    private final Project myProject;
    @NotNull
    private final RdCallHierarchySession sessionModel;
    @NotNull
    private final RdCallHierarchyElement elementModel;
    @Nullable
    private final Icon icon;

    public RiderCallHierarchyElement(@NotNull Project myProject, @NotNull RdCallHierarchySession sessionModel, @NotNull RdCallHierarchyElement elementModel, @Nullable Icon icon) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)((Object)sessionModel), (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)elementModel, (String)"elementModel");
        this.myProject = myProject;
        this.sessionModel = sessionModel;
        this.elementModel = elementModel;
        this.icon = icon;
    }

    @NotNull
    public final RdCallHierarchySession getSessionModel() {
        return this.sessionModel;
    }

    @NotNull
    public final RdCallHierarchyElement getElementModel() {
        return this.elementModel;
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiFile psiFile2;
        VirtualFile vFile;
        Path path = Paths.get(this.elementModel.getFilePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        VirtualFile virtualFile = vFile = VfsUtil.findFile((Path)path, (boolean)true);
        if (virtualFile != null) {
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)psiDocumentManager, (String)"getInstance(...)");
            psiFile2 = ExtensionsKt.getPsiFile(virtualFile, fileDocumentManager, psiDocumentManager);
        } else {
            psiFile2 = null;
        }
        return psiFile2;
    }

    @NotNull
    public Language getLanguage() {
        PsiFile psiFile2 = this.getContainingFile();
        if (psiFile2 == null || (psiFile2 = psiFile2.getLanguage()) == null) {
            Language language = Language.ANY;
            psiFile2 = language;
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"ANY");
        }
        return psiFile2;
    }

    @NotNull
    public PsiElement[] getChildren() {
        return new PsiElement[0];
    }

    @Nullable
    public PsiElement getParent() {
        return (PsiElement)this.getContainingFile();
    }

    @Nullable
    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return 0;
    }

    public int getTextLength() {
        return this.getText().length();
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return 0;
    }

    @NotNull
    public String getName() {
        return RichAttributedModelExKt.toText((RichAttributedTextModel)this.elementModel.getText());
    }

    @NotNull
    public String getText() {
        return this.getName();
    }

    @NotNull
    public char[] textToCharArray() {
        char[] cArray = this.getText().toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        return cArray;
    }

    @Nullable
    public ASTNode getNode() {
        return null;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public boolean isPhysical() {
        return false;
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.icon;
    }

    public void navigate(boolean requestFocus) {
        this.sessionModel.getNavigate().fire((Object)new RdCallHierarchySessionNavigateArgs(this.elementModel.getId(), requestFocus));
    }
}

