/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.inspections.typeHierarchy;

import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.LanguageTypeHierarchy;
import com.intellij.ide.hierarchy.actions.BrowseHierarchyActionBase;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.rd.ide.model.RdTypeHierarchyTree;
import com.jetbrains.rd.ide.model.RdTypeHierarchyTreeBuildViewArgs;
import com.jetbrains.rd.ide.model.RdTypeHierarchyTreeNavigateArgs;
import com.jetbrains.rd.ide.model.RdTypeHierarchyTreeView;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.TypeHierarchyModel;
import com.jetbrains.rd.ide.model.TypeHierarchyModel_GeneratedKt;
import com.jetbrains.rd.ide.model.TypeHierarchyViewStyle;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.inspections.typeHierarchy.elements.RiderTypeHierarchyRootElement;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000  2\u00020\u0001:\u0002 !B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u001e\u001a\u00020\u001fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/inspections/typeHierarchy/RiderTypeHierarchyHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "addHierarchySession", "", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "sessionId", "", "tree", "Lcom/jetbrains/rd/ide/model/RdTypeHierarchyTree;", "getHierarchyProvider", "Lcom/intellij/ide/hierarchy/HierarchyProvider;", "psiElement", "Lcom/intellij/psi/PsiElement;", "fireBuildView", "viewStyle", "Lcom/jetbrains/rd/ide/model/TypeHierarchyViewStyle;", "fireNavigateTo", "view", "Lcom/jetbrains/rd/ide/model/RdTypeHierarchyTreeView;", "itemIndex", "requestFocus", "", "fireRefreshSession", "fireShowOnDiagram", "closeSession", "getTypeHierarchyModel", "Lcom/jetbrains/rd/ide/model/TypeHierarchyModel;", "Companion", "Listener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderTypeHierarchyHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderTypeHierarchyHost.kt\ncom/jetbrains/rider/inspections/typeHierarchy/RiderTypeHierarchyHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,95:1\n13#2:96\n14#3:97\n*S KotlinDebug\n*F\n+ 1 RiderTypeHierarchyHost.kt\ncom/jetbrains/rider/inspections/typeHierarchy/RiderTypeHierarchyHost\n*L\n25#1:96\n25#1:97\n*E\n"})
public final class RiderTypeHierarchyHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public RiderTypeHierarchyHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    private final void addHierarchySession(Lifetime sessionLifetime, int sessionId, RdTypeHierarchyTree tree) {
        logger.debug("New type hierarchy session attached: " + sessionId);
        RiderTypeHierarchyRootElement element = new RiderTypeHierarchyRootElement(this.project, sessionLifetime, sessionId, tree);
        HierarchyProvider hierarchyProvider = this.getHierarchyProvider((PsiElement)element);
        if (hierarchyProvider != null) {
            SourceExKt.adviseOnce((ISource)((ISource)tree.getViews()), (Lifetime)sessionLifetime, arg_0 -> RiderTypeHierarchyHost.addHierarchySession$lambda$1(sessionLifetime, this, hierarchyProvider, element, arg_0));
        } else {
            logger.debug("Failed to find a hierarchy provider, terminate session " + sessionId);
            this.closeSession(sessionId);
        }
    }

    private final HierarchyProvider getHierarchyProvider(PsiElement psiElement) {
        Function1 dataContext = arg_0 -> RiderTypeHierarchyHost.getHierarchyProvider$lambda$2(psiElement, arg_0);
        return BrowseHierarchyActionBase.findBestHierarchyProvider((LanguageExtension)((LanguageExtension)LanguageTypeHierarchy.INSTANCE), (PsiElement)psiElement, arg_0 -> RiderTypeHierarchyHost.getHierarchyProvider$lambda$3(dataContext, arg_0));
    }

    public final void fireBuildView(@NotNull RdTypeHierarchyTree tree, @NotNull TypeHierarchyViewStyle viewStyle) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)viewStyle, (String)"viewStyle");
        if (tree.isBound()) {
            RdTypeHierarchyTreeBuildViewArgs args = new RdTypeHierarchyTreeBuildViewArgs(viewStyle);
            tree.getBuildView().fire((Object)args);
        }
    }

    public final void fireNavigateTo(@NotNull RdTypeHierarchyTreeView view, int itemIndex, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view.isBound()) {
            RdTypeHierarchyTreeNavigateArgs args = new RdTypeHierarchyTreeNavigateArgs(itemIndex, requestFocus);
            view.getNavigate().fire((Object)args);
        }
    }

    public final void fireRefreshSession(int sessionId) {
        RdTypeHierarchyTree session2;
        RdTypeHierarchyTree rdTypeHierarchyTree = session2 = (RdTypeHierarchyTree)TypeHierarchyModel_GeneratedKt.getTypeHierarchyModel((Solution)SolutionHostExtensionsKt.getSolution(this.project)).getSessions().get((Object)sessionId);
        boolean bl = rdTypeHierarchyTree != null ? rdTypeHierarchyTree.isBound() : false;
        if (bl) {
            session2.isRefreshing().set((Object)true);
            session2.getRefresh().fire((Object)Unit.INSTANCE);
        }
    }

    public final void fireShowOnDiagram(int sessionId) {
        TypeHierarchyModel_GeneratedKt.getTypeHierarchyModel((Solution)SolutionHostExtensionsKt.getSolution(this.project)).getShowOnDiagram().fire((Object)sessionId);
    }

    public final void closeSession(int sessionId) {
        logger.debug("Closing type hierarchy session " + sessionId);
        TypeHierarchyModel_GeneratedKt.getTypeHierarchyModel((Solution)SolutionHostExtensionsKt.getSolution(this.project)).getSessions().remove((Object)sessionId);
    }

    @TestOnly
    @NotNull
    public final TypeHierarchyModel getTypeHierarchyModel() {
        return TypeHierarchyModel_GeneratedKt.getTypeHierarchyModel((Solution)SolutionHostExtensionsKt.getSolution(this.project));
    }

    private static final boolean addHierarchySession$lambda$1$lambda$0(RiderTypeHierarchyHost this$0, HierarchyProvider $hierarchyProvider, RiderTypeHierarchyRootElement $element, boolean it) {
        if (it) {
            BrowseHierarchyActionBase.createAndAddToPanel((Project)this$0.project, (HierarchyProvider)$hierarchyProvider, (PsiElement)((PsiElement)$element));
        }
        return it;
    }

    private static final Unit addHierarchySession$lambda$1(Lifetime $sessionLifetime, RiderTypeHierarchyHost this$0, HierarchyProvider $hierarchyProvider, RiderTypeHierarchyRootElement $element, IViewableMap.Event evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Object object = evt.getNewValueOpt();
        Intrinsics.checkNotNull((Object)object);
        SourceExKt.adviseUntil((ISource)((ISource)((RdTypeHierarchyTreeView)object).isReady()), (Lifetime)$sessionLifetime, arg_0 -> RiderTypeHierarchyHost.addHierarchySession$lambda$1$lambda$0(this$0, $hierarchyProvider, $element, arg_0));
        return Unit.INSTANCE;
    }

    private static final PsiElement getHierarchyProvider$lambda$2(PsiElement $psiElement, String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Intrinsics.areEqual((Object)key, (Object)CommonDataKeys.PSI_ELEMENT.getName()) ? $psiElement : null;
    }

    private static final Object getHierarchyProvider$lambda$3(Function1 $tmp0, String p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return $tmp0.invoke((Object)p0);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderTypeHierarchyHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderTypeHierarchyHost.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/inspections/typeHierarchy/RiderTypeHierarchyHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/inspections/typeHierarchy/RiderTypeHierarchyHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderTypeHierarchyHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderTypeHierarchyHost.kt\ncom/jetbrains/rider/inspections/typeHierarchy/RiderTypeHierarchyHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,95:1\n30#2,2:96\n*S KotlinDebug\n*F\n+ 1 RiderTypeHierarchyHost.kt\ncom/jetbrains/rider/inspections/typeHierarchy/RiderTypeHierarchyHost$Companion\n*L\n26#1:96,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderTypeHierarchyHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RiderTypeHierarchyHost> serviceClass$iv = RiderTypeHierarchyHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RiderTypeHierarchyHost)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/inspections/typeHierarchy/RiderTypeHierarchyHost$Listener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/TypeHierarchyModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.rdclient.dotnet"})
    public static final class Listener
    implements SolutionExtListener<TypeHierarchyModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session2, @NotNull TypeHierarchyModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            model2.getSessions().view(lifetime, (arg_0, arg_1, arg_2) -> Listener.extensionCreated$lambda$0(session2, arg_0, arg_1, arg_2));
        }

        private static final Unit extensionCreated$lambda$0(ClientProjectSession $session, Lifetime lt, int sessionId, RdTypeHierarchyTree tree) {
            Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Companion.getInstance($session.getProject()).addHierarchySession(lt, sessionId, tree);
            return Unit.INSTANCE;
        }
    }
}

