/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.framework.MarshallersProvider;
import com.jetbrains.rd.framework.Serializers;
import com.jetbrains.rd.framework.SocketWire;
import com.jetbrains.rd.framework.util.LifetimeCoroutineUtilKt;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.SwitchingScheduler;
import com.jetbrains.rd.protocol.IdeRootMarshallersProvider;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.ExecutionOrder;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rider.protocol.DelayedServerWire;
import com.jetbrains.rider.protocol.EarlyReSharperProcess;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.util.StartUpUtilKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ,2\u00020\u0001:\u0003,-.B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\u0006\u0010\u0019\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000e\u00a2\u0006\u0002\u0010\u001bR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR-\u0010\f\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/protocol/EarlyBackendStarter;", "", "pluginsLists", "Ljava/io/File;", "extraFlagsList", "extraEnvVarsMap", "<init>", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;)V", "lifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getLifetimeDef", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "actionsToQueue", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "getActionsToQueue", "()Ljava/util/ArrayList;", "actualScheduler", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "getActualScheduler", "()Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "setActualSchedulerWithProtocolInitBlock", "T", "value", "block", "(Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "switchingScheduler", "Lcom/jetbrains/rd/platform/protocol/SwitchingScheduler;", "getSwitchingScheduler", "()Lcom/jetbrains/rd/platform/protocol/SwitchingScheduler;", "preparedWire", "Lcom/jetbrains/rider/protocol/DelayedServerWire;", "getPreparedWire", "()Lcom/jetbrains/rider/protocol/DelayedServerWire;", "preparedProcess", "Lcom/jetbrains/rider/protocol/ReSharperProcessBase;", "getPreparedProcess", "()Lcom/jetbrains/rider/protocol/ReSharperProcessBase;", "serializers", "Lcom/jetbrains/rd/framework/Serializers;", "getSerializers", "()Lcom/jetbrains/rd/framework/Serializers;", "Companion", "EbsPreparedThings", "StubScheduler", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nEarlyBackendStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EarlyBackendStarter.kt\ncom/jetbrains/rider/protocol/EarlyBackendStarter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n774#2:184\n865#2,2:185\n774#2:187\n865#2,2:188\n1193#2,2:190\n1267#2,2:192\n1270#2:195\n1869#2,2:196\n1#3:194\n*S KotlinDebug\n*F\n+ 1 EarlyBackendStarter.kt\ncom/jetbrains/rider/protocol/EarlyBackendStarter\n*L\n176#1:184\n176#1:185,2\n177#1:187\n177#1:188,2\n177#1:190,2\n177#1:192,2\n177#1:195\n130#1:196,2\n*E\n"})
public final class EarlyBackendStarter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LifetimeDefinition lifetimeDef;
    @NotNull
    private final ArrayList<Function0<Unit>> actionsToQueue;
    @NotNull
    private final SwitchingScheduler switchingScheduler;
    @NotNull
    private final DelayedServerWire preparedWire;
    @NotNull
    private final ReSharperProcessBase preparedProcess;
    @NotNull
    private final Serializers serializers;
    @NotNull
    public static final String pluginsCacheFileName = "rider_ebs_plugins.txt";
    @NotNull
    public static final String extraFlagsCacheFileName = "rider_ebs_flags.txt";
    @NotNull
    public static final String extraEnvVarsFileName = "rider_ebs_vars.txt";
    @NotNull
    public static final String startTimeKey = "StartTime";
    @NotNull
    private static final Logger logger;
    @Nullable
    private static Boolean isEbsDisabled;
    @Nullable
    private static EbsPreparedThings preparedThings;
    @NotNull
    private static final HashSet<String> nonEbsCommands;

    /*
     * WARNING - void declaration
     */
    public EarlyBackendStarter(@NotNull File pluginsLists, @NotNull File extraFlagsList, @NotNull File extraEnvVarsMap) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)pluginsLists, (String)"pluginsLists");
        Intrinsics.checkNotNullParameter((Object)extraFlagsList, (String)"extraFlagsList");
        Intrinsics.checkNotNullParameter((Object)extraEnvVarsMap, (String)"extraEnvVarsMap");
        this.lifetimeDef = new LifetimeDefinition();
        this.actionsToQueue = new ArrayList();
        this.switchingScheduler = new SwitchingScheduler((IRdDispatcher)new StubScheduler());
        this.preparedWire = new DelayedServerWire(new SocketWire.Server(this.lifetimeDef.getLifetime(), (IScheduler)this.switchingScheduler, null, "EarlyStartServerWire", false, 16, null));
        this.serializers = new Serializers((MarshallersProvider)IdeRootMarshallersProvider.Companion);
        String pluginsListsContents = FilesKt.readText$default((File)pluginsLists, null, (int)1, null);
        int firstLineEndOffset = StringsKt.indexOf$default((CharSequence)pluginsListsContents, (char)'\n', (int)0, (boolean)false, (int)6, null);
        String string = pluginsListsContents.substring(0, firstLineEndOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String dotNetExtraPaths = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string2 = pluginsListsContents.substring(firstLineEndOffset + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String dotNetPluginXml = string2;
        char[] cArray = new char[]{'\n'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)FilesKt.readText$default((File)extraFlagsList, null, (int)1, null), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List extraFlags = (List)destination$iv$iv;
        char[] $i$f$filter22 = new char[]{'\n'};
        Iterable $this$filter$iv2 = StringsKt.split$default((CharSequence)FilesKt.readText$default((File)extraEnvVarsMap, null, (int)1, null), (char[])$i$f$filter22, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl3 = ((CharSequence)it).length() > 0;
            if (!bl3) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv3;
            String line = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"="};
            List it = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean bl4 = false;
            Pair pair2 = TuplesKt.to(it.get(0), it.get(1));
            map.put(pair2.getFirst(), pair2.getSecond());
        }
        Map extraEnvVars = destination$iv$iv3;
        this.preparedProcess = new EarlyReSharperProcess(this.lifetimeDef.getLifetime(), this.preparedWire.getRealWire().getPort(), extraFlags, dotNetExtraPaths, dotNetPluginXml, extraEnvVars);
    }

    @NotNull
    public final LifetimeDefinition getLifetimeDef() {
        return this.lifetimeDef;
    }

    @NotNull
    public final ArrayList<Function0<Unit>> getActionsToQueue() {
        return this.actionsToQueue;
    }

    @NotNull
    public final IRdDispatcher getActualScheduler() {
        return this.switchingScheduler.getActualScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T setActualSchedulerWithProtocolInitBlock(@NotNull IRdDispatcher value, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ArrayList<Function0<Unit>> arrayList = this.actionsToQueue;
        synchronized (arrayList) {
            boolean bl = false;
            this.switchingScheduler.setActualScheduler(value);
            Object result2 = block.invoke();
            Iterable $this$forEach$iv = this.actionsToQueue;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Function0 it = (Function0)element$iv;
                boolean bl2 = false;
                value.queue(it);
            }
            this.actionsToQueue.clear();
            Object object = result2;
            return (T)object;
        }
    }

    @NotNull
    public final SwitchingScheduler getSwitchingScheduler() {
        return this.switchingScheduler;
    }

    @NotNull
    public final DelayedServerWire getPreparedWire() {
        return this.preparedWire;
    }

    @NotNull
    public final ReSharperProcessBase getPreparedProcess() {
        return this.preparedProcess;
    }

    @NotNull
    public final Serializers getSerializers() {
        return this.serializers;
    }

    @JvmStatic
    public static final void invoke(@NotNull String[] args) {
        Companion.invoke(args);
    }

    static {
        Logger logger = Logger.getInstance(EarlyBackendStarter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        EarlyBackendStarter.logger = logger;
        Object[] objectArray = new String[]{"cwmHostStatus", "installGatewayProtocolHandler", "jarOrder", "remoteDevShowHelp", "uninstallGatewayProtocolHandler", "update", "registerBackendLocationForGateway"};
        nonEbsCommands = SetsKt.hashSetOf((Object[])objectArray);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u001b\u0010 \u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002\u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020\rJ\u0006\u0010#\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0018\"\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u001cj\b\u0012\u0004\u0012\u00020\u0005`\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/protocol/EarlyBackendStarter$Companion;", "", "<init>", "()V", "pluginsCacheFileName", "", "extraFlagsCacheFileName", "extraEnvVarsFileName", "startTimeKey", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isEbsDisabled", "", "Ljava/lang/Boolean;", "invoke", "", "args", "", "([Ljava/lang/String;)V", "getPreparedThings", "Lcom/jetbrains/rider/protocol/EarlyBackendStarter;", "preparedThings", "Lcom/jetbrains/rider/protocol/EarlyBackendStarter$EbsPreparedThings;", "()Lcom/jetbrains/rider/protocol/EarlyBackendStarter$EbsPreparedThings;", "setPreparedThings", "(Lcom/jetbrains/rider/protocol/EarlyBackendStarter$EbsPreparedThings;)V", "nonEbsCommands", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getNonEbsCommands", "()Ljava/util/HashSet;", "shouldSkipEbs", "([Ljava/lang/String;)Z", "isDisabled", "isEnabled", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void invoke(@NotNull String[] args) {
            Long startupDelay;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (this.shouldSkipEbs(args)) {
                isEbsDisabled = true;
                return;
            }
            isEbsDisabled = false;
            String string = System.getenv("RIDER_STARTUP_DELAY_MS");
            Long l = startupDelay = string != null ? StringsKt.toLongOrNull((String)string) : null;
            if (startupDelay != null) {
                Thread.sleep(startupDelay);
            }
            this.setPreparedThings(new EbsPreparedThings());
            StartUpUtilKt.logMeasuredStartupTime(logger, EarlyBackendStarter.startTimeKey);
        }

        private final EarlyBackendStarter getPreparedThings() {
            EarlyBackendStarter earlyBackendStarter;
            String string = PathManager.getSystemPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSystemPath(...)");
            String systemPath = string;
            File cachesFolder = new File(systemPath, "caches");
            File storedPluginLists = new File(cachesFolder, EarlyBackendStarter.pluginsCacheFileName);
            File storedExtraFlagsList = new File(cachesFolder, EarlyBackendStarter.extraFlagsCacheFileName);
            File extraEnvVarsMap = new File(cachesFolder, EarlyBackendStarter.extraEnvVarsFileName);
            if (storedPluginLists.exists() && storedExtraFlagsList.exists() && extraEnvVarsMap.exists()) {
                earlyBackendStarter = new EarlyBackendStarter(storedPluginLists, storedExtraFlagsList, extraEnvVarsMap);
            } else {
                logger.info("Not starting backend early: no plugin cache, extra flags or env file");
                earlyBackendStarter = null;
            }
            return earlyBackendStarter;
        }

        @Nullable
        public final EbsPreparedThings getPreparedThings() {
            return preparedThings;
        }

        public final void setPreparedThings(@Nullable EbsPreparedThings ebsPreparedThings) {
            preparedThings = ebsPreparedThings;
        }

        @NotNull
        public final HashSet<String> getNonEbsCommands() {
            return nonEbsCommands;
        }

        private final boolean shouldSkipEbs(String[] args) {
            return !(args.length == 0) && this.getNonEbsCommands().contains(args[0]);
        }

        public final boolean isDisabled() {
            Boolean bl = isEbsDisabled;
            return bl != null ? bl : false;
        }

        public final boolean isEnabled() {
            return Intrinsics.areEqual((Object)isEbsDisabled, (Object)false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/protocol/EarlyBackendStarter$EbsPreparedThings;", "", "<init>", "()V", "isStarted", "Ljava/util/concurrent/atomic/AtomicBoolean;", "future", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/rider/protocol/EarlyBackendStarter;", "completeFuture", "", "getValue", "intellij.rider.rdclient.dotnet"})
    public static final class EbsPreparedThings {
        @NotNull
        private final AtomicBoolean isStarted = new AtomicBoolean(false);
        @NotNull
        private final CompletableFuture<EarlyBackendStarter> future = new CompletableFuture();

        public EbsPreparedThings() {
            LifetimeCoroutineUtilKt.launch$default((Lifetime)Lifetime.Companion.getEternal(), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ EbsPreparedThings this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.this$0.completeFuture();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        private final boolean completeFuture() {
            if (this.isStarted.compareAndSet(false, true)) {
                try {
                    this.future.complete(Companion.getPreparedThings());
                }
                catch (Throwable e) {
                    this.future.completeExceptionally(e);
                }
                return true;
            }
            return false;
        }

        @Nullable
        public final EarlyBackendStarter getValue() {
            this.completeFuture();
            return this.future.get();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0016H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0018\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/protocol/EarlyBackendStarter$StubScheduler;", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "<init>", "(Lcom/jetbrains/rider/protocol/EarlyBackendStarter;)V", "noSchedulerSet", "", "backgroundScheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "getBackgroundScheduler", "()Lcom/jetbrains/rd/util/reactive/IScheduler;", "executionOrder", "Lcom/jetbrains/rd/util/reactive/ExecutionOrder;", "getExecutionOrder", "()Lcom/jetbrains/rd/util/reactive/ExecutionOrder;", "suppressPumping", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "repost", "allowBackgroundThreadAndSuppressPumping", "allowAllBackgroundThreadsAndSuppressPumping", "pumpProtocolQueue", "condition", "Lkotlin/Function0;", "", "isActive", "()Z", "flush", "queue", "", "action", "intellij.rider.rdclient.dotnet"})
    private final class StubScheduler
    implements IRdDispatcher {
        private final Void noSchedulerSet() {
            throw new IllegalStateException("No actual scheduler was set for the early start scheduler proxy".toString());
        }

        @NotNull
        public IScheduler getBackgroundScheduler() {
            this.noSchedulerSet();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public ExecutionOrder getExecutionOrder() {
            return ExecutionOrder.Sequential;
        }

        @NotNull
        public Void suppressPumping(@NotNull Lifetime lifetime) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.noSchedulerSet();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void repost() {
            this.noSchedulerSet();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void allowBackgroundThreadAndSuppressPumping(@NotNull Lifetime lifetime) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.noSchedulerSet();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void allowAllBackgroundThreadsAndSuppressPumping(@NotNull Lifetime lifetime) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.noSchedulerSet();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void pumpProtocolQueue(@NotNull Function0<Boolean> condition) {
            Intrinsics.checkNotNullParameter(condition, (String)"condition");
            this.noSchedulerSet();
            throw new KotlinNothingValueException();
        }

        public boolean isActive() {
            this.noSchedulerSet();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void flush() {
            this.noSchedulerSet();
            throw new KotlinNothingValueException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queue(@NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            ArrayList<Function0<Unit>> arrayList = EarlyBackendStarter.this.getActionsToQueue();
            EarlyBackendStarter earlyBackendStarter = EarlyBackendStarter.this;
            ArrayList<Function0<Unit>> arrayList2 = arrayList;
            synchronized (arrayList2) {
                Object object;
                boolean bl = false;
                if (earlyBackendStarter.getActualScheduler() != this) {
                    earlyBackendStarter.getActualScheduler().queue(action2);
                    object = Unit.INSTANCE;
                } else {
                    object = earlyBackendStarter.getActionsToQueue().add(action2);
                }
                Object object2 = object;
            }
        }

        public void assertThread(@Nullable Object debugInfo) {
            IRdDispatcher.DefaultImpls.assertThread((IRdDispatcher)this, (Object)debugInfo);
        }

        public void invokeOrQueue(@NotNull Function0<Unit> action2) {
            IRdDispatcher.DefaultImpls.invokeOrQueue((IRdDispatcher)this, action2);
        }
    }
}

