/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.system.CpuArch;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/protocol/RuntimeSpecificAssemblyResolver;", "", "<init>", "()V", "getCompatScore", "", "tfm", "", "currentArch", "currentPlatformRid", "getCurrentPlatformRid", "()Ljava/lang/String;", "platformCorrespondsToCurrent", "", "platform", "architectureCorrespondsToCurrent", "arch", "ridConsumableByCurrentPlatform", "rid", "enumerateRuntimeSpecificAssemblies", "", "Ljava/nio/file/Path;", "runtimesDir", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRuntimeSpecificAssemblyResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeSpecificAssemblyResolver.kt\ncom/jetbrains/rider/protocol/RuntimeSpecificAssemblyResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n774#2:79\n865#2,2:80\n774#2:82\n865#2,2:83\n1068#2:85\n774#2:86\n865#2,2:87\n*S KotlinDebug\n*F\n+ 1 RuntimeSpecificAssemblyResolver.kt\ncom/jetbrains/rider/protocol/RuntimeSpecificAssemblyResolver\n*L\n66#1:79\n66#1:80,2\n72#1:82\n72#1:83,2\n72#1:85\n73#1:86\n73#1:87,2\n*E\n"})
public final class RuntimeSpecificAssemblyResolver {
    @NotNull
    public static final RuntimeSpecificAssemblyResolver INSTANCE = new RuntimeSpecificAssemblyResolver();
    @NotNull
    private static final String currentArch;

    private RuntimeSpecificAssemblyResolver() {
    }

    private final double getCompatScore(String tfm) {
        return StringsKt.startsWith$default((String)tfm, (String)"net4", (boolean)false, (int)2, null) ? 70.0 + Double.parseDouble(StringsKt.substringAfter$default((String)tfm, (String)"net", null, (int)2, null)) : (StringsKt.startsWith$default((String)tfm, (String)"netcoreapp", (boolean)false, (int)2, null) ? 90.0 + Double.parseDouble(StringsKt.substringAfter$default((String)tfm, (String)"netcoreapp", null, (int)2, null)) : (StringsKt.startsWith$default((String)tfm, (String)"netstandard", (boolean)false, (int)2, null) ? 80.0 + Double.parseDouble(StringsKt.substringAfter$default((String)tfm, (String)"netstandard", null, (int)2, null)) : (StringsKt.startsWith$default((String)tfm, (String)"net", (boolean)false, (int)2, null) ? 100.0 + Double.parseDouble(StringsKt.substringAfter$default((String)tfm, (String)"net", null, (int)2, null)) : 0.0)));
    }

    @NotNull
    public final String getCurrentPlatformRid() {
        String string;
        if (SystemInfo.isLinux) {
            string = "linux";
        } else if (SystemInfo.isMac) {
            string = "osx";
        } else if (SystemInfo.isWindows) {
            string = "win";
        } else {
            throw new IllegalStateException(("Unknown platform: " + SystemInfoRt.OS_NAME).toString());
        }
        String platform = string;
        return platform + "-" + currentArch;
    }

    private final boolean platformCorrespondsToCurrent(String platform) {
        String string = platform.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return switch (string) {
            case "any" -> true;
            case "linux" -> SystemInfo.isLinux;
            case "osx" -> SystemInfo.isMac;
            case "unix" -> SystemInfo.isUnix;
            case "win" -> SystemInfo.isWindows;
            default -> false;
        };
    }

    private final boolean architectureCorrespondsToCurrent(String arch) {
        return Intrinsics.areEqual((Object)arch, (Object)currentArch);
    }

    private final boolean ridConsumableByCurrentPlatform(String rid) {
        if (!StringsKt.contains$default((CharSequence)rid, (char)'-', (boolean)false, (int)2, null)) {
            return this.platformCorrespondsToCurrent(rid);
        }
        char[] cArray = new char[]{'-'};
        List components = StringsKt.split$default((CharSequence)rid, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (components.size() != 2) {
            return false;
        }
        Object e = components.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        String platform = (String)e;
        Object e2 = components.get(1);
        Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
        String architecture = (String)e2;
        return this.platformCorrespondsToCurrent(platform) && this.architectureCorrespondsToCurrent(architecture);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> enumerateRuntimeSpecificAssemblies(@NotNull Path runtimesDir) {
        Iterable<Path> it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)runtimesDir, (String)"runtimesDir");
        List result2 = new ArrayList();
        Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)runtimesDir, null, (int)1, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Path)element$iv$iv;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!(Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && INSTANCE.ridConsumableByCurrentPlatform(PathsKt.getName((Path)it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ridDirs = (List)destination$iv$iv;
        for (Path ridDir : ridDirs) {
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            Path tfmDir;
            void $this$filterTo$iv$iv3;
            Path libDir = ridDir.resolve("lib");
            Intrinsics.checkNotNull((Object)libDir);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(libDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            Iterable $this$filter$iv3 = PathsKt.listDirectoryEntries$default((Path)libDir, null, (int)1, null);
            boolean $i$f$filter2 = false;
            it = $this$filter$iv3;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                Path it2 = (Path)element$iv$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isDirectory(it2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$sortedByDescending$iv = (List)destination$iv$iv2;
            boolean $i$f$sortedByDescending22 = false;
            if ((Path)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Path it = (Path)b;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(RuntimeSpecificAssemblyResolver.access$getCompatScore(RuntimeSpecificAssemblyResolver.INSTANCE, PathsKt.getName((Path)it)));
                    it = (Path)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(RuntimeSpecificAssemblyResolver.access$getCompatScore(RuntimeSpecificAssemblyResolver.INSTANCE, PathsKt.getName((Path)it))));
                }
            })) == null) continue;
            Iterable $i$f$filterTo3 = PathsKt.listDirectoryEntries$default((Path)tfmDir, null, (int)1, null);
            List list = result2;
            boolean $i$f$filter3 = false;
            void $i$f$sortedByDescending22 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo4 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Path it3 = (Path)element$iv$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                if (!(Files.isRegularFile(it3, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) && StringsKt.equals((String)PathsKt.getExtension((Path)it3), (String)"dll", (boolean)true))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            list.addAll((List)destination$iv$iv3);
        }
        return result2;
    }

    public static final /* synthetic */ double access$getCompatScore(RuntimeSpecificAssemblyResolver $this, String tfm) {
        return $this.getCompatScore(tfm);
    }

    static {
        CpuArch cpuArch = CpuArch.CURRENT;
        currentArch = switch (cpuArch == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cpuArch.ordinal()]) {
            case 1 -> "arm";
            case 2 -> "arm64";
            case 3 -> "x86";
            case 4 -> "x64";
            default -> throw new IllegalStateException(("Unknown CPU architecture: " + CpuArch.CURRENT).toString());
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.ARM32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86_64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

