/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol.components;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdSolutionCloseOptions;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.SolutionModel;
import com.jetbrains.rd.ide.model.SolutionModel_GeneratedKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/protocol/components/SolutionHost;", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "getProtocol", "()Lcom/jetbrains/rd/framework/IProtocol;", "model", "Lcom/jetbrains/rd/ide/model/SolutionModel;", "getModel", "()Lcom/jetbrains/rd/ide/model/SolutionModel;", "set", "", "solution", "Lcom/jetbrains/rd/ide/model/Solution;", "remove", "assertReadyForSolution", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nSolutionHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionHost.kt\ncom/jetbrains/rider/protocol/components/SolutionHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,48:1\n13#2:49\n14#3:50\n*S KotlinDebug\n*F\n+ 1 SolutionHost.kt\ncom/jetbrains/rider/protocol/components/SolutionHost\n*L\n14#1:49\n14#1:50\n*E\n"})
public final class SolutionHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final AtomicInteger idFactory;

    public SolutionHost(@NotNull ClientAppSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    private final IProtocol getProtocol() {
        return FrontendSessionsUtilKt.getProtocol((ClientAppSession)this.session);
    }

    private final SolutionModel getModel() {
        return SolutionModel_GeneratedKt.getSolutionModel((IProtocol)this.getProtocol());
    }

    public final void set(@NotNull Solution solution) {
        Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
        int id = idFactory.incrementAndGet();
        logger.info("Putting protocol solution...");
        ((Map)this.getModel().getSolutions()).put(id, solution);
    }

    public final void remove(@NotNull Solution solution) {
        Intrinsics.checkNotNullParameter((Object)solution, (String)"solution");
        logger.info("Sending 'close' signal...");
        RdSolutionCloseOptions options = new RdSolutionCloseOptions(false);
        solution.getClose().fire((Object)options);
        DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel((IProtocol)this.getProtocol()).getDocuments().clear();
        logger.info("Clearing protocol solution...");
        this.getModel().getSolutions().clear();
    }

    public final void assertReadyForSolution() {
        Collection solutions = this.getModel().getSolutions().values();
        if (!solutions.isEmpty()) {
            Object object = (Solution)CollectionsKt.firstOrNull((Iterable)solutions);
            if (object == null || (object = SolutionHostExtensionsKt.getPath(object)) == null) {
                object = "EMPTY PATH";
            }
            Object existingSolution = object;
            throw new UnsupportedOperationException("Opening new solution before closing an old one. Current solution: " + (String)existingSolution);
        }
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SolutionHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SolutionHost.logger = logger;
        idFactory = new AtomicInteger(0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/protocol/components/SolutionHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "idFactory", "Ljava/util/concurrent/atomic/AtomicInteger;", "getInstance", "Lcom/jetbrains/rider/protocol/components/SolutionHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nSolutionHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionHost.kt\ncom/jetbrains/rider/protocol/components/SolutionHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,48:1\n30#2,2:49\n*S KotlinDebug\n*F\n+ 1 SolutionHost.kt\ncom/jetbrains/rider/protocol/components/SolutionHost$Companion\n*L\n17#1:49,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SolutionHost getInstance(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session2;
            boolean $i$f$service = false;
            Class<SolutionHost> serviceClass$iv = SolutionHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SolutionHost)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

