/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services;

import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rider.model.messageBox.MessageBoxModel;
import com.jetbrains.rider.model.messageBox.RdMessageBoxIconType;
import com.jetbrains.rider.model.messageBox.RdMessageBoxModel;
import com.jetbrains.rider.model.messageBox.RdMessageBoxResponse;
import com.jetbrains.rider.model.messageBox.RdMessageBoxType;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"handleEvents", "", "Lcom/jetbrains/rider/model/messageBox/MessageBoxModel;", "handleMessageBox", "Lcom/jetbrains/rider/model/messageBox/RdMessageBoxResponse;", "messageBoxModel", "Lcom/jetbrains/rider/model/messageBox/RdMessageBoxModel;", "handleYesNo", "handleYesNoCancel", "handleOkCancel", "handleOk", "getIcon", "Ljavax/swing/Icon;", "iconType", "Lcom/jetbrains/rider/model/messageBox/RdMessageBoxIconType;", "intellij.rider.rdclient.dotnet"})
public final class RiderMessageBoxHostKt {
    public static final void handleEvents(@NotNull MessageBoxModel $this$handleEvents) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$handleEvents), (String)"<this>");
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)$this$handleEvents.getMessageBox()), null, null, RiderMessageBoxHostKt::handleEvents$lambda$0, (int)3, null);
    }

    private static final RdMessageBoxResponse handleMessageBox(RdMessageBoxModel messageBoxModel) {
        return switch (WhenMappings.$EnumSwitchMapping$0[messageBoxModel.getType().ordinal()]) {
            case 1 -> RiderMessageBoxHostKt.handleOk(messageBoxModel);
            case 2 -> RiderMessageBoxHostKt.handleOkCancel(messageBoxModel);
            case 3 -> RiderMessageBoxHostKt.handleYesNo(messageBoxModel);
            case 4 -> RiderMessageBoxHostKt.handleYesNoCancel(messageBoxModel);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final RdMessageBoxResponse handleYesNo(RdMessageBoxModel messageBoxModel) {
        return MessageDialogBuilder.Companion.yesNo(messageBoxModel.getCaption(), messageBoxModel.getMessage(), RiderMessageBoxHostKt.getIcon(messageBoxModel.getIconType())).guessWindowAndAsk() ? RdMessageBoxResponse.YES : RdMessageBoxResponse.NO;
    }

    private static final RdMessageBoxResponse handleYesNoCancel(RdMessageBoxModel messageBoxModel) {
        int result2 = Messages.showYesNoCancelDialog((String)messageBoxModel.getMessage(), (String)messageBoxModel.getCaption(), (Icon)RiderMessageBoxHostKt.getIcon(messageBoxModel.getIconType()));
        if (result2 == 0) {
            return RdMessageBoxResponse.YES;
        }
        if (result2 == 1) {
            return RdMessageBoxResponse.NO;
        }
        if (result2 == 2) {
            return RdMessageBoxResponse.CANCEL;
        }
        throw new UnsupportedOperationException("Unknown response type");
    }

    private static final RdMessageBoxResponse handleOkCancel(RdMessageBoxModel messageBoxModel) {
        return MessageDialogBuilder.Companion.okCancel(messageBoxModel.getCaption(), messageBoxModel.getMessage()).guessWindowAndAsk() ? RdMessageBoxResponse.OK : RdMessageBoxResponse.CANCEL;
    }

    private static final RdMessageBoxResponse handleOk(RdMessageBoxModel messageBoxModel) {
        Messages.showMessageDialog((String)messageBoxModel.getMessage(), (String)messageBoxModel.getCaption(), (Icon)RiderMessageBoxHostKt.getIcon(messageBoxModel.getIconType()));
        return RdMessageBoxResponse.OK;
    }

    private static final Icon getIcon(RdMessageBoxIconType iconType) {
        Icon icon;
        switch (WhenMappings.$EnumSwitchMapping$1[iconType.ordinal()]) {
            case 1: {
                Icon icon2 = UIUtil.getErrorIcon();
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getErrorIcon(...)");
                break;
            }
            case 2: {
                Icon icon3 = UIUtil.getWarningIcon();
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"getWarningIcon(...)");
                break;
            }
            case 3: {
                Icon icon4 = UIUtil.getInformationIcon();
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"getInformationIcon(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return icon;
    }

    private static final RdMessageBoxResponse handleEvents$lambda$0(RdMessageBoxModel messageBoxModel) {
        Intrinsics.checkNotNullParameter((Object)messageBoxModel, (String)"messageBoxModel");
        return RiderMessageBoxHostKt.handleMessageBox(messageBoxModel);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RdMessageBoxType.values().length];
            try {
                nArray[RdMessageBoxType.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdMessageBoxType.OKCANCEL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdMessageBoxType.YESNO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdMessageBoxType.YESNOCANCEL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RdMessageBoxIconType.values().length];
            try {
                nArray[RdMessageBoxIconType.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdMessageBoxIconType.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdMessageBoxIconType.Info.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

