/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.layouter;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.AdditionalApiKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.services.popups.nova.layouter.AnchoringRect;
import com.jetbrains.rider.services.popups.nova.layouter.RectangleUtilsKt;
import com.jetbrains.rider.ui.SwingScheduler;
import com.jetbrains.rider.ui.components.utils.RdSwingKt;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.time.Duration;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/EditorAnchoringRect;", "Lcom/jetbrains/rider/services/popups/nova/layouter/AnchoringRect;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "documentOffset", "", "delegate", "Lkotlin/Function1;", "Ljava/awt/Rectangle;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Editor;ILkotlin/jvm/functions/Function1;)V", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "rectangle", "Lcom/jetbrains/rd/util/reactive/IProperty;", "getRectangle", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "calculateRectangle", "Companion", "intellij.rider.rdclient.dotnet"})
public final class EditorAnchoringRect
implements AnchoringRect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    private final int documentOffset;
    @NotNull
    private final Function1<Rectangle, Rectangle> delegate;
    @NotNull
    private final RangeMarker rangeMarker;
    @NotNull
    private final IProperty<Rectangle> rectangle;

    public EditorAnchoringRect(@NotNull Lifetime lifetime, @NotNull Editor editor, int documentOffset, @NotNull Function1<? super Rectangle, ? extends Rectangle> delegate) {
        EditorImpl outerLifetime;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.editor = editor;
        this.documentOffset = documentOffset;
        this.delegate = delegate;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        RangeMarker rangeMarker = document2.createRangeMarker(this.documentOffset, this.documentOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        this.rangeMarker = rangeMarker;
        this.rectangle = (IProperty)new Property((Object)this.calculateRectangle());
        ScrollingModel scrollingModel = this.editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"getScrollingModel(...)");
        ISource<VisibleAreaEvent> visibleAreaChanged2 = RdSwingKt.visibleAreaChanged(scrollingModel);
        Editor editor2 = this.editor;
        Object object = editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
        if (object == null || (object = object.getDisposable()) == null || (object = LifetimeDisposableExKt.createLifetime((Disposable)object)) == null) {
            Project project = this.editor.getProject();
            object = project != null ? ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)project)) : null;
        }
        Lifetime lt = (outerLifetime = object) != null ? RLifetimeKt.intersect((Lifetime)lifetime, (Lifetime)outerLifetime) : lifetime;
        Duration duration = Duration.ofMillis(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        AdditionalApiKt.throttleLast(visibleAreaChanged2, (Duration)duration, (IScheduler)SwingScheduler.INSTANCE).advise(lt, arg_0 -> EditorAnchoringRect._init_$lambda$1(this, arg_0));
    }

    public /* synthetic */ EditorAnchoringRect(Lifetime lifetime, Editor editor, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            function1 = EditorAnchoringRect::_init_$lambda$0;
        }
        this(lifetime, editor, n, (Function1<? super Rectangle, ? extends Rectangle>)function1);
    }

    @NotNull
    public IProperty<Rectangle> getRectangle() {
        return this.rectangle;
    }

    private final Rectangle calculateRectangle() {
        Rectangle rectangle;
        Point point;
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!(!this.editor.isDisposed())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!this.rangeMarker.isValid()) {
            return null;
        }
        TextRange textRange = this.rangeMarker.getTextRange();
        Intrinsics.checkNotNull((Object)textRange);
        TextRange range = textRange;
        if (range.isEmpty()) {
            Point point2 = this.editor.offsetToXY(range.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"offsetToXY(...)");
            point = point2;
            rectangle = new Rectangle(point, new Dimension(JBUI.scale((int)1), this.editor.getLineHeight() + JBUI.scale((int)1)));
        } else {
            Point point3 = this.editor.offsetToXY(range.getStartOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"offsetToXY(...)");
            Point start2 = point3;
            Point point4 = this.editor.offsetToXY(range.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)point4, (String)"offsetToXY(...)");
            Point end = point4;
            rectangle = RectangleUtilsKt.rectangleFromLTRBNonNegative(start2.x, start2.y - this.editor.getLineHeight(), end.x, end.y);
        }
        Rectangle rect = rectangle;
        Rectangle rectangle2 = RectangleUtilsKt.map(rect, (Function1<? super Rectangle, ? extends Rectangle>)((Function1)arg_0 -> EditorAnchoringRect.calculateRectangle$lambda$2(this, arg_0)));
        if (rectangle2 == null) {
            return null;
        }
        rect = rectangle2;
        point = rect.getLocation();
        SwingUtilities.convertPointToScreen(point, this.editor.getContentComponent());
        return new Rectangle(point, new Dimension(rect.width, rect.height));
    }

    private static final Rectangle _init_$lambda$0(Rectangle it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final Unit _init_$lambda$1(EditorAnchoringRect this$0, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Property)this$0.getRectangle()).set((Object)this$0.calculateRectangle());
        return Unit.INSTANCE;
    }

    private static final Rectangle calculateRectangle$lambda$2(EditorAnchoringRect this$0, Rectangle it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RectangleUtilsKt.map(it, this$0.delegate);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ6\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0016\b\u0002\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/services/popups/nova/layouter/EditorAnchoringRect$Companion;", "", "<init>", "()V", "horizontalSmartClipDelegate", "Lkotlin/Function1;", "Ljava/awt/Rectangle;", "editor", "Lcom/intellij/openapi/editor/Editor;", "smartClipDelegate", "create", "Lcom/jetbrains/rider/services/popups/nova/layouter/EditorAnchoringRect;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "offset", "", "delegate", "createSmartClipRect", "Lcom/jetbrains/rider/services/popups/nova/layouter/AnchoringRect;", "createHorizontalSmartClipRect", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<Rectangle, Rectangle> horizontalSmartClipDelegate(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return arg_0 -> Companion.horizontalSmartClipDelegate$lambda$0(editor, arg_0);
        }

        @NotNull
        public final Function1<Rectangle, Rectangle> smartClipDelegate(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return arg_0 -> Companion.smartClipDelegate$lambda$1(editor, arg_0);
        }

        @NotNull
        public final EditorAnchoringRect create(@NotNull Lifetime lifetime, int offset, @NotNull Editor editor, @NotNull Function1<? super Rectangle, ? extends Rectangle> delegate) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            return new EditorAnchoringRect(lifetime, editor, offset, delegate);
        }

        public static /* synthetic */ EditorAnchoringRect create$default(Companion companion, Lifetime lifetime, int n, Editor editor, Function1 function1, int n2, Object object) {
            if ((n2 & 8) != 0) {
                function1 = Companion::create$lambda$2;
            }
            return companion.create(lifetime, n, editor, (Function1<? super Rectangle, ? extends Rectangle>)function1);
        }

        @NotNull
        public final AnchoringRect createSmartClipRect(@NotNull Lifetime lifetime, int offset, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return this.create(lifetime, offset, editor, this.smartClipDelegate(editor));
        }

        @NotNull
        public final AnchoringRect createHorizontalSmartClipRect(@NotNull Lifetime lifetime, int offset, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return this.create(lifetime, offset, editor, this.horizontalSmartClipDelegate(editor));
        }

        private static final Rectangle horizontalSmartClipDelegate$lambda$0(Editor $editor, Rectangle it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Rectangle rectangle = $editor.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            return visibleArea.y >= it.y + $editor.getLineHeight() || visibleArea.y + visibleArea.height <= it.y - $editor.getLineHeight() / 2 ? null : RectangleUtilsKt.horizontalSmartClip(it, visibleArea);
        }

        private static final Rectangle smartClipDelegate$lambda$1(Editor $editor, Rectangle it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Rectangle rectangle = $editor.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            return RectangleUtilsKt.smartClip(it, visibleArea);
        }

        private static final Rectangle create$lambda$2(Rectangle it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

