/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.popups.ProtoViewModel;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.KeyPathComponents;
import com.jetbrains.rd.ide.model.PredefinedValue;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.ui.bindable.ViewRegistry;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import com.jetbrains.rider.model.BeSimpleOptionsPageContent;
import com.jetbrains.rider.model.CodeStylePageContent;
import com.jetbrains.rider.model.NamingPageContentBase;
import com.jetbrains.rider.model.OptionsDialog;
import com.jetbrains.rider.model.OptionsPageContentBase;
import com.jetbrains.rider.model.OptionsPageInfo;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.settings.IRiderViewModelConfigurableKt;
import com.jetbrains.rider.settings.OptionsUtilsHost;
import com.jetbrains.rider.settings.RiderCodeStyleContentPageConverter;
import com.jetbrains.rider.settings.RiderCodeStyleSettings;
import com.jetbrains.rider.settings.RiderCustomCodeStyleSettings;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import com.jetbrains.rider.settings.codeStyle.RiderCodeStyleTabPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0014J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0012\u001a\u0015\u0012\u0004\u0012\u00020\u0014\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u0015\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/settings/RiderCodeStyleMainPanel;", "Lcom/intellij/application/options/TabbedLanguageCodeStylePanel;", "language", "Lcom/intellij/lang/Language;", "currentSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "settings", "<init>", "(Lcom/intellij/lang/Language;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "mySettings", "", "Lcom/jetbrains/rd/ide/model/KeyPathComponents;", "Lcom/jetbrains/rd/ide/model/PredefinedValue;", "mySchemeRefresher", "Lkotlin/Function0;", "", "myTabsLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "myPages", "", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "dispose", "initTabs", "resetImpl", "apply", "isModified", "", "initSchemeSupport", "host", "Lcom/jetbrains/rider/settings/SettingsViewModelHost;", "updateProtocolStorage", "lifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "addAutodetectButton", "Ljavax/swing/JPanel;", "content", "Lcom/jetbrains/rider/model/CodeStylePageContent;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderCodeStyleMainPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCodeStyleMainPanel.kt\ncom/jetbrains/rider/settings/RiderCodeStyleMainPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,321:1\n1#2:322\n68#3,4:323\n68#3,4:328\n14#3:340\n216#4:327\n217#4:332\n1869#5,2:333\n1869#5,2:335\n1869#5,2:337\n13#6:339\n*S KotlinDebug\n*F\n+ 1 RiderCodeStyleMainPanel.kt\ncom/jetbrains/rider/settings/RiderCodeStyleMainPanel\n*L\n97#1:323,4\n133#1:328,4\n73#1:340\n102#1:327\n102#1:332\n191#1:333,2\n214#1:335,2\n251#1:337,2\n73#1:339\n*E\n"})
public final class RiderCodeStyleMainPanel
extends TabbedLanguageCodeStylePanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<KeyPathComponents, PredefinedValue> mySettings;
    @Nullable
    private Function0<Unit> mySchemeRefresher;
    @Nullable
    private LifetimeDefinition myTabsLifetime;
    @Nullable
    private Map<String, String> myPages;
    @NotNull
    private static final Logger LOG;

    public RiderCodeStyleMainPanel(@Nullable Language language, @NotNull CodeStyleSettings currentSettings, @NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)currentSettings, (String)"currentSettings");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(language, currentSettings, settings);
        this.mySettings = new LinkedHashMap();
    }

    public void dispose() {
        LifetimeDefinition lifetimeDefinition = this.myTabsLifetime;
        if (lifetimeDefinition != null) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
        super.dispose();
    }

    protected void initTabs(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        LOG.trace("RiderCodeStyleMainPanel::initTabs");
        PermittedModalitiesImpl permittedModalitiesImpl = IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null);
        JComponent jComponent = this.getPanel();
        Intrinsics.checkNotNull((Object)jComponent);
        permittedModalitiesImpl.allowPumpProtocolForComponent((Component)jComponent, (Disposable)this);
        SettingsViewModelHost host = SettingsViewModelHost.Companion.getCurrentInstance();
        if (host != null) {
            boolean bl;
            boolean bl2 = bl = this.myTabsLifetime == null;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-RiderCodeStyleMainPanel$initTabs$22 = false;
                String $i$a$-assert-RiderCodeStyleMainPanel$initTabs$22 = "myTabsLifetime is not null";
                throw new AssertionError((Object)$i$a$-assert-RiderCodeStyleMainPanel$initTabs$22);
            }
            this.myTabsLifetime = host.getCurrentDialogLifetime().createNested();
            this.myPages = settings instanceof RiderCodeStyleSettings ? ((RiderCodeStyleSettings)settings).getPages() : ((RiderCustomCodeStyleSettings)settings.getCustomSettings(RiderCustomCodeStyleSettings.class)).getPages();
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl3 = false;
                Map<String, String> map = this.myPages;
                logger.trace("Preparing to initialize " + (map != null ? Integer.valueOf(map.size()) : null) + " pages for the Code Style settings page.");
            }
            this.mySchemeRefresher = this.initSchemeSupport(host);
            Ref.BooleanRef autodetectButtonAdded = new Ref.BooleanRef();
            Map<String, String> map = this.myPages;
            Intrinsics.checkNotNull(map);
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> it = element$iv = iterator.next();
                boolean bl4 = false;
                Language language = this.getDefaultLanguage();
                FileType fileType = UnknownFileType.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"INSTANCE");
                LifetimeDefinition lifetimeDefinition = this.myTabsLifetime;
                Intrinsics.checkNotNull((Object)lifetimeDefinition);
                RiderCodeStyleTabPanel myCodeStyleAbstractPanel = new RiderCodeStyleTabPanel(language, fileType, it.getValue(), (Lifetime)lifetimeDefinition, settings);
                host.requestFullPage(it.getKey(), (Function1<? super OptionsPageInfo, Unit>)((Function1)arg_0 -> RiderCodeStyleMainPanel.initTabs$lambda$4$lambda$2(myCodeStyleAbstractPanel, autodetectButtonAdded, this, arg_0)));
                Logger $this$trace$iv2 = LOG;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    Logger logger = $this$trace$iv2;
                    boolean bl5 = false;
                    logger.trace("Adding a tab " + myCodeStyleAbstractPanel + " (" + it.getKey() + ", " + it.getValue() + ") to " + this + ".");
                }
                this.addTab(myCodeStyleAbstractPanel);
            }
            for (CodeStyleSettingsProvider provider : (CodeStyleSettingsProvider[])Extensions.getExtensions((ExtensionPointName)CodeStyleSettingsProvider.EXTENSION_POINT_NAME)) {
                if (!Intrinsics.areEqual((Object)provider.getLanguage(), (Object)this.getDefaultLanguage()) || provider.hasSettingsPage()) continue;
                this.createTab(provider);
            }
        } else if (ApplicationKt.getApplication().isHeadlessEnvironment()) {
            CodeStyleSettings codeStyleSettings = this.getCurrentSettings();
            this.addTab(new CodeStyleAbstractPanel(codeStyleSettings){

                protected void resetImpl(CodeStyleSettings settings) {
                    Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                }

                protected String getPreviewText() {
                    return "";
                }

                public boolean isModified(CodeStyleSettings settings) {
                    return false;
                }

                public JComponent getPanel() {
                    return new JPanel();
                }

                protected int getRightMargin() {
                    return 0;
                }

                public void apply(CodeStyleSettings settings) {
                    Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                }

                protected FileType getFileType() {
                    Language language = this.getDefaultLanguage();
                    Object object = language != null ? language.getAssociatedFileType() : null;
                    Intrinsics.checkNotNull((Object)object);
                    return (FileType)object;
                }

                protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
                    Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
                    return (EditorHighlighter)new EmptyEditorHighlighter(TextAttributes.ERASE_MARKER);
                }
            });
        }
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        SettingsViewModelHost host;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (OptionsUtilsHost.Companion.getAllowSchemeSupport()) {
            this.mySettings.clear();
            this.mySettings.putAll(((RiderCustomCodeStyleSettings)settings.getCustomSettings(RiderCustomCodeStyleSettings.class)).getData());
            Function0<Unit> refresher = this.mySchemeRefresher;
            if (refresher != null) {
                refresher.invoke();
            }
        }
        if ((host = SettingsViewModelHost.Companion.getCurrentInstance()) != null && this.myPages != null) {
            Map<String, String> map = this.myPages;
            Intrinsics.checkNotNull(map);
            Iterable $this$forEach$iv = map.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                host.requestPage(it, (Function1<? super OptionsPageContentBase, Unit>)((Function1)RiderCodeStyleMainPanel::resetImpl$lambda$6$lambda$5));
            }
        }
        super.resetImpl(settings);
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        if (OptionsUtilsHost.Companion.getAllowSchemeSupport()) {
            Map<KeyPathComponents, PredefinedValue> data2 = ((RiderCustomCodeStyleSettings)settings.getCustomSettings(RiderCustomCodeStyleSettings.class)).getData();
            data2.clear();
            data2.putAll(this.mySettings);
        }
        super.apply(settings);
    }

    public boolean isModified(@Nullable CodeStyleSettings settings) {
        if (settings != null && OptionsUtilsHost.Companion.getAllowSchemeSupport()) {
            Map<KeyPathComponents, PredefinedValue> data2 = ((RiderCustomCodeStyleSettings)settings.getCustomSettings(RiderCustomCodeStyleSettings.class)).getData();
            Iterable $this$forEach$iv = this.mySettings.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KeyPathComponents it = (KeyPathComponents)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)data2.get(it), (Object)this.mySettings.get(it))) continue;
                return true;
            }
        }
        return super.isModified(settings);
    }

    private final Function0<Unit> initSchemeSupport(SettingsViewModelHost host) {
        if (!OptionsUtilsHost.Companion.getAllowSchemeSupport()) {
            return RiderCodeStyleMainPanel::initSchemeSupport$lambda$8;
        }
        SequentialLifetimes lifetimes = new SequentialLifetimes(host.getLifetimeDef().getLifetime());
        Function0 schemeRefresher = () -> RiderCodeStyleMainPanel.initSchemeSupport$lambda$9(this, lifetimes, host);
        JComponent jComponent = this.getPanel();
        Intrinsics.checkNotNull((Object)jComponent);
        jComponent.addHierarchyListener(arg_0 -> RiderCodeStyleMainPanel.initSchemeSupport$lambda$10(schemeRefresher, arg_0));
        return schemeRefresher;
    }

    private final void updateProtocolStorage(SequentialLifetimes lifetimes, SettingsViewModelHost host) {
        JComponent jComponent = this.getPanel();
        Intrinsics.checkNotNull((Object)jComponent);
        if (jComponent.isShowing()) {
            IMutableViewableMap<KeyPathComponents, PredefinedValue> storage;
            OptionsDialog currentDialog;
            LifetimeDefinition lifetime = lifetimes.next();
            OptionsDialog optionsDialog = currentDialog = (OptionsDialog)((Object)host.getCurrentDialog().getValueOrNull());
            Object object = storage = optionsDialog != null ? optionsDialog.getTransactionStorage() : null;
            if (storage != null) {
                Map<KeyPathComponents, PredefinedValue> customSettings = this.mySettings;
                LifetimeDefinition handshake = lifetime.createNested();
                SourceExKt.adviseOnce((ISource)((ISource)currentDialog.getTransactionStorageChanged()), (Lifetime)((Lifetime)handshake), arg_0 -> RiderCodeStyleMainPanel.updateProtocolStorage$lambda$11(handshake, arg_0));
                boolean needSynchronization = false;
                Iterable $this$forEach$iv = CollectionsKt.union((Iterable)storage.keySet(), (Iterable)customSettings.keySet());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KeyPathComponents key = (KeyPathComponents)element$iv;
                    boolean bl = false;
                    PredefinedValue dest = customSettings.getOrDefault(key, null);
                    if (Intrinsics.areEqual((Object)storage.get((Object)key), (Object)dest)) continue;
                    if (dest == null) {
                        storage.remove((Object)key);
                    } else {
                        ((Map)storage).put(key, dest);
                    }
                    needSynchronization = true;
                }
                if (!needSynchronization) {
                    LifetimeDefinition.terminate$default((LifetimeDefinition)handshake, (boolean)false, (int)1, null);
                } else {
                    IProtocol protocol = ApplicationProtocolKt.getProtocolOrFirstExistentForDefault(host.getProject());
                    long timeout = 100L;
                    try {
                        IRdDispatcherKt.pumpProtocolQueue((IRdDispatcher)IRdDispatcherKt.getAsRdDispatcher((IScheduler)protocol.getScheduler()), (long)timeout, () -> RiderCodeStyleMainPanel.updateProtocolStorage$lambda$13(handshake));
                    }
                    catch (TimeoutException timeoutException) {
                        LOG.info("Failed to terminate handshake lifetime for " + timeout + " ms");
                    }
                }
                storage.getChange().advise((Lifetime)lifetime, arg_0 -> RiderCodeStyleMainPanel.updateProtocolStorage$lambda$14(customSettings, this, arg_0));
            }
        } else {
            lifetimes.next();
        }
    }

    private final JPanel addAutodetectButton(CodeStylePageContent content) {
        JLabel descriptionLabel = new JLabel(RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.label.based.on.the.existing.code.of.the.entire.solution", new Object[0]));
        descriptionLabel.setOpaque(true);
        descriptionLabel.setForeground(UIUtil.getMenuItemDisabledForeground());
        JButton runDetectionButton = new JButton(RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.button.auto.detect.formatting.rules", new Object[0]));
        JPanel panelWithRunAutodetection = new JPanel();
        panelWithRunAutodetection.setBorder((Border)JBUI.Borders.empty());
        panelWithRunAutodetection.setLayout((LayoutManager)new MigLayout("insets 3 5 10 5"));
        panelWithRunAutodetection.setOpaque(true);
        panelWithRunAutodetection.add(runDetectionButton);
        panelWithRunAutodetection.add(descriptionLabel);
        panelWithRunAutodetection.setVisible(true);
        runDetectionButton.addActionListener(arg_0 -> RiderCodeStyleMainPanel.addAutodetectButton$lambda$15(descriptionLabel, content, arg_0));
        return panelWithRunAutodetection;
    }

    private static final Unit initTabs$lambda$4$lambda$2(RiderCodeStyleTabPanel $myCodeStyleAbstractPanel, Ref.BooleanRef $autodetectButtonAdded, RiderCodeStyleMainPanel this$0, OptionsPageInfo page) {
        Intrinsics.checkNotNullParameter((Object)((Object)page), (String)"page");
        OptionsPageContentBase content = page.getContent();
        $myCodeStyleAbstractPanel.setSearchableKeywords(IRiderViewModelConfigurableKt.getAllKeywords(page.getSearchableKeywords()));
        OptionsPageContentBase optionsPageContentBase = content;
        if (optionsPageContentBase instanceof CodeStylePageContent) {
            if (((CodeStylePageContent)content).getShowAutoDetectButton() && !$autodetectButtonAdded.element) {
                $autodetectButtonAdded.element = true;
                JPanel panelWithRunAutodetection = this$0.addAutodetectButton((CodeStylePageContent)content);
                JComponent jComponent = this$0.getPanel();
                Intrinsics.checkNotNull((Object)jComponent);
                jComponent.add((Component)panelWithRunAutodetection, "North");
            }
            $myCodeStyleAbstractPanel.setContent((CodeStylePageContent)content);
        } else if (optionsPageContentBase instanceof NamingPageContentBase) {
            $myCodeStyleAbstractPanel.setContent((NamingPageContentBase)content);
        } else if (optionsPageContentBase instanceof BeSimpleOptionsPageContent) {
            ViewRegistry viewRegistry = ViewRegistry.Companion.getInstance();
            ProtoViewModel protoViewModel = (ProtoViewModel)((BeSimpleOptionsPageContent)content).getAutomation();
            LifetimeDefinition lifetimeDefinition = this$0.myTabsLifetime;
            Intrinsics.checkNotNull((Object)lifetimeDefinition);
            JComponent view = viewRegistry.getView(protoViewModel, (Lifetime)lifetimeDefinition);
            $myCodeStyleAbstractPanel.setContent(view);
        } else {
            JComponent component2 = RiderCodeStyleContentPageConverter.Companion.createComponent(content, $myCodeStyleAbstractPanel.getLifetime());
            if (component2 != null) {
                $myCodeStyleAbstractPanel.setContent(component2);
            } else {
                LOG.error("Unexpected page content " + content);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit resetImpl$lambda$6$lambda$5(OptionsPageContentBase optionsPageContentBase) {
        Intrinsics.checkNotNullParameter((Object)((Object)optionsPageContentBase), (String)"optionsPageContentBase");
        InterfacesKt.fire(optionsPageContentBase.getReset());
        return Unit.INSTANCE;
    }

    private static final Unit initSchemeSupport$lambda$8() {
        return Unit.INSTANCE;
    }

    private static final Unit initSchemeSupport$lambda$9(RiderCodeStyleMainPanel this$0, SequentialLifetimes $lifetimes, SettingsViewModelHost $host) {
        this$0.updateProtocolStorage($lifetimes, $host);
        return Unit.INSTANCE;
    }

    private static final void initSchemeSupport$lambda$10(Function0 $schemeRefresher, HierarchyEvent it) {
        if ((it.getChangeFlags() & 4L) != 0L) {
            $schemeRefresher.invoke();
        }
    }

    private static final Unit updateProtocolStorage$lambda$11(LifetimeDefinition $handshake, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LifetimeDefinition.terminate$default((LifetimeDefinition)$handshake, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final boolean updateProtocolStorage$lambda$13(LifetimeDefinition $handshake) {
        return RLifetimeKt.isAlive((Lifetime)$handshake.getLifetime());
    }

    private static final Unit updateProtocolStorage$lambda$14(Map $customSettings, RiderCodeStyleMainPanel this$0, IViewableMap.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        IViewableMap.Event event2 = event;
        if (event2 instanceof IViewableMap.Event.Add) {
            $customSettings.put(((IViewableMap.Event.Add)event).getKey(), ((IViewableMap.Event.Add)event).getNewValue());
        } else if (event2 instanceof IViewableMap.Event.Update) {
            $customSettings.put(((IViewableMap.Event.Update)event).getKey(), ((IViewableMap.Event.Update)event).getNewValue());
        } else if (event2 instanceof IViewableMap.Event.Remove) {
            $customSettings.remove(((IViewableMap.Event.Remove)event).getKey());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this$0.applySettingsToModel();
        return Unit.INSTANCE;
    }

    private static final void addAutodetectButton$lambda$15(JLabel $descriptionLabel, CodeStylePageContent $content, ActionEvent it) {
        block1: {
            if (!((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.dialog.title.run.detection.in.background", new Object[0]), RiderSettingsBundle.Companion.message("RiderCodeStyleMainPanel.dialog.message.run.detection", new Object[0])).icon(Messages.getQuestionIcon())).ask((Component)$descriptionLabel)) break block1;
            InterfacesKt.fire($content.getRunAutodetection());
            SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
            if (settingsViewModelHost != null) {
                settingsViewModelHost.cancel();
            }
        }
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderCodeStyleMainPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/settings/RiderCodeStyleMainPanel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

