/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.naming;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rider.model.NamingPageContentBase;
import com.jetbrains.rider.model.NamingPolicy;
import com.jetbrains.rider.model.NamingRuleItem;
import com.jetbrains.rider.settings.naming.DescriptionColumnInfo;
import com.jetbrains.rider.settings.naming.ModificationColumnInfo;
import com.jetbrains.rider.settings.naming.NamingChangeTracker;
import com.jetbrains.rider.settings.naming.NamingTreeNode;
import com.jetbrains.rider.settings.naming.PreviewColumnInfo;
import com.jetbrains.rider.settings.tree.CodeStyleTreeTable;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"buildNamingRuleItemsTree", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeTable;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "content", "Lcom/jetbrains/rider/model/NamingPageContentBase;", "namingChangeTracker", "Lcom/jetbrains/rider/settings/naming/NamingChangeTracker;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nNamingPolicyEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingPolicyEditor.kt\ncom/jetbrains/rider/settings/naming/NamingPolicyEditorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1869#2,2:289\n*S KotlinDebug\n*F\n+ 1 NamingPolicyEditor.kt\ncom/jetbrains/rider/settings/naming/NamingPolicyEditorKt\n*L\n42#1:289,2\n*E\n"})
public final class NamingPolicyEditorKt {
    @NotNull
    public static final CodeStyleTreeTable buildNamingRuleItemsTree(@NotNull Lifetime lifetime, @NotNull NamingPageContentBase content, @NotNull NamingChangeTracker namingChangeTracker) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)content), (String)"content");
        Intrinsics.checkNotNullParameter((Object)namingChangeTracker, (String)"namingChangeTracker");
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new DescriptionColumnInfo(), new ModificationColumnInfo(), new PreviewColumnInfo()};
        ColumnInfo[] columns = columnInfoArray;
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        ListTreeTableModel model2 = new ListTreeTableModel((TreeNode)rootNode, columns);
        CodeStyleTreeTable treeTable2 = new CodeStyleTreeTable(columns, (TreeTableModel)model2, (Function1<? super TreePath, String>)((Function1)NamingPolicyEditorKt::buildNamingRuleItemsTree$lambda$0));
        treeTable2.setRootVisible(false);
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref ruleLifetimeRef = ref;
        NamingPolicyEditorKt.buildNamingRuleItemsTree$initTable((Ref<LifetimeDefinition>)ruleLifetimeRef, lifetime, content, model2, treeTable2, rootNode, namingChangeTracker, 0);
        content.getItems().advise(lifetime, arg_0 -> NamingPolicyEditorKt.buildNamingRuleItemsTree$lambda$3(treeTable2, rootNode, ruleLifetimeRef, lifetime, content, model2, namingChangeTracker, arg_0));
        TreeTableTree tree = treeTable2.getTree();
        tree.setShowsRootHandles(true);
        treeTable2.setSelectionMode(0);
        treeTable2.setTableHeader(null);
        treeTable2.getColumnModel().getSelectionModel().setAnchorSelectionIndex(1);
        treeTable2.getColumnModel().getSelectionModel().setLeadSelectionIndex(1);
        TableColumn modificationColumn = treeTable2.getColumnModel().getColumn(1);
        modificationColumn.setMaxWidth(7);
        modificationColumn.setMinWidth(7);
        int maxWidth = tree.getPreferredScrollableViewportSize().width + 10;
        treeTable2.getSelectionModel().addListSelectionListener(arg_0 -> NamingPolicyEditorKt.buildNamingRuleItemsTree$lambda$4(treeTable2, content, namingChangeTracker, arg_0));
        Dimension valueSize = new JLabel(ApplicationBundle.message((String)"option.table.sizing.text", (Object[])new Object[0])).getPreferredSize();
        treeTable2.setPreferredScrollableViewportSize(new Dimension(maxWidth + valueSize.width + 10, 20));
        treeTable2.putClientProperty("terminateEditOnFocusLost", true);
        return treeTable2;
    }

    private static final String buildNamingRuleItemsTree$lambda$0(TreePath it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getLastPathComponent();
        Object object2 = object instanceof NamingTreeNode ? (NamingTreeNode)object : null;
        return object2 != null && (object2 = ((NamingTreeNode)object2).getModel()) != null ? ((NamingRuleItem)((Object)object2)).getDescription() : null;
    }

    private static final Unit buildNamingRuleItemsTree$initTable$lambda$2$lambda$1(NamingChangeTracker $namingChangeTracker, IOptProperty $policy, NamingPolicy it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        $namingChangeTracker.policyChangedOutsideThePolicyEditor((IOptProperty<NamingPolicy>)$policy);
        return Unit.INSTANCE;
    }

    private static final void buildNamingRuleItemsTree$initTable(Ref<LifetimeDefinition> ruleLifetimeRef, Lifetime $lifetime, NamingPageContentBase $content, ListTreeTableModel model2, CodeStyleTreeTable treeTable2, DefaultMutableTreeNode rootNode, NamingChangeTracker $namingChangeTracker, int selectedRow) {
        LifetimeDefinition lifetimeDefinition = (LifetimeDefinition)ruleLifetimeRef.get();
        if (lifetimeDefinition != null) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
        ruleLifetimeRef.set((Object)$lifetime.createNested());
        Iterable $this$forEach$iv = BeGetterExtensionsKt.valueOrEmpty($content.getItems());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NamingRuleItem it = (NamingRuleItem)((Object)element$iv);
            boolean bl = false;
            NamingTreeNode node = new NamingTreeNode(it);
            rootNode.add(node);
            IOptProperty<NamingPolicy> policy = it.getPolicy();
            ISource iSource = policy.getChange();
            Object object = ruleLifetimeRef.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            iSource.advise((Lifetime)object, arg_0 -> NamingPolicyEditorKt.buildNamingRuleItemsTree$initTable$lambda$2$lambda$1($namingChangeTracker, policy, arg_0));
        }
        model2.reload();
        if (treeTable2.getRowCount() > 0) {
            treeTable2.getSelectionModel().setLeadSelectionIndex(RangesKt.coerceIn((int)selectedRow, (int)0, (int)treeTable2.getRowCount()));
        }
    }

    private static final Unit buildNamingRuleItemsTree$lambda$3(CodeStyleTreeTable $treeTable, DefaultMutableTreeNode $rootNode, Ref $ruleLifetimeRef, Lifetime $lifetime, NamingPageContentBase $content, ListTreeTableModel $model, NamingChangeTracker $namingChangeTracker, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int selectedRow = $treeTable.getSelectionModel().getLeadSelectionIndex();
        $treeTable.getSelectionModel().clearSelection();
        $rootNode.removeAllChildren();
        NamingPolicyEditorKt.buildNamingRuleItemsTree$initTable((Ref<LifetimeDefinition>)$ruleLifetimeRef, $lifetime, $content, $model, $treeTable, $rootNode, $namingChangeTracker, selectedRow);
        return Unit.INSTANCE;
    }

    private static final void buildNamingRuleItemsTree$lambda$4(CodeStyleTreeTable $treeTable, NamingPageContentBase $content, NamingChangeTracker $namingChangeTracker, ListSelectionEvent it) {
        int selectedRow = $treeTable.getSelectedRow();
        if (selectedRow == -1) {
            return;
        }
        List namingRuleItems = BeGetterExtensionsKt.valueOrEmpty($content.getItems());
        if (selectedRow >= namingRuleItems.size()) {
            return;
        }
        NamingRuleItem selectedRule = (NamingRuleItem)((Object)namingRuleItems.get(selectedRow));
        $namingChangeTracker.namingRuleSelectionChanged(selectedRule);
    }
}

