/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.tree;

import com.intellij.openapi.Disposable;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Alarm;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.rd.ide.model.CodeStyleBoolOption;
import com.jetbrains.rd.ide.model.CodeStyleEnumOption;
import com.jetbrains.rd.ide.model.CodeStyleFlaggedEnumOption;
import com.jetbrains.rd.ide.model.CodeStyleGroupOption;
import com.jetbrains.rd.ide.model.CodeStyleNumericOption;
import com.jetbrains.rd.ide.model.CodeStyleOptionBase;
import com.jetbrains.rd.ide.model.CodeStyleOrderedCollectionOption;
import com.jetbrains.rd.ide.model.CodeStyleStringOption;
import com.jetbrains.rd.ide.model.FlaggedEnumOptionValue;
import com.jetbrains.rd.ide.model.OrderedCollection;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.CodeStylePageContent;
import com.jetbrains.rider.settings.tree.CodeStyleTreeCellRenderer;
import com.jetbrains.rider.settings.tree.CodeStyleTreeNode;
import com.jetbrains.rider.settings.tree.CodeStyleTreeNodeBase;
import com.jetbrains.rider.settings.tree.CodeStyleTreeTable;
import com.jetbrains.rider.settings.tree.TreeListSelectionListener;
import com.jetbrains.rider.settings.tree.columns.NotifyColumnInfo;
import com.jetbrains.rider.settings.tree.columns.TitleColumnInfo;
import com.jetbrains.rider.settings.tree.columns.ValueColumnInfo;
import com.jetbrains.rider.settings.util.TreeUtil;
import com.jetbrains.rider.ui.components.table.TableEmptyHeaderCellRenderer;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0017J'\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001fJ.\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00182\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/settings/tree/CodeStyleTreeFactory;", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/Disposable;)V", "getParentDisposable", "()Lcom/intellij/openapi/Disposable;", "titleColumnInfo", "Lcom/jetbrains/rider/settings/tree/columns/TitleColumnInfo;", "valueColumnInfo", "Lcom/jetbrains/rider/settings/tree/columns/ValueColumnInfo;", "notifyColumnInfo", "Lcom/jetbrains/rider/settings/tree/columns/NotifyColumnInfo;", "myTitleRenderer", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeCellRenderer;", "createTree", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeTable;", "content", "Lcom/jetbrains/rider/model/CodeStylePageContent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "filler", "Lkotlin/Function2;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeFactory$Refresher;", "", "getColumns", "", "Lcom/intellij/util/ui/ColumnInfo;", "notifyColumnExist", "(Z)[Lcom/intellij/util/ui/ColumnInfo;", "fillTree", "groupNode", "options", "", "Lcom/jetbrains/rd/ide/model/CodeStyleOptionBase;", "refresher", "Refresher", "intellij.rider.rdclient.dotnet"})
public final class CodeStyleTreeFactory {
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final TitleColumnInfo titleColumnInfo;
    @NotNull
    private final ValueColumnInfo valueColumnInfo;
    @NotNull
    private final NotifyColumnInfo notifyColumnInfo;
    @NotNull
    private final CodeStyleTreeCellRenderer myTitleRenderer;

    public CodeStyleTreeFactory(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.parentDisposable = parentDisposable;
        this.titleColumnInfo = new TitleColumnInfo();
        this.valueColumnInfo = new ValueColumnInfo();
        this.notifyColumnInfo = new NotifyColumnInfo();
        this.myTitleRenderer = new CodeStyleTreeCellRenderer();
    }

    @NotNull
    public final Disposable getParentDisposable() {
        return this.parentDisposable;
    }

    @NotNull
    public final CodeStyleTreeTable createTree(@NotNull CodeStylePageContent content, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)content), (String)"content");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        CodeStyleTreeTable treeTable2 = this.createTree((Function2<? super DefaultMutableTreeNode, ? super Refresher, Boolean>)((Function2)(arg_0, arg_1) -> CodeStyleTreeFactory.createTree$lambda$0(this, content, lifetime, arg_0, arg_1)));
        treeTable2.getSelectionModel().addListSelectionListener(new TreeListSelectionListener(treeTable2, content));
        return treeTable2;
    }

    @NotNull
    public final CodeStyleTreeTable createTree(@NotNull Function2<? super DefaultMutableTreeNode, ? super Refresher, Boolean> filler) {
        Intrinsics.checkNotNullParameter(filler, (String)"filler");
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        Refresher refresher = new Refresher();
        boolean severityColumnExist = (Boolean)filler.invoke((Object)rootNode, (Object)refresher);
        ColumnInfo<Object, Object>[] columns = this.getColumns(severityColumnExist);
        ListTreeTableModel model2 = new ListTreeTableModel((TreeNode)rootNode, columns);
        CodeStyleTreeTable treeTable2 = new CodeStyleTreeTable(columns, (TreeTableModel)model2, (Function1<? super TreePath, String>)((Function1)CodeStyleTreeFactory::createTree$lambda$1));
        refresher.setTreeTable(treeTable2);
        treeTable2.setRootVisible(false);
        TreeTableTree tree = treeTable2.getTree();
        tree.setCellRenderer((TreeCellRenderer)((Object)this.myTitleRenderer));
        tree.setShowsRootHandles(true);
        treeTable2.setSelectionMode(0);
        treeTable2.getTableHeader().setDefaultRenderer(new TableEmptyHeaderCellRenderer());
        treeTable2.getTableHeader().setReorderingAllowed(false);
        TreeUtil.INSTANCE.fitColumnWidthPercent(0, treeTable2, (int)(1.2 * (double)(100 / treeTable2.getColumnCount())), true);
        Intrinsics.checkNotNull((Object)tree);
        TreeUtil.INSTANCE.expandTree((JTree)tree);
        treeTable2.getColumnModel().getSelectionModel().setAnchorSelectionIndex(1);
        treeTable2.getColumnModel().getSelectionModel().setLeadSelectionIndex(1);
        treeTable2.putClientProperty("terminateEditOnFocusLost", true);
        Alarm alarm = new Alarm((JComponent)((Object)treeTable2), this.parentDisposable);
        Function0 onUpdate = () -> CodeStyleTreeFactory.createTree$lambda$3(alarm, treeTable2);
        this.valueColumnInfo.setOnUpdate((Function0<Unit>)onUpdate);
        if (!severityColumnExist) {
            this.notifyColumnInfo.setOnUpdate((Function0<Unit>)onUpdate);
        }
        return treeTable2;
    }

    private final ColumnInfo<Object, Object>[] getColumns(boolean notifyColumnExist) {
        ColumnInfo[] columnInfoArray;
        if (notifyColumnExist) {
            ColumnInfo[] columnInfoArray2 = new ColumnInfo[]{this.titleColumnInfo, this.valueColumnInfo, this.notifyColumnInfo};
            columnInfoArray = columnInfoArray2;
        } else {
            ColumnInfo[] columnInfoArray3 = new ColumnInfo[]{this.titleColumnInfo, this.valueColumnInfo};
            columnInfoArray = columnInfoArray3;
        }
        return columnInfoArray;
    }

    private final boolean fillTree(DefaultMutableTreeNode groupNode, List<? extends CodeStyleOptionBase> options, Lifetime lifetime, Refresher refresher) {
        boolean severityExists = false;
        for (CodeStyleOptionBase codeStyleOptionBase : options) {
            CodeStyleTreeNode newNode = new CodeStyleTreeNode(codeStyleOptionBase);
            severityExists = codeStyleOptionBase instanceof CodeStyleGroupOption ? this.fillTree(newNode, ((CodeStyleGroupOption)codeStyleOptionBase).getChildren(), lifetime, refresher) || severityExists : codeStyleOptionBase.getSeverity() != null || severityExists;
            groupNode.add(newNode);
            CodeStyleOptionBase codeStyleOptionBase2 = codeStyleOptionBase;
            if (codeStyleOptionBase2 instanceof CodeStyleEnumOption) {
                ((CodeStyleEnumOption)codeStyleOptionBase).getValue().getChange().advise(lifetime, arg_0 -> CodeStyleTreeFactory.fillTree$lambda$4(refresher, arg_0));
            } else if (codeStyleOptionBase2 instanceof CodeStyleBoolOption) {
                ((CodeStyleBoolOption)codeStyleOptionBase).getValue().getChange().advise(lifetime, arg_0 -> CodeStyleTreeFactory.fillTree$lambda$5(refresher, arg_0));
            } else if (codeStyleOptionBase2 instanceof CodeStyleFlaggedEnumOption) {
                ((CodeStyleFlaggedEnumOption)codeStyleOptionBase).getValue().getChange().advise(lifetime, arg_0 -> CodeStyleTreeFactory.fillTree$lambda$6(refresher, arg_0));
            } else if (codeStyleOptionBase2 instanceof CodeStyleNumericOption) {
                ((CodeStyleNumericOption)codeStyleOptionBase).getValue().getChange().advise(lifetime, arg_0 -> CodeStyleTreeFactory.fillTree$lambda$7(refresher, arg_0));
            } else if (codeStyleOptionBase2 instanceof CodeStyleStringOption) {
                ((CodeStyleStringOption)codeStyleOptionBase).getValue().getChange().advise(lifetime, arg_0 -> CodeStyleTreeFactory.fillTree$lambda$8(refresher, arg_0));
            } else if (codeStyleOptionBase2 instanceof CodeStyleOrderedCollectionOption) {
                ((CodeStyleOrderedCollectionOption)codeStyleOptionBase).getValue().getChange().advise(lifetime, arg_0 -> CodeStyleTreeFactory.fillTree$lambda$9(refresher, arg_0));
            }
            codeStyleOptionBase.isEnabled().getChange().advise(lifetime, arg_0 -> CodeStyleTreeFactory.fillTree$lambda$10(refresher, arg_0));
        }
        return severityExists;
    }

    private static final boolean createTree$lambda$0(CodeStyleTreeFactory this$0, CodeStylePageContent $content, Lifetime $lifetime, DefaultMutableTreeNode rootNode, Refresher refresher) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter((Object)refresher, (String)"refresher");
        return this$0.fillTree(rootNode, $content.getOptions(), $lifetime, refresher);
    }

    private static final String createTree$lambda$1(TreePath it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getLastPathComponent();
        Object object2 = object instanceof CodeStyleTreeNodeBase ? (CodeStyleTreeNodeBase)object : null;
        if (object2 == null || (object2 = ((CodeStyleTreeNodeBase)object2).getDescription()) == null) {
            object2 = "";
        }
        return object2;
    }

    private static final void createTree$lambda$3$lambda$2(CodeStyleTreeTable $treeTable) {
        $treeTable.validate();
        $treeTable.repaint();
    }

    private static final Unit createTree$lambda$3(Alarm $alarm, CodeStyleTreeTable $treeTable) {
        $alarm.addComponentRequest(() -> CodeStyleTreeFactory.createTree$lambda$3$lambda$2($treeTable), 100);
        return Unit.INSTANCE;
    }

    private static final Unit fillTree$lambda$4(Refresher $refresher, int it) {
        $refresher.refresh();
        return Unit.INSTANCE;
    }

    private static final Unit fillTree$lambda$5(Refresher $refresher, boolean it) {
        $refresher.refresh();
        return Unit.INSTANCE;
    }

    private static final Unit fillTree$lambda$6(Refresher $refresher, FlaggedEnumOptionValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        $refresher.refresh();
        return Unit.INSTANCE;
    }

    private static final Unit fillTree$lambda$7(Refresher $refresher, int it) {
        $refresher.refresh();
        return Unit.INSTANCE;
    }

    private static final Unit fillTree$lambda$8(Refresher $refresher, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $refresher.refresh();
        return Unit.INSTANCE;
    }

    private static final Unit fillTree$lambda$9(Refresher $refresher, OrderedCollection it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        $refresher.refresh();
        return Unit.INSTANCE;
    }

    private static final Unit fillTree$lambda$10(Refresher $refresher, boolean it) {
        $refresher.refresh();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/settings/tree/CodeStyleTreeFactory$Refresher;", "", "<init>", "()V", "treeTable", "Lcom/jetbrains/rider/settings/tree/CodeStyleTreeTable;", "getTreeTable", "()Lcom/jetbrains/rider/settings/tree/CodeStyleTreeTable;", "setTreeTable", "(Lcom/jetbrains/rider/settings/tree/CodeStyleTreeTable;)V", "refresh", "", "intellij.rider.rdclient.dotnet"})
    public static final class Refresher {
        @Nullable
        private CodeStyleTreeTable treeTable;

        @Nullable
        public final CodeStyleTreeTable getTreeTable() {
            return this.treeTable;
        }

        public final void setTreeTable(@Nullable CodeStyleTreeTable codeStyleTreeTable) {
            this.treeTable = codeStyleTreeTable;
        }

        public final void refresh() {
            block0: {
                CodeStyleTreeTable codeStyleTreeTable = this.treeTable;
                if (codeStyleTreeTable == null) break block0;
                codeStyleTreeTable.repaint();
            }
        }
    }
}

