/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui.components.utils;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rd.util.reactive.PropertyViewExKt;
import com.jetbrains.rider.ui.components.utils.RdSwingKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001*\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0002\u001a\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0001*\u00020\u000b\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000b\u001a\u0012\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0001*\u00020\u000b\u001a\u0012\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0001*\u00020\u000b\u001a\u0017\u0010\u0011\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u00130\u0001*\u00020\u000b\u001a\u0017\u0010\u0014\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u00130\u0001*\u00020\u000b\u001a\u0012\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0001*\u00020\u000b\u001a6\u0010\u0018\u001a.\u0012*\u0012(\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a\u0018\u0001 \u001b*\r\u0012\u0002\b\u0003\u0018\u00010\u0019\u00a2\u0006\u0002\b\u001c0\u0019\u00a2\u0006\u0002\b\u001c0\u0001*\u00020\u000b\u001a\u0010\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\r*\u00020\u001f\u001a\u0010\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000b\u001a\u0010\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000b\u001a\u0010\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\r*\u00020$\u001a\u0010\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020%0\r*\u00020&\u00a8\u0006'"}, d2={"windowAncestor", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "Ljava/awt/Window;", "Ljavax/swing/JComponent;", "getMousePositionSafe", "Ljava/awt/Point;", "Ljava/awt/Component;", "Ljava/awt/Container;", "allowChildren", "", "mouseEntered", "Lcom/intellij/openapi/editor/Editor;", "editorMouseListener", "Lcom/jetbrains/rd/util/reactive/ISource;", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseRelativePoint", "mousePoint", "mouseVisualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "Lorg/jetbrains/annotations/NotNull;", "mouseLogicalPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "mouseOffset", "", "hoveredInlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/Nullable;", "visibleAreaChanged", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "Lcom/intellij/openapi/editor/ScrollingModel;", "mousePressed", "mouseReleased", "documentChanged", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "Lcom/intellij/openapi/editor/Document;", "Ljavax/swing/event/ChangeEvent;", "Ljavax/swing/JViewport;", "intellij.rider.rdclient.dotnet"})
public final class RdSwingKt {
    @NotNull
    public static final IPropertyView<Window> windowAncestor(@NotNull JComponent $this$windowAncestor) {
        Intrinsics.checkNotNullParameter((Object)$this$windowAncestor, (String)"<this>");
        return com.jetbrains.rd.swing.RdSwingKt.proxyProperty((Object)SwingUtilities.getWindowAncestor($this$windowAncestor), (arg_0, arg_1) -> RdSwingKt.windowAncestor$lambda$2($this$windowAncestor, arg_0, arg_1));
    }

    private static final Point getMousePositionSafe(Component $this$getMousePositionSafe) {
        return MouseInfo.getPointerInfo() == null ? null : $this$getMousePositionSafe.getMousePosition();
    }

    private static final Point getMousePositionSafe(Container $this$getMousePositionSafe, boolean allowChildren) {
        return MouseInfo.getPointerInfo() == null ? null : $this$getMousePositionSafe.getMousePosition(allowChildren);
    }

    @NotNull
    public static final IPropertyView<Boolean> mouseEntered(@NotNull Editor $this$mouseEntered) {
        Intrinsics.checkNotNullParameter((Object)$this$mouseEntered, (String)"<this>");
        JComponent jComponent = $this$mouseEntered.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return com.jetbrains.rd.swing.RdSwingKt.proxyProperty((Object)(RdSwingKt.getMousePositionSafe(jComponent) != null ? 1 : 0), (arg_0, arg_1) -> RdSwingKt.mouseEntered$lambda$5($this$mouseEntered, arg_0, arg_1));
    }

    @NotNull
    public static final ISource<EditorMouseEvent> editorMouseListener(@NotNull Editor $this$editorMouseListener) {
        Intrinsics.checkNotNullParameter((Object)$this$editorMouseListener, (String)"<this>");
        return (ISource)new ISource<EditorMouseEvent>($this$editorMouseListener){
            final /* synthetic */ Editor $this_editorMouseListener;
            {
                this.$this_editorMouseListener = $receiver;
            }

            public void advise(Lifetime lifetime, Function1<? super EditorMouseEvent, Unit> handler) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter(handler, (String)"handler");
                EditorMouseMotionListener listener2 = new EditorMouseMotionListener(handler){
                    final /* synthetic */ Function1<EditorMouseEvent, Unit> $handler;
                    {
                        this.$handler = $handler;
                    }

                    public void mouseMoved(EditorMouseEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.$handler.invoke((Object)e);
                    }
                };
                this.$this_editorMouseListener.addEditorMouseMotionListener(listener2);
                lifetime.onTermination(() -> editorMouseListener.1.advise$lambda$0(this.$this_editorMouseListener, listener2));
            }

            private static final Unit advise$lambda$0(Editor $this_editorMouseListener, editorMouseListener.advise.listener.1 $listener) {
                $this_editorMouseListener.removeEditorMouseMotionListener((EditorMouseMotionListener)$listener);
                return Unit.INSTANCE;
            }
        };
    }

    @NotNull
    public static final IPropertyView<Point> mouseRelativePoint(@NotNull Editor $this$mouseRelativePoint) {
        Intrinsics.checkNotNullParameter((Object)$this$mouseRelativePoint, (String)"<this>");
        JComponent jComponent = $this$mouseRelativePoint.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        return com.jetbrains.rd.swing.RdSwingKt.proxyProperty((Object)RdSwingKt.getMousePositionSafe(jComponent, true), (arg_0, arg_1) -> RdSwingKt.mouseRelativePoint$lambda$8($this$mouseRelativePoint, arg_0, arg_1));
    }

    @NotNull
    public static final IPropertyView<Point> mousePoint(@NotNull Editor $this$mousePoint) {
        Intrinsics.checkNotNullParameter((Object)$this$mousePoint, (String)"<this>");
        return PropertyViewExKt.switchMap(RdSwingKt.mouseEntered($this$mousePoint), arg_0 -> RdSwingKt.mousePoint$lambda$9($this$mousePoint, arg_0));
    }

    @NotNull
    public static final IPropertyView<VisualPosition> mouseVisualPosition(@NotNull Editor $this$mouseVisualPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$mouseVisualPosition, (String)"<this>");
        JComponent jComponent = $this$mouseVisualPosition.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return PropertyCombinatorsKt.map((IPropertyView)com.jetbrains.rd.swing.RdSwingKt.awtMousePoint((JComponent)jComponent), arg_0 -> RdSwingKt.mouseVisualPosition$lambda$10($this$mouseVisualPosition, arg_0));
    }

    @NotNull
    public static final IPropertyView<LogicalPosition> mouseLogicalPosition(@NotNull Editor $this$mouseLogicalPosition) {
        Intrinsics.checkNotNullParameter((Object)$this$mouseLogicalPosition, (String)"<this>");
        return PropertyCombinatorsKt.map(RdSwingKt.mouseVisualPosition($this$mouseLogicalPosition), arg_0 -> RdSwingKt.mouseLogicalPosition$lambda$11($this$mouseLogicalPosition, arg_0));
    }

    @NotNull
    public static final IPropertyView<Integer> mouseOffset(@NotNull Editor $this$mouseOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$mouseOffset, (String)"<this>");
        return PropertyCombinatorsKt.map(RdSwingKt.mouseLogicalPosition($this$mouseOffset), arg_0 -> RdSwingKt.mouseOffset$lambda$12($this$mouseOffset, arg_0));
    }

    @NotNull
    public static final IPropertyView<Inlay<?>> hoveredInlay(@NotNull Editor $this$hoveredInlay) {
        Intrinsics.checkNotNullParameter((Object)$this$hoveredInlay, (String)"<this>");
        return PropertyCombinatorsKt.map(RdSwingKt.mouseRelativePoint($this$hoveredInlay), arg_0 -> RdSwingKt.hoveredInlay$lambda$13($this$hoveredInlay, arg_0));
    }

    @NotNull
    public static final ISource<VisibleAreaEvent> visibleAreaChanged(@NotNull ScrollingModel $this$visibleAreaChanged) {
        Intrinsics.checkNotNullParameter((Object)$this$visibleAreaChanged, (String)"<this>");
        return (ISource)new ISource<VisibleAreaEvent>($this$visibleAreaChanged){
            final /* synthetic */ ScrollingModel $this_visibleAreaChanged;
            {
                this.$this_visibleAreaChanged = $receiver;
            }

            public void advise(Lifetime lifetime, Function1<? super VisibleAreaEvent, Unit> handler) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter(handler, (String)"handler");
                VisibleAreaListener visibleAreaListener = arg_0 -> visibleAreaChanged.1.advise$lambda$0(handler, arg_0);
                this.$this_visibleAreaChanged.addVisibleAreaListener(visibleAreaListener);
                lifetime.onTermination(() -> visibleAreaChanged.1.advise$lambda$1(this.$this_visibleAreaChanged, visibleAreaListener));
            }

            private static final void advise$lambda$0(Function1 $handler, VisibleAreaEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                $handler.invoke((Object)it);
            }

            private static final Unit advise$lambda$1(ScrollingModel $this_visibleAreaChanged, VisibleAreaListener $visibleAreaListener) {
                $this_visibleAreaChanged.removeVisibleAreaListener($visibleAreaListener);
                return Unit.INSTANCE;
            }
        };
    }

    @NotNull
    public static final ISource<EditorMouseEvent> mousePressed(@NotNull Editor $this$mousePressed) {
        Intrinsics.checkNotNullParameter((Object)$this$mousePressed, (String)"<this>");
        return (ISource)new ISource<EditorMouseEvent>($this$mousePressed){
            final /* synthetic */ Editor $this_mousePressed;
            {
                this.$this_mousePressed = $receiver;
            }

            public void advise(Lifetime lifetime, Function1<? super EditorMouseEvent, Unit> handler) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter(handler, (String)"handler");
                EditorMouseListener clickListener2 = new EditorMouseListener(handler){
                    final /* synthetic */ Function1<EditorMouseEvent, Unit> $handler;
                    {
                        this.$handler = $handler;
                    }

                    public void mousePressed(EditorMouseEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.$handler.invoke((Object)event);
                    }
                };
                this.$this_mousePressed.addEditorMouseListener(clickListener2);
                lifetime.onTermination(() -> mousePressed.1.advise$lambda$0(this.$this_mousePressed, clickListener2));
            }

            private static final Unit advise$lambda$0(Editor $this_mousePressed, mousePressed.advise.clickListener.1 $clickListener) {
                $this_mousePressed.removeEditorMouseListener((EditorMouseListener)$clickListener);
                return Unit.INSTANCE;
            }
        };
    }

    @NotNull
    public static final ISource<EditorMouseEvent> mouseReleased(@NotNull Editor $this$mouseReleased) {
        Intrinsics.checkNotNullParameter((Object)$this$mouseReleased, (String)"<this>");
        return (ISource)new ISource<EditorMouseEvent>($this$mouseReleased){
            final /* synthetic */ Editor $this_mouseReleased;
            {
                this.$this_mouseReleased = $receiver;
            }

            public void advise(Lifetime lifetime, Function1<? super EditorMouseEvent, Unit> handler) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter(handler, (String)"handler");
                EditorMouseListener clickListener2 = new EditorMouseListener(handler){
                    final /* synthetic */ Function1<EditorMouseEvent, Unit> $handler;
                    {
                        this.$handler = $handler;
                    }

                    public void mouseReleased(EditorMouseEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.$handler.invoke((Object)event);
                    }
                };
                this.$this_mouseReleased.addEditorMouseListener(clickListener2);
                lifetime.onTermination(() -> mouseReleased.1.advise$lambda$0(this.$this_mouseReleased, clickListener2));
            }

            private static final Unit advise$lambda$0(Editor $this_mouseReleased, mouseReleased.advise.clickListener.1 $clickListener) {
                $this_mouseReleased.removeEditorMouseListener((EditorMouseListener)$clickListener);
                return Unit.INSTANCE;
            }
        };
    }

    @NotNull
    public static final ISource<DocumentEvent> documentChanged(@NotNull Document $this$documentChanged) {
        Intrinsics.checkNotNullParameter((Object)$this$documentChanged, (String)"<this>");
        return (ISource)new ISource<DocumentEvent>($this$documentChanged){
            final /* synthetic */ Document $this_documentChanged;
            {
                this.$this_documentChanged = $receiver;
            }

            public void advise(Lifetime lifetime, Function1<? super DocumentEvent, Unit> handler) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter(handler, (String)"handler");
                DocumentListener ls2 = new DocumentListener(handler){
                    final /* synthetic */ Function1<DocumentEvent, Unit> $handler;
                    {
                        this.$handler = $handler;
                    }

                    public void documentChanged(DocumentEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.$handler.invoke((Object)event);
                    }
                };
                this.$this_documentChanged.addDocumentListener(ls2);
                lifetime.onTermination(() -> documentChanged.1.advise$lambda$0(this.$this_documentChanged, ls2));
            }

            private static final Unit advise$lambda$0(Document $this_documentChanged, documentChanged.advise.ls.1 $ls) {
                $this_documentChanged.removeDocumentListener((DocumentListener)$ls);
                return Unit.INSTANCE;
            }
        };
    }

    @NotNull
    public static final ISource<ChangeEvent> visibleAreaChanged(@NotNull JViewport $this$visibleAreaChanged) {
        Intrinsics.checkNotNullParameter((Object)$this$visibleAreaChanged, (String)"<this>");
        return (ISource)new ISource<ChangeEvent>($this$visibleAreaChanged){
            final /* synthetic */ JViewport $this_visibleAreaChanged;
            {
                this.$this_visibleAreaChanged = $receiver;
            }

            public void advise(Lifetime lifetime, Function1<? super ChangeEvent, Unit> handler) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter(handler, (String)"handler");
                ChangeListener ls2 = arg_0 -> visibleAreaChanged.2.advise$lambda$0(handler, arg_0);
                lifetime.bracket(() -> visibleAreaChanged.2.advise$lambda$1(this.$this_visibleAreaChanged, ls2), () -> visibleAreaChanged.2.advise$lambda$2(this.$this_visibleAreaChanged, ls2));
            }

            private static final void advise$lambda$0(Function1 $handler, ChangeEvent e) {
                Intrinsics.checkNotNull((Object)e);
                $handler.invoke((Object)e);
            }

            private static final Unit advise$lambda$1(JViewport $this_visibleAreaChanged, ChangeListener $ls) {
                $this_visibleAreaChanged.addChangeListener($ls);
                return Unit.INSTANCE;
            }

            private static final Unit advise$lambda$2(JViewport $this_visibleAreaChanged, ChangeListener $ls) {
                $this_visibleAreaChanged.removeChangeListener($ls);
                return Unit.INSTANCE;
            }
        };
    }

    private static final Unit windowAncestor$lambda$2$lambda$0(JComponent $this_windowAncestor, windowAncestor.1.listener.1 $listener) {
        $this_windowAncestor.addAncestorListener((AncestorListener)((Object)$listener));
        return Unit.INSTANCE;
    }

    private static final Unit windowAncestor$lambda$2$lambda$1(JComponent $this_windowAncestor, windowAncestor.1.listener.1 $listener) {
        $this_windowAncestor.removeAncestorListener((AncestorListener)((Object)$listener));
        return Unit.INSTANCE;
    }

    private static final Unit windowAncestor$lambda$2(JComponent $this_windowAncestor, Lifetime lifetime, Function1 set) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        AncestorListenerAdapter listener2 = new AncestorListenerAdapter((Function1<? super Window, Unit>)set, $this_windowAncestor){
            final /* synthetic */ Function1<Window, Unit> $set;
            final /* synthetic */ JComponent $this_windowAncestor;
            {
                this.$set = $set;
                this.$this_windowAncestor = $receiver;
            }

            public void ancestorAdded(AncestorEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$set.invoke((Object)SwingUtilities.getWindowAncestor(this.$this_windowAncestor));
            }

            public void ancestorRemoved(AncestorEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$set.invoke(null);
            }
        };
        lifetime.bracket(() -> RdSwingKt.windowAncestor$lambda$2$lambda$0($this_windowAncestor, listener2), () -> RdSwingKt.windowAncestor$lambda$2$lambda$1($this_windowAncestor, listener2));
        return Unit.INSTANCE;
    }

    private static final Unit mouseEntered$lambda$5$lambda$3(Editor $this_mouseEntered, mouseEntered.1.listener.1 $listener) {
        $this_mouseEntered.addEditorMouseListener((EditorMouseListener)$listener);
        return Unit.INSTANCE;
    }

    private static final Unit mouseEntered$lambda$5$lambda$4(Editor $this_mouseEntered, mouseEntered.1.listener.1 $listener) {
        $this_mouseEntered.removeEditorMouseListener((EditorMouseListener)$listener);
        return Unit.INSTANCE;
    }

    private static final Unit mouseEntered$lambda$5(Editor $this_mouseEntered, Lifetime lifetime, Function1 set) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        EditorMouseListener listener2 = new EditorMouseListener((Function1<? super Boolean, Unit>)set){
            final /* synthetic */ Function1<Boolean, Unit> $set;
            {
                this.$set = $set;
            }

            public void mouseEntered(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$set.invoke((Object)true);
            }

            public void mouseExited(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$set.invoke((Object)false);
            }
        };
        lifetime.bracket(() -> RdSwingKt.mouseEntered$lambda$5$lambda$3($this_mouseEntered, listener2), () -> RdSwingKt.mouseEntered$lambda$5$lambda$4($this_mouseEntered, listener2));
        return Unit.INSTANCE;
    }

    private static final Unit mouseRelativePoint$lambda$8$lambda$6(Function1 $set, Editor $this_mouseRelativePoint, EditorMouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RelativePoint relativePoint = new RelativePoint(it.getMouseEvent());
        $set.invoke(Intrinsics.areEqual((Object)it.getArea(), (Object)EditorMouseEventArea.EDITING_AREA) && $this_mouseRelativePoint.getComponent().contains(relativePoint.getPoint((Component)$this_mouseRelativePoint.getComponent())) ? it.getMouseEvent().getPoint() : null);
        return Unit.INSTANCE;
    }

    private static final Unit mouseRelativePoint$lambda$8$lambda$7(Editor $this_mouseRelativePoint, Function1 $set, VisibleAreaEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JComponent jComponent = $this_mouseRelativePoint.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        Point position = RdSwingKt.getMousePositionSafe(jComponent, true);
        $set.invoke((Object)position);
        return Unit.INSTANCE;
    }

    private static final Unit mouseRelativePoint$lambda$8(Editor $this_mouseRelativePoint, Lifetime lifetime, Function1 set) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        RdSwingKt.editorMouseListener($this_mouseRelativePoint).advise(lifetime, arg_0 -> RdSwingKt.mouseRelativePoint$lambda$8$lambda$6(set, $this_mouseRelativePoint, arg_0));
        ScrollingModel scrollingModel = $this_mouseRelativePoint.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"getScrollingModel(...)");
        RdSwingKt.visibleAreaChanged(scrollingModel).advise(lifetime, arg_0 -> RdSwingKt.mouseRelativePoint$lambda$8$lambda$7($this_mouseRelativePoint, set, arg_0));
        return Unit.INSTANCE;
    }

    private static final IPropertyView mousePoint$lambda$9(Editor $this_mousePoint, boolean it) {
        return it ? RdSwingKt.mouseRelativePoint($this_mousePoint) : (IPropertyView)new Property(null);
    }

    private static final VisualPosition mouseVisualPosition$lambda$10(Editor $this_mouseVisualPosition, Point it) {
        Point point = it;
        return point == null ? null : $this_mouseVisualPosition.xyToVisualPosition(point);
    }

    private static final LogicalPosition mouseLogicalPosition$lambda$11(Editor $this_mouseLogicalPosition, VisualPosition it) {
        VisualPosition visualPosition = it;
        return visualPosition == null ? null : $this_mouseLogicalPosition.visualToLogicalPosition(visualPosition);
    }

    private static final Integer mouseOffset$lambda$12(Editor $this_mouseOffset, LogicalPosition it) {
        LogicalPosition logicalPosition = it;
        return logicalPosition == null ? null : Integer.valueOf($this_mouseOffset.logicalPositionToOffset(logicalPosition));
    }

    private static final Inlay hoveredInlay$lambda$13(Editor $this_hoveredInlay, Point it) {
        return it == null ? null : $this_hoveredInlay.getInlayModel().getElementAt(it);
    }
}

