/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage.llvm;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.coverage.SuccessCoverageLoadingResult;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.util.DocumentUtil;
import com.jetbrains.cidr.execution.coverage.CidrBranchCoverageFileData;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageEngine;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSuite;
import com.jetbrains.cidr.execution.coverage.CidrCoverageUtil;
import com.jetbrains.cidr.execution.coverage.CidrProjectData;
import com.jetbrains.cidr.execution.coverage.llvm.LLVMCoverageModel;
import com.jetbrains.cidr.execution.coverage.llvm.LLVMCoverageRunnerKt;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J$\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\"\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006$"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageRunner;", "Lcom/intellij/coverage/CoverageRunner;", "<init>", "()V", "getId", "", "getPresentableName", "getDataFileExtension", "acceptsCoverageEngine", "", "engine", "Lcom/intellij/coverage/CoverageEngine;", "loadCoverageData", "Lcom/intellij/coverage/CoverageLoadingResult;", "sessionDataFile", "Ljava/io/File;", "coverageSuite", "Lcom/intellij/coverage/CoverageSuite;", "reporter", "Lcom/intellij/coverage/CoverageLoadErrorReporter;", "containsStatementsInRange", "currentSegment", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel$Segment;", "lineIdx", "", "nextSegment", "document", "Lcom/intellij/openapi/editor/Document;", "parseModel", "Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageModel;", "inputPath", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "doParseModel", "Companion", "intellij.cidr.coverage"})
@SourceDebugExtension(value={"SMAP\nLLVMCoverageRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLVMCoverageRunner.kt\ncom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageRunner\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n13472#2,2:186\n12637#2,2:188\n1#3:190\n*S KotlinDebug\n*F\n+ 1 LLVMCoverageRunner.kt\ncom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageRunner\n*L\n103#1:186,2\n119#1:188,2\n*E\n"})
public final class LLVMCoverageRunner
extends CoverageRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "llvm-cov";

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getPresentableName() {
        String string = CidrCoverageBundle.message("llvm.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDataFileExtension() {
        return "json";
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        return engine instanceof CidrCoverageEngine;
    }

    @NotNull
    public CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite coverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)sessionDataFile, (String)"sessionDataFile");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        CidrToolEnvironment cidrToolEnvironment = CidrCoverageUtil.Companion.getEnvironment(coverageSuite);
        if (cidrToolEnvironment == null) {
            cidrToolEnvironment = new CidrToolEnvironment();
        }
        CidrToolEnvironment environment = cidrToolEnvironment;
        Path path = environment.getHostMachine().getPath(sessionDataFile.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        CoverageSuite coverageSuite2 = coverageSuite;
        LLVMCoverageModel model = this.parseModel(path, (Project)(coverageSuite2 != null ? coverageSuite2.getProject() : null), reporter);
        if (model == null) {
            LLVMCoverageRunnerKt.access$getLOG$p().warn("Could not parse model from file: " + sessionDataFile.getPath());
            return (CoverageLoadingResult)new FailedCoverageLoadingResult("Could not parse model");
        }
        CidrProjectData projectData = new CidrProjectData();
        HashMap summaries = new HashMap();
        for (LLVMCoverageModel.CoverageMapping mapping : model.getMappings()) {
            for (LLVMCoverageModel.FileMapping fileMapping : mapping.getFileMappings()) {
                boolean bl;
                CidrBranchCoverageFileData branchCoverageData;
                block17: {
                    int n;
                    int lineIdx;
                    String canonicalFilePath = FileUtil.toCanonicalPath((String)environment.toLocalPath(fileMapping.getName()));
                    ClassData fileData = projectData.getOrCreateClassData(canonicalFilePath);
                    LLVMCoverageModel.Segment segment = (LLVMCoverageModel.Segment)CollectionsKt.lastOrNull(fileMapping.getSegments());
                    int maxLine = segment != null ? segment.getBeginLine() : -1;
                    LineData[] lines = new LineData[maxLine + 1];
                    LLVMCoverageModel.Segment currentSegment = null;
                    Ref.ObjectRef document = new Ref.ObjectRef();
                    ActionsKt.runReadAction(() -> LLVMCoverageRunner.loadCoverageData$lambda$1(canonicalFilePath, document));
                    if (document.element == null) {
                        String message = "Could not find document for file " + canonicalFilePath;
                        LLVMCoverageRunnerKt.access$getLOG$p().warn(message);
                        CoverageLoadErrorReporter.reportWarning$default((CoverageLoadErrorReporter)reporter, (String)message, null, (int)2, null);
                    }
                    for (LLVMCoverageModel.Segment nextSegment : fileMapping.getSegments()) {
                        block18: {
                            if (currentSegment == null || (lineIdx = currentSegment.getBeginLine()) > (n = nextSegment.getBeginLine())) break block18;
                            while (true) {
                                block20: {
                                    LineData lineData;
                                    boolean exists;
                                    block19: {
                                        exists = lines[lineIdx] != null;
                                        LineData lineData2 = lines[lineIdx];
                                        if (lineData2 == null) {
                                            lineData2 = lineData = new LineData(lineIdx, null);
                                        }
                                        if (document.element == null) break block19;
                                        Object object = document.element;
                                        Intrinsics.checkNotNull((Object)object);
                                        if (!this.containsStatementsInRange(currentSegment, lineIdx, nextSegment, (Document)object)) break block20;
                                    }
                                    int hits = (int)Math.min(currentSegment.getCount(), Integer.MAX_VALUE);
                                    if (exists) {
                                        Object object = lineData.getSwitchData(0);
                                        if (object == null) {
                                            Object object2 = new int[]{currentSegment.getBeginColumn() - 1};
                                            Object it = object2 = (Object)lineData.addSwitch(0, object2);
                                            boolean bl2 = false;
                                            it.getHits()[0] = lineData.getHits();
                                            it.setDefaultHits(lineData.getHits());
                                            object = object2;
                                        }
                                        SwitchData switchData = object;
                                        int[] nArray = switchData.getKeys();
                                        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getKeys(...)");
                                        int[] nArray2 = ArraysKt.plus((int[])nArray, (int)currentSegment.getBeginColumn());
                                        int[] nArray3 = switchData.getHits();
                                        Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"getHits(...)");
                                        switchData.setKeysAndHits(nArray2, ArraysKt.plus((int[])nArray3, (int)hits));
                                    }
                                    lineData.setHits(Math.max(lineData.getHits(), hits));
                                    lines[lineIdx] = lineData;
                                }
                                if (lineIdx == n) break;
                                ++lineIdx;
                            }
                        }
                        currentSegment = nextSegment.getHasCount() ? nextSegment : null;
                    }
                    LineData[] $this$forEach$iv = lines;
                    boolean $i$f$forEach = false;
                    n = $this$forEach$iv.length;
                    for (lineIdx = 0; lineIdx < n; ++lineIdx) {
                        LineData element$iv;
                        LineData it = element$iv = $this$forEach$iv[lineIdx];
                        boolean bl3 = false;
                        LineData lineData = it;
                        if (lineData == null) continue;
                        lineData.fillArrays();
                    }
                    fileData.setLines(lines);
                    LLVMCoverageModel.Summary summary = fileMapping.getSummary();
                    if ((summary != null ? summary.getLines() : null) != null) {
                        BaseCoverageAnnotator.FileCoverageInfo it = $i$f$forEach = new BaseCoverageAnnotator.FileCoverageInfo();
                        boolean bl4 = false;
                        it.coveredLineCount = fileMapping.getSummary().getLines().getCovered();
                        it.totalLineCount = fileMapping.getSummary().getLines().getCount();
                        BaseCoverageAnnotator.FileCoverageInfo fileSummary = $i$f$forEach;
                        ((Map)summaries).put(canonicalFilePath, fileSummary);
                    }
                    LLVMCoverageModel.Summary summary2 = fileMapping.getSummary();
                    if ((summary2 != null ? summary2.getBranches() : null) == null) continue;
                    Intrinsics.checkNotNull((Object)canonicalFilePath);
                    branchCoverageData = projectData.getOrCreateBranchCoverageData(canonicalFilePath);
                    branchCoverageData.setTotalBranches(fileMapping.getSummary().getBranches().getCount());
                    branchCoverageData.setCoveredBranches(fileMapping.getSummary().getBranches().getCovered());
                    if (branchCoverageData.getTotalBranches() != 0) continue;
                    LineData[] $this$any$iv = lines;
                    boolean $i$f$any = false;
                    int n2 = $this$any$iv.length;
                    for (n = 0; n < n2; ++n) {
                        LineData element$iv;
                        LineData it = element$iv = $this$any$iv[n];
                        boolean bl5 = false;
                        LineData lineData = it;
                        if (!((lineData != null ? Integer.valueOf(lineData.getHits()) : null) != null && it.getHits() > 0)) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
                if (!bl) continue;
                branchCoverageData.setTotalBranches(1);
                branchCoverageData.setCoveredBranches(1);
            }
        }
        if (coverageSuite instanceof CidrCoverageSuite) {
            ((CidrCoverageSuite)coverageSuite).setSummaries(summaries);
        }
        return (CoverageLoadingResult)new SuccessCoverageLoadingResult((ProjectData)projectData);
    }

    private final boolean containsStatementsInRange(LLVMCoverageModel.Segment currentSegment, int lineIdx, LLVMCoverageModel.Segment nextSegment, Document document) {
        int endOffset;
        if (!DocumentUtil.isValidLine((int)(lineIdx - 1), (Document)document)) {
            return true;
        }
        if (!DocumentUtil.isValidLine((int)(currentSegment.getBeginLine() - 1), (Document)document) || !DocumentUtil.isValidLine((int)(nextSegment.getBeginLine() - 1), (Document)document)) {
            return true;
        }
        int currentSegmentStartOffset = document.getLineStartOffset(currentSegment.getBeginLine() - 1) + currentSegment.getBeginColumn() - 1;
        int lineBeginOffset = document.getLineStartOffset(lineIdx - 1);
        int lineEndOffset = document.getLineEndOffset(lineIdx - 1);
        int nextSegmentStartOffset = document.getLineStartOffset(nextSegment.getBeginLine() - 1) + nextSegment.getBeginColumn() - 1;
        if (currentSegmentStartOffset <= lineBeginOffset && lineEndOffset < nextSegmentStartOffset) {
            return true;
        }
        int startOffset = currentSegmentStartOffset > lineBeginOffset ? currentSegmentStartOffset : lineBeginOffset;
        int n = endOffset = nextSegmentStartOffset < lineEndOffset ? nextSegmentStartOffset : lineEndOffset;
        if (!DocumentUtil.isValidOffset((int)startOffset, (Document)document) || !DocumentUtil.isValidOffset((int)endOffset, (Document)document)) {
            return true;
        }
        int offset = startOffset;
        char charAt = '\u0000';
        while (offset >= 0 && offset < document.getCharsSequence().length() && offset < endOffset) {
            charAt = document.getCharsSequence().charAt(offset++);
            if (CharsKt.isWhitespace((char)charAt) || charAt == ';') continue;
            return true;
        }
        return false;
    }

    private final LLVMCoverageModel parseModel(Path inputPath, Project project, CoverageLoadErrorReporter reporter) {
        try {
            return this.doParseModel(inputPath, project, reporter);
        }
        catch (LLVMCoverageModel.InvalidModelException e) {
            CidrCoverageLogKt.getCidrCoverageLog().warn((Throwable)e);
            reporter.reportWarning("Could not parse model because it is invalid: " + e.getMessage(), (Exception)e);
            return null;
        }
    }

    private final LLVMCoverageModel doParseModel(Path inputPath, Project project, CoverageLoadErrorReporter reporter) {
        return (LLVMCoverageModel)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> LLVMCoverageRunner.doParseModel$lambda$6(inputPath, reporter), CidrCoverageBundle.message("coverage.reading.output.data", new Object[0]), true, project);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit loadCoverageData$lambda$1(String $canonicalFilePath, Ref.ObjectRef $document) {
        Document document;
        VirtualFile virtualFile = VfsUtil.findFile((Path)Path.of($canonicalFilePath, new String[0]), (boolean)false);
        Ref.ObjectRef objectRef = $document;
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 != null) {
            void it;
            VirtualFile virtualFile3 = virtualFile2;
            Ref.ObjectRef objectRef2 = objectRef;
            boolean bl = false;
            document = FileDocumentManager.getInstance().getDocument((VirtualFile)it);
            objectRef = objectRef2;
        } else {
            document = null;
        }
        objectRef.element = document;
        return Unit.INSTANCE;
    }

    private static final LLVMCoverageModel doParseModel$lambda$6(Path $inputPath, CoverageLoadErrorReporter $reporter) {
        return LLVMCoverageModel.Companion.fromFile($inputPath, $reporter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/execution/coverage/llvm/LLVMCoverageRunner$Companion;", "", "<init>", "()V", "ID", "", "intellij.cidr.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

