/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.command;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.rd.platform.diagnostics.LogTraceScenarioBase;
import com.jetbrains.rd.platform.diagnostics.LogTraceScenariosRegistry;
import com.jetbrains.rd.platform.diagnostics.RdLogTraceScenarios;
import com.jetbrains.rider.diagnostics.LogTraceScenarios;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/command/SetTraceCategoryCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "initializeRelevantTraceScenarios", "", "Companion", "intellij.rider.plugins.rdclient.performance"})
@SourceDebugExtension(value={"SMAP\nSetTraceCategoryCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetTraceCategoryCommand.kt\ncom/jetbrains/rider/command/SetTraceCategoryCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n1#2:70\n1563#3:71\n1634#3,3:72\n13#4:75\n14#5:76\n*S KotlinDebug\n*F\n+ 1 SetTraceCategoryCommand.kt\ncom/jetbrains/rider/command/SetTraceCategoryCommand\n*L\n49#1:71\n49#1:72,3\n17#1:75\n17#1:76\n*E\n"})
public final class SetTraceCategoryCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%logSetTraceCategory";
    @NotNull
    private static final Logger logger;

    public SetTraceCategoryCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        logger.info("Start setting trace category.");
        ActionCallback callback = new ActionCallback("Execute Set Trace Category command.");
        String[] stringArray = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getText(...)");
        String[] stringArray2 = stringArray;
        int n = 21;
        String string = stringArray2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        stringArray2 = new String[]{"="};
        List args = StringsKt.split$default((CharSequence)string, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        if (args.size() != 2) {
            String message = "Set Trace Category command should take two parameters - 'trace category name' and 'category state'.";
            logger.error(message);
            ActionCallback actionCallback = callback.reject(message);
            Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"reject(...)");
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        String traceCategoryName = (String)args.get(0);
        boolean enabled = Boolean.parseBoolean((String)args.get(1));
        logger.info("Trace Category parameters. Name: '" + traceCategoryName + "', enable: '" + enabled + "'.");
        LogTraceScenariosRegistry logTraceScenariosRegistry = LogTraceScenariosRegistry.Companion.getInstance();
        this.initializeRelevantTraceScenarios();
        LogTraceScenarioBase scenario = (LogTraceScenarioBase)LogTraceScenariosRegistry.Companion.getAllValues().get(traceCategoryName);
        if (scenario == null) {
            boolean $i$a$-requireNotNull-SetTraceCategoryCommand$_execute$22 = false;
            String $i$a$-requireNotNull-SetTraceCategoryCommand$_execute$22 = "Can't find scenario: " + scenario;
            throw new IllegalArgumentException($i$a$-requireNotNull-SetTraceCategoryCommand$_execute$22.toString());
        }
        List enabledScenarios = CollectionsKt.toMutableList((Collection)logTraceScenariosRegistry.enabledScenarios());
        boolean bl = enabled ? enabledScenarios.add(scenario) : enabledScenarios.remove(scenario);
        Iterable iterable = enabledScenarios;
        LogTraceScenariosRegistry logTraceScenariosRegistry2 = logTraceScenariosRegistry;
        boolean $i$f$map = false;
        void var11_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LogTraceScenarioBase logTraceScenarioBase = (LogTraceScenarioBase)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getName());
        }
        logTraceScenariosRegistry2.save((List)destination$iv$iv);
        callback.setDone();
        return Promises.toPromise((ActionCallback)callback);
    }

    private final void initializeRelevantTraceScenarios() {
        logger.info(LogTraceScenarios.SearchAndNavigation.INSTANCE.getName() + " is initialized");
        logger.info(RdLogTraceScenarios.Completion.INSTANCE.getName() + " is initialized");
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SetTraceCategoryCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SetTraceCategoryCommand.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/command/SetTraceCategoryCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.rdclient.performance"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

