/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangChangeModuleMapActionsKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ModifyModuleMapParams;
import java.awt.Dimension;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangModifyModuleMapDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "pathGetter", "Lkotlin/Function1;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangLanguageService;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getPathGetter", "()Lkotlin/jvm/functions/Function1;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "params", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ModifyModuleMapParams;", "getParams", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ModifyModuleMapParams;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "send", "intellij.cidr.clangd.toolwindow"})
public final class ClangModifyModuleMapDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Function1<ClangLanguageService, String> pathGetter;
    private DialogPanel panel;
    @NotNull
    private final ModifyModuleMapParams params;

    public ClangModifyModuleMapDialog(@NotNull Project project, @NotNull Function1<? super ClangLanguageService, String> pathGetter) {
        ClangLanguageService service;
        ClangLanguageServiceProvider provider;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(pathGetter, (String)"pathGetter");
        super(project, true, DialogWrapper.IdeModalityType.MODELESS);
        this.project = project;
        this.pathGetter = pathGetter;
        this.params = new ModifyModuleMapParams(null, 1, null);
        ClangLanguageServiceProvider clangLanguageServiceProvider = provider = ClangLanguageServiceProvider.getProvider((Project)this.project);
        Object object = service = clangLanguageServiceProvider != null ? clangLanguageServiceProvider.getIfStarted() : null;
        if (service != null) {
            String string = VirtualFileManager.constructUrl((String)"file", (String)((String)this.pathGetter.invoke((Object)service)));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrl(...)");
            String url = string;
            String content = (String)service.getContext().getRemoteWorkspace().apply(url, ClangModifyModuleMapDialog::_init_$lambda$0);
            String string2 = content;
            if (string2 == null) {
                string2 = "";
            }
            this.params.setText(string2);
        }
        this.setOKButtonText("Send");
        this.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Function1<ClangLanguageService, String> getPathGetter() {
        return this.pathGetter;
    }

    @NotNull
    public final ModifyModuleMapParams getParams() {
        return this.params;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Dimension dimension;
        this.panel = BuilderKt.panel(arg_0 -> ClangModifyModuleMapDialog.createCenterPanel$lambda$5(this, arg_0));
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        if ((dimension = DimensionService.getInstance().getSize("ClangModifyModMapDimensions", this.project)) == null) {
            JBDimension jBDimension = JBUI.size((int)640, (int)480);
            Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
            dimension = (Dimension)jBDimension;
        }
        dialogPanel.setPreferredSize(dimension);
        DialogPanel dialogPanel2 = this.panel;
        if (dialogPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel2 = null;
        }
        return (JComponent)dialogPanel2;
    }

    protected void doOKAction() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        dialogPanel.apply();
        super.doOKAction();
        this.send();
    }

    private final void send() {
        ClangLanguageServiceProvider clangLanguageServiceProvider = ClangLanguageServiceProvider.getProvider((Project)this.project);
        if (clangLanguageServiceProvider == null) {
            ClangChangeModuleMapActionsKt.access$showNotification(this.project, "ClangLanguageServiceProvider not found");
            return;
        }
        ClangLanguageServiceProvider provider = clangLanguageServiceProvider;
        ClangLanguageService clangLanguageService = provider.getIfStarted();
        ClangdLanguageService clangdLanguageService = clangLanguageService instanceof ClangdLanguageService ? (ClangdLanguageService)clangLanguageService : null;
        if (clangdLanguageService == null) {
            ClangChangeModuleMapActionsKt.access$showNotification(this.project, "ClangdLanguageService not found");
            return;
        }
        ClangdLanguageService service = clangdLanguageService;
        String string = VirtualFileManager.constructUrl((String)"file", (String)((String)this.pathGetter.invoke((Object)service)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrl(...)");
        String url = string;
        service.notifyDocumentChanged(url, this.params.getText());
    }

    private static final String _init_$lambda$0(RemoteWorkspaceFile wf) {
        return wf.getContent();
    }

    private static final String createCenterPanel$lambda$5$lambda$4$lambda$1(EditorTextField editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String string = editor.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$4$lambda$3$lambda$2(EditorTextField $editor, String $text) {
        $editor.getDocument().setText((CharSequence)$text);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$4$lambda$3(EditorTextField editor, String text) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ActionsKt.runWriteAction(() -> ClangModifyModuleMapDialog.createCenterPanel$lambda$5$lambda$4$lambda$3$lambda$2(editor, text));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5$lambda$4(ClangModifyModuleMapDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        EditorTextField textEditor = new EditorTextField(this$0.project, (FileType)PlainTextFileType.INSTANCE);
        textEditor.setOneLineMode(false);
        textEditor.setFontInheritedFromLAF(false);
        textEditor.setFont(EditorUtil.getEditorFont());
        $this$row.cell((JComponent)textEditor).align(Align.FILL).label("File text", LabelPosition.TOP).bind(ClangModifyModuleMapDialog::createCenterPanel$lambda$5$lambda$4$lambda$1, ClangModifyModuleMapDialog::createCenterPanel$lambda$5$lambda$4$lambda$3, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.params){

            public Object get() {
                return ((ModifyModuleMapParams)this.receiver).getText();
            }

            public void set(Object value) {
                ((ModifyModuleMapParams)this.receiver).setText((String)value);
            }
        })));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$5(ClangModifyModuleMapDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> ClangModifyModuleMapDialog.createCenterPanel$lambda$5$lambda$4(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }
}

