/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u001f\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/ClangdPanelBase;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "dispose", "", "createToolbarWithActions", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "([Lcom/intellij/openapi/actionSystem/AnAction;)V", "truncateIfNecessary", "", "text", "intellij.cidr.clangd.toolwindow"})
public abstract class ClangdPanelBase
extends SimpleToolWindowPanel
implements Disposable {
    public ClangdPanelBase() {
        super(false, true);
    }

    public void dispose() {
    }

    public final void createToolbarWithActions(AnAction ... actions) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        if (!(actions.length == 0)) {
            DefaultActionGroup actionsGroup = new DefaultActionGroup(Arrays.copyOf(actions, actions.length));
            ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ClangdPanel", (ActionGroup)actionsGroup, false);
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
            ActionToolbar toolbar = actionToolbar;
            toolbar.setTargetComponent((JComponent)((Object)this));
            this.setToolbar(toolbar.getComponent());
        }
    }

    @NotNull
    public final String truncateIfNecessary(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int limit = Registry.Companion.get("clion.clang.clangd.log.message.body.limit").asInteger();
        if (limit == 0 || text.length() <= limit) {
            return text;
        }
        return StringUtil.shortenTextWithEllipsis((String)text, (int)limit, (int)0) + " (set appropriate \"clion.clang.clangd.log.message.body.limit\" in Registry... to see the full message)";
    }
}

