/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsActionEx;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestExecutionUtil;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunMode;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.boost.BoostTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestElements;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrTestCommandLineState<CONFIGURATION> {
    public static final Supplier<CidrTestScope> EMPTY_TEST_SCOPE_PRODUCER = () -> CidrTestScope.createEmptyTestScope((String)BoostTestLanguageSupport.getInstance().getPatternSeparatorInCommandLine());

    public CidrBoostTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        if (configuration == null) {
            CidrBoostTestCommandLineState.$$$reportNull$$$0(0);
        }
        if (launcher == null) {
            CidrBoostTestCommandLineState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            CidrBoostTestCommandLineState.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrBoostTestCommandLineState.$$$reportNull$$$0(3);
        }
        super(configuration, launcher, env, executor, failedTests, EMPTY_TEST_SCOPE_PRODUCER);
    }

    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView consoleView) {
        if (consoleView == null) {
            CidrBoostTestCommandLineState.$$$reportNull$$$0(4);
        }
        return CidrBoostTestCommandLineState.doCreateRerunFailedTestsActionStandard(this, consoleView, "boost://");
    }

    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@Nullable String suiteName, @Nullable String testName) {
        CidrTestScopeElement cidrTestScopeElement = CidrBoostTestElements.createTestScopeElementForSuiteAndTest(suiteName, testName);
        if (cidrTestScopeElement == null) {
            CidrBoostTestCommandLineState.$$$reportNull$$$0(5);
        }
        return cidrTestScopeElement;
    }

    public void prepareTestExecutionEnvironment(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            CidrBoostTestCommandLineState.$$$reportNull$$$0(6);
        }
        CidrTestRunConfiguration configuration = this.getConfiguration();
        CidrTestLanguageSupport language = BoostTestLanguageSupport.getInstance();
        @NotNull Project project = configuration.getProject();
        configuration.getTestData().setCommandLineTestPattern(CidrTestExecutionUtil.getAsPatternForCommandLine((Project)configuration.getProject(), file -> language.getElementsInFile(file), EMPTY_TEST_SCOPE_PRODUCER, () -> language.areSymbolsLoaded(project), (CidrTestScope)this.testScope(), (ProgressIndicator)progress));
        super.prepareTestExecutionEnvironment(progress);
    }

    @Contract(pure=true)
    protected boolean needCloseBeforeTestRunTaskResults() {
        return false;
    }

    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            CidrBoostTestCommandLineState.$$$reportNull$$$0(7);
        }
        if (this.myRunMode == CidrTestRunMode.GET_TEST_LIST) {
            cl.addParameter("--list_content=DOT");
        } else {
            double version;
            try {
                version = Double.parseDouble(Registry.get((String)"cidr.test.framework.boost.version").asString());
            }
            catch (NumberFormatException ex) {
                version = 0.0;
            }
            if (version > 0.0 && version < 1.59) {
                CidrBoostTestCommandLineState.addParametersAtFirstPos((GeneralCommandLine)cl, (String[])new String[]{"--show_progress=no", "--report_format=HRF"});
            } else {
                CidrBoostTestCommandLineState.addParametersAtFirstPos((GeneralCommandLine)cl, (String[])new String[]{"--show_progress=no", "--report_format=HRF", "--color_output=false"});
            }
            @NonNls String testLogFormat = "--log_format=";
            @NonNls String testLogLevel = "--log_level=";
            @NonNls String testLogger = "--logger=";
            String line = cl.getPreparedCommandLine();
            if (!(line.contains("--log_format=") || line.contains("--log_level=") || line.contains("--logger="))) {
                CidrBoostTestCommandLineState.addParametersAtFirstPos((GeneralCommandLine)cl, (String[])new String[]{"--logger=HRF,all"});
            }
        }
        String commandLineTestPattern = this.getConfiguration().getTestData().getCommandLineTestPattern();
        if (!StringUtil.isEmpty((String)commandLineTestPattern)) {
            CidrBoostTestCommandLineState.addParametersAtFirstPos((GeneralCommandLine)cl, (String[])new String[]{"--run_test=" + commandLineTestPattern});
        }
        return cl;
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    protected static CidrRerunFailedTestsAction doCreateRerunFailedTestsActionStandard(@NotNull CidrTestCommandLineState<?> self, @NotNull SMTRunnerConsoleView consoleView, @NotNull String protocolPrefix) {
        if (self == null) {
            CidrBoostTestCommandLineState.$$$reportNull$$$0(8);
        }
        if (consoleView == null) {
            CidrBoostTestCommandLineState.$$$reportNull$$$0(9);
        }
        if (protocolPrefix == null) {
            CidrBoostTestCommandLineState.$$$reportNull$$$0(10);
        }
        return new CidrRerunFailedTestsActionEx((ComponentContainer)consoleView, testContext -> {
            String url = ((AbstractTestProxy)testContext.first).getLocationUrl();
            if (url != null && url.startsWith(protocolPrefix)) {
                return url.substring(protocolPrefix.length());
            }
            return null;
        }, self);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestCommandLineState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocolPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestCommandLineState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestScopeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRerunFailedTestsAction";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestExecutionEnvironment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRerunFailedTestsActionStandard";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

