/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestBaseUtil;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestLocation;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.boost.BoostTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.boost.CidrBoostTestElements;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class CidrBoostTestLocationProvider
implements SMTestLocator,
DumbAware {
    @NonNls
    public static final String PROTOCOL = "boost";
    @NonNls
    public static final String PROTOCOL_PREFIX = "boost://";
    @NonNls
    public static final String DATA_TEST_CASE_PREFIX = "_";
    @NonNls
    public static final String TYPED_TEXT_SUFFIX = "<>";
    public static final CidrBoostTestLocationProvider INSTANCE = new CidrBoostTestLocationProvider();

    @NotNull
    static List<Location> getLocationsSync(@NotNull @NonNls String locationPath, @Nullable @NonNls String metainfo, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (locationPath == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(2);
        }
        List parts = CidrTestScopeElementImpl.splitPath((String)locationPath);
        int lastIndex = parts.size() - 1;
        Object configurationName = (String)parts.get(lastIndex);
        CidrTestLanguageSupport tls = BoostTestLanguageSupport.getInstance();
        CidrTestScopeElement scopeElement = null;
        if (tls.usesTestIndexForNavigation()) {
            scopeElement = tls.getTopTestScopeElement(CidrTestBaseUtil.replaceTemplateParamTo((String)locationPath, (String)TYPED_TEXT_SUFFIX), (String)configurationName, metainfo, project, scope, CidrBoostTestElements.getGenerator());
            if (scopeElement == null && parts.size() > 1 && ((String)configurationName).startsWith(DATA_TEST_CASE_PREFIX)) {
                configurationName = (String)parts.get(lastIndex - 1) + "(" + (String)configurationName + ")";
                parts = ContainerUtil.concat(parts.subList(0, lastIndex), parts.subList(lastIndex, parts.size()));
                scopeElement = tls.getTopTestScopeElement(CidrTestScopeElementImpl.createPathFromParts((Collection)parts), (String)configurationName, metainfo, project, scope, CidrBoostTestElements.getGenerator());
            }
            if (scopeElement != null && !locationPath.equals(scopeElement.getTestPath())) {
                CidrTestScopeElement finalScopeElement = scopeElement;
                scopeElement = CidrTestScopeElementImpl.createTestScopeElementForVirtualTestPath((String)locationPath, (String)configurationName, () -> ((CidrTestScopeElement)finalScopeElement).getElement(), CidrBoostTestElements.getGenerator());
            }
        }
        if (scopeElement == null) {
            scopeElement = BoostTestLanguageSupport.ourLanguageFreeService.getTopTestScopeElement(locationPath, (String)configurationName, metainfo, project, scope, CidrBoostTestElements.getGenerator());
        }
        List<Object> list = scopeElement == null ? Collections.emptyList() : Collections.singletonList(new CidrTestLocation(project, scopeElement, PROTOCOL_PREFIX));
        if (list == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(4);
        }
        if (path == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(7);
        }
        List<Location> list = this.getLocation(protocol, path, null, project, scope);
        if (list == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<Location> getLocation(@NotNull String protocol, @NotNull String locationPath, @Nullable String metainfo, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(9);
        }
        if (locationPath == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(10);
        }
        if (project == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(12);
        }
        if (!PROTOCOL.equals(protocol)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                CidrBoostTestLocationProvider.$$$reportNull$$$0(13);
            }
            return list;
        }
        if (locationPath.startsWith("CIDRRerun?")) {
            String _metainfo = locationPath.substring("CIDRRerun?".length());
            CidrTestScopeElement scopeElement = BoostTestLanguageSupport.ourLanguageFreeService.createTestScopeElementsSync("", null, _metainfo, project, scope, CidrBoostTestElements.getGenerator());
            List<Object> list = scopeElement == null ? Collections.emptyList() : Collections.singletonList(new CidrTestLocation(project, scopeElement, PROTOCOL_PREFIX, _metainfo));
            if (list == null) {
                CidrBoostTestLocationProvider.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = BoostTestLanguageSupport.getInstance().getLocationSafe(project, () -> CidrBoostTestLocationProvider.getLocationsSync(locationPath, metainfo, project, scope));
        if (list == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project) {
        if (project == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(16);
        }
        ModificationTracker modificationTracker = BoostTestLanguageSupport.getInstance().getLocationCacheModificationTracker(project);
        if (modificationTracker == null) {
            CidrBoostTestLocationProvider.$$$reportNull$$$0(17);
        }
        return modificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 13, 14, 15, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationPath";
                break;
            }
            case 1: 
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestLocationProvider";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostTestLocationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationsSync";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationCacheModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocationsSync";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLocationCacheModificationTracker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 13, 14, 15, 17 -> new IllegalStateException(string);
        };
    }
}

