/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.cidr.execution.testing.CidrTestLanguageSupport;
import com.jetbrains.cidr.execution.testing.CidrTestListUpdater;
import com.jetbrains.cidr.execution.testing.CidrTestNoIndexSupport;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElementImpl;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsAndGeneratorFramework;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestFrameworkLanguageSupport
implements CidrTestLanguageSupport {
    protected final CidrTestWithScopeElementsAndGeneratorFramework myFramework;

    public CidrTestFrameworkLanguageSupport(CidrTestWithScopeElementsAndGeneratorFramework framework) {
        this.myFramework = framework;
    }

    @NonNls
    @NotNull
    public String getProtocolPrefix() {
        String string = this.myFramework.getProtocolPrefix();
        if (string == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getPatternSeparatorInCommandLine() {
        String string = this.myFramework.getPatternSeparatorInCommandLine();
        if (string == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@Nullable PsiFile file) {
        return CidrTestNoIndexSupport.findCachedTestObject((PsiElement)file, (String)this.getProtocolPrefix()) != null || this.myFramework.isAvailable(file);
    }

    public CidrTestScopeElement findTestObject(PsiElement element) {
        CidrTestScopeElement findCachedTestObject = CidrTestNoIndexSupport.findCachedTestObject((PsiElement)element, (String)this.getProtocolPrefix());
        if (findCachedTestObject != null) {
            return findCachedTestObject;
        }
        return (CidrTestScopeElement)this.myFramework.findTestObject(element);
    }

    @NotNull
    public GlobalSearchScope getProjectSourcesScope(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(2);
        }
        GlobalSearchScope globalSearchScope = this.myFramework.getProjectSourcesScope(project);
        if (globalSearchScope == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    public boolean areSymbolsLoaded(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(4);
        }
        return FileSymbolTablesCache.areSymbolsLoaded((Project)project);
    }

    public boolean isIndexing(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(5);
        }
        return this.myFramework.getUpdater(project).isIndexing();
    }

    @NotNull
    public Collection<? extends CidrTestScopeElement> getElementsInFile(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(6);
        }
        Collection collection = this.myFramework.getTestObjects(OCLanguageUtils.tryGetOCFile((PsiFile)file)).values();
        if (collection == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public ModificationTracker getLocationCacheModificationTracker(@NotNull Project project) {
        if (project == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(8);
        }
        CidrTestListUpdater cidrTestListUpdater = this.myFramework.getUpdater(project);
        if (cidrTestListUpdater == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(9);
        }
        return cidrTestListUpdater;
    }

    @NotNull
    public Collection<CidrTestScopeElement> findTestScopeElementsSync(@NotNull @NonNls String locationPath, @NotNull @NonNls String configName, @Nullable @NonNls String metainfo, @NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull Function<CidrTestScopeElementImpl, CidrTestScopeElementImpl.AbstractPropertiesGenerator> generator) {
        if (locationPath == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(10);
        }
        if (configName == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(11);
        }
        if (project == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(13);
        }
        if (generator == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(14);
        }
        Collection<CidrTestScopeElement> collection = this.myFramework.collectTestObjects(locationPath, project, scope);
        if (collection == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    public List<Location> getLocationSafe(@NotNull Project project, @NotNull Computable<List<Location>> findLocationsInScope) {
        if (project == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(16);
        }
        if (findLocationsInScope == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(17);
        }
        List list = (List)OCTestExecution.executeWithCachedValuesFast(() -> this.myFramework.getUpdater(project).getLocation(findLocationsInScope));
        if (list == null) {
            CidrTestFrameworkLanguageSupport.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 8, 10, 11, 12, 13, 14, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestFrameworkLanguageSupport";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findLocationsInScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocolPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternSeparatorInCommandLine";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestFrameworkLanguageSupport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsInFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationCacheModificationTracker";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestScopeElementsSync";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationSafe";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSourcesScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "areSymbolsLoaded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIndexing";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementsInFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLocationCacheModificationTracker";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findTestScopeElementsSync";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLocationSafe";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 8, 10, 11, 12, 13, 14, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

