/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.codeInsight;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.lexer.HttpClientExtensionLexemesDefaultManager;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpVisitor;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/HttpClientInappropriateProtocolUsageInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.restClient"})
public final class HttpClientInappropriateProtocolUsageInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new HttpVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitRequest(HttpRequest o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                PsiElement requestProtocol = HttpRequestPsiUtils.getProtocol(o);
                if (requestProtocol == null) {
                    return;
                }
                if (HttpClientExtensionLexemesDefaultManager.getMethods().contains(o.getHttpMethod())) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new PsiUpdateModCommandQuickFix(){

                    protected void applyFix(Project project, PsiElement element, ModPsiUpdater updater) {
                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
                        element.delete();
                    }

                    public String getFamilyName() {
                        String string = RestClientBundle.message("http.client.inappropriate.protocol.fix", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return string;
                    }
                }};
                this.$holder.registerProblem(requestProtocol, RestClientBundle.message("http.client.inappropriate.protocol.inspection.message", new Object[0]), localQuickFixArray);
            }
        };
    }
}

