/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.scientific.statistics.ScientificImageActionsCollector;
import org.intellij.images.scientific.utils.ScientificImageViewerCoroutineKt;
import org.intellij.images.scientific.utils.ScientificUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/intellij/images/scientific/action/InvertChannelsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "applyInvertChannels", "Ljava/awt/image/BufferedImage;", "image", "(Ljava/awt/image/BufferedImage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.images"})
public final class InvertChannelsAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile imageFile = virtualFile;
        BufferedImage bufferedImage = (BufferedImage)imageFile.getUserData(ScientificUtils.INSTANCE.getORIGINAL_IMAGE_KEY());
        if (bufferedImage == null) {
            return;
        }
        BufferedImage originalImage = bufferedImage;
        ImageDocument imageDocument = (ImageDocument)e.getData(ImageDocument.IMAGE_DOCUMENT_DATA_KEY);
        if (imageDocument == null) {
            return;
        }
        ImageDocument document = imageDocument;
        Integer n = (Integer)imageFile.getUserData(ScientificUtils.INSTANCE.getROTATION_ANGLE_KEY());
        int currentAngle = n != null ? n : 0;
        imageFile.putUserData(ScientificUtils.INSTANCE.getNORMALIZATION_APPLIED_KEY(), (Object)false);
        ScientificImageViewerCoroutineKt.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(currentAngle, originalImage, this, imageFile, document, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ int $currentAngle;
            final /* synthetic */ BufferedImage $originalImage;
            final /* synthetic */ InvertChannelsAction this$0;
            final /* synthetic */ VirtualFile $imageFile;
            final /* synthetic */ ImageDocument $document;
            {
                this.$currentAngle = $currentAngle;
                this.$originalImage = $originalImage;
                this.this$0 = $receiver;
                this.$imageFile = $imageFile;
                this.$document = $document;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block9: {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (this.$currentAngle == 0) break;
                            this.label = 1;
                            v0 = ScientificUtils.INSTANCE.rotateImage$intellij_platform_images(this.$originalImage, this.$currentAngle, (Continuation<? super BufferedImage>)((Continuation)this));
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            v1 = (BufferedImage)v0;
                            break block9;
                        }
                    }
                    v1 = this.$originalImage;
                }
                rotatedOriginal = v1;
                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)rotatedOriginal);
                this.label = 2;
                v2 = InvertChannelsAction.access$applyInvertChannels(this.this$0, rotatedOriginal, (Continuation)this);
                if (v2 == var4_2) {
                    return var4_2;
                }
                ** GOTO lbl29
                {
                    case 2: {
                        rotatedOriginal = (BufferedImage)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        invertedImage = (BufferedImage)v2;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)rotatedOriginal);
                        this.L$1 = invertedImage;
                        this.label = 3;
                        v3 = ScientificUtils.INSTANCE.saveImageToFile$intellij_platform_images(this.$imageFile, invertedImage, (Continuation<? super Unit>)((Continuation)this));
                        if (v3 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl42
                    }
                    case 3: {
                        invertedImage = (BufferedImage)this.L$1;
                        rotatedOriginal = (BufferedImage)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl42:
                        // 2 sources

                        this.$document.setValue(invertedImage);
                        ScientificImageActionsCollector.INSTANCE.logInvertChannelsInvoked();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Object applyInvertChannels(BufferedImage image, Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BufferedImage invertedImage = new BufferedImage(this.$image.getWidth(), this.$image.getHeight(), this.$image.getType());
                        int n = this.$image.getWidth();
                        for (int x = 0; x < n; ++x) {
                            int n2 = this.$image.getHeight();
                            for (int y = 0; y < n2; ++y) {
                                int rgba = this.$image.getRGB(x, y);
                                int alpha = rgba >> 24 & 0xFF;
                                int red = rgba >> 16 & 0xFF;
                                int green = rgba >> 8 & 0xFF;
                                int blue = rgba & 0xFF;
                                int invertedRed = 255 - red;
                                int invertedGreen = 255 - green;
                                int invertedBlue = 255 - blue;
                                int invertedRgba = alpha << 24 | invertedRed << 16 | invertedGreen << 8 | invertedBlue;
                                invertedImage.setRGB(x, y, invertedRgba);
                            }
                        }
                        return invertedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ Object access$applyInvertChannels(InvertChannelsAction $this, BufferedImage image, Continuation $completion) {
        return $this.applyInvertChannels(image, (Continuation<? super BufferedImage>)$completion);
    }
}

