/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution;

import com.intellij.clion.embedded.execution.ui.EmbeddedMessages;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class OpenOcdListener
implements ProcessListener {
    static final String READY_COMMAND = "echo (((READY)))";
    private static final String READY_STAMP = "(((READY)))";
    private static final String @NotNull [] FAIL_STRINGS = new String[]{"** Programming Failed **", "communication failure", "** OpenOCD init failed **", "** Unable to reset target **"};
    private static final String FLASH_SUCCESS_TEXT = "** Programming Finished **";
    private static final String FLASH_START_TEXT = "** Programming Started **";
    private final CompletableFuture<STATUS> result;
    private volatile STATUS status;
    private String textTail;
    private final Project myProject;

    @VisibleForTesting
    public OpenOcdListener(@NotNull Project project) {
        if (project == null) {
            OpenOcdListener.$$$reportNull$$$0(0);
        }
        this.result = new CompletableFuture();
        this.status = STATUS.SUCCESS;
        this.textTail = "";
        this.myProject = project;
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            OpenOcdListener.$$$reportNull$$$0(1);
        }
        this.result.complete(this.status);
    }

    public synchronized void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        int eolIdx;
        if (event == null) {
            OpenOcdListener.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            OpenOcdListener.$$$reportNull$$$0(3);
        }
        this.textTail = this.textTail + Objects.toString(event.getText(), "");
        while ((eolIdx = Math.max(this.textTail.lastIndexOf(10), this.textTail.lastIndexOf(13))) >= 0) {
            String text = this.textTail.substring(0, eolIdx);
            this.textTail = this.textTail.substring(eolIdx + 1);
            if (text.contains(FLASH_SUCCESS_TEXT)) {
                this.status = STATUS.FLASH_SUCCESS;
                continue;
            }
            if (text.contains(FLASH_START_TEXT)) {
                this.status = STATUS.ERROR;
            }
            if (ContainerUtil.exists((Object[])FAIL_STRINGS, s -> text.contains((CharSequence)s))) {
                this.status = STATUS.ERROR;
                EmbeddedMessages.showFailedDownloadNotification(this.myProject);
                continue;
            }
            int readyCommandIndex = text.indexOf(READY_COMMAND);
            int readyStampIndex = readyCommandIndex > 0 ? text.indexOf(READY_STAMP, readyCommandIndex + READY_COMMAND.length()) : text.indexOf(READY_STAMP);
            if (readyStampIndex < 0) continue;
            this.result.complete(this.status);
        }
    }

    @VisibleForTesting
    public CompletableFuture<STATUS> getResult() {
        return this.result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/clion/embedded/execution/OpenOcdListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processTerminated";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onTextAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum STATUS {
        FLASH_SUCCESS,
        SUCCESS,
        ERROR;

    }
}

