/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos;

import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\tH\u00c6\u0003JI\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\tH\u00c6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/RtosLLThread;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "gdbThreadId", "", "taskId", "taskState", "", "threadName", "stackTopAddress", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "programCounter", "<init>", "(JJLjava/lang/String;Ljava/lang/String;Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lcom/jetbrains/cidr/execution/debugger/memory/Address;)V", "getGdbThreadId", "()J", "getTaskId", "getTaskState", "()Ljava/lang/String;", "getThreadName", "getStackTopAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getProgramCounter", "getDisplayName", "toString", "equals", "", "other", "", "hashCode", "", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "intellij.clion.embedded"})
public final class RtosLLThread
extends LLThread {
    private final long gdbThreadId;
    private final long taskId;
    @Nullable
    private final String taskState;
    @NotNull
    private final String threadName;
    @NotNull
    private final Address stackTopAddress;
    @Nullable
    private final Address programCounter;

    public RtosLLThread(long gdbThreadId, long taskId, @Nullable String taskState, @NotNull String threadName, @NotNull Address stackTopAddress, @Nullable Address programCounter) {
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullParameter((Object)stackTopAddress, (String)"stackTopAddress");
        super(gdbThreadId, taskState, null, threadName, null);
        this.gdbThreadId = gdbThreadId;
        this.taskId = taskId;
        this.taskState = taskState;
        this.threadName = threadName;
        this.stackTopAddress = stackTopAddress;
        this.programCounter = programCounter;
    }

    public final long getGdbThreadId() {
        return this.gdbThreadId;
    }

    public final long getTaskId() {
        return this.taskId;
    }

    @Nullable
    public final String getTaskState() {
        return this.taskState;
    }

    @NotNull
    public final String getThreadName() {
        return this.threadName;
    }

    @NotNull
    public final Address getStackTopAddress() {
        return this.stackTopAddress;
    }

    @Nullable
    public final Address getProgramCounter() {
        return this.programCounter;
    }

    @NotNull
    public String getDisplayName() {
        CharSequence charSequence;
        StringBuilder builder = new StringBuilder("Task-" + this.taskId);
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (((CharSequence)string).length() > 0) {
            builder.append(" [" + this.getName() + "]");
        }
        if (!((charSequence = (CharSequence)this.taskState) == null || charSequence.length() == 0)) {
            builder.append(" " + this.taskState);
        }
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.clion.embedded.execution.rtos.RtosLLThread");
        RtosLLThread cfr_ignored_0 = (RtosLLThread)((Object)other);
        if (this.gdbThreadId != ((RtosLLThread)((Object)other)).gdbThreadId) {
            return false;
        }
        if (this.taskId != ((RtosLLThread)((Object)other)).taskId) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getName(), (Object)((RtosLLThread)((Object)other)).getName());
    }

    public int hashCode() {
        int result2 = 31 * Long.hashCode(this.gdbThreadId);
        result2 = 31 * result2 + Long.hashCode(this.taskId);
        String string = this.taskState;
        result2 = 31 * result2 + (string != null ? string.hashCode() : 0);
        result2 = 31 * result2 + this.getName().hashCode();
        return result2;
    }

    public final long component1() {
        return this.gdbThreadId;
    }

    public final long component2() {
        return this.taskId;
    }

    @Nullable
    public final String component3() {
        return this.taskState;
    }

    @NotNull
    public final String component4() {
        return this.threadName;
    }

    @NotNull
    public final Address component5() {
        return this.stackTopAddress;
    }

    @Nullable
    public final Address component6() {
        return this.programCounter;
    }

    @NotNull
    public final RtosLLThread copy(long gdbThreadId, long taskId, @Nullable String taskState, @NotNull String threadName, @NotNull Address stackTopAddress, @Nullable Address programCounter) {
        Intrinsics.checkNotNullParameter((Object)threadName, (String)"threadName");
        Intrinsics.checkNotNullParameter((Object)stackTopAddress, (String)"stackTopAddress");
        return new RtosLLThread(gdbThreadId, taskId, taskState, threadName, stackTopAddress, programCounter);
    }

    public static /* synthetic */ RtosLLThread copy$default(RtosLLThread rtosLLThread, long l, long l2, String string, String string2, Address address, Address address2, int n, Object object) {
        if ((n & 1) != 0) {
            l = rtosLLThread.gdbThreadId;
        }
        if ((n & 2) != 0) {
            l2 = rtosLLThread.taskId;
        }
        if ((n & 4) != 0) {
            string = rtosLLThread.taskState;
        }
        if ((n & 8) != 0) {
            string2 = rtosLLThread.threadName;
        }
        if ((n & 0x10) != 0) {
            address = rtosLLThread.stackTopAddress;
        }
        if ((n & 0x20) != 0) {
            address2 = rtosLLThread.programCounter;
        }
        return rtosLLThread.copy(l, l2, string, string2, address, address2);
    }
}

