/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos.freertos;

import com.intellij.clion.embedded.execution.rtos.freertos.AddressAsLongSerializer;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosDataManagerKt;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapBlock$;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapBlockStatus;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapRegion;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.PrintWriter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 52\u00020\u0001:\u000256B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bBK\b\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\n\u0010\u0011J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0007H\u00c6\u0003J\t\u0010(\u001a\u00020\tH\u00c6\u0003J1\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010*\u001a\u00020\u001e2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020\rH\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001J%\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0001\u00a2\u0006\u0002\b4R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0017\u00a8\u00067"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlock;", "", "details", "", "start", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "size", "", "status", "Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlockStatus;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/cidr/execution/debugger/memory/Address;JLcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlockStatus;)V", "seen0", "", "end", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lcom/jetbrains/cidr/execution/debugger/memory/Address;JLcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlockStatus;Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getDetails", "()Ljava/lang/String;", "setDetails", "(Ljava/lang/String;)V", "getStart", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getSize", "()J", "getStatus", "()Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlockStatus;", "getEnd", "fits", "", "region", "Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapRegion;", "exportCsv", "", "writer", "Ljava/io/PrintWriter;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_clion_embedded", "Companion", "$serializer", "intellij.clion.embedded"})
public final class HeapBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String details;
    @NotNull
    private final Address start;
    private final long size;
    @NotNull
    private final HeapBlockStatus status;
    @NotNull
    private final Address end;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;
    @NotNull
    private static final String[] columnNames;

    public HeapBlock(@NotNull String details, @NotNull Address start, long size, @NotNull HeapBlockStatus status) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        this.details = details;
        this.start = start;
        this.size = size;
        this.status = status;
        this.end = this.start.plus((Number)this.size).minus((Number)1);
    }

    public /* synthetic */ HeapBlock(String string, Address address, long l, HeapBlockStatus heapBlockStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "Free";
        }
        if ((n & 8) != 0) {
            heapBlockStatus = HeapBlockStatus.FREE;
        }
        this(string, address, l, heapBlockStatus);
    }

    @NotNull
    public final String getDetails() {
        return this.details;
    }

    public final void setDetails(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.details = string;
    }

    @NotNull
    public final Address getStart() {
        return this.start;
    }

    public final long getSize() {
        return this.size;
    }

    @NotNull
    public final HeapBlockStatus getStatus() {
        return this.status;
    }

    @NotNull
    public final Address getEnd() {
        return this.end;
    }

    public final boolean fits(@NotNull HeapRegion region) {
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        return this.start.compareTo(region.getStart()) >= 0 && this.end.compareTo(region.getEnd()) <= 0;
    }

    public final void exportCsv(@NotNull PrintWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        String[] stringArray = new String[]{FreeRtosDataManagerKt.to32BitString(this.start), String.valueOf(this.size), this.status.toString(), this.details};
        FreeRtosDataManagerKt.writeCsv(writer, stringArray);
    }

    @NotNull
    public final String component1() {
        return this.details;
    }

    @NotNull
    public final Address component2() {
        return this.start;
    }

    public final long component3() {
        return this.size;
    }

    @NotNull
    public final HeapBlockStatus component4() {
        return this.status;
    }

    @NotNull
    public final HeapBlock copy(@NotNull String details, @NotNull Address start, long size, @NotNull HeapBlockStatus status) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        return new HeapBlock(details, start, size, status);
    }

    public static /* synthetic */ HeapBlock copy$default(HeapBlock heapBlock, String string, Address address, long l, HeapBlockStatus heapBlockStatus, int n, Object object) {
        if ((n & 1) != 0) {
            string = heapBlock.details;
        }
        if ((n & 2) != 0) {
            address = heapBlock.start;
        }
        if ((n & 4) != 0) {
            l = heapBlock.size;
        }
        if ((n & 8) != 0) {
            heapBlockStatus = heapBlock.status;
        }
        return heapBlock.copy(string, address, l, heapBlockStatus);
    }

    @NotNull
    public String toString() {
        return "HeapBlock(details=" + this.details + ", start=" + this.start + ", size=" + this.size + ", status=" + this.status + ")";
    }

    public int hashCode() {
        int result2 = this.details.hashCode();
        result2 = result2 * 31 + this.start.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.size);
        result2 = result2 * 31 + this.status.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HeapBlock)) {
            return false;
        }
        HeapBlock heapBlock = (HeapBlock)other;
        if (!Intrinsics.areEqual((Object)this.details, (Object)heapBlock.details)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.start, (Object)heapBlock.start)) {
            return false;
        }
        if (this.size != heapBlock.size) {
            return false;
        }
        return this.status == heapBlock.status;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$intellij_clion_embedded(HeapBlock self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : !Intrinsics.areEqual((Object)self.details, (Object)"Free")) {
            output.encodeStringElement(serialDesc, 0, self.details);
        }
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)AddressAsLongSerializer.INSTANCE, (Object)self.start);
        output.encodeLongElement(serialDesc, 2, self.size);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.status != HeapBlockStatus.FREE) {
            output.encodeSerializableElement(serialDesc, 3, (SerializationStrategy)lazyArray[3].getValue(), (Object)self.status);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : !Intrinsics.areEqual((Object)self.end, (Object)self.start.plus((Number)self.size).minus((Number)1))) {
            output.encodeSerializableElement(serialDesc, 4, (SerializationStrategy)AddressAsLongSerializer.INSTANCE, (Object)self.end);
        }
    }

    public /* synthetic */ HeapBlock(int seen0, String details, Address start, long size, HeapBlockStatus status, Address end, SerializationConstructorMarker serializationConstructorMarker) {
        if (6 != (6 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)6, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.details = (seen0 & 1) == 0 ? "Free" : details;
        this.start = start;
        this.size = size;
        this.status = (seen0 & 8) == 0 ? HeapBlockStatus.FREE : status;
        this.end = (seen0 & 0x10) == 0 ? this.start.plus((Number)this.size).minus((Number)1) : end;
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Object[] objectArray = new Lazy[]{null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"com.intellij.clion.embedded.execution.rtos.freertos.HeapBlockStatus", (Enum[])HeapBlockStatus.values())), null};
        $childSerializers = objectArray;
        objectArray = new String[]{"Start address", "Size", "Status", "Details"};
        columnNames = objectArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlock$Companion;", "", "<init>", "()V", "columnNames", "", "", "getColumnNames", "()[Ljava/lang/String;", "[Ljava/lang/String;", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlock;", "intellij.clion.embedded"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getColumnNames() {
            return columnNames;
        }

        @NotNull
        public final KSerializer<HeapBlock> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

